<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sales extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->userID = $this->session->userdata('id');
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"sales/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
        //$this->load->model('users/user_point_model','user_point');
        $this->load->model('products/Item_model','item');
		$this->load->library(array('Stock','Targets'));
        $this->load->model('branches/Branch_model','brch');       
		#-----------checking branch_type
		$this->branch_status = 0;
		if($this->dms->branch_type())
		{
			$this->branch_status = 1;
		}

		$this->vtype = 6;
	}

	public function add()
	{              
        $this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_type_model','customer_type');
        $this->load->model('products/Unit_model','unit');
       
		$vtype_id = $this->vtype;

		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$sales_cst = $this->stock->get_constant(array('sales_cst'));
		$presumptive_tax = $this->stock->get_tax_type();
		$cess = $this->stock->get_cess();				

		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus'])
        { 
			if($result_array['s_status'] == 2)
			{
				redirect("order_to_sales/so_sales/".$result_array['sid']);
			}
			elseif($result_array['s_status'] == 1)
			{
				redirect("request_to_sales/pr_sales/".$result_array['sid']);
			}

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_sales as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_sales','a.table_group_id' => $group_id)));
			if(!empty($voucher_details))
			{
				redirect("sales/update/id/".$voucher_details[0]['id']);
			}  

			/*$cst_status = $this->sales_obj->get_cst($group_id);*/
			$cst_status = 0;
			if($cst_status)
			{
				$sales_cst = $cst_status;
			}
		}
		else
		{ 
			//$group_id = $this->stock->get_group_id('dms_sales_items1');
			$group_id = $this->stock->get_book_group_id($this->branchID);
		}
 
        $branchs_id = $this->session->userdata('under_id');

        $previous_status = $this->brch->get_previous_status($branchs_id);

		if(isset($_POST['btn_add']))
		{
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('sales[bill_no]','lang:bill-no',"required|xss_clean|".$rules);
			$this->form_validation->set_rules('sales[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
			$this->form_validation->set_rules('sales[mobile]','lang:mob','required|xss_clean');
			$this->form_validation->set_rules('sales[salesman]','lang:sales-man','required|xss_clean');
            $this->form_validation->set_rules('s_type','lang:bill-type','required|xss_clean');
			//$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			//$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			
			if(isset($_POST['newp'])) 
            {
                $this->form_validation->set_rules('new_item[item_group_id]','lang:item-type','required|xss_clean');
                $this->form_validation->set_rules('new_item[item_code]','lang:item-code','required|xss_clean|is_unique[item_master.item_code]');
                $this->form_validation->set_rules('new_item[item_name]','lang:item-name','required|xss_clean');
            }
            else
            {
                $this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
            }

			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
                $sal_tem = $this->input->post('sales',true);
                $des_array = $this->input->post('des',true);
                $gst_st = $item_array['gstin'];
                $s_type = $this->input->post('s_type',true);
                $new_item = $this->input->post('new_item',true);
               
                if(isset($_POST['newp'])) 
                {                               
                    $new_stats = 1;
                    $new_item_details = array();
                    $new_item_details['company_id']=$this->companyID;
                    $new_item_details['item_group_id']=$new_item['item_group_id'];
                    $new_item_details['item_manufacturer_id'] = 5;
                    $new_item_details['item_code'] = $new_item['item_code'];
                    $new_item_details['item_name'] = $new_item['item_name'];
                    $new_it = $this->db->select(array('item_type'))->from('item_type_master')->where('id',$new_item['item_group_id'])->where('status',1)->get()->row_array();                                
                    $new_item_details['item_types'] = strtolower($new_it['item_type']);
                    $tp=$new_item_details['item_types'];
                    $cd=$new_item_details['item_code'];
                    if($tp=='contact' || $tp=='solution')
    			    {
    			        $new_item_details['code_id'] = substr($cd,2);
    			    }
    			    else
    			    {
    			        $new_item_details['code_id'] = substr($cd,1);
    			    }
                    $new_item_details['unit_id'] = $new_item['unit_id'];
                    $new_item_details['hsn'] = $new_item['hsn'];
                    $new_item_details['stock_type'] = 1;
                    $new_item_details['status'] = 1;

                    $new_item_id = $this->sales_obj->insert("item_master",$new_item_details);
                    if($new_item_id)
                    {
                        $new_stock = array();
                        $new_stock['company_id'] = $this->companyID;
                        $new_stock['branch_id'] = $this->branchID;
                        $new_stock['godown_id'] = $new_item['godown_id'];
                        $new_stock['item_id'] = $new_item_id;
                        $new_stock['qty']=0;
                        $new_stock['unit_id'] = $new_item['unit_id'];
                        $new_stock['rate'] = 0;
                        $new_stock['stock_date'] = $this->fiscal_start_date;
                        $new_stock['status'] = 1;
                        $this->sales_obj->insert("dms_stocks",$new_stock);
                        
                        $new_rate = array();
                        $new_rate['company_id'] = $this->companyID;
                        $new_rate['item_id'] = $new_item_id;
                        $new_rate['rate'] = $item_array['rate'];
                        $new_rate['valid_from'] = $sal_tem['bill_date'];
                        $new_rate['status'] = 1; 
                        $this->sales_obj->insert("dms_item_rates",$new_rate);
                    }
                    
                    $item_array['item_id']=$new_item_id;
                    $item_array['godown_id']=$new_item['godown_id'];
                    $item_array['hsn']=$new_item['hsn'];
                }

				unset($item_array['sales']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
                unset($item_array['gstin']);
                unset($item_array['des']);  
                unset($item_array['s_type']); 
                unset($item_array['new_item']);  
                unset($item_array['newp']);   

				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				$item_array['item_status'] = 2;

				$item_array['rate'] = 0;
				if($item_array['qty'] != 0)
				{
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}
                
                $sales_temp_item_result = $this->sales_obj->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
		
				if($sales_temp_item_result == 0)
				{
					$cgst = $this->stock->get_item_cgst($item_array['item_id']);
					$sgst = $this->stock->get_item_sgst($item_array['item_id']);
                    			
					$item_array['taxable_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt'])*100)/(100+(float)$cgst+(float)$sgst+(float)$cess);
					$item_array['cgst'] = $cgst;
					$item_array['sgst'] = $sgst;
					
					$item_array['cgst_amt'] = ((float)$item_array['taxable_amt'] * (float)$cgst) / 100;
					$item_array['sgst_amt'] = ((float)$item_array['taxable_amt'] * (float)$sgst) / 100;
					$item_array['cess_amt'] = ((float)$item_array['taxable_amt'] * (float)$cess) / 100;
					
					$sales_temp_array = $this->input->post('sales',true);
					$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
					$sales_temp_array['s_type'] = $this->input->post('s_type',true);
					$sales_temp_array = array_filter($sales_temp_array);

					$this->db->trans_start();

					if($result_array['vstatus'] == 0)
					{
						$vtype_id = $sales_temp_array['vtype_id'];
						$voucher_no = $sales_temp_array['bill_no'];                                                 
                        			
                        if($s_type == "med")
			            {                                                
			                $ref_no = $sales_temp_array['ref_no'];
			                $doctor = $sales_temp_array['doctor'];
			                if(empty($doctor)){ $doctor=""; }
			            }
			            else
			            { 
                            $ref_no = 0; $doctor=""; 
                        }
                        			
						$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
						$customer_type = 2; //$sales_temp_array['customer_type'];
						$customer_name = $sales_temp_array['customer_id'];
                        $cust_mob = $sales_temp_array['mobile'];
                        $cust_addr = $sales_temp_array['address'];
                        $cust_mail = $sales_temp_array['email_id'];
                        if (!empty($sales_temp_array['dob'])) {
                        $cust_dob = date('Y-m-d',strtotime($sales_temp_array['dob']));
                        }
                        else
                        {
                            $cust_dob = null; 
                        }
                        if(empty($cust_addr)){ $cust_addr = " ";}
                        if(empty($cust_mail)){ $cust_mail = " ";}
                       
                        $doctor = $sales_temp_array['doctor']; if(empty($doctor)){ $doctor = " ";}
                        $user_idsal = $sales_temp_array['salesman'] ; if(empty($user_idsal)){ $user_idsal = " ";}
                        $customer_id = $this->sales_obj->save_customer(array('fname'=>$customer_name,'mobile_no'=>$cust_mob,'address'=>$cust_addr,'email_id'=>$cust_mail,'dob'=>$cust_dob,'status'=>1));

						$data_sales_temp=array('vtype_id' => $vtype_id,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'s_type'=>$s_type,'ref_no'=>$ref_no,'doctor'=>$doctor,'user_id'=>$user_idsal,'customer_type_id' => 2,'customer_id' => $customer_id,'status' => -1);						
						if(array_key_exists('pricelist_id',$sales_temp_array))
						{
							$data_sales_temp['pricelist_id'] = $sales_temp_array['pricelist_id'];
						}

						$this->sales_obj->insert("dms_sales",$data_sales_temp);
                        $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                        $this->db->query("insert into doctor_description(group_id,customer_id,ldv1,ldv2,ldv3,ldv4,lnv1,lnv2,lnv3,lnv4,ladd,lipg,rdv1,rdv2,rdv3,rdv4,rnv1,rnv2,rnv3,rnv4,radd,ripg) values('$group_id','$customer_id','$ldv1','$ldv2','$ldv3','$ldv4','$lnv1','$lnv2','$lnv3','$lnv4','$ladd','$lipg','$rdv1','$rdv2','$rdv3','$rdv4','$rnv1','$rnv2','$rnv3','$rnv4','$radd','$ripg')");
					}
					
					$ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                    $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                    $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id='$group_id' and customer_id='$customer_id'");
 
					$branch_id = $this->session->userdata('under_id');
                    $godown_id = $this->stock->get_branch_godown($branch_id); 
                    
                    $sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);					          

                    if($sales_items_id)
					{
						$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
						$this->message->set($this->lang->line('sales-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-add-error'),'e');
					} 

					$this->db->trans_complete();
				}
				else
				{
					$this->message->set($this->lang->line('sales-add-error'),'e');
				}
			
				echo '<script>window.location.href = "'.base_url('sales/add').'";</script>';
			}
		}

		if(isset($_POST['btn_save']))
		{
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			$this->form_validation->set_rules('amount1','lang:amount','required|xss_clean');
			if($this->input->post('payment_mode',true) == 2)
			{
				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
			}
			elseif($this->input->post('payment_mode',true) > 2)
			{
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run('btn_save') === true)
			{
				$narration = $this->input->post('remarks',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
				$bill_discount_per = $this->input->post('bill_discount_per',true);
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				
				$payment_mode = 0; $amount1 = 0;
                if(!empty($this->input->post('amount1')) && !empty($this->input->post('payment_mode')))
                {
                    $payment_mode = $this->input->post('payment_mode');
                    $amount1 = $this->input->post('amount1');
                }
                    
                $payment_mode2 = 0; $amount2 = 0;        
                if(!empty($this->input->post('payment_mode2')) && !empty($this->input->post('amount2')))
                {
                    $payment_mode2 = $this->input->post('payment_mode2');
                    $amount2 = $this->input->post('amount2');
                }
                
                $payment = (float)$amount1+(float)$amount2;
                
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'amount1' => $amount1,'payment_mode2' => $payment_mode2,'amount2' => $amount2,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

                $sales_entry_check = $this->sales_obj->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.customer_type_id','a.customer_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));

				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					$vtype_id = $sales_entry_check[0]['vtype_id'];
					$bill_no = $sales_entry_check[0]['bill_no'];
                    $customer_id = $sales_entry_check[0]['customer_id'];                                    
                    $amount = $this->input->post('grand_total',true);
                    $vat = $this->input->post('vat_total',true);
                    $tot_amount = (float)$amount+(float)$vat; 

					$this->db->trans_start();
					if($this->sales_obj->update(array('table' => 'dms_sales','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
					{
					    $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                       $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id='$group_id'");
 
                       if($bill_discount_per>0){
                            $voucher_amount=0;  $vat_amount=0; $round_off_amount=0; $cess_amount=0;
                            $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id','discount_amt'),'conditions' => array('group_id' => $group_id,'status!=' => 0,'item_status >' => 0)));
    						foreach($sales_items_array as $key => $value){
    						    $it_up_id = $value['id'];
    						    $itid = $value['item_id']; 
    						    $itamt = (float)$value['qty']*(float)$value['rate'];
    						    $itdisc = $value['discount_amt'];
    						    $itmamt = (float)$itamt-(float)$itdisc;
    						    $itmdisc = ((float)$itmamt*(float)$bill_discount_per)/100;
    						    $itcgst = $this->stock->get_item_cgst($itid);
    						    $itsgst = $this->stock->get_item_sgst($itid);
    						    $it_taxable = (((float)$itmamt-(float)$itmdisc)*100)/(100+(float)$itcgst+(float)$itsgst+(float)$cess);
    						    $it_cgst_amt = ((float)$it_taxable*(float)$itcgst)/100; 
    						    $it_sgst_amt = ((float)$it_taxable*(float)$itsgst)/100; 
    						    $it_cess_amt = ((float)$it_taxable*(float)$cess)/100;
    						    
    						    (float)$voucher_amount += (float)$it_taxable;
    						    (float)$vat_amount += (float)$it_cgst_amt+(float)$it_sgst_amt;
    						    (float)$cess_amount += (float)$it_cess_amt;
    						    
    						    $it_up_array = array('bill_disc_per'=>$bill_discount_per,'bill_disc_amt'=>$itmdisc,'taxable_amt'=>$it_taxable,'cgst'=>$it_cgst,'sgst'=>$it_sgst,'cgst_amt'=>$it_cgst_amt,'sgst_amt'=>$it_sgst_amt,'cess_amt'=>$it_cess_amt);
    						
    						    $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						}
                        }
                        else
                        {
                            $voucher_amount = $this->input->post('grand_total',true);
    						$round_off_amount = $this->input->post('round_off_amount',true);
    						$vat_amount = $this->input->post('vat_total',true);
    						$cess_amount = $this->input->post('cess_total',true);
                        }
					    
                        $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' =>0,'item_status >' => 0)));
                        								
                        $sl_qr = $this->db->select(array('id'))->from('dms_sales')->where('group_id',$group_id)->get()->row_array();							
                        $sls_id = $sl_qr['id'];

						$user_points = 0;$user_type = "";
						if($sales_entry_check[0]['customer_type_id'] == 2)//customer
						{							
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
						}
						else
						{
							$designation_id = $sales_entry_check[0]['customer_type_id'];
							if($designation_id == 3)
							{
								$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
							else
							{
								$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
						}

                        $customer_id = $sales_entry_check[0]['customer_id'];
						$designation_id = $sales_entry_check[0]['customer_type_id'];
                        $bill_no = $sales_entry_check[0]['bill_no'];

						$amt= $this->dms->get_qty($customer_id,$bill_no);
                        $customer_points = $this->targets->get_customer_bill_points($amt);
                                              
                        $target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
						if($target_id2)
						{
						    $this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));
						}
						
						$bill_date_time = strtotime($bill_date);
    					if($payment > 0)
                        {
                            $voucher_status1 = $voucher_status2 = 1;
                                
                            $voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'vtype_id' => $vtype_id,'vno' => $group_id,'vorder_no' => 1,'vdate' => $bill_date,'cr_ledger' => 4,'table_name' => 'dms_sales','table_group_id' => $group_id);
    						
                            if(!empty($payment_mode) && !empty($amount1) && $amount1 > 0)
                            {
                                if($payment_mode > 2)
    						    {
                                    $cheque_date1 = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
            						$cheque_date_time1 = strtotime($cheque_date1);
            						if($this->input->post('ccd',true) == 1 && $cheque_date_time1 > $bill_date_time)
            						{
            							$voucher_status1 = 3;
            						}
    						    }
    						    elseif($payment_mode == 2)
            					{
            						$payment_mode = $customer[0]['ledger_id'];
            					}
            						
            					$voucher_group_id1 = $this->stock->get_group_id('dms_vouchers');
            						
            					$voucher_array['group_id'] = $voucher_group_id1;
            					$voucher_array['dr_ledger'] = $payment_mode;
            					$voucher_array['vamount'] = $amount1;
            					$voucher_array['status'] = $voucher_status1;
            				
            					$voucher_success1 = $this->sales_obj->insert('dms_vouchers',$voucher_array);
    						
        						if($payment_mode1 > 2)
                                {
                                    $this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id1,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date1,'vdate' => $bill_date));
        						}
                            }
                                
                            if(!empty($payment_mode2) && !empty($amount2) && $amount2 > 0)
                            {
                                if($payment_mode2 > 2)
    						    {
                                    $cheque_date2 = date('Y-m-d',strtotime($this->input->post('cheque_date2',true)));
            						$cheque_date_time2 = strtotime($cheque_date2);
            						if($this->input->post('ccd2',true) == 1 && $cheque_date_time2 > $bill_date_time)
            						{
            							$voucher_status2 = 3;
            						}
    						    }
    						    elseif($payment_mode2 == 2)
            					{
            						$payment_mode2 = $customer[0]['ledger_id'];
            					}
            					
            					$voucher_group_id2 = $this->stock->get_group_id('dms_vouchers');
            					$voucher_array['group_id'] = $voucher_group_id2;
            					$voucher_array['dr_ledger'] = $payment_mode2;
            					$voucher_array['vamount'] = $amount2;
            					$voucher_array['status'] = $voucher_status2;
            						
            					$voucher_success2 = $this->sales_obj->insert('dms_vouchers',$voucher_array);
    						
        						if($payment_mode2 > 2)
                                {
                                    $this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id2,'cash_type' => $this->input->post('ccd2',true),'cd_no' => $this->input->post('cd_no2',true),'pdc' => $cheque_date2,'vdate' => $bill_date));
        						}
                            }
                        }
						
						$branch_id = $this->session->userdata('under_id');
                        $godown_id = $this->stock->get_branch_godown($branch_id); 
                                         
						$sales_items_array = $this->sales_obj->get_sales_itemss(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));
   						
						foreach($sales_items_array as $key => $value)
						{
							$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 6,'table_id' => $value['id'])));
						}
					
						$this->message->set($this->lang->line('sales-save-success'));

                        
					}
					else
					{
						$this->message->set($this->lang->line('sales-save-error'),'e');
					}
					 echo "<script>window.open('/sales/print_bill/id/$sls_id','_blank');</script>";
                    //$lnk='sales/print_bill/id/'.$sls_id;
					//redirect($lnk);
					$this->db->trans_complete();
				}
				else
				{
					$this->message->set($this->lang->line('sales-save-error'),'e');
				}
				echo '<script>window.location.href = "'.base_url('sales/add').'";</script>';
			}
		}
		
		$this->load->model('godown/Godown_model','godown');

        $units1 = $this->unit->listing();
        $item_groups1 = $this->item->item_group_listing();
        $godowns1 = $this->godown->listing();

		$user_types = array();$custType = 2;
		if($this->branch_status)
		{
			$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		}
		else
		{
			$customerTypes = $this->desig->listing(array('id'=>2));
		}

		$units = array();$goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name','model_no');
		$items = $this->stock->get_stock_items($args);
	
		if($this->input->post('item_id',true))
		{
			$itemID = $this->input->post('item_id',true);

			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		$sales_temp_data = array();$cust_id="";$users = array();$user = "";$pricelists=array();$desig_id="";
		$price_list_id="";$stock_count="";$primary_unit['symbol']="";
		if($result_array['vstatus'])
		{
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
		
            $sales_temp_data = $this->sales_obj->get_sales_gst(array('columns' => array('a.group_id','a.customer_type_id','a.s_type','a.ref_no','a.doctor','a.user_id','a.customer_id','a.pricelist_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));

            $stype = $sales_temp_data[0]['s_type'];
            $refno = $sales_temp_data[0]['ref_no'];
            
            $gr_id = $sales_temp_data[0]['group_id']; 
            $des_array = $this->sales_obj->get_description($gr_id); 
            
            $doctor = $sales_temp_data[0]['doctor'];
			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];
            $user_ids = $sales_temp_data[0]['user_id'];
			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];
			$this->load->model('customers/Customer_master_model','customer_master');
            $args = array('conditions'=>array('id'=>$cust_id));
            $cust_data = $this->customer_master->get($args);
            $cust_name = $cust_data[0]['fname'];
            $cust_mob = $cust_data[0]['mobile_no'];
		}
		else
		{
			$sales_array = $this->input->post('sales',true);
			#------------customer type
			if($sales_array['customer_type'] != ""){
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != ""){
				$cust_id = $sales_array['customer_id'];
			}

			#------------user details
			if($sales_array['user_type'] != ""){
				$desig_id = $sales_array['user_type'];
				$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
				if($sales_array['user_id'] != ""){
					$user = $sales_array['user_id'];
				}
			}

			#------------pricelist
			if(isset($sales_array['pricelist_id']) && $sales_array['pricelist_id'] != ""){
				$price_list_id = $sales_array['pricelist_id'];
			}

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}

		if($this->branch_status)
		{
			if($custType == 1){

				$this->load->model('branches/branch_model','branches');
				$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
			}
			else if($custType ==2){
				$this->load->model('customers/Customer_master_model','customer_master');
				$customers = $this->customer_master->listing();
				#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
			}
			else{
				$this->load->model('retailers/Counter_model','retailer_master');
				$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
			}
		}
		else
		{
			$this->load->model('customers/Customer_master_model','customer_master');
			$customers = $this->customer_master->listing();
		}
		
		$branch_det = $this->db->select(array('id','branch_name','ledger_id','area_id'))->from('branch_master')->where('id',$this->branchID)->get()->row_array();
        $branch_area = $branch_det['area_id'];

		$user_types = $this->desig->listing(array('utype_status' => 1));
		$pricelists = $this->customer_type->listing();
		$areas[''] = 'Select';ksort($areas);
		$user_types[''] = "Select";ksort($user_types);
		$pricelists[''] = 'Select';ksort($pricelists);
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$users[''] = 'Select';ksort($users);

		$payment_mode = $this->stock->payment_modes();

		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2)
		{
			$cd_status = 0;
		}

        $unmae = $this->sales_obj->listing();

		$this->template->title("New Sales Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales/report'));
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_entry/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'user_types' => $user_types,'users' => $users,'user' => $user,'pricelists' => $pricelists,'price_list_id' => $price_list_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'cust_name' => $cust_name,'cust_mob'=>$cust_mob,'doctor'=>$doctor,'cust_id' => $cust_id,'desig_id' => $desig_id,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix' => $bill_prefix,'refno' => $refno,'stype' => $stype,'doctor' => $doctor,'des_array'=>$des_array,'units1' => $units1,'groups1' => $item_groups1,'godowns1' => $godowns1,'branch_area'=>$branch_area,'previous_status'=>$previous_status,'user_name'=>$unmae,'user_id'=>$user_ids));
        $this->template->slice('dms/modals/search');
		$this->template->other_script('sales/sales_order');		
        $this->template->other_script('products/search');
		$this->template->render();
	}

	public function delete_temp()
	{
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];            
				unset($uri_array['idu']);

				$redirect_uri = "sales/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
                $gid= $uri_array['gida'];
				unset($uri_array['ida']);
                unset($uri_array['gida']);

				$redirect_uri = "sales/add/".$this->uri->assoc_to_uri($uri_array);
			}

            $s = $this->sales_obj->get_bills(array('columns' => array('bill_date'),'conditions' => array('group_id'=> $gid),'numrows' => true));

            $result = $this->sales_obj->get_sales_itemss(array('columns' => array('group_id','status','item_status','created_by'),'conditions' => array('id' => $id,'status !=' => 0)));

			if(!empty($result))
			{
				$row = $result[0];
				if($row['status'] == -1)
				{
					if($row['created_by'] == $this->session->userdata('id'))
					{
						$this->db->trans_start();

                        if($this->sales_obj->delete(array('table' => 'dms_sales_items1','conditions' => array('id' => $id))))
						{
							$this->sales_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 6)));
							$count = $this->sales_obj->get_sales_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
							if($count == 0)
							{
								$this->sales_obj->delete(array('table' => 'dms_sales','conditions' => array('group_id' => $row['group_id'])));
							}
							$this->message->set($this->lang->line('sales-item-delete-success'));
						}
						else
						{
							$this->message->set($this->lang->line('sales-item-delete-error'),'e');
						}

						$this->db->trans_complete();
					}
					else
					{
						redirect('users/logout');
					}
				}
				else
				{
					$this->db->trans_start();
 
                    if($row['item_status'] == 2)//sales entry
					{
						$this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('status' => 0),'conditions' => array('id' => $id)));
					}
					else//sales order
					{
						$this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
					}

					$this->sales_obj->update(array('table' => 'dms_sales','data' => array('status' => -1),'conditions' => array('group_id' => $row['group_id'])));
					$this->sales_obj->update(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 6)));

                    $count = $this->sales_obj->get_sales_itemss(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status >' => 0),'numrows' => true));

					if($count == 0)
					{
						$this->sales_obj->update(array('table' => 'dms_sales','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));
						$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_sales','table_group_id' => $row['group_id'])));

						$cheque_details = $this->vouchers->cheque_data(array('columns' => 'b.id','conditions' => array('table_name' => 'dms_sales','table_group_id' => $row['group_id'])));
						if(!empty($cheque_details))
						{
							$this->sales_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('status' => 0),'conditions' => array('id' => $cheque_details[0]['id'])));
						}

						$this->sales_obj->update_others(array('table' => 'user_points','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						$this->sales_obj->update_others(array('table' => 'dms_sms','data' => array('status' => 0),'conditions' => array('bill_ref_no' => $row['group_id'])));

						$redirect_uri = "sales/report/".$this->uri->assoc_to_uri($uri_array);
					}
					
					$this->message->set($this->lang->line('sales-item-delete-success'));
					$this->db->trans_complete();
				}
				
				$result1 = $this->sales_obj->get_sales_itemss(array('columns' => array('id','item_id','qty','rate','amount','cgst','sgst'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0)));
                if(!empty($result1))
			    {
			        foreach($result1 as $res1)
			        {
			            $ins_array = array();
			            $ins_array['discount_per'] = 0;
			            $ins_array['discount_amt'] = 0;
			            $ins_array['taxable_amt'] = ((float)$res1['amount']*100)/(100+(float)$res1['cgst']+(float)$res1['sgst']);
			            $ins_array['cgst_amt'] = ((float)$ins_array['taxable_amt']*(float)$res1['cgst'])/100;
			            $ins_array['sgst_amt'] = ((float)$ins_array['taxable_amt']*(float)$res1['sgst'])/100;
			            $ins_array['cess_amt'] = 0;
			            
			            $this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => $ins_array,'conditions' => array('id' => $res1['id'])));
                    }
			    }
			    
			    $this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_discount_per'=>0,'bill_discount_amt'=>0),'conditions' => array('group_id' => $row['group_id'])));
            }
			
			echo '<script>window.location.href = "'.base_url().$redirect_uri.'";</script>';
		}
		redirect('users/logout');
	}  

	public function update_temp()
	{
		#----------sales temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
		    $cess = $this->stock->get_cess();
		    
		    $admin = '';
		    if($this->userID != '-1' && $this->userID != '-2'){ $admin = "readonly"; }
		    
			if(isset($uri_array['idu']))
			{
				$sales_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "sales/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$sales_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "sales/add/".$this->uri->assoc_to_uri($uri_array);
			}

            $row = $this->sales_obj->get_sales_itemss(array('columns' => array('id','group_id','item_id','hsn','qty','unit_id','rate','amount','taxable_amt','discount_per','discount_amt','cgst','sgst','cgst_amt','sgst_amt','cess_amt','godown_id','status','item_status','created_by'),'conditions' => array('id' => $sales_temp_id,'status !=' => 0)));

			if(!empty($row))
			{
				$sales_temp_data = $row[0];$continue = 1;
				if($sales_temp_data['status'] == -1){
					if($sales_temp_data['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#-----------validation
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					//$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------updating temporary data
					if($this->form_validation->run() === true)
					{
						$item_temp_array = $this->input->post(NULL,true);

						#----------rate calculation
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0){
							$item_temp_array['rate'] = (float)$item_temp_array['amount'] / (float)$item_temp_array['qty'];
						}

						#------------presumptive tax checking
						$presumptive_tax = $this->stock->get_tax_type();

						#----------GST calculation
						
					    $item_temp_array['cgst'] = $this->stock->get_item_cgst($sales_temp_data['item_id']);
                        $item_temp_array['sgst'] = $this->stock->get_item_sgst($sales_temp_data['item_id']);
                        
                        $item_temp_array['taxable_amt'] = (((float)$item_temp_array['amount']-(float)$item_temp_array['discount_amt'])*100)/(100+(float)$item_temp_array['cgst']+(float)$item_temp_array['sgst']+(float)$cess);
                        
						#----------start transaction
						$this->db->trans_start();

                        if($sales_temp_data['item_status'] == 1 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id'] || $sales_temp_data['cgst_amt'] != $item_temp_array['cgst_amt'] || $sales_temp_data['sgst_amt'] != $item_temp_array['sgst_amt']))
						{
							$item_temp_array['group_id'] = $sales_temp_data['group_id'];
							$item_temp_array['item_id'] = $sales_temp_data['item_id'];
							$item_temp_array['status'] = -1;
							$item_temp_array['item_status'] = 2;
							$sales_temp_data['item_status'] = 2;
							if($this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $sales_temp_id)))){
								$sales_temp_id = $this->sales_obj->insert('dms_sales_items1',$item_temp_array);
								$this->message->set($this->lang->line('sales-edit-temp-success'));
							}
						}
						else
						{
							$item_temp_array['status'] = -1;
							$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));
							$this->message->set($this->lang->line('sales-edit-temp-success'));
						}

						#--------------updating bill status in dms_sales
						$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('status' => -1),'conditions' => array('group_id' => $sales_temp_data['group_id'])));
                        
						            $branch_id = $this->session->userdata('under_id');
                                    $godown_id = $this->stock->get_branch_godown($branch_id); 
						#--------------updating temporary stock balance in dms_stocks
						if($sales_temp_data['item_status'] == 2)
						{
							$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
							if($stock_bal_temp)
							{
								$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'status' => $item_temp_array['status']),'conditions' => "(stock_status = 6 or stock_status = 5) and table_id = $sales_temp_id"));
							    $stock_count = $this->stock->get_stock_count($godown_id,$sales_temp_data['item_id']);
                                $this->sales_obj->update(array('table' => 'item_stock','data' => array('qty' => $stock_count),'conditions' => array('branch_id' =>$this->session->userdata('under_id'),'item_id' =>$sales_temp_data['item_id'])));
					        					
							    
							}
						}

						#----------end transaction
						$this->db->trans_complete();

						//redirect($redirect_uri);
						echo '<script>window.location.href = "'.base_url().$redirect_uri.'";</script>';
					}

					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#-----------sales cst checking details
					$sales_cst = $this->stock->get_constant(array('sales_cst'));

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
				/*	$cst_status = $this->sales_obj->get_cst($sales_temp_data['group_id']);*/
				$cst_status = 0;
					if($cst_status){
						$sales_cst = $cst_status;
					}

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name','model_no'));
					$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name']." / ".$item_details['model_no'];
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($sales_temp_data['item_id']);

					#------------sale date
					$sale_date = $this->sales_obj->get_sales_gst(array('columns' => array('bill_date'),'conditions' => array('a.group_id' => $sales_temp_data['group_id'],'a.status !=' => 0,'b.item_status >' => 0)))[0];

					#------------stock count of this item
					$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_date['bill_date']);

					#------------primary unit details
					$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

					#------------template
					$this->template->title("Update Sales Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'sales/report',$this->lang->line('go-back') => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/sales_entry/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess'=>$cess,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_date['bill_date'],'admin'=>$admin));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	public function report()
	{
		#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
        $this->load->model('booking/Booking_model','book_obj');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('sales/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		$cond=$branch_id='';
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date']){
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
        $this->form_validation->set_rules('phone','phone','xss_clean|trim');
		if($this->form_validation->run() === true){
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true))){
				$vnos = $this->input->post('bill_no',true);
				$cond .= " and s.bill_no like '%$vnos%'";
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
			if(!empty($this->input->post('branch_id',true))){
				$branch_id = $this->input->post('branch_id',true);
				$cond .= " and s.branch_id='$branch_id'";
				$conditions['branch_id'] = $branch_id;
				$config['base_url'] .= '/branch/'.$branch_id;
				$config['uri_segment'] += 2;
				$redirect .= '/branch/'.$branch_id;
			}
            if(!empty($this->input->post('phone',true))){
                $ph = $this->input->post('phone',true);  
                $cust_qr=$this->db->select('id')->from('customer_master')->where('mobile_no',$ph)->get()->row_array();
                $cust_ids= $cust_qr['id']; 
                if(!empty($cust_ids)){
                    $conditions['customer_id'] = $cust_ids;
                }
            }
            if(!empty($this->input->post('customer_id',true))){
                $cust_ids = $this->input->post('customer_id',true);                                                                                   
                $conditions['customer_id'] = $cust_ids;                        
            }
		}elseif(isset($uri_array['vt'])){
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate'])){
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn'])){
				$vnos = $uri_array['vn'];
				$cond .= " and s.bill_no like '%$vnos%'";
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
			if(isset($uri_array['branch'])){
				$branch_id = $uri_array['branch'];
				$cond .= " and s.branch_id='$branch_id'";
				$conditions['branch_id'] = $branch_id;
				$config['base_url'] .= '/branch/'.$branch_id;
				$config['uri_segment'] += 2;
				$redirect .= '/branch/'.$branch_id;
			}
		}
		if($branch_id==''){
		    $cond .= " and s.branch_id='$this->branchID'";
		}
		$cond .= " and s.vtype_id='$vtype_id' and s.bill_date between '$from_date' and '$to_date'";
		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
		#----------total rows
		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));
		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}
		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;
        $this->load->model('customers/Customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
        $customers['']= "Select";
        ksort($customers);
		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();
		#----------sales report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
		$mode_array=array();
		$mode_res = $this->db->query("select s.payment_mode,sum(s.amount1) as amount,l.ledger_name from dms_sales as s inner join dms_ledgers as l on s.payment_mode=l.id where s.status=1 and s.amount1>0 $cond group by s.payment_mode")->result_array();
		$mode_res1 = $this->db->query("select s.payment_mode2,sum(s.amount2) as amount,l.ledger_name from dms_sales as s inner join dms_ledgers as l on s.payment_mode=l.id where s.status=1 and s.amount2>0 $cond group by s.payment_mode2")->result_array();
		
		foreach($mode_res as $mode){
		    if(isset($mode_array[$mode['payment_mode']]['amount'])){
		        (float)$mode_array[$mode['payment_mode']]['amount'] += (float)$mode['amount'];
		    }else{
		        $mode_array[$mode['payment_mode']]['name'] = $mode['ledger_name'];
		        $mode_array[$mode['payment_mode']]['amount'] = $mode['amount'];
		    }
		}
		foreach($mode_res1 as $mode1){
		    if(isset($mode_array[$mode1['payment_mode']]['amount'])){
		        (float)$mode_array[$mode1['payment_mode']]['amount'] += (float)$mode1['amount'];
		    }else{
		        $mode_array[$mode1['payment_mode']]['name'] = $mode1['ledger_name'];
		        $mode_array[$mode1['payment_mode']]['amount'] = $mode1['amount'];
		    }
		}
		
		$this->load->model('branches/Branch_model','branch');
		$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
		$branches[''] = 'Select';
		ksort($branches);
		
		#----------template
		$this->template->title("Sales Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search',array('branches'=>$branches,'branch_id'=>$branch_id,'voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'ph'=>$ph,'rtype' => 'sales','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array)){
			$this->template->slice('sales/sales_entry/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect,'mode_array'=>$mode_array));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();
	}

	public function view()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales/add',$this->lang->line('report') => 'sales/report',$this->lang->line("view") => 'no_link');

			if($this->uri->segment(3) == 'group_id')
			{
			   
				$conditions = array('a.group_id' => $this->uri->segment(4),'a.status' => 1,'b.status !=' => 0,'b.item_status >' => 0);
				if($this->uri->segment(5) && $this->uri->segment(5) == 'vt')
				{
					$breadcrumb_url = "daybooks/index/vt/".$this->uri->segment(6);
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && ($this->uri->segment(5) == 'id' || $this->uri->segment(5) == 'mid' || $this->uri->segment(5) == 'sid'))
				{
					$breadcrumb_url = "stock_item_register/index/".$this->uri->segment(5)."/".$this->uri->segment(6);
					if($this->uri->segment(7) && $this->uri->segment(7) == 'rtype'){
						$breadcrumb_url .= "/rtype/".$this->uri->segment(8);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && $this->uri->segment(5) == 'vp')
				{
					$breadcrumb[$this->lang->line("go-back")] = "vat_detailed_reports/index/ttyp/1/vp/".$this->uri->segment(6)."/fdate/".$this->uri->segment(8)."/tdate/".$this->uri->segment(10);
				}
				else
				{
					$breadcrumb_url = "ledger_reports/index/";
					if($this->uri->segment(5))
					{
						$breadcrumb_url .= $this->uri->segment(5);
					}
					if($this->uri->segment(6))
					{
						$breadcrumb_url .= "/sid/".$this->uri->segment(6);
					}
					if($this->uri->segment(7))
					{
						$breadcrumb_url .= "/tbp/".$this->uri->segment(7);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				#----------sales primary key
				$sales_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $sales_id,'a.status' => 1,'b.status !=' => 0,'b.item_status >' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "sales/report/".$this->uri->assoc_to_uri($uri_array);
			}

			#----------sales data


			
            $sales_array = $this->sales_obj->get_sales_gst(array('columns' => array('a.id as primary_id','a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','a.updated_by','a.updated_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => $conditions));

                         $b_date= $sales_array[0]['bill_date'];
                         $b_group_id = $sales_array[0]['group_id'];
                         $this->load->model('booking/Booking_model','book_obj');
                         $conditions1 = array('a.group_id' => $b_group_id);
$book_array = $this->book_obj->get_sales(array('columns' => array('a.id as primary_id','a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','a.paid_amount','a.balance_amount','a.doctor','a.delivery_date','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.vendor_id','b.lens_quantity','b.lens_refno'),'conditions' => $conditions1));


			if(!empty($sales_array))
			{
				#------------loading model
				$this->load->model('customers/Customer_type_model','customer_type');

				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#------------checking cst enabled or not
			      /* $sales_cst = $this->sales_obj->get_cst($sales_array[0]['group_id']);*/
			      $sales_cst = 0;
                $vendor_name = $this->stock->vendor_name($book_array[0]['vendor_id']);
				$lens_refno = $book_array[0]['lens_refno'];
				$lens_qty = $book_array[0]['lens_quantity'];
				$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
				$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
				$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
				$area_id = $this->dms->get_area($sales_array[0]['area_id']);
				$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);

				#--------------cheque / dd details
				$cd_status = 1;$ccd = $cd_no = $pdc = "";
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_sales','a.table_group_id' => $sales_array[0]['group_id'])));
				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}

				#----------template
				$this->template->title("Sales Report");
				$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("view"));
				$this->template->breadcrumb($breadcrumb);
				$this->template->slice('dms/message');
				$this->template->slice('sales/sales_entry/view',array('sales_array' => $sales_array,'b_date'=>$b_date,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'vendor_name'=>$vendor_name,'lens_refno'=>$lens_refno,'lens_qty'=>$lens_qty,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'book_array'=>$book_array));
				$this->template->other_script('sales/sales_order');
				$this->template->render();
			}
			else
			{
				redirect($breadcrumb[$this->lang->line("go-back")]);
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

    public function update()
	{
		#----------voucher type
		$vtype_id = $this->vtype;
                
		#----------sales primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$sales_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "sales/report/".$this->uri->assoc_to_uri($uri_array);

			#----------redirect uri while updating
			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------sales cst checking details
			$sales_cst = $this->stock->get_constant(array('sales_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------cess %
			$cess = $this->stock->get_cess();

			#------------bill group_id and date
			$item_details = $this->sales_obj->get_group($sales_id);

			#-------------adding items to sales bill
			if(isset($_POST['btn_add']))
			{
				#-----------validation
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
				$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				//$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------adding items
				if($this->form_validation->run('btn_add') === true)
				{
					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
                    $item_array['hsn'] = $this->input->post('hsn',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = $this->input->post('unit_id',true);
					//$item_array['rate'] = $this->input->post('rate',true);
					$item_array['amount'] = $this->input->post('amount',true);
                                          
					#----------rate calculation
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0)
					{
						$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
					}

					$item_array['discount_per'] = $this->input->post('discount_per',true);
					$item_array['discount_amt'] = $this->input->post('discount_amt',true);
					$item_array['godown_id'] = $this->input->post('godown_id',true);
					$item_array['status'] = -1;
					$item_array['item_status'] = 2;//sales only items
					
					$sales_temp_item_result = $this->sales_obj->get_sales_gst(array('columns' => array('b.id','a.bill_date'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
					if($sales_temp_item_result == 0)
					{
						#----------TAX calculation
                        $sale_temp=$this->input->post('sales',true);
                        
                        $cgst = $this->stock->get_item_cgst($item_array['item_id']);
					    $sgst = $this->stock->get_item_sgst($item_array['item_id']);
                        
                        $item_array['taxable_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt'])*100)/(100+(float)$cgst+(float)$sgst+(float)$cess);
    					$item_array['cgst'] = $cgst;
    					$item_array['sgst'] = $sgst;
    					
    					$item_array['cgst_amt'] = ((float)$item_array['taxable_amt'] * (float)$cgst) / 100;
    					$item_array['sgst_amt'] = ((float)$item_array['taxable_amt'] * (float)$sgst) / 100;
    					$item_array['cess_amt'] = ((float)$item_array['taxable_amt'] * (float)$cess) / 100;

						#----------start transaction
						$this->db->trans_start();
                        $sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);
                                        
						if($sales_items_id)
						{
							$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('status' => -1),'conditions' => array('group_id' => $item_array['group_id'])));
							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 6,'table_group_id' => $item_array['group_id'],'table_id' => $sales_items_id));
							
							$result1 = $this->sales_obj->get_sales_itemss(array('columns' => array('id','item_id','qty','rate','amount','cgst','sgst'),'conditions' => array('group_id' => $item_array['group_id'],'status !=' => 0)));
                            if(!empty($result1))
            			    {
            			        foreach($result1 as $res1)
            			        {
            			            $ins_array = array();
            			            $ins_array['discount_per'] = 0;
            			            $ins_array['discount_amt'] = 0;
            			            $ins_array['taxable_amt'] = ((float)$res1['amount']*100)/(100+(float)$res1['cgst']+(float)$res1['sgst']);
            			            $ins_array['cgst_amt'] = ((float)$ins_array['taxable_amt']*(float)$res1['cgst'])/100;
            			            $ins_array['sgst_amt'] = ((float)$ins_array['taxable_amt']*(float)$res1['sgst'])/100;
            			            $ins_array['cess_amt'] = 0;
            			            
            			            $this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => $ins_array,'conditions' => array('id' => $res1['id'])));
                                }
            			    }
            			    
            			    $this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_discount_per'=>0,'bill_discount_amt'=>0),'conditions' => array('group_id' => $item_array['group_id'])));
                        
							$this->message->set($this->lang->line('sales-add-success'));
						}
						else
						{
							$this->message->set($this->lang->line('sales-add-error'),'e');
						}

						$this->db->trans_complete();
					}
					else
					{
						$this->message->set($this->lang->line('sales-add-error'),'e');
					}
					redirect($update_uri);
				}
			}

			if(isset($_POST['btn_update']))
			{
				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");

				$row = $this->sales_obj->get_bills(array('columns' => array('sid','s_status'),'conditions' => array('id' => $sales_id,'s_status >' => 0)));
				if(!empty($row))
				{
					$this->load->library('Sales_lib');
					$pre_bill_date = $this->sales_lib->get_bill_date($row[0]['sid'],$row[0]['s_status']);
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$pre_bill_date.>=]");
				}
				else
				{
					$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				}
			    $this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
                $this->form_validation->set_rules('sales[mobile]','lang:customer-name','xss_clean');
				$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
				$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
				if($this->input->post('payment_mode',true) == 2)
				{
					$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
				}
				elseif($this->input->post('payment_mode',true) > 2)
				{
					$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
					$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
					$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$item_details[bill_date].>=]");
				}
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				if($this->form_validation->run('btn_update') === true)
				{ 
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$bill_no = $this->input->post('bill_no',true);
					$narration = $this->input->post('remarks',true);
					$payment_mode = $this->input->post('payment_mode',true);
					$bill_discount_amt = $this->input->post('bill_discount_amt',true);
					$bill_discount_per = $this->input->post('bill_discount_per',true);
					$freight = $this->input->post('freight',true);
					$other_expense = $this->input->post('other_expense',true);
					
					$sales_temp_array = $this->input->post('sales',true);
                    $des_array = $this->input->post('des',true);

                    $customer_name = $sales_temp_array['customer_id'];
                    $cust_mob = $sales_temp_array['mobile'];
                    $doctor = $this->input->post('doctor',true);
                    $customer_id = $this->sales_obj->save_customer(array('fname'=>$customer_name,'mobile_no'=>$cust_mob,'status'=>1));
                    
                    $user_id = $sales_temp_array['salesman'];
                    
                    $up_date_time = date('Y-m-d H:i:s');
                    
					$sales_entry_array=array('bill_no' => $bill_no,'bill_date' => $bill_date,'user_id' =>$user_id,'customer_type_id' => 2,'customer_id' => $customer_id,'area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1,'updated_by'=>$this->session->userdata('id'),'updated_on'=>$up_date_time);

					$this->db->trans_start();
                    $group_id1 = $item_details['group_id'];

					if($this->sales_obj->update(array('table' => 'dms_sales','data' => $sales_entry_array,'conditions' => array('id' => $sales_id))))
					{
					    $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                        $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id='$item_details[group_id]'");
 
                        if($bill_discount_per>0)
                        {
                            $voucher_amount=0; $vat_amount=0; $cess_amount=0; $round_off_amount=0;
                            $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id','discount_amt'),'conditions' => array('group_id' => $group_id1,'status!=' => 0,'item_status >' => 0)));
   						
    						foreach($sales_items_array as $key => $value)
    						{
    						    $it_up_id = $value['id'];
    						    $itid = $value['item_id']; 
    						    $itamt =  (float)$value['qty']* (float)$value['rate'];
    						    $itdisc = $value['discount_amt'];
    						    $itmamt = (float)$itamt-(float)$itdisc;
    						    $itmdisc = ((float)$itmamt*(float)$bill_discount_per)/100;
    						    $itcgst = $this->stock->get_item_cgst($itid);
    						    $itsgst = $this->stock->get_item_sgst($itid);
    						    $it_taxable = (((float)$itmamt-(float)$itmdisc)*100)/(100+(float)$itcgst+(float)$itsgst+(float)$cess);
    						    $it_cgst_amt = ((float)$it_taxable*(float)$itcgst)/100; 
    						    $it_sgst_amt = ((float)$it_taxable*(float)$itsgst)/100; 
    						    $it_cess_amt = ((float)$it_taxable*(float)$cess)/100;
    						    
    						    (float)$voucher_amount += (float)$it_taxable;
    						    $vat_amount += (float)$it_cgst_amt+(float)$it_sgst_amt;
    						    (float)$cess_amount += (float)$it_cess_amt;
    						    
    						    $it_up_array = array('bill_disc_per'=>$bill_discount_per,'bill_disc_amt'=>$itmdisc,'taxable_amt'=>$it_taxable,'cgst'=>$it_cgst,'sgst'=>$it_sgst,'cgst_amt'=>$it_cgst_amt,'sgst_amt'=>$it_sgst_amt,'cess_amt'=>$it_cess_amt);
    						    $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						}
                        }
                        else
                        {
                            $voucher_amount = $this->input->post('grand_total',true);
    						$round_off_amount = $this->input->post('round_off_amount',true);
    						$vat_amount = $this->input->post('vat_total',true);
    						$cess_amount = $this->input->post('cess_total',true);
                        }
					    
						$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $item_details['group_id'],'status !=' => 0,'item_status >' => 0)));

						$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1,'stock_date'=>$bill_date),'conditions' => "table_group_id = ".$item_details['group_id']." and (stock_status = 5 or stock_status = 6)"));
                        
						$user_points = 0;$user_type = "";
						if($sales_entry_array['customer_type_id'] == 2)//customer
						{
							$user_id = $sales_entry_array['user_id'];
							$designation_id = $this->dms->get_desig($user_id);
							if($designation_id == 4)
							{
								$user_type = "c";
							}
							elseif($designation_id == 5)
							{
								$user_type = "m";
							}
							elseif($designation_id == 6)
							{
								$user_type = "e";
							}
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_array['customer_id'])));
						}
						else//branch or AR
						{
							$des_id = $sales_entry_array['customer_type_id'];
							$user_id = $sales_entry_array['user_id'];
                                                       
							if($des_id == 3)
							{
								$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_array['customer_id'])));
							}
							else
							{
								$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_array['customer_id'])));
							}

                            $designation_id = $this->dms->get_desig($user_id);
							if($designation_id == 4)
							{
								$user_type = "c";
							}
							elseif($designation_id == 5)
							{
								$user_type = "m";
							}
							elseif($designation_id == 6)
							{
								$user_type = "e";
							}
						}

						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2){
							$payment_mode = $customer[0]['ledger_id'];
						}
						//$voucher_amount -= $bill_discount_amt;
						 (float)$voucher_amount +=  (float)$round_off_amount;
						 (float)$voucher_amount +=  (float)$vat_amount;
						 (float)$voucher_amount += (float)$cess_amount;

						$voucher_data = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => array('id','group_id'),'conditions' => array('table_name' => 'dms_sales','table_group_id' => $item_details['group_id']),'order_by' => 'vorder_no','order' => 'asc','limit' => 1,'offset' => 0));
						if(empty($voucher_data))
						{
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
							$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $item_details['vtype_id'],'vno' => $item_details['group_id'],'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales','table_group_id' => $item_details['group_id'],'status' => $voucher_status);

							$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
							    if($payment_mode > 2)
								{
									$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}
						else
						{
							$voucher_array = array('vno' => $item_details['group_id'],'vdate' => $bill_date,'dr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'status' => $voucher_status);
							$voucher_success = $this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('id' => $voucher_data[0]['id'])));
							if($voucher_success)
							{
								#-----------VAT
								$voucher_array['vamount'] = $vat_amount;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'cr_ledger' => 12)));
								#-----------CESS
								$voucher_array['vamount'] = $cess_amount;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'cr_ledger' => 15)));
								#-----------Freight
								$voucher_array['cr_ledger'] = $payment_mode;
								unset($voucher_array['dr_ledger']);
								$voucher_array['vamount'] = $freight;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 13)));
								#-----------Other Expense
								$voucher_array['vamount'] = $other_expense;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 14)));

								if($payment_mode > 2)
								{
									if($this->dms->get_data(array('table' => 'dms_voucher_banks','columns' => array('id'),'conditions' => array('group_id' => $voucher_data[0]['group_id']),'numrows' => true)) == 0)
									{
										$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_data[0]['group_id'],'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
									else
									{
										$this->sales_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date),'conditions' => array('group_id' => $voucher_data[0]['group_id'])));
									}
								}
							}
						}
                             
                        $this->load->model('sms/Sms_model','sms');
	
						$sms_users = $this->sms->sms_user();
						$sms_user = $sms_users[0];
						$username = $sms_user['username'];
						$password = $sms_user['password'];
						$route = $sms_user['sms_type'];
						$msg_balance = $this->sms->sms_balance($username,$password,$route);		
															 
						$message="Sales bill with bill no. ".$bill_no." has been updated by ".get_username($this->session->userdata('id'));																		
						if($msg_balance > 0 )
						{
	                        $admin = $this->db->select(array('mobile'))->from('users')->where('id',-2)->get()->row_array();
							$user_mobile = $admin['mobile'];                                       
							/*if($this->sms->send($user_mobile,$message))
		 					{	
		                        $this->message->set($this->lang->line('message-sent'));	
	                            $d=array('mobile'=>$user_mobile,'message'=>$message);
	                            $this->db->insert('message_log',$d); 	
		  					}*/
		                }

						$this->message->set($this->lang->line('sales-edit-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-edit-error'),'e');
					}
			
			        $this->db->trans_complete();

					redirect('sales/report');
				}
			}

			$sales_array = $this->sales_obj->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.user_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.status','a.bill_status','a.created_by','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));

            $b_date=$sales_array[0]['bill_date'];        

			if(!empty($sales_array))
			{
			    $grid = $sales_array[0]['group_id'];
			    $des_array = $this->sales_obj->get_description($grid);
			    
			    $cust_id = $sales_array[0]['customer_id'];
                $this->load->model('customers/Customer_master_model','customer_master');
                $args = array('conditions'=>array('id'=>$cust_id));
                $cust_data = $this->customer_master->get($args); 
                $cust_name = $cust_data[0]['fname'];
                $cust_mob = $cust_data[0]['mobile_no'];
			    
				if($sales_array[0]['bill_status'] >= 2)
				{
					$this->message->set($this->lang->line('bill-already-converted'),'e');
					redirect($redirect_uri);
				}
				$continue = 1;
				if($sales_array[0]['status'] == -1)
				{
					if($sales_array[0]['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$stock_count="";$primary_unit['symbol']="";

					#------------loading model
					$this->load->model('designations/Designation_master_model','desig');
					$this->load->model('customers/Customer_type_model','customer_type');
					$this->load->model('areas/Area_model','area');

					#------------checking cst enabled or not
					/*$cst_status = $this->sales_obj->get_cst($sales_array[0]['group_id']);*/
					$cst_status = 0;
					if($cst_status)
					{
						$sales_cst = $cst_status;
					}

					#------------customer type and customer details
					$user_types = array();$desig_id="";$user="";$users=array();
					if($this->branch_status)
					{
						$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));

						#------------customer details
						if($sales_array[0]['customer_type_id'] == 1)
						{
							$this->load->model('branches/Branch_model','branches');
							$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
						}
						else if($sales_array[0]['customer_type_id'] ==2){
							$this->load->model('customers/Customer_master_model','customer_master');
							$customers = $this->customer_master->listing();
							#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
							#------------usertype details
							$user_types = $this->desig->listing(array('utype_status' => 1));
							if($sales_array[0]['user_id'] > 0)
							{
								$user = $sales_array[0]['user_id'];
								$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

								#------------user details
								$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
							}
						}
						else{
							$this->load->model('retailers/Counter_model','retailer_master');
							$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
                            $user_types = $this->desig->listing(array('utype_status' => 1));
                            if($sales_array[0]['user_id'] > 0)
							{
								$user = $sales_array[0]['user_id'];
								$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

								#------------user details
								$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
							}
						}
					}
					else
					{
						$customerTypes = $this->desig->listing(array('id' => 2));
						$this->load->model('customers/Customer_master_model','customer_master');
					  
						$customers = $this->customer_master->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));

						#------------usertype details
						$user_types = $this->desig->listing(array('utype_status' => 1));
						if($sales_array[0]['user_id'] > 0)
						{
							$user = $sales_array[0]['user_id'];
							$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

							#------------user details
							$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
						}
					}

					#------------pricelist details
					$pricelists = $this->customer_type->listing();

					#------------area details
					$areas = $this->area->listing();

					#------------payment modes
					$payment_modes = $this->stock->payment_modes();

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$units[''] = "Select";
					$args1['select'] = array('id','item_code','item_name','model_no');
		            $items = $this->stock->get_stock_items($args1);
					if(empty($items)){
						$this->message->set($this->lang->line('no-items-found'),'i');
					}
					if($this->input->post('item_id',true))
					{
						$itemID = $this->input->post('item_id',true);
						$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
						$units = $this->stock->get_units($itemID);
					}

					if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array[0]['bill_date'] != "")
					{
						$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array[0]['bill_date']);
						$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
					}

					$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);

                    $user_ids = $sales_array[0]['user_id'];
					$unmae = $this->sales_obj->listing();
					
					$cd_status = 1;$ccd = $cd_no = $pdc = "";
					$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_sales','a.table_group_id' => $sales_array[0]['group_id'])));
					if(!empty($cheque_dd_array))
					{
						$cd_status = 0;
						$ccd = $cheque_dd_array[0]['cash_type'];
						$cd_no = $cheque_dd_array[0]['cd_no'];
						$pdc = $cheque_dd_array[0]['pdc'];
					} 

					$areas[''] = 'Select';ksort($areas);
					$customers[''] = "Select";ksort($customers);
					$user_types[''] = "Select";ksort($user_types);
					$pricelists[''] = 'Select';ksort($pricelists);
					$items[''] = 'Select';ksort($items);
					$goDowns[''] = 'Select';ksort($goDowns);
					$users[''] = 'Select';ksort($users);
					
					$this->template->title("Edit Sales");
					$this->template->main_heading($this->lang->line("edit")." ".$this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales/add',$this->lang->line('report') => 'sales/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/sales_entry/edit',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'desig_id' => $desig_id,'b_date'=>$b_date,'user' => $user,'price_list_id' => $sales_array[0]['pricelist_id'],'area_id' => $sales_array[0]['area_id'],'payment_mode' => $sales_array[0]['payment_mode'],'voucher_name' => $voucher_name,'customerTypes' => $customerTypes,'customers' => $customers,'pricelists' => $pricelists,'areas' => $areas,'payment_modes' => $payment_modes,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'ccd' => $ccd,'cd_no' => $cd_no,'pdc' => $pdc,'redirect' => $redirect,'des_array'=>$des_array,'cust_name' => $cust_name,'cust_mob'=>$cust_mob,'user_name'=>$unmae,'user_id'=>$user_ids));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
			    redirect('users/logout');
			}
		}
		else
		{
	        redirect('users/logout');
		} 
	}

	public function delete()
	{
		#----------sales primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "sales/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->sales_obj->get_sales_gst(array('columns' => array('a.group_id','a.s_status','a.status','a.created_by','b.id','b.item_status'),'conditions' => array('a.id' => $id,'a.status !=' => 0,'b.item_status >' => 0)));
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{
						#-------------deleting stock from dms_vouchers
						$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_sales','table_group_id' => $row['group_id'])));

						if($row['s_status'] != 3)
						{
							foreach($result as $key => $value)
							{
								if($value['item_status'] == 2){
									#-------------deleting sales_items of sales
									$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 0),'conditions' => array('id' => $value['id'])));
								}
								else{
									#-------------deleting sales_items of sales order
									$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $value['id'])));
								}

								#-------------deleting stock bal. from dms_stocks
								$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 6)));
							}
						}
                                                else
                                                {
                                                   						
						   $this->sales_obj->update_others(array('table' => 'dms_booking','data' => array('book_status' => 0),'conditions' => array('group_id' => $row['group_id'])));
                                                   foreach($result as $key => $value)
						   {
                                                            $this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 6)));
                                                   }
						}

						#-------------deleting user points achieved through this bill
						//$this->sales_obj->update_others(array('table' => 'user_points','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-------------deleting sms
						$this->sales_obj->update_others(array('table' => 'dms_sms','data' => array('status' => 0),'conditions' => array('bill_ref_no' => $row['group_id'])));

						$this->message->set($this->lang->line('sales-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-delete-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}
	
	public function cancel()
	{
	    #----------sales primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "sales/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->sales_obj->get_sales_gst(array('columns' => array('a.group_id','a.s_status','a.status','a.created_by','b.id','b.item_status'),'conditions' => array('a.id' => $id,'a.status !=' => 0,'b.item_status >' => 0)));
			if(!empty($result))
			{
				$row = $result[0]; $continue = 1;
				if($row['status'] == -1)
				{
					if($row['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('status' => 2),'conditions' => array('id' => $id))))
					{
						$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 2),'conditions' => array('table_name' => 'dms_sales','table_group_id' => $row['group_id'])));

						if($row['s_status'] != 3)
						{
							foreach($result as $key => $value)
							{
								if($value['item_status'] == 2)
								{
									$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 2),'conditions' => array('id' => $value['id'])));
								}
								else
								{
									$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $value['id'])));
								}

								$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 6)));
							}
						}
                        else
                        {
                            $this->sales_obj->update_others(array('table' => 'dms_booking','data' => array('book_status' => 0),'conditions' => array('group_id' => $row['group_id'])));
                            foreach($result as $key => $value)
						    {
                                $this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 6)));
                            }
						}

						$this->sales_obj->update_others(array('table' => 'user_points','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));
						$this->sales_obj->update_others(array('table' => 'dms_sms','data' => array('status' => 0),'conditions' => array('bill_ref_no' => $row['group_id'])));
						$this->message->set($this->lang->line('sales-cancel-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-cancel-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function bill_pdf()
	{
        $pdf_name = 'sales';
		$pdf_contents = '';
		if(!$this->uri->segment(4))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_sales',array('id'=>$sales_id,'status'=>1)) === false)
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library(array('My_pdf','To_words'));

		#----------sales data
        $sales_array = $this->sales_obj->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.hsn','b.discount_amt','b.bill_disc_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
        $bill_date = $sales_array[0]['bill_date'];
        $group_id = $sales_array[0]['group_id'];
        $des_array = $this->sales_obj->get_description($group_id);
        $book_data = $this->sales_obj->get_booking($group_id);

		if(empty($sales_array))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		else
		{
			#------------loading model
			$this->load->model('customers/Customer_type_model','customer_type');
			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();
			#------------checking cst enabled or not
			$pdf_name = 'sales_bill_'.$sales_array[0]['bill_no'];
			/*$sales_cst = $this->sales_obj->get_cst($sales_array[0]['group_id']);*/
			$sales_cst = 0;
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);
			$pdf_file = 'sales_bill_ar_pdf';

			$args = array();
			$args['select'] = array('dsv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dsv.km','dsv.remarks','dsv.vehicle_type','dsv.vehicle_no as vehicle_number','dsv.driver_name');
			$args['conditions'] = array('dsv.group_id'=>$sales_array[0]['group_id']);
			$args['join'] = array('route_master as rm'=>'dsv.route_id=rm.id','vehicle_master as vm'=>'dsv.vehicle_id=vm.id','users as u'=>'dsv.driver_id=u.id');
			
			if($sales_array[0]['customer_type_id'] == 2)
			{
			    if($this->branchID==4 || $this->branchID=='31') //$this->dms->branch_type())
			    {
			        $pdf_file = 'sales_bill_tax_pdf';
			    }
			    else
			    {
				    $pdf_file = 'sales_bill_pdf';
			    }
			}
			else
			{
				$this->my_pdf->set_tin();
			}
			if($this->branchID==4 || $this->branchID=='31') //$this->dms->branch_type())
			{ 
			    
			}
			else
			{
			    $this->my_pdf->set_header();
			}

			$pdf_contents = $this->load->view('sales/sales_entry/'.$pdf_file,array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'customer_name' => $customer_name,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'des_array'=>$des_array,'book_data'=>$book_data),true);
		    
		} 
        //ob_end_clean();
        
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
	
	public function sales_registry(){
	 	#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
		#----------voucher type
		$conditions = array('a.status' => 1);
		$like_array = array();$vnos="";
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);
		#----------redirect
		$redirect = "";
		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('sales/sales_registry');
		$config['uri_segment'] = 3;
		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date']){
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		#----------validation
	    $this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		if($this->form_validation->run() === true){
		    if(!empty($this->input->post('from_date',true)) && !empty($this->input->post('to_date',true))){
                $from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
                $to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
                $config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
                $config['uri_segment'] += 4;
                $redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
            }
            if(!empty($this->input->post('item_group',true))){
			    $item_group = $this->input->post('item_group',true);
			    $conditions['d.item_group_id'] = $item_group;
			    $config['base_url'] .= '/item_group/'.$item_group;
			    $config['uri_segment'] += 2;
			    $redirect .= '/item_group/'.$item_group;
			}
            if(!empty($this->input->post('vendor_id',true))){
			    $vendor_id = $this->input->post('vendor_id',true);
			    $conditions['c.vendor_id'] = $vendor_id;
			    $config['base_url'] .= '/vendor_id/'.$vendor_id;
			    $config['uri_segment'] += 2;
			    $redirect .= '/vendor_id/'.$vendor_id;
			}
            if(!empty($this->input->post('salesman',true))){
			    $salesman = $this->input->post('salesman',true);
			    $conditions['a.user_id'] = $salesman;
			    $config['base_url'] .= '/salesman/'.$salesman;
			    $config['uri_segment'] += 2;
			    $redirect .= '/salesman/'.$salesman;
			}
			if(!empty($this->input->post('item_id',true))){
				$item_id = $this->input->post('item_id',true);
				$conditions['c.item_id'] = $item_id;
				$config['base_url'] .= '/item_id/'.$item_id;
				$config['uri_segment'] += 2;
				$redirect .= '/item_id/'.$item_id;
			}
		}elseif(!empty($uri_array)){
			if(isset($uri_array['fdate']) && isset($uri_array['tdate'])){
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['item_group'])){
				$item_group = $uri_array['item_group'];
				$conditions['d.item_group_id'] = $item_group;
				$config['base_url'] .= '/item_group/'.$item_group;
				$config['uri_segment'] += 2;
				$redirect .= '/item_group/'.$item_group;
			}
			if(isset($uri_array['vendor_id'])){
				$vendor_id = $uri_array['vendor_id'];
				$conditions['c.vendor_id'] = $vendor_id;
				$config['base_url'] .= '/vendor_id/'.$vendor_id;
				$config['uri_segment'] += 2;
				$redirect .= '/vendor_id/'.$vendor_id;
			}
			if(isset($uri_array['salesman'])){
				$salesman = $uri_array['salesman'];
				$conditions['a.user_id'] = $salesman;
			    $config['base_url'] .= '/salesman/'.$salesman;
			    $config['uri_segment'] += 2;
			    $redirect .= '/salesman/'.$salesman;
			}
			if(isset($uri_array['item_id'])){
				$item_id = $uri_array['item_id'];
				$conditions['c.item_id'] = $item_id;
				$config['base_url'] .= '/item_id/'.$item_id;
				$config['uri_segment'] += 2;
				$redirect .= '/item_id/'.$item_id;
			}
		}
		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
		#----------total rows
		$config['total_rows'] = $this->sales_obj->get_registry_billss1(array('columns' => array('a.id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));
        if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}
		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;
		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();
		#----------sales report datas
        $sales_array = $this->sales_obj->get_registry_billss1(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'a.bill_date','order'=>'ASC','limit'=>$config['per_page'],'offset'=>$offset));

		$args = array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}		
		$items[''] = 'Select';
		ksort($items);

        $item_groups1 = $this->item->item_group_listing();
        $item_groups1['']  = 'select';ksort($item_groups1);
        
        #------------vendor details
		$vendors = $this->stock->get_vendors();
		$vendors[''] = 'Select';ksort($vendors);
		#------------salesman details
        $unmae = $this->sales_obj->listing();
		#----------template
		$this->template->title("Sales Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales/add',$this->lang->line('report') => 'sales/report',$this->lang->line('sales-registry') => 'no_link'));
		$this->template->slice('sales/sales_entry/search_sales_registry',array('from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales','items'=>$items,'item_groups1'=>$item_groups1,'vendors'=>$vendors,'vendor_id'=>$vendor_id,'item_id'=>$item_id,'item_group'=>$item_group,'user_name'=>$unmae,'user_id'=>$salesman));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array)){
			$this->template->slice('sales/sales_entry/sales_registry',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();
	}
	
	public function sales_item_report(){
	 	$conditions = array('a.status' => 1,'c.status'=>1);
		$like_array = array();$vnos="";
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);
		#----------redirect
		$redirect = "";
		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('sales/sales_registry');
		$config['uri_segment'] = 3;
		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date']){
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		#----------validation
	    $this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		if($this->form_validation->run() === true){
		    if(!empty($this->input->post('from_date',true)) && !empty($this->input->post('to_date',true))){
                $from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
                $to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
                $config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
                $config['uri_segment'] += 4;
                $redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
            }
            if(!empty($this->input->post('item_group',true))){
			    $item_group = $this->input->post('item_group',true);
			    $conditions['d.item_group_id'] = $item_group;
			    $config['base_url'] .= '/item_group/'.$item_group;
			    $config['uri_segment'] += 2;
			    $redirect .= '/item_group/'.$item_group;
			}
		}elseif(!empty($uri_array)){
			if(isset($uri_array['fdate']) && isset($uri_array['tdate'])){
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['item_group'])){
				$item_group = $uri_array['item_group'];
				$conditions['d.item_group_id'] = $item_group;
				$config['base_url'] .= '/item_group/'.$item_group;
				$config['uri_segment'] += 2;
				$redirect .= '/item_group/'.$item_group;
			}
		}
		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
		#----------total rows
		$config['total_rows'] = $this->sales_obj->get_item_report(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));
        if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}
		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;
		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();
		#----------sales report datas
        $sales_array = $this->sales_obj->get_item_report(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'a.bill_date','order'=>'ASC','limit'=>$config['per_page'],'offset'=>$offset));

        $item_groups = $this->item->item_group_listing();
        $item_groups['']  = 'select';ksort($item_groups);
        
		#----------template
		$this->template->title("Sales Item Report");
		$this->template->main_heading($this->lang->line("sales-item-report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales/add',$this->lang->line('report') => 'sales/report',$this->lang->line('sales-item-report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search_item_report',array('from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales','item_groups'=>$item_groups,'item_group'=>$item_group));
		$this->template->slice('dms/message');
		if(!empty($sales_array)){
			$this->template->slice('sales/sales_entry/sales_item_report',array('sales_array'=>$sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
		}
		$this->template->render();
	}

    public function print_bill()
    {
		if(!$this->uri->segment(4))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_sales',array('id'=>$sales_id,'status'=>1)) === false)
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}

		$vtype_id = $this->vtype;

		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('To_words');	

        $sales_array = $this->sales_obj->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.hsn','b.discount_amt','b.bill_disc_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
        $bill_date=$sales_array[0]['bill_date'];
        $gr_id = $sales_array[0]['group_id'];
        $des_array = $this->sales_obj->get_description($gr_id);
        $book_data = $this->sales_obj->get_booking($gr_id);

		if(empty($sales_array))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		else
		{
			$this->load->model('customers/Customer_type_model','customer_type');
			
			$doctor = $book_data['doctor'];
            $paid_amt = $book_data['paid_amount'];
		    $bal_amt = $book_data['balance_amount'];
            $del_date = $book_data['delivery_date'];

			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);						
			
			if($this->branchID==4 || $this->branchID=='31') //$this->dms->branch_type())
		    {			
			   $this->load->view('sales/sales_entry/print_tax_bill',array('sales_array' => $sales_array,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'customer_name' => $customer_name,'area_id' => $area_id,'payment_mode' => $payment_mode,'paid_amount'=>$paid_amt,'bal_amount'=>$bal_amt,'del_date'=>$del_date,'doctor'=>$doctor,'des_array'=>$des_array,'book_array'=>$book_data));
		    }else{    
			    $this->load->view('sales/sales_entry/print_bill',array('sales_array' => $sales_array,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'customer_name' => $customer_name,'area_id' => $area_id,'payment_mode' => $payment_mode,'paid_amount'=>$paid_amt,'bal_amount'=>$bal_amt,'del_date'=>$del_date,'doctor'=>$doctor,'des_array'=>$des_array,'book_array'=>$book_data));
		    }
		}		
	}
	
	public function print_med_bill()
	{
		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_sales',array('id'=>$sales_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('To_words');	

		#----------sales data
	
                $sales_array = $this->sales_obj->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.s_type','a.ref_no','a.doctor','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.narration','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.hsn','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
                
                $bill_date=$sales_array[0]['bill_date'];
                $group_id = $sales_array[0]['group_id'];
                $ref_no =  $sales_array[0]['ref_no']; 
                $doctor = $sales_array[0]['doctor']; 
                $des_array = $this->sales_obj->get_description($group_id);
		if(empty($sales_array)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}else{
			#------------loading model
			$this->load->model('customers/Customer_type_model','customer_type');
				                        
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			
			$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);						
			$pdf_file = 'print_med_bill';			
			$this->load->view('sales/sales_entry/print_med_bill',array('sales_array' => $sales_array,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'customer_name' => $customer_name,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'doctor'=>$doctor,'des_array'=>$des_array,'ref_no'=>$ref_no));
		}		
	}

        public function barcode()
	{
               
            	#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_type_model','customer_type');

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------sales cst checking details
		$sales_cst = $this->stock->get_constant(array('sales_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();
		$this->load->library('Transport_lib');

				$vehicles =$drivers = $routes= $sales_vehicles = $sales_driver = array();

		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();

		#-----------sales date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus']){

			#-----------redirection if sales order / delivery note / purchase request conversion is pending
			if($result_array['s_status'] == 2){
				redirect("order_to_sales/so_sales/".$result_array['sid']);
			}
			/*elseif($result_array['s_status'] == 3){
				redirect("delivery_to_sales/sales/".$result_array['sid']);
			}*/
			elseif($result_array['s_status'] == 1){
				redirect("request_to_sales/pr_sales/".$result_array['sid']);
			}

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_sales as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_sales','a.table_group_id' => $group_id)));
			if(!empty($voucher_details))
			{
				redirect("sales/update/id/".$voucher_details[0]['id']);
			}  

			#------------checking cst enabled or not
			/*$cst_status = $this->sales_obj->get_cst($group_id);*/
			$cst_status =0;
			if($cst_status){
				$sales_cst = $cst_status;
			}
		}
		else{
			$group_id = $this->stock->get_group_id('dms_sales_items1');
		}

		#-------------adding data to sales temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('sales[bill_no]','lang:bill-no',"required|xss_clean|".$rules);
			$this->form_validation->set_rules('sales[bill_date]','lang:bill-date','required|xss_clean|valid_date');			
			$this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
                        $this->form_validation->set_rules('sales[mobile]','lang:mobile','required|xss_clean');
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');						
			$this->form_validation->set_rules('qty','lang:quantity','xss_clean|greater_than[0]|less_than[100000000]');
			

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
                                $sal_tem = $this->input->post('sales',true);
                                
				unset($item_array['sales']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);

                                $itemID = $item_array['item_id'];
                                if($item_array['qty']=='')
                                {
                                        $item_array['qty']='1';
                                } 

                                $qr_11 = $this->db->select(array('godown_id','unit_id'))->from('dms_stocks')->where('item_id',$item_array['item_id'])->get()->row_array();

                                $item_array['godown_id']=$qr_11['godown_id'];
                                $item_array['hsn']='1';                                
                                $item_array['unit_id']=$qr_11['unit_id'];
                                $item_array['rate']=$this->stock->get_item_rate($itemID); 
                                $item_array['amount']=($item_array['qty'])*($item_array['rate']);
                                $item_array['discount_per']='';
                                $item_array['discount_amt']='';


				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//sales only items

				#----------rate calculation
				$item_array['rate'] = 0;
				if($item_array['qty'] != 0){
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}
                                if($item_array['qty'] != 0)
                                  {
                              
                                   //$customer_id=$sal_tem['customer_id'];
                                   $qty = $item_array['qty'];
                                   $bill_no = $sal_tem['bill_no'];
                            /*     $sql = "insert into customer_quantity (customer_id,bill_no,group_id,qty,item_id) values ('$customer_id','$bill_no','$group_id','$qty','$item_id')";
$this->db->query($sql); */

								  }
	 		
                                $sales_temp_item_result = $this->sales_obj->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
				if($sales_temp_item_result == 0)
				{
					#----------GST calculation
   
                                        $cgst = $this->stock->get_item_cgst($item_array['item_id']);
					$sgst = $this->stock->get_item_sgst($item_array['item_id']);
					$item_array['cgst'] = $cgst;
					$item_array['sgst'] = $sgst;
					$item_array['cgst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$cgst) / 100;
					$item_array['sgst_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt']) * (float)$sgst) / 100;
 
					$sales_temp_array = $this->input->post('sales',true);
					$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
					$sales_temp_array = array_filter($sales_temp_array);

					#----------start transaction
					$this->db->trans_start();
//print_r($item_array);
					#-----------bill date and next bill no
					if($result_array['vstatus'] == 0)//data not in dms_sales
					{
						$vtype_id = $sales_temp_array['vtype_id'];
						$voucher_no = $sales_temp_array['bill_no'];
						$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
						$customer_type = 2;
						$customer_name = $sales_temp_array['customer_id'];
                                                $cust_mob = $sales_temp_array['mobile'];
                                                $doctor = $sales_temp_array['doctor'];
                                                $customer_id = $this->sales_obj->save_customer(array('fname'=>$customer_name,'mobile_no'=>$cust_mob,'status'=>1));
						$data_sales_temp=array('vtype_id' =>$vtype_id,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'customer_type_id' => 2,'customer_id' => $customer_id,'status' => -1);
		//	print_r($data_sales_temp);	
		//	print_r("sd");
						if(array_key_exists('pricelist_id',$sales_temp_array)){
							$data_sales_temp['pricelist_id'] = $sales_temp_array['pricelist_id'];
						}
//print_r($data_sales_temp);
						$this->sales_obj->insert("dms_sales",$data_sales_temp);
					}
else
{
echo "hi";
}
					#--------------adding sales items
                                                                   
                                        $sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);
					          

                                        if($sales_items_id)
					{
						#--------------adding temporary stock balance in dms_stocks
						$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
						if($stock_bal_temp)
						{
							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
						}
						$this->message->set($this->lang->line('sales-add-success'));

					}
					else
					{
						$this->message->set($this->lang->line('sales-add-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();
				}
				else{
					$this->message->set($this->lang->line('sales-add-error'),'e');
				}
				redirect('sales/barcode');
			}
		}

		#------------saving sales voucher
		if(isset($_POST['btn_save']))
		{
			#-----------validation
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) == 2){
				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
			}
			elseif($this->input->post('payment_mode',true) > 2){
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');


			#-----------saving data

			if($this->form_validation->run('btn_save') === true)
			{
				$payment_mode = $this->input->post('payment_mode',true);
				$narration = $this->input->post('remarks',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

                $sales_entry_check = $this->sales_obj->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.customer_type_id','a.customer_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));

				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					$vtype_id = $sales_entry_check[0]['vtype_id'];
					$bill_no = $sales_entry_check[0]['bill_no'];
                                        $customer_id = $sales_entry_check[0]['customer_id'];                                    
                                        $amount = $this->input->post('grand_total',true);
                                        $vat = $this->input->post('vat_total',true);
                                        $tot_amount = $amount+$vat;

if($bill_discount_amt)
{
if($bill_discount_amt != 0)
{
     $sqlu1 = "update customer_total_point set point='0' where cid='$customer_id'";
                             $this->db->query($sqlu1);
}
}


                                        $sql = "insert into customer_quantity (customer_id,bill_no,group_id,amount) values ('$customer_id','$bill_no','$group_id','$tot_amount')";
$this->db->query($sql);

					#----------start transaction
					$this->db->trans_start();
					if($this->sales_obj->update(array('table' => 'dms_sales','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
					{
					
                    	   

                      		$this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' =>0,'item_status >' => 0)));
                        								
$sl_qr = $this->db->select(array('id'))->from('dms_sales')->where('group_id',$group_id)->get()->row_array();							
                                                $sls_id = $sl_qr['id'];

						#--------------checking for user points and dr_ledger
						$user_points = 0;$user_type = "";
						if($sales_entry_check[0]['customer_type_id'] == 2)//customer
						{							
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
						}
						else//branch or AR
						{
							$designation_id = $sales_entry_check[0]['customer_type_id'];
							//$user_id = $sales_entry_check[0]['customer_id'];
							if($designation_id == 3)
							{
								$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
							else
							{
								$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
						}

                                                
							$customer_id = $sales_entry_check[0]['customer_id'];
							$designation_id = $sales_entry_check[0]['customer_type_id'];
                                                        $bill_no = $sales_entry_check[0]['bill_no'];

						 	$amt= $this->dms->get_qty($customer_id,$bill_no);
                                                        $customer_points = $this->targets->get_customer_bill_points($amt);
                                                        
                                                        $c_point = $this->db->select(array('point'))->from('customer_total_point')->where('cid',$customer_id)->get()->row_array();
                        if($c_point)
                        {
                             $cur_point = $c_point['point'];
echo "<br/>";
                             $new_point = $cur_point+$customer_points;
                             $sqlu = "update customer_total_point set point='$new_point' where cid='$customer_id'";
                             $this->db->query($sqlu);
                        }
                        else
                        {
                            $sql1 = "insert into customer_total_point(cid,point) values('$cust_id','$customer_points')";

                            $this->db->query($sql1);
                        }
                        $target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
						if($target_id2)
						{
							$this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));
						}
						
						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						$voucher_amount = $this->input->post('grand_total',true);
						$round_off_amount = $this->input->post('round_off_amount',true);
						$vat_amount = $this->input->post('vat_total',true);
						$cess_amount = $this->input->post('cess_total',true);
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
							$payment_mode = $customer[0]['ledger_id'];//customer
						}
						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
						(float)$voucher_amount += (float)$vat_amount;
						(float)$voucher_amount += (float)$cess_amount;

						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales','table_group_id' => $group_id,'status' => $voucher_status);
						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_sales','table_group_id' => $group_id),'numrows' => true));
						if($voucher_data == 0)
						{
							$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								#-----------VAT
							/*	$voucher_array['cr_ledger'] = 12;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['cr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['dr_ledger'] = 13;
								$voucher_array['cr_ledger'] = $payment_mode;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['dr_ledger'] = 14;
								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->sales_obj->insert('dms_vouchers',$voucher_array); */

								if($payment_mode > 2)
								{
									$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}
							$sales_items_array = $this->sales_obj->get_sales_itemss(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));

   						
						foreach($sales_items_array as $key => $value)
						{

                                                       
                                              
						
							#-------------enabling temporarily added stocks
							$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 6,'table_id' => $value['id'])));
                                              /*          if(!empty($customer_id))//cust_new
							{

								$customer_points += $this->targets->get_bill_points(0,1,$value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$bill_date);

							} */
						
						}
					/*	  if($customer_points > 0)//new_cust_28
						{
						
							$target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
							if($target_id2)
							{
								$this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));
									 
							}
						}
                        if(!empty($customer_type))//new_cust
						{
							$customer_data = $this->dms->get_data(array('table' =>'customer_master','columns' => 'mobile','conditions' => array('id' => $customer_id)));
							if(!empty($customer_data)){
								$customer_type_mobile=$customer_data[0]['mobile'];
								$this->sales_obj->insert('dms_sms_customer',array('company_id' =>$this->companyID,'bill_ref_no' => $group_id,'user_type'=>$customer_type_id,'user_id'=>$customer_id,'status'=>3));
							}
						} */
						$this->message->set($this->lang->line('sales-save-success'));


               #-------------------------------SMS----------------------------------

                                         $this->load->model('sms/Sms_model','sms');

						$sms_users = $this->sms->sms_user();
						$sms_user = $sms_users[0];
									//print_r($sms_user);
						$username = $sms_user['username'];
						$password = $sms_user['password'];
						$route = $sms_user['sms_type'];
						$msg_balance = $this->sms->sms_balance($username,$password,$route);		
											
						$cus_id=$sales_entry_check[0]['customer_id'];
                        $r=$this->db->select(array('mobile_no','fname'))->from('customer_master')->where('id',$cus_id)->get()->row_array();
                                   
                                               
                                                $message="Thank you for choosing SAMSONS OPTICALS.";	
					 
													
														
						if($msg_balance > 0)
						{

							$user_mobile = $r['mobile_no'];
                                                        $us_name = $r['fname'];
							$this->sms->send($user_mobile,$message);	
                                                        $this->message->set($this->lang->line('message-sent'));	
                                                        $sql = "insert into message_log (mobile, message) values ('$user_mobile','$message')";

                                                        $this->db->query($sql);
                                                        $sql1 = "insert into customer_sms (customer_name,customer_id,mobile,message) values ('$us_name','$cus_id','$user_mobile','$message')";
			 	                        $this->db->query($sql1);
						}		










                     #---------------------------------------------------------------------------------------


                                                $lnk='sales/print_bill/id/'.$sls_id;
						redirect($lnk);
					}
					else{
						$this->message->set($this->lang->line('sales-save-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();

					
					
				}
				else
				{
					$this->message->set($this->lang->line('sales-save-error'),'e');
				}
				redirect('sales/barcode');
			}
		}

		#------------customer type
		$user_types = array();$custType = 2;
		if($this->branch_status){
			$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		}
		else{
			$customerTypes = $this->desig->listing(array('id'=>2));
		}

		#------------item details / unit details / godown details
		$units = array();$goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------------sales temp data
		$sales_temp_data = array();$cust_id="";$users = array();$user = "";$pricelists=array();$desig_id="";
		$price_list_id="";$stock_count="";$primary_unit['symbol']="";
		if($result_array['vstatus'])
		{
			#------------area details
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
		
                        $sales_temp_data = $this->sales_obj->get_sales_gst(array('columns' => array('a.group_id','a.customer_type_id','a.customer_id','a.pricelist_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));


			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];

			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];
                        $this->load->model('customers/Customer_master_model','customer_master');
                        $args = array('conditions'=>array('id'=>$cust_id));
                        $cust_data = $this->customer_master->get($args);
                        $cust_name = $cust_data[0]['fname'];
                        $cust_mob = $cust_data[0]['mobile_no'];
			#------------user
			$user = $sales_temp_data[0]['user_id'];
                        
			#------------user designation
			$desig_id = $this->dms->get_desig($user);

			#------------user details
			$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));

			#------------pricelist id
			$price_list_id = $sales_temp_data[0]['pricelist_id'];;
		}
		else
		{
			$sales_array = $this->input->post('sales',true);
			#------------customer type
			if($sales_array['customer_type'] != ""){
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != ""){
				$cust_id = $sales_array['customer_id'];
			}

			#------------user details
			if($sales_array['user_type'] != ""){
				$desig_id = $sales_array['user_type'];
				$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
				if($sales_array['user_id'] != ""){
					$user = $sales_array['user_id'];
				}
			}

			#------------pricelist
			if(isset($sales_array['pricelist_id']) && $sales_array['pricelist_id'] != ""){
				$price_list_id = $sales_array['pricelist_id'];
			}

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}

		#------------customer details
		if($this->branch_status)
		{
			if($custType == 1){

				$this->load->model('branches/Branch_model','branches');
				$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
			}
			else if($custType ==2){
				$this->load->model('customers/Customer_master_model','customer_master');
				$customers = $this->customer_master->listing();
				#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
			}
			else{
				$this->load->model('retailers/Counter_model','retailer_master');
				$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
			}
		}
		else
		{
			$this->load->model('customers/Customer_master_model','customer_master');
			$customers = $this->customer_master->listing();
			#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
		}

		#------------usertype details
		$user_types = $this->desig->listing(array('utype_status' => 1));

		#------------pricelist details
		$pricelists = $this->customer_type->listing();

		$areas[''] = 'Select';ksort($areas);
		$customers[''] = "Select";ksort($customers);
		$user_types[''] = "Select";ksort($user_types);
		$pricelists[''] = 'Select';ksort($pricelists);
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$users[''] = 'Select';ksort($users);

		#------------payment modes
		$payment_mode = $this->stock->payment_modes();

		#------------cheque / dd details
		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2){
			$cd_status = 0;
		}

		#------------template
		$this->template->title("New Sales Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales/report'));
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_entry/barcode_add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'user_types' => $user_types,'users' => $users,'user' => $user,'pricelists' => $pricelists,'price_list_id' => $price_list_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'cust_name' => $cust_name,'cust_mob'=>$cust_mob,'cust_id' => $cust_id,'desig_id' => $desig_id,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes));
		$this->template->other_script('sales/sales_order');
				$this->template->other_script('vehicles/assign_vehicle');

		$this->template->render();
	}


        public function balance_report()
	{
		#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
                $this->load->model('booking/Booking_model','book_obj');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('sales/balance_report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
                $this->form_validation->set_rules('phone','phone','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
                        $conditions['balance>'] = 0;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
                        if(!empty($this->input->post('phone',true)))
			{
                            $ph = $this->input->post('phone',true);  
                            $cust_qr=$this->db->select('id')->from('customer_master')->where('mobile_no',$ph)->get()->row_array();
                            $cust_ids= $cust_qr['id']; 
                            if(!empty($cust_ids))
                            {
                                   $conditions['customer_id'] = $cust_ids;
                            }
                        }
                        if(!empty($this->input->post('customer_id',true)))
			{
                            $cust_ids = $this->input->post('customer_id',true);                                                                                   
                            $conditions['customer_id'] = $cust_ids;                        
                        }
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
                        $conditions['balance>'] = 0;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows

		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

                $this->load->model('customers/Customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
                $customers['']= "Select";
                ksort($customers);

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Sales Balance Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("balance report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales/add',$this->lang->line('report') => 'sales/report',$this->lang->line('balance-report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'ph'=>$ph,'rtype' => 'sales','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('sales/sales_entry/balance_report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();
	}

    public function cancelled_report()
	{
		$this->load->model('designations/Designation_master_model','desig');
        $this->load->model('products/Item_model','item');

		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		$voucher_types = $this->vouchers->voucher_types_all($this->vtype);

		$uri_array  = $this->uri->uri_to_assoc(3);

		$redirect = "";

		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('sales/cancelled_report');
		$config['uri_segment'] = 3;

		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
            if(!empty($this->input->post('customer_id',true)))
			{
                $cust_ids = $this->input->post('customer_id',true);                                                                                   
                $conditions['customer_id'] = $cust_ids;                        
            }
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

	    $between = "bill_date between '$from_date' and '$to_date'";
        $conditions['status'] = '2';
		
		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

        $this->load->model('customers/Customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
        $customers['']= "Select";
        ksort($customers);

		$presumptive_tax = $this->stock->get_tax_type();

		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		$this->template->title("Sales Cancelled Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("cancelled")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line('booking') => 'sales/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search_cancelledreprt',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('sales/sales_entry/cancelled_report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		} 
		$this->template->render();
	}

}
?>