<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_barcode extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branch_id = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add');
		fiscal_status($this->uri->segment(2),$method_array,"sales/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
        $this->load->model('users/User_point_model','user_point');
        $this->load->model('products/Item_model','item');
		$this->load->library(array('Stock','Targets'));
                
		#-----------checking branch_type
		$this->branch_status = 0;
		if($this->dms->branch_type())
		{
			$this->branch_status = 1;
		}

		#----------voucher type
		$this->vtype = 6;
	}

	public function add()
	{              
        #----------loading models
		$this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_type_model','customer_type');
        $this->load->model('products/Unit_model','unit');

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------sales cst checking details
		$sales_cst = $this->stock->get_constant(array('sales_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();				

		#-----------sales date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus'])
        { 
			#-----------redirection if sales order / delivery note / purchase request conversion is pending
			if($result_array['s_status'] == 2)
			{
				redirect("order_to_sales/so_sales/".$result_array['sid']);
			}
			elseif($result_array['s_status'] == 1)
			{
				redirect("request_to_sales/pr_sales/".$result_array['sid']);
			}

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_sales as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_sales','a.table_group_id' => $group_id)));
			if(!empty($voucher_details))
			{
				redirect("sales/update/id/".$voucher_details[0]['id']);
			}  

			#------------checking cst enabled or not
			//$cst_status = $this->sales_obj->get_cst($group_id);
			$cst_status=0;
			if($cst_status)
			{
				$sales_cst = $cst_status;
			}
		}
		else
		{ 
			$group_id = $this->stock->get_group_id('dms_sales_items1');
		}

		#-------------adding data to sales temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			//$this->form_validation->set_rules('sales[bill_no]','lang:bill-no',"required|xss_clean|".$rules);
			$this->form_validation->set_rules('sales[bill_no]','lang:bill-no',"required|xss_clean");
			$this->form_validation->set_rules('sales[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
			$this->form_validation->set_rules('sales[mobile]','lang:mob','required|xss_clean');  
            $this->form_validation->set_rules('s_type','lang:bill-type','required|xss_clean');

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
                $sal_tem = $this->input->post('sales',true);
                $des_array = $this->input->post('des',true);
                $s_type = $this->input->post('s_type',true);

				unset($item_array['sales']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
                unset($item_array['gstin']);
                unset($item_array['des']);  
                unset($item_array['s_type']); 
                unset($item_array['sal_item']);
				unset($item_array['rno']);

				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//sales only items
				$bill_nos = $sal_tem['bill_no'];
			    $billdate = date('Y-m-d',strtotime($sal_tem['bill_date']));
			    
			      for($i=1;$i<=10;$i++)
                {
                    $result_array = $this->sales_obj->next_bill_no($this->vtype);
                    $item_code = $item_array['code'.$i];
                              
                    if($item_code!=null )  
                    { 
                      $itemarray = array();
                        $data_salestemp = array();
                        
                        $qry_godown = $this->db->select('id')->from('godown_master')->where(array('branch_id' => $this->branch_id,'status'=>1))->get()->row_array();
		                $godown_id = $qry_godown['id'];
                                   
                        $item_id = $this->stock->get_item_datas($item_code);
                        $item_unit = $this->stock->get_unit_id($item_id); 
                                    
                        $itemarray['item_id'] = $item_id;
                                    
                        $cgst = $this->stock->get_item_cgst($itemarray['item_id']);
					    $sgst = $this->stock->get_item_sgst($itemarray['item_id']);
                                        
                        $sales_temp_item_result = $this->sales_obj->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_id,'godown_id' => $godown_id,'unit_id' => $item_unit,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
                        if($sales_temp_item_result == 0)
				        { 
                             $itemarray['group_id'] = $item_array['group_id'];
                            $itemarray['qty'] = $item_array['qty'.$i];
                            $itemarray['unit_id'] = $item_unit;
                            $itemarray['rate'] = $item_array['rate'.$i];
                            $itemarray['amount'] = $item_array['amt'.$i];
                            $itemarray['discount_per'] = 0;
                            $itemarray['discount_amt'] = 0;
                            $itemarray['taxable_amt'] = ((float)$itemarray['amount']*100)/(100+(float)$cgst+(float)$sgst+(float)$cess);
                            $itemarray['cgst'] = $cgst;
                            $itemarray['sgst'] = $sgst;
                            $itemarray['cgst_amt'] = ((float)$itemarray['taxable_amt']*(float)$cgst)/100;
                            $itemarray['sgst_amt'] = ((float)$itemarray['taxable_amt']*(float)$sgst)/100;
                            $itemarray['cess_amt'] = ((float)$itemarray['taxable_amt']*(float)$cess)/100;
                            $itemarray['godown_id'] = $godown_id;
                            $itemarray['status'] = -1;
                            $itemarray['item_status'] = 2;
                           
        					$sales_temp_array = $this->input->post('sales',true);
        					$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
        					$sales_temp_array['s_type'] = $this->input->post('s_type',true);
        					$sales_temp_array = array_filter($sales_temp_array);
					
                            $user_id = $this->session->userdata('id');
                            $ukey = $this->db->select(array('designation_id'))->from('users')->where('id',$user_id)->get()->row_array();
                            $user_type = $ukey['designation_id'];
                            
        					#----------start transaction
        					$this->db->trans_start();
                            
        					#-----------bill date and next bill no
        					if($result_array['vstatus'] == 0)//data not in dms_sales
        					{
        						$vtype_id = $sales_temp_array['vtype_id'];
        						$voucher_no = $sales_temp_array['bill_no'];
        						
        						if($s_type == "med")
        			            {                                                
        			                 $ref_no = $sales_temp_array['ref_no'];
        			            }
        			            else
        			            { 
                                    $ref_no = 0;
                                }
        						
        						$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
        						
        						$customer_type = 2;
        						$customer_name = $sales_temp_array['customer_id'];
                                $cust_mob = $sales_temp_array['mobile'];
                                $cust_addr = $sales_temp_array['address'];
                                $cust_mail = $sales_temp_array['email_id'];
                                if(empty($cust_addr)){ $cust_addr = " ";}
                                if(empty($cust_mail)){ $cust_mail = " ";}
                                $doctor = $sales_temp_array['doctor']; if(empty($doctor)){ $doctor = " ";}
                                $customer_id = $this->sales_obj->save_customer(array('fname'=>$customer_name,'mobile_no'=>$cust_mob,'address'=>$cust_addr,'email_id'=>$cust_mail,'status'=>1));
        
        						$data_sales_temp = array('vtype_id' =>$vtype_id,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'customer_type_id' => $customer_type,'customer_id' => $customer_id,'s_type'=>$s_type,'ref_no'=>$ref_no,'doctor'=>$doctor,'cess'=>$cess,'status' =>-1);
        						
        						if(array_key_exists('pricelist_id',$sales_temp_array))
        						{
        							$data_sales_temp['pricelist_id'] = $sales_temp_array['pricelist_id'];
        						}
        				
						        $this->sales_obj->insert("dms_sales",$data_sales_temp);
						        $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                                $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                                $this->db->query("insert into doctor_description(group_id,customer_id,ldv1,ldv2,ldv3,ldv4,lnv1,lnv2,lnv3,lnv4,ladd,lipg,rdv1,rdv2,rdv3,rdv4,rnv1,rnv2,rnv3,rnv4,radd,ripg) values('$group_id','$customer_id','$ldv1','$ldv2','$ldv3','$ldv4','$lnv1','$lnv2','$lnv3','$lnv4','$ladd','$lipg','$rdv1','$rdv2','$rdv3','$rdv4','$rnv1','$rnv2','$rnv3','$rnv4','$radd','$ripg')");
				            }
				            
				            $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                            $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                            $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id='$group_id' and customer_id='$customer_id'");
 
					        #--------------adding sales items
					       
                            $sales_items_id = $this->sales_obj->insert("dms_sales_items1",$itemarray);
					          
                            if($sales_items_id)
        					{
        						#--------------adding temporary stock balance in dms_stocks
            					$stock_bal_temp = $this->stock->unit_conversion($itemarray['item_id'],$itemarray['unit_id'],$itemarray['qty'],$itemarray['rate'],$itemarray['amount']);
        						if($stock_bal_temp)
        						{
        							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $itemarray['godown_id'],'item_id' => $itemarray['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
        						}
        						$this->message->set($this->lang->line('sales-add-success'));
        					}
        					else
    				        {
    					        $this->message->set($this->lang->line('sales-add-error'),'e');
    				        }

					        #----------transaction completed
					       $this->db->trans_complete();
					    }
                    }
                }
			    echo '<script>window.location.href = "'.base_url('sales_barcode/add').'";</script>';    
			    //redirect('sales_barcode/add');
			}
		}

		#------------saving sales voucher
		if(isset($_POST['btn_save']))
		{
			#-----------validation

			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) == 2)
			{
				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
			}
			elseif($this->input->post('payment_mode',true) > 2)
			{
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------saving data

			if($this->form_validation->run('btn_save') === true)
			{
				$payment_mode = $this->input->post('payment_mode',true);
				$narration = $this->input->post('remarks',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
				$bill_discount_per = $this->input->post('bill_discount_per',true);
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

                $sales_entry_check = $this->sales_obj->get_sales_gst(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.customer_type_id','a.customer_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));

				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					$vtype_id = $sales_entry_check[0]['vtype_id'];
					$bill_no = $sales_entry_check[0]['bill_no'];
                    $customer_id = $sales_entry_check[0]['customer_id'];                                    
                    $amount = $this->input->post('grand_total',true);
                    $vat = $this->input->post('vat_total',true);
                    $tot_amount = (float)$amount+(float)$vat; 

					#----------start transaction
					$this->db->trans_start();
					if($this->sales_obj->update(array('table' => 'dms_sales','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
					{
					    $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                        $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id='$group_id'");
 
                        if($bill_discount_per>0)
                        {
                            $voucher_amount=0;  $vat_amount=0; $round_off_amount=0; $cess_amount=0;
                            $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status!=' => 0,'item_status >' => 0)));
   						
    						foreach($sales_items_array as $key => $value)
    						{
    						    $it_up_id = $value['id'];
    						    $itid = $value['item_id']; 
    						    $itamt = (float)$value['qty']*(float)$value['rate'];
    						    $itdiscamt = ((float)$itamt*(float)$bill_discount_per)/100;
    						    $it_cgst = $this->stock->get_item_cgst($itid);
    						    $it_sgst = $this->stock->get_item_sgst($itid);
    						    
    						    $it_taxable = (((float)$itamt-(float)$itdiscamt)*100)/(100+(float)$it_cgst+(float)$it_sgst+(float)$cess);
    						    $it_cgst_amt = ((float)$it_taxable*(float)$it_cgst)/100; 
    						    $it_sgst_amt = ((float)$it_taxable*(float)$it_sgst)/100; 
    						    $it_cess_amt = ((float)$it_taxable*(float)$cess)/100; 
    						    
    						    (float)$voucher_amount += (float)$it_taxable;
    						    (float)$vat_amount += (float)$it_cgst_amt+(float)$it_sgst_amt;
    						    (float)$cess_amount += (float)$it_cess_amt;
    						    
    						    $it_up_array = array('discount_per'=>$bill_discount_per,'discount_amt'=>$itdiscamt,'taxable_amt'=>$it_taxable,'cgst'=>$it_cgst,'sgst'=>$it_sgst,'cgst_amt'=>$it_cgst_amt,'sgst_amt'=>$it_sgst_amt,'cess_amt'=>$it_cess_amt);
    						
    						    $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						}
                        }
                        else
                        {
                            $voucher_amount = $this->input->post('grand_total',true);
    						$round_off_amount = $this->input->post('round_off_amount',true);
    						$vat_amount = $this->input->post('vat_total',true);
    						$cess_amount = $this->input->post('cess_total',true);
                        }
					    
                        $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' =>0,'item_status >' => 0)));
                        								
                        $sl_qr = $this->db->select(array('id'))->from('dms_sales')->where('group_id',$group_id)->get()->row_array();							
                        $sls_id = $sl_qr['id'];

						#--------------checking for user points and dr_ledger
						$user_points = 0;$user_type = "";
						if($sales_entry_check[0]['customer_type_id'] == 2)//customer
						{							
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
						}
						else//branch or AR
						{
							$designation_id = $sales_entry_check[0]['customer_type_id'];
							//$user_id = $sales_entry_check[0]['customer_id'];
							if($designation_id == 3)
							{
								$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
							else
							{
								$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
						}

                                                $customer_id = $sales_entry_check[0]['customer_id'];
						$designation_id = $sales_entry_check[0]['customer_type_id'];
                                                $bill_no = $sales_entry_check[0]['bill_no'];

						$amt= $this->dms->get_qty($customer_id,$bill_no);
                                                $customer_points = $this->targets->get_customer_bill_points($amt);
                                              
                                                $target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
						if($target_id2)
						{
						         $this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));

						}
						
						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
							$payment_mode = $customer[0]['ledger_id'];//customer
						}
						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
						(float)$voucher_amount += (float)$vat_amount;
						(float)$voucher_amount += (float)$cess_amount;
						(float)$voucher_amount = round_this($voucher_amount);
						
						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $group_id,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales','table_group_id' => $group_id,'status' => $voucher_status);
						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_sales','table_group_id' => $group_id),'numrows' => true));
						if($voucher_data == 0)
						{
							$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								#-----------VAT
							/*	$voucher_array['cr_ledger'] = 12;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['cr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['cr_ledger'] = 13;
								$voucher_array['dr_ledger'] = $payment_mode;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['cr_ledger'] = 14;

								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);*/

								if($payment_mode > 2)
								{
									$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}
						
						$sales_items_array = $this->sales_obj->get_sales_itemss(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));
   						
						foreach($sales_items_array as $key => $value)
						{
							$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 6,'table_id' => $value['id'])));
                       	}
					
						$this->message->set($this->lang->line('sales-save-success'));

                        #-------------------------------SMS----------------------------------

                        /*  $this->load->model('sms/sms_model','sms');

						$sms_users = $this->sms->sms_user();
						$sms_user = $sms_users[0];
									//print_r($sms_user);
						$username = $sms_user['username'];
						$password = $sms_user['password'];
						$route = $sms_user['sms_type'];
						$msg_balance = $this->sms->sms_balance($username,$password,$route);		
											
						$cus_id=$sales_entry_check[0]['customer_id'];
                        $r=$this->db->select(array('mobile_no','fname'))->from('customer_master')->where('id',$cus_id)->get()->row_array();                                   
                        $message="Thank you for choosing NETHRA OPTICALS.";	
					 																											
						if($msg_balance > 0)
						{
							$user_mobile = $r['mobile_no'];
                            $us_name = $r['fname'];
							$this->sms->send($user_mobile,$message);	
                            $this->message->set($this->lang->line('message-sent'));	
                            $sql = "insert into message_log (mobile, message) values ('$user_mobile','$message')";

                            $this->db->query($sql);
                            $sql1 = "insert into customer_sms (customer_name,customer_id,mobile,message) values ('$us_name','$cus_id','$user_mobile','$message')";
			 	            $this->db->query($sql1);
					    }	*/	

                        #---------------------------------------------------------------------------------------
                         echo "<script>window.open('/sales/print_bill/id/$sls_id','_blank');</script>";
                        //$lnk='sales/print_bill/id/'.$sls_id;
						//redirect($lnk);
					}
					else
					{
						$this->message->set($this->lang->line('sales-save-error'),'e');
					}

					#----------transaction completed
					
					$this->db->trans_complete();
				    echo '<script>window.location.href = "'.base_url('sales_barcode/add').'";</script>';    
				}
				else
				{
					$this->message->set($this->lang->line('sales-save-error'),'e');
				}
				echo '<script>window.location.href = "'.base_url('sales_barcode/add').'";</script>';
			}
				
		}
		
		$this->load->model('godown/Godown_model','godown');

                $units1 = $this->unit->listing();
                $item_groups1 = $this->item->item_group_listing();
                $godowns1 = $this->godown->listing();

		#------------customer type
		$user_types = array();$custType = 2;
		if($this->branch_status){
			$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		}
		else{
			$customerTypes = $this->desig->listing(array('id'=>2));
		}

		#------------item details / unit details / godown details
		$units = array();$goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
	//	if(empty($items)){
	//		$this->message->set($this->lang->line('no-items-found'),'i');
	//	}
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);

			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------------sales temp data
		$sales_temp_data = array();$cust_id="";$users = array();$user = "";$pricelists=array();$desig_id="";
		$price_list_id="";$stock_count="";$primary_unit['symbol']="";
		if($result_array['vstatus'])
		{
			#------------area details
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
		
            $sales_temp_data = $this->sales_obj->get_sales_gst(array('columns' => array('a.group_id','a.customer_type_id','a.s_type','a.ref_no','a.doctor','a.customer_id','a.pricelist_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));

            $stype = $sales_temp_data[0]['s_type'];
            $refno = $sales_temp_data[0]['ref_no'];
            
            $gr_id = $sales_temp_data[0]['group_id']; 
            $des_array = $this->sales_obj->get_description($gr_id); 
            
            $doctor = $sales_temp_data[0]['doctor'];
			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];

			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];
			$this->load->model('customers/Customer_master_model','customer_master');
            $args = array('conditions'=>array('id'=>$cust_id));
            $cust_data = $this->customer_master->get($args);
            $cust_name = $cust_data[0]['fname'];
            $cust_mob = $cust_data[0]['mobile_no'];
		}
		else
		{
			$sales_array = $this->input->post('sales',true);
			#------------customer type
			if($sales_array['customer_type'] != ""){
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != ""){
				$cust_id = $sales_array['customer_id'];
			}

			#------------user details
			if($sales_array['user_type'] != ""){
				$desig_id = $sales_array['user_type'];
				$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
				if($sales_array['user_id'] != ""){
					$user = $sales_array['user_id'];
				}
			}

			#------------pricelist
			if(isset($sales_array['pricelist_id']) && $sales_array['pricelist_id'] != ""){
				$price_list_id = $sales_array['pricelist_id'];
			}

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}

		#------------customer details
		if($this->branch_status)
		{
			if($custType == 1){

				$this->load->model('branches/Branch_model','branches');
				$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
			}
			else if($custType ==2){
				$this->load->model('customers/Customer_master_model','customer_master');
				$customers = $this->customer_master->listing();
				#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
			}
			else{
				$this->load->model('retailers/Counter_model','retailer_master');
				$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
			}
		}
		else
		{
			$this->load->model('customers/Customer_master_model','customer_master');
			$customers = $this->customer_master->listing();
		
			#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
		}
        
        $branch_det = $this->db->select(array('id','branch_name','ledger_id','area_id'))->from('branch_master')->where('id',$this->branch_id)->get()->row_array();
        $branch_area = $branch_det['area_id'];
        
        $itemcodes = $this->item->itemcode(); 

		#------------usertype details
		$user_types = $this->desig->listing(array('utype_status' => 1));

		#------------pricelist details
		$pricelists = $this->customer_type->listing();

		$areas[''] = 'Select';ksort($areas);
	//	$customers[''] = "Select";ksort($customers);
		$user_types[''] = "Select";ksort($user_types);
		$pricelists[''] = 'Select';ksort($pricelists);
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$users[''] = 'Select';ksort($users);

		#------------payment modes
		$payment_mode = $this->stock->payment_modes();

		#------------cheque / dd details
		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2)
		{
			$cd_status = 0;
		}

		#------------template
		$this->template->title("New Sales Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales/report'));
		$this->template->slice('dms/message');
		$this->template->slice('sales/barcode/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'user_types' => $user_types,'users' => $users,'user' => $user,'pricelists' => $pricelists,'price_list_id' => $price_list_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'cust_name' => $cust_name,'cust_mob'=>$cust_mob,'doctor'=>$doctor,'cust_id' => $cust_id,'desig_id' => $desig_id,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix' => $bill_prefix,'refno' => $refno,'stype' => $stype,'doctor' => $doctor,'des_array'=>$des_array,'units1' => $units1,'groups1' => $item_groups1,'godowns1' => $godowns1,'itemcodes'=>$itemcodes,'branch_area'=>$branch_area));
		$this->template->other_script('barcode/sale');		
		$this->template->render();
	}
}