<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
class Sales_order extends MY_Controller{

	public function __construct(){

		parent::__construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add');
		fiscal_status($this->uri->segment(2),$method_array,"sales_order/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$this->load->library(array('Stock'));

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

	}

	#======================================================
	public function add(){

		$this->template->title($this->lang->line('sales-order'));
		$this->template->main_heading($this->lang->line('sales-order'));
		$this->template->breadcrumb(array($this->lang->line('sales-order') => 'no_link',$this->lang->line('report') => 'sales_order/report'));
		$this->load->model('customers/Customer_master_model','customer_master');
		$this->load->model('customers/Customer_type_model','customer_type');
		$this->load->model('sales/Sales_order_temp_model','sales_order_temp');
		$this->load->model('areas/Area_model','area');
		$this->load->model('designations/Designation_master_model','designations');

		$selCustType=2;
		$user_types = $this->designations->listing(array('utype_status'=>1));
		if($this->dms->get_main_branch($this->branchID) === true){
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status >'=>1));
		}else{
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status'=>4));
		}

$lm_date = '2017-07-01';
		$SalesOrderItems = $users = $units = $goDowns = $areas = $sales_order_items = array();
		$item_rate=$bill_num=$bill_date=$user_type=$item_id=$godown=$quantity=$unit =$rateAmount=NULL;
		$primary_unit=$discount_percent = $discount_amount = $customer_id = $user=$sales_order_item_count=NULL;
		$bill_date = date('Y-m-d');$cstEnabled = 0;

		$sales_orders = array();
		#-----get max. bill number----------------------------
		$bill_num = $this->sales_order_temp->get_sales_order_number();
		#-----get max. bill number----------------------------
		$customers = $this->stock->get_customers($selCustType,0);

		$items = $this->stock->get_stock_items();
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		$areas = $this->area->listing();
		if($this->input->post('user_type')){
			$userTypeID = $this->input->post('user_type');
			if(!empty($userTypeID)){
				$users = $this->dms->get_users(array('conditions'=>array('designation_id'=>$userTypeID,'branch_id'=>$this->branchID)));
			}
		}

		$presumtiveTax = $this->stock->get_tax_type();

		#------get all godowns-----------------------------------------------
		if($this->input->post('item_id')){
			$itemID = $this->input->post('item_id');
			$item_rate = $this->stock->get_item_rate($itemID);
			$primary_unit = ' / '.$this->stock->get_primary_unit($itemID)['symbol'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}
		#------get all godowns-----------------------------------------------

		$args = array();
		$args['select'] = array('id','branch_id','so_no','so_date','customer_type_id','customer_id',/*'user_id',*/'area_id','discount_per','discount_amt','cess','order_status','order_id');
		$args['conditions'] = array('branch_id'=>$this->branchID,'created_by'=>$this->createdBY);
		$sales_orders = $this->sales_order_temp->get_temp_order($args);

		if(!empty($sales_orders)){

			$salesOrderID = $sales_orders[0]['id'];
			$bill_num = $sales_orders[0]['so_no'];
			$custType = $sales_orders[0]['customer_type_id'];
			$customerType = $custType;
			$customerID = $sales_orders[0]['customer_id'];
			$bill_date =date('Y-m-d',strtotime($sales_orders[0]['so_date']));

		/*	$userID = $sales_orders[0]['user_id'];
			$userdtls = $this->dms->get_users(array('columns'=>array('id','designation_id'),'conditions'=>array('id'=>$userID)));
			if(!empty($userdtls)){
				$user_type = $userdtls[$userID]['designation_id'];
				$users = $this->dms->get_users(array('conditions'=>array('designation_id'=>$user_type,'branch_id'=>$this->branchID)));
			}*/

			$args=array();
			$args['select'] = array('dsoti.id');
			$args['conditions'] = array('dsoti.so_temp_id'=>$salesOrderID,'dsoti.cst >'=>0);
			$cstEnabled = $this->sales_order_temp->get_temp_order_items($args);
			$cstEnabled = count($cstEnabled);

			$args = array();
			$args['conditions'] = array('so_temp_id'=>$salesOrderID);
if($bill_date < $lm_date)
{
			$sales_order_items = $this->sales_order_temp->get_temp_order_items($args);
}
else
{
           $sales_order_items = $this->sales_order_temp->get_temp_order_itemss($args);
}
		}
		if(isset($_POST['add_to_bill'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]|callback_bill_num_check');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			if(empty($sales_orders)){
				$this->form_validation->set_rules('customer_type','lang:customer-type','xss_clean|required');
				$this->form_validation->set_rules('customer_id','lang:customer-name','xss_clean|required');
			}
		//	$this->form_validation->set_rules('user_type','lang:user-type','xss_clean');
		//	$this->form_validation->set_rules('user_id','lang:user','xss_clean');
		//	if($this->input->post('user_type')){
		//		$this->form_validation->set_rules('user_id','lang:user','xss_clean|required');
		//	}
			$this->form_validation->set_rules('item_id','lang:item-name','xss_clean|required');
			$this->form_validation->set_rules('godown_id','lang:godown','xss_clean|required');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('unit_id','lang:unit','xss_clean|required');
			$this->form_validation->set_rules('qty','lang:qty','xss_clean|required|greater_or_equal[0]');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run('add_to_bill') === true){

                                $lm_date = '2017-07-01';
				$postedValues = $this->input->post(NULL,true);
				$billNum = $postedValues['bill_no'];
				$billDate = date('Y-m-d',strtotime($postedValues['bill_date']));
				if(empty($sales_orders)){
					$customerType = $this->input->post('customer_type');
					$customerID = $this->input->post('customer_id');
				}

			//	$userTypeID = $this->input->post('user_type');
			//	$userID = $this->input->post('user_id');
				$itemID = $this->input->post('item_id');
				$godownID = $this->input->post('godown_id');
				$qty = $this->input->post('qty');
				$unitID = $this->input->post('unit_id');
				$rate = 0;
				$amount = $this->input->post('amount');
				if($qty > 0){
					$rate = $amount/$qty;
				}
				
				$discountPercent = $this->input->post('discount_per');
				$discountAmount = $this->input->post('discount_amt');
				$cstPercent = $this->input->post('cst');
				$this->db->trans_start();
				if(empty($sales_orders)){

					$saveSoTempArray = array('customer_type_id'=>$customerType,'branch_id'=>$this->branchID,'so_no'=>$billNum,'so_date'=>$billDate,'customer_id'=>$customerID,/*'user_id'=>$userID,*/'created_by'=>$this->createdBY);
					if($this->sales_order_temp->save_temp_order($saveSoTempArray)){
						$salesOrderID = $this->db->insert_id();
					}

				}else{

					$salesOrderID = $sales_orders[0]['id'];
					$this->sales_order_temp->update('dms_sales_order_temp',array('so_date'=>$billDate,'customer_type_id'=>$customerType,'customer_id'=>$customerID,/*'user_id'=>$userID*/),array('id'=>$salesOrderID));

				}

				if(!empty($salesOrderID)){

if($billDate < $lm_date)
{

					#----------VAT calculation
					$vat_amt = $vat_percent = 0;
					if(empty($presumtiveTax)){
						if($cstPercent == 0){
							$vat_percent = $this->stock->get_item_vat($itemID);
							$vat_amt = ((((float)$amount-(float)$discountAmount) * (float)$vat_percent) / 100);#round_this
						}
					}
}
else
{
                   $cgst=$this->stock->get_item_cgst($itemID);
                   $sgst=$this->stock->get_item_sgst($itemID);
                   $cgst_amt = ((((float)$amount-(float)$discountAmount) * (float)$cgst) / 100);
                   $sgst_amt = ((((float)$amount-(float)$discountAmount) * (float)$sgst) / 100);
}

					$args = array();
					$args['select'] = array('dsoti.id');
					$args['conditions'] = array('dsoti.so_temp_id'=>$salesOrderID,'dsoti.item_id'=>$itemID,'dsoti.godown_id'=>$godownID,'dsoti.unit_id'=>$unitID);

if($billDate < $lm_date)
{
					$checkSOItem = $this->sales_order_temp->get_temp_order_items($args);
					if(empty($checkSOItem))
                                        {
						$saveSoItemsArray = array('so_temp_id'=>$salesOrderID,'item_id'=>$itemID,'godown_id'=>$godownID,'qty'=>$qty,'unit_id'=>$unitID,'rate'=>$rate,'amount'=>$amount,'so_discount_per'=>$discountPercent,'so_discount_amt'=>$discountAmount,'vat_percent'=>$vat_percent,'vat_amt'=>$vat_amt,'cst'=>$cstPercent,'created_by'=>$this->createdBY);
						if($this->sales_order_temp->save_temp_order_items($saveSoItemsArray))
                                                {
							$this->message->set($this->lang->line('item-added-to-bill'));
							$this->db->trans_complete();
							redirect('sales_order/add');
						}
					}else{
						$this->message->set($this->lang->line('sales-order-item-exist'),'e');
					}
}
else
{
          $checkSOItem = $this->sales_order_temp->get_temp_order_itemss($args);
					if(empty($checkSOItem))
                                        {
						$saveSoItemsArray = array('so_temp_id'=>$salesOrderID,'item_id'=>$itemID,'godown_id'=>$godownID,'qty'=>$qty,'unit_id'=>$unitID,'rate'=>$rate,'amount'=>$amount,'so_discount_per'=>$discountPercent,'so_discount_amt'=>$discountAmount,'cgst'=>$cgst,'sgst'=>$sgst,'cgst_amt'=>$cgst_amt,'sgst_amt'=>$sgst_amt,'created_by'=>$this->createdBY);
						if($this->sales_order_temp->save_temp_order_itemss($saveSoItemsArray))
                                                {
							$this->message->set($this->lang->line('item-added-to-bill'));
							$this->db->trans_complete();
							redirect('sales_order/add');
						}
					}else{
						$this->message->set($this->lang->line('sales-order-item-exist'),'e');
					} 
}
				}
			}
		}

		if(isset($_POST['save_bill'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
		//	$this->form_validation->set_rules('user_type','lang:user-type','xss_clean');
		//	$this->form_validation->set_rules('user_id','lang:user','xss_clean');
		//	if($this->input->post('user_type')){
			//	$this->form_validation->set_rules('user_id','lang:user','xss_clean|required');
			//}

			$this->form_validation->set_rules('area_id','lang:area','xss_clean|required');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('bill_discount_per','lang:discount','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount-amt','xss_clean|less_than[100000000]');

			if($this->form_validation->run('save_bill') === true){

				if(!empty($sales_orders)){
					foreach($sales_orders as $key=>$s_order_temp){

						$soTempID = $s_order_temp['id'];
						$branchID = $s_order_temp['branch_id'];
						$sales_order_status = $s_order_temp['order_status'];
						$so_from_id = $s_order_temp['order_id'];
						$customerType = $s_order_temp['customer_type_id'];
						$customerID = $s_order_temp['customer_id'];
						$bill_num = $this->input->post('bill_no');
						$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
					//	$userID = $this->input->post('user_id');
						$areaID = $this->input->post('area_id');
						$remarks = $this->input->post('remarks');
						$billDiscountPer = $this->input->post('bill_discount_per');
						$billDiscountAmt = $this->input->post('bill_discount_amt');
						$SalesGroupID = $this->stock->get_group_id('dms_sales_items1');
						$cess = $this->stock->get_cess();
						$pre_request_date = date('Y-m-d',strtotime($this->fiscal_start_date));

						if(!empty($sales_order_status) && $sales_order_status == 1){
							$this->load->model('sales/Quotation_model','quotation');
							$args = array();
							$args['select'] = array('dq.qt_date');
							$args['conditions'] = array('dq.id'=>$so_from_id);
							$quotations = $this->quotation->get($args);
							$pre_request_date = date('Y-m-d',strtotime($quotations[0]['qt_date']));
						}

						if($this->sales_order_temp->check_sales_order_number($bill_num) === true){
							if(strtotime($pre_request_date) <= strtotime($bill_date)){
								$this->db->trans_start();
								$saveSO = array('branch_id'=>$branchID,'so_no'=>$bill_num,'so_date'=>$bill_date,'group_id'=>$SalesGroupID,'customer_type_id'=>$customerType,'customer_id'=>$customerID,/*'user_id'=>$userID,*/'area_id'=>$areaID,'remarks'=>$remarks,'so_status'=>0,'so_discount_per'=>$billDiscountPer,'so_discount_amt'=>$billDiscountAmt,'cess'=>$cess,'order_from'=>$sales_order_status,'order_from_id'=>$so_from_id);
								if($this->sales_order_temp->save_sales_order($saveSO)){
									$sales_order_id = $this->db->insert_id();
									$args = array();
									$args['conditions'] = array('so_temp_id'=>$soTempID);

if($bill_date < $lm_date)
{
				$SOrderItems = $this->sales_order_temp->get_temp_order_items($args);
				foreach($SOrderItems as $sotKey=>$SOItem)
                                {
					$delID = $SOItem['id'];
					$saveSOI = array('group_id'=>$SalesGroupID,'item_id'=>$SOItem['item_id'],'qty'=>$SOItem['qty'],'unit_id'=>$SOItem['unit_id'],'rate'=>$SOItem['rate'],'amount'=>$SOItem['amount'],'discount_per'=>$SOItem['so_discount_per'],'discount_amt'=>$SOItem['so_discount_amt'],'vat_percent'=>$SOItem['vat_percent'],'vat_amt'=>$SOItem['vat_amt'],'cst'=>$SOItem['cst'],'godown_id'=>$SOItem['godown_id'],'item_status'=>0);

					if($this->sales_order_temp->save_sales_order_items($saveSOI))
                                        {
						$this->sales_order_temp->delete_temp_item($delID);
					}
				}
}
else
{
                               $SOrderItems = $this->sales_order_temp->get_temp_order_itemss($args);
				foreach($SOrderItems as $sotKey=>$SOItem)
                                {
					$delID = $SOItem['id'];
					$saveSOI = array('group_id'=>$SalesGroupID,'item_id'=>$SOItem['item_id'],'qty'=>$SOItem['qty'],'unit_id'=>$SOItem['unit_id'],'rate'=>$SOItem['rate'],'amount'=>$SOItem['amount'],'discount_per'=>$SOItem['so_discount_per'],'discount_amt'=>$SOItem['so_discount_amt'],'cgst'=>$SOItem['cgst'],'sgst'=>$SOItem['sgst'],'cgst_amt'=>$SOItem['cgst_amt'],'sgst_amt'=>$SOItem['sgst_amt'],'godown_id'=>$SOItem['godown_id'],'item_status'=>0);

					if($this->sales_order_temp->save_sales_order_itemss($saveSOI))
                                        {
						$this->sales_order_temp->delete_temp_items($delID);
					}
				}



}
									if(!empty($sales_order_status) && $sales_order_status == 1){
										$this->sales_order_temp->update('dms_quotations',array('qt_status'=>1),array('id'=>$so_from_id));
									}
									$this->message->set($this->lang->line('sales-order-saved'));
									redirect('sales_order/view/'.$sales_order_id);
								}else{
									$this->message->set($this->lang->line('sales-order-not-saved'),'e');
								}
								//$this->db->trans_complete();
							}else{
								$this->message->set($this->lang->line('select-valid-so-date'),'e');
							}
						}else{
							$this->message->set($this->lang->line('same-so-bill-exists'),'e');
						}
					}
					redirect('sales_order/add');
				}
			}
		}

		if(!empty($custType)){
			$customers = $this->stock->get_customers($custType,0);
			$user_types = $this->stock->get_customers($custType,1);
			$selCustType = $custType;
		}

		$items[''] = 'Select';
		ksort($items);
		$units[''] = 'Select';
		ksort($units);
		$goDowns[''] = 'Select';
		ksort($goDowns);
		$users[''] = 'Select';
		ksort($users);
		$areas[''] = 'Select';
		ksort($areas);
		$customers[''] = 'Select';
		ksort($customers);
		$user_types[''] = 'Select';
		ksort($user_types);
		$pricelists[''] = 'Select';
		ksort($pricelists);

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_order/add_sales_order',array('customers'=>$customers,'userTypes'=>$user_types,'users'=>$users,'items'=>$items,'goDowns'=>$goDowns,'units'=>$units,'bill_num'=>$bill_num,'bill_date'=>$bill_date,'user_type'=>$user_type,'customerTypes'=>$customerTypes,'sales_order'=>$sales_orders,'sales_order_items'=>$sales_order_items,'areas'=>$areas,'cst_enabled'=>$cstEnabled,'item_rate'=>$item_rate,'primary_unit'=>$primary_unit,'presumtiveTax' => $presumtiveTax));
		$this->template->other_script(array('sales/sales_order'));
		$this->template->render();
		#-------------------------------------------------------------
	}

	#======================================================
	/*  sales order bill number checking */
	public function bill_num_check($str){

		if($this->sales_order_temp->sales_order_number_check($str) === true){
			return TRUE;
		}else{
			return FALSE;
		}

	}
	#======================================================
	#  Remove an item from temporary created sales order
	public function remove_temp_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);
	//	if($this->if_exists('dms_sales_order_temp_items',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){

                if($this->if_exists('dms_sales_order_temp_items1',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){
			redirect('sales_order/add');
		}
		$this->load->model('sales/Sales_order_temp_model','sales_order_temp');
	/*	if($this->sales_order_temp->delete_temp_item($tempItemID)){
                
			$this->message->set($this->lang->line('item-deleted-from-bill'));
		} */
                if($this->sales_order_temp->delete_temp_items($tempItemID)){
                        $this->message->set($this->lang->line('item-deleted-from-bill'));
                }
		redirect('sales_order/add');
	}

	#======================================================

	public function edit_temp_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);
	//	if($this->if_exists('dms_sales_order_temp_items',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){
                if($this->if_exists('dms_sales_order_temp_items1',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){
			redirect('sales_order/add');
		}
		$salesOrders = array();
		$this->template->title($this->lang->line('edit-sales-order'));
		$this->template->main_heading($this->lang->line('edit-sales-order'));
		$this->template->breadcrumb(array($this->lang->line('sales-order') => 'sales_order/add',$this->lang->line('edit') => 'no_link',$this->lang->line('all')=>'sales_order/report'));
		$this->load->model('sales/Sales_order_temp_model','sales_order_temp');

		$args = array();
		$args['conditions'] = array('dsoti.id'=>$tempItemID);
	//	$salesOrders = $this->sales_order_temp->get_temp_order_items($args);
                $salesOrders = $this->sales_order_temp->get_temp_order_itemss($args);
		if(empty($salesOrders)){
			redirect('sales_order/add');
		}else{
			$itemID = $salesOrders[0]['item_id'];
			$salesOrderID = $salesOrders[0]['so_temp_id'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
		$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
		$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
		$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

		if($this->form_validation->run() === true)
		{
			$postedValues = $this->input->post();
			if($this->input->post('cst')){
				$postedValues['cst'] = $this->input->post('cst');
			}else{
				$postedValues['cst'] = 0;
			}
			$postedValues['rate'] = 0;
			if($postedValues['qty'] > 0){
				$postedValues['rate'] = (float)$postedValues['amount']/(float)$postedValues['qty'];
			}
			
			$args = array();
			$args['select'] = array('dsoti.id');
			$args['conditions'] = array('dsoti.so_temp_id'=>$salesOrderID,'dsoti.item_id'=>$itemID,'dsoti.godown_id'=>$postedValues['godown_id'],'dsoti.unit_id'=>$postedValues['unit_id'],'dsoti.id !='=>$tempItemID);
		//	$checkSOItem = $this->sales_order_temp->get_temp_order_items($args);
                        $checkSOItem = $this->sales_order_temp->get_temp_order_itemss($args);
			if(empty($checkSOItem))
                        {
		//		if($this->sales_order_temp->update('dms_sales_order_temp_items',array('godown_id'=>$postedValues['godown_id'],'qty'=>$postedValues['qty'],'unit_id'=>$postedValues['unit_id'],'rate'=>$postedValues['rate'],'amount'=>$postedValues['amount'],'so_discount_per'=>$postedValues['discount_per'],'so_discount_amt'=>$postedValues['discount_amt'],'vat_amt'=>$postedValues['vat_amt'],'cst'=>$postedValues['cst']),array('id'=>$tempItemID))){

                                if($this->sales_order_temp->update('dms_sales_order_temp_items1',array('godown_id'=>$postedValues['godown_id'],'qty'=>$postedValues['qty'],'unit_id'=>$postedValues['unit_id'],'rate'=>$postedValues['rate'],'amount'=>$postedValues['amount'],'so_discount_per'=>$postedValues['discount_per'],'so_discount_amt'=>$postedValues['discount_amt'],'cgst_amt'=>$postedValues['cgst_amt'],'sgst_amt'=>$postedValues['sgst_amt']),array('id'=>$tempItemID))){
					$this->message->set($this->lang->line('item-added-to-bill'));
					redirect('sales_order/add');
				}

			}else{
				$this->message->set($this->lang->line('sales-order-item-exist'),'e');
			}
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_order/edit_temp_item',array('sales_orders'=>$salesOrders,'goDowns'=>$goDowns,'units'=>$units));
		$this->template->other_script(array('sales/sales_order'));
		$this->template->render();
	}
	#======================================================
	/*	sales order report starts here */
	public function report(){

		$this->template->title($this->lang->line('sales-order-report'));
		$this->template->main_heading($this->lang->line('sales-order-report'));
		$this->template->breadcrumb(array($this->lang->line('sales-order') => 'sales_order/add',$this->lang->line('report') => 'no_link',$this->lang->line('all')=>'sales_order/report'));
		$this->load->model('sales/Sales_order_model','sales_order');
		$this->load->library('Pagination');
		$links=NULL;$offset=0;$from_date=NULL;$to_date=NULL;
		$config['uri_segment'] = 3;
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('sales_order/report');
		$salesOrderItems=$soStatusArray = array();
		if(isset($_POST['get'])){
			$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|is_date');
			$this->form_validation->set_rules('to_date','lang:to-date','xss_clean|required|is_date');
			if($this->form_validation->run() === true){
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
				$config['base_url'] = base_url('sales_order/report/'.$from_date.'/'.$to_date);
			}
		}else if($this->uri->segment(3) && $this->uri->segment(4)){
			$from_date = date('Y-m-d',strtotime($this->uri->segment(3)));
			$to_date = date('Y-m-d',strtotime($this->uri->segment(4)));
			$config['uri_segment'] = 5;
			$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			$config['base_url'] = base_url('sales_order/report/'.$from_date.'/'.$to_date);
		}else{
			if((strtotime($this->fiscal_start_date) <= strtotime(date('Y-m-d'))) && (strtotime($this->fiscal_end_date) >= strtotime(date('Y-m-d')))){
				$from_date = date('Y-m-d');
				$to_date = date('Y-m-d');
			}else{
				$from_date = $this->fiscal_end_date;
				$to_date = $this->fiscal_end_date;
			}
		}

		$salesOrders = array();$users = array();
		if(!empty($from_date) && !empty($to_date)){
			#-----pagination----------------------------
			$config['per_page'] = $this->per_page();
			$args = array();
			$args['select'] = array('dso.id');
			$args['num_rows'] = 1;
			$args['conditions'] = array('dso.branch_id'=>$this->branchID);
			$args['between'] = array('from_date'=>$from_date,'to_date'=>$to_date);
			$config['total_rows'] = $this->sales_order->get_sales_order($args);
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();

			$args = array();
			$args['select'] = array('dso.id','dso.branch_id','dso.so_no','dso.so_date','dso.group_id','dso.customer_type_id','dso.customer_id',/*'dso.user_id',*/'dso.area_id','dso.remarks','dso.so_status','dso.so_discount_per','dso.so_discount_amt','dso.cess','dso.pricelist_id','dm.designation_name as customer_type','am.area');
			$args['join'] = array('designation_master dm'=>'dso.customer_type_id=dm.id','area_master am'=>'dso.area_id=am.id');
			$args['limit'] = $config['per_page'];
			$args['offset'] = $offset;
			$args['conditions'] = array('dso.branch_id'=>$this->branchID);
			$args['between'] = array('from_date'=>$from_date,'to_date'=>$to_date);
			$args['order_by'] = array('dso.so_date'=>'desc','dso.so_no'=>'desc');
			$salesOrders = $this->sales_order->get_sales_order($args);

			foreach($salesOrders as $key=>$sales_order){

				$args = array();
                                $dt = $sales_order['so_date'];
                                $l_date = '2017-07-01';
                                if($dt<$l_date)
                                {
				       $args['select'] = array('dsi.id','dsi.item_id','dsi.qty','dsi.unit_id','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','dsi.vat_amt','dsi.cst','dsi.godown_id','dsi.status');
				       $args['conditions'] = array('dsi.group_id'=>$sales_order['group_id'],'dsi.status'=>1,'dsi.item_status <='=>1);
                                
				       $salesOrderItems[$sales_order['id']] = $this->sales_order->get_sales_order_items($args);
                                }
                                else
                                {
                                       $args['select'] = array('dsi.id','dsi.item_id','dsi.qty','dsi.unit_id','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','dsi.cgst_amt','dsi.sgst_amt','dsi.godown_id','dsi.status');
				       $args['conditions'] = array('dsi.group_id'=>$sales_order['group_id'],'dsi.status'=>1,'dsi.item_status <='=>1);
                                
				       $salesOrderItems[$sales_order['id']] = $this->sales_order->get_sales_order_itemss($args);
                                }
				if($this->sales_order->get_so_status($sales_order['id']) === true){
					$soStatusArray[$sales_order['id']] = 1;
				}else{
					$soStatusArray[$sales_order['id']] = 0;
				}
			}

			if(empty($salesOrders)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
		}else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('date/between_date_search',array('from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->slice('sales/sales_order/sales_order_report',array('sales_orders'=>$salesOrders,'so_status_array'=>$soStatusArray,'sales_order_items'=>$salesOrderItems,'count'=>$offset+1,'links'=>$links,'from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->other_script(array('sales/sales_order'));
		$this->template->render();
	}

	#======================================================

	public function edit(){
		if(!$this->uri->segment(3)){
			redirect('sales_order/report');
		}
		$salesOrderID = $this->uri->segment(3);
		if($this->if_exists('dms_sales_orders',array('id'=>$salesOrderID,'status'=>1)) === false){
			redirect('sales_order/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$salesOrders = array();$salesOrderItems = array();$user_typeID=NULL;
		$this->template->title($this->lang->line('edit-sales-order'));
		$this->template->main_heading($this->lang->line('edit-sales-order'));
		$this->template->breadcrumb(array($this->lang->line('sales-order') => 'sales_order/add',$this->lang->line('report') => 'sales_order/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('sales_order/report/'.$urlString)));

		$this->load->model('sales/Sales_order_model','sales_order');
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('customers/Customer_master_model','customer_master');
		$this->load->model('areas/Area_model','area');

		if($this->dms->get_main_branch($this->branchID) === true){
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status >'=>1));
		}else{
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status'=>4));
		}

		$user_types = $this->designations->listing(array('utype_status'=>1));
		$areas = $this->area->listing();
		$goDowns = array();$units = array();
		$args = array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);

		#------get all godowns-----------------------------------------------
		if($this->input->post('item_id')){
			$itemID = $this->input->post('item_id');
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------get all godowns-----------------------------------------------
		$args = array();
		$args['conditions'] = array('dso.id'=>$salesOrderID);
		$salesOrders = $this->sales_order->get_sales_order($args);

		$presumtiveTax = $this->stock->get_tax_type();

		#---------Add more items to sales order starts here---------------------------------

		if(isset($_POST['add_to_bill'])){

			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run('add_to_bill') === true){

				if(!empty($salesOrders))
				{
					$soGroupID = $salesOrders[0]['group_id'];
					if($salesOrders[0]['so_status'] == 0)
					{
						$postedValues = $this->input->post(NULL,true);
						$cst=0;
						if($this->input->post('cst')){$cst = $this->input->post('cst');}

						#----------VAT calculation
						$s_date = $salesOrders[0]['so_date'];
						$l_date = '2017-07-01';
						if($s_date < $l_date)
						{
							$vat_amt = $vat_percent = 0;
							if(empty($presumtiveTax))
							{
								if(!$cst)
								{
									$vat_percent = $this->stock->get_item_vat($postedValues['item_id']);
									$vat_amt = ((($postedValues['amount']-$postedValues['discount_amt']) * $vat_percent) / 100);#round_this
								}
							}
						}
						else
						{
							$cgst = $this->stock->get_item_cgst($postedValues['item_id']);	
							$sgst = $this->stock->get_item_sgst($postedValues['item_id']);
							$cgstAmt = ((((float)$postedValues['amount']-(float)$postedValues['discount_amt']) * (float)$cgst) / 100);
							$sgstAmt = ((((float)$postedValues['amount']-(float)$postedValues['discount_amt']) * (float)$sgst) / 100);
							$vat_amt = (float)$cgstAmt+(float)$sgstAmt;
						}
						$postedValues['rate'] = 0;
						if($postedValues['qty'] >0){
							$postedValues['rate'] = (float)$postedValues['amount']/(float)$postedValues['qty'];
						}
						$postedValues['group_id'] = $soGroupID ;
						$postedValues['item_status'] = 0;
						if($s_date < $l_date)
						{
							$saveArray = array('group_id'=>$soGroupID,'item_id'=>$postedValues['item_id'],'qty'=>$postedValues['qty'],'unit_id'=>$postedValues['unit_id'],'rate'=>$postedValues['rate'],'amount'=>$postedValues['amount'],'discount_per'=>$postedValues['discount_per'],'discount_amt'=>$postedValues['discount_amt'],'vat_percent'=>$vat_percent,'vat_amt'=>$vat_amt,'cst'=>$cst,'godown_id'=>$postedValues['godown_id'],'item_status'=>0);
							
						}
						else
						{
							$saveArray = array('group_id'=>$soGroupID,'item_id'=>$postedValues['item_id'],'qty'=>$postedValues['qty'],'unit_id'=>$postedValues['unit_id'],'rate'=>$postedValues['rate'],'amount'=>$postedValues['amount'],'discount_per'=>$postedValues['discount_per'],'discount_amt'=>$postedValues['discount_amt'],'cgst'=>$cgst,'sgst'=>$sgst,'cgst_amt'=>$cgstAmt,'sgst_amt'=>$sgstAmt,'godown_id'=>$postedValues['godown_id'],'item_status'=>0);
						}
						if($this->sales_order->save_sales_order_itemss($saveArray) || $this->sales_order->save_sales_order_itemss($saveArray)){
							$this->message->set($this->lang->line('item-added-to-bill'));
							redirect('sales_order/edit/'.$salesOrderID.'/'.$urlString);
						}
					}else{
						$this->message->set($this->lang->line('sales-order-converted'),'e');
					}
				}
			}
		}

		#---------Add more items to sales order starts here---------------------------------

		if(!empty($salesOrders)){

			$sales_order = $salesOrders[0];
			$groupID = $sales_order['group_id'];
			$so_date = $sales_order['so_date'];
			$custTypeID = $sales_order['customer_type_id'];
			$customerID = $sales_order['customer_id'];
			$custType = $custTypeID;
			$user = $sales_order['user_id'];
			$userdtls = $this->dms->get_users(array('columns'=>array('id','designation_id'),'conditions'=>array('id'=>$user)));

			if(!empty($userdtls)){
				$user_typeID = $userdtls[$user]['designation_id'];
				$users = $this->dms->get_users(array('conditions'=>array('designation_id'=>$user_typeID,'branch_id'=>$this->branchID)));
			}

			$cstEnabled = 0;
			$args=array();
			$args['select'] = array('dsi.id');
			$args['conditions'] = array('dsi.group_id'=>$groupID,'dsi.item_status <='=>1);
			
				$salesOrderCST = $this->sales_order->get_sales_order_items($args);
			
			
			$cstEnabled = count($salesOrderCST);

			$args = array();
			$args['conditions'] = array('dsi.group_id'=>$groupID,'dsi.item_status <='=>1);
			if($so_date < $l_date)
			{
				$salesOrderItems = $this->sales_order->get_sales_order_items($args);
			}
			else
			{
				$salesOrderItems = $this->sales_order->get_sales_order_itemss($args);	
			}
		}

		#---------Updated sales order starts here---------------------------------------------
		if(isset($_POST['save_bill'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('customer_type','lang:customer-type','xss_clean|required');
			$this->form_validation->set_rules('customer_id','lang:customer-name','xss_clean|required');
			$this->form_validation->set_rules('user_type','lang:user-type','xss_clean');
			$this->form_validation->set_rules('user_id','lang:user','xss_clean');
			if($this->input->post('user_type')){
				$this->form_validation->set_rules('user_id','lang:user','xss_clean|required');
				$userTypeID = $this->input->post('user_type');
				if(!empty($userTypeID)){
					$users = $this->dms->get_users(array('conditions'=>array('designation_id'=>$userTypeID,'branch_id'=>$this->branchID)));
				}
			}
			if($this->input->post('customer_type')){
				$custType = $this->input->post('customer_type');
			}
			$this->form_validation->set_rules('area_id','lang:area','xss_clean|required');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('bill_discount_per','lang:discount','xss_clean|is_numeric|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount-amt','xss_clean|less_than[100000000]');

			if($this->form_validation->run() === true){

				if($salesOrders[0]['so_status'] == 0){
					$this->load->model('sales/Sales_order_temp_model','sales_order_temp');
					$postedValues = $this->input->post();

					$args = array();
					$args['select'] = array('dso.id');
					$args['conditions'] = array('dso.id !='=>$salesOrderID,'so_no'=>$postedValues['bill_no']);
					$checkSO = $this->sales_order->get_sales_order($args);

					$args = array();
					$args['select'] = array('id');
					$args['conditions'] = array('so_no'=>$postedValues['bill_no']);
					$checkSOtemp = $this->sales_order_temp->get_temp_order($args);

					if(empty($checkSO) && empty($checkSOtemp)){
						if($this->sales_order->update_so(array('so_no'=>$postedValues['bill_no'],'so_date'=>date('Y-m-d',strtotime($postedValues['bill_date'])),'customer_type_id'=>$postedValues['customer_type'],'customer_id'=>$postedValues['customer_id'],'user_id'=>$postedValues['user_id'],'area_id'=>$postedValues['area_id'],'remarks'=>$postedValues['remarks'],'so_discount_per'=>$postedValues['bill_discount_per'],'so_discount_amt'=>$postedValues['bill_discount_amt']),array('id'=>$salesOrderID))){
							$this->message->set($this->lang->line('sales-order-saved'));
							redirect('sales_order/edit/'.$salesOrderID.'/'.$urlString);
						}
					}else{
						$this->message->set($this->lang->line('same-so-bill-exists'),'e');
					}
				}else{
					$this->message->set($this->lang->line('edit-converted-sales-order'),'e');
				}

			}
		}

		if(!empty($custType)){
			$customers = $this->stock->get_customers($custType,0);
			$user_types = $this->stock->get_customers($custType,1);
			$selCustType = $custType;
		}
		#---------Updated sales order starts here---------------------------------------------
		$items[''] = 'Select';
		ksort($items);
		$units[''] = 'Select';
		ksort($units);
		$goDowns[''] = 'Select';
		ksort($goDowns);
		$users[''] = 'Select';
		ksort($users);
		$areas[''] = 'Select';
		ksort($areas);
		$customers[''] = 'Select';
		ksort($customers);
		$user_types[''] = 'Select';
		ksort($user_types);
		$pricelists[''] = 'Select';
		ksort($pricelists);

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_order/edit_sales_order',array('items'=>$items,'goDowns'=>$goDowns,'units'=>$units,'areas'=>$areas,'user'=>$user,'user_type'=>$user_typeID,'users'=>$users,'userTypes'=>$user_types,'customers'=>$customers,'customerTypes'=>$customerTypes,'sales_order'=>$salesOrders,'sales_order_items'=>$salesOrderItems,'cst_enabled'=>$cstEnabled,'salesOrderID'=>$salesOrderID,'presumtiveTax' => $presumtiveTax));
		$this->template->other_script(array('sales/sales_order'));
		$this->template->render();

	}

	#======================================================

	public function edit_item(){

		if(!$this->uri->segment(3)){
			redirect('sales_order/report');
		}

		$soItemID = $this->uri->segment(3);
		if($this->if_exists('dms_sales_items1',array('id'=>$soItemID,'status'=>1)) === false){
			redirect('sales_order/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);

		$this->load->model('sales/Sales_order_model','sales_order');
		$args = array();
		$args['select'] = array('dso.id','dsi.group_id','dsi.item_id','dsi.qty','dsi.unit_id','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','dsi.godown_id','dsi.item_status');
		$args['conditions'] = array('dsi.id'=>$soItemID);
		$args['join'] = array('dms_sales_items1 dsi'=>'dso.group_id=dsi.group_id');
		$sales_order = $this->sales_order->get_sales_order($args);
		if(empty($sales_order)){
			redirect('sales_order/report');
		}

		$salesOrderID = $sales_order[0]['id'];
		$itemStatus = $sales_order[0]['item_status'];
		$itemID = $sales_order[0]['item_id'];
		$groupID = $sales_order[0]['group_id'];
		$this->template->title($this->lang->line('edit-sales-order'));
		$this->template->main_heading($this->lang->line('edit-sales-order'));
		$this->template->breadcrumb(array($this->lang->line('sales-order') => 'sales_order/add',$this->lang->line('report') => 'sales_order/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('sales_order/edit/'.$urlString)));

		$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
		$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
		$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
		$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

		if($this->form_validation->run() === true){
			$postedValues = $this->input->post(NULL,true);
			$args = array();
			$args['select'] = array('dsi.id');
			$args['conditions'] = array('dsi.id !='=>$soItemID,'dsi.group_id'=>$groupID,'dsi.item_id'=>$itemID,'dsi.godown_id'=>$postedValues['godown_id'],'dsi.unit_id'=>$postedValues['unit_id']);
			$args['join'] = array('dms_sales_items1 dsi'=>'dso.group_id=dsi.group_id');
			$soItemCheck = $this->sales_order->get_sales_order($args);
			
			$postedValues['rate'] = 0;
			if($postedValues['qty'] >0){
				$postedValues['rate'] = (float)$postedValues['amount']/(float)$postedValues['qty'];
			}
			unset($postedValues['vat_amt']);
			unset($postedValues['cst']);
			if(empty($soItemCheck)){
				if($itemStatus == 0){
					if($this->sales_order->update_so_item($postedValues,array('id'=>$soItemID))){
						$this->message->set($this->lang->line('sales-order-updated'));
						redirect('sales_order/edit/'.$urlString);
					}
				}
			}else{
				$this->message->set($this->lang->line('sales-order-item-exist'));
			}
		}

		if($itemStatus == 0){

			$args = array();
			$args['select'] = array('id','item_code','item_name');
			$items = $this->stock->get_stock_items($args);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
			$cstEnabled = 0;
			$args=array();
			$args['select'] = array('dsi.id');
			$args['conditions'] = array('dsi.group_id'=>$groupID,'dsi.item_status <='=>1);
			$salesOrderCST = $this->sales_order->get_sales_order_items($args);
			$cstEnabled = count($salesOrderCST);
			$salesOrderItems = array();

		}else{
			$this->message->set($this->lang->line('edit-converted-sales-order'),'e');
			redirect('sales_order/edit/'.$urlString);
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_order/edit_sales_order_item',array('goDowns'=>$goDowns,'units'=>$units,'items'=>$items,'sales_order'=>$sales_order[0],'cst_enabled'=>$cstEnabled));
		$this->template->other_script(array('sales/sales_order'));
		$this->template->render();
	}

	#======================================================

	public function remove_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$soItemID = $this->uri->segment(3);
		if($this->if_exists('dms_sales_items1',array('id'=>$soItemID,'status'=>1,'item_status <='=>1)) === false){
			redirect('sales_order/report');
		}
		$this->load->model('sales/Sales_order_model','sales_order');
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$args = array();
		$args['select'] = array('dso.id','dsi.item_status');
		$args['conditions'] = array('dsi.id'=>$soItemID);
		$args['join'] = array('dms_sales_items1 dsi'=>'dso.group_id=dsi.group_id');
		$sales_order = $this->sales_order->get_sales_order($args);
		if(empty($sales_order)){
			redirect('sales_order/report');
		}
		$salesOrderID = $sales_order[0]['id'];
		$itemStatus = $sales_order[0]['item_status'];
		if($itemStatus <= 0){
			if($this->sales_order->delete_so_item($soItemID)){
				$this->message->set($this->lang->line('item-deleted-from-bill'));
			}
		}else{
			$this->message->set($this->lang->line('delete-converted-sales-order'),'e');
		}
		redirect('sales_order/edit/'.$urlString);
	}

	#======================================================

	public function delete(){

		if(!$this->uri->segment(3)){
			redirect('sales_order/report');
		}

		$salesOrderID = $this->uri->segment(3);
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if($this->if_exists('dms_sales_orders',array('id'=>$salesOrderID,'status'=>1)) === false){
			redirect('sales_order/report');
		}
		$this->load->model('sales/Sales_order_model','sales_order');
		$args = array();
		$args['select'] = array('dso.group_id','dso.so_status');
		$args['conditions'] = array('dso.id'=>$salesOrderID);
		$salesOrder = $this->sales_order->get_sales_order($args)[0];

		if($salesOrder['so_status'] == 0){
			$groupID = $salesOrder['group_id'];
			if($this->sales_order->update_so(array('status'=>0),array('id'=>$salesOrderID))){
				$this->sales_order->update_so_item(array('status'=>0),array('group_id'=>$groupID));
				$this->message->set($this->lang->line('sales-order-deleted'));
			}else{
				$this->message->set($this->lang->line('sales-order-not-deleted'),'e');
			}
		}else{
			$this->message->set($this->lang->line('delete-converted-sales-order'),'e');
		}
		redirect('sales_order/report/'.$urlString);
	}

	#======================================================

	public function view(){

		if(!$this->uri->segment(3)){
			redirect('sales_order/report');
		}
		$salesOrderID = $this->uri->segment(3);
		if($this->if_exists('dms_sales_orders',array('id'=>$salesOrderID,'status'=>1)) === false){
			redirect('sales_order/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$salesOrders = array();$salesOrderItems = array();
		$this->template->title($this->lang->line('view-sales-order'));
		$this->template->main_heading($this->lang->line('view-sales-order'));
		$this->template->breadcrumb(array($this->lang->line('sales-order') => 'sales_order/add',$this->lang->line('report') => 'sales_order/report',$this->lang->line('view')=>'no_link',$this->lang->line('go-back')=>array('sales_order/report/'.$urlString)));

		$this->load->model('sales/Sales_order_model','sales_order');
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('customers/Customer_master_model','customer_master');
		$user_types = $this->designations->listing(array('utype_status'=>1));

		$args = array();
		$args['select'] = array('dso.branch_id','dso.so_no','dso.so_date','dso.group_id','dso.customer_type_id','dso.customer_id','dso.user_id','dso.area_id','dso.remarks','dso.so_status','dso.so_discount_per','dso.so_discount_amt','dso.cess','dso.created_by','dso.created_on','dm.designation_name as customer_type','am.area');
		$args['join'] = array('designation_master dm'=>'dso.customer_type_id=dm.id','area_master am'=>'dso.area_id=am.id');
		$args['conditions'] = array('dso.id'=>$salesOrderID);
		$salesOrders = $this->sales_order->get_sales_order($args);

		if(!empty($salesOrders)){

			$sales_order = $salesOrders[0];
			$groupID = $sales_order['group_id'];
			$cstEnabled = 0;
			$args=array();
			$args['select'] = array('dsi.id');
			$args['conditions'] = array('dsi.group_id'=>$groupID,'dsi.item_status <='=>1);
			$salesOrderCST = $this->sales_order->get_sales_order_items($args);
			$cstEnabled = count($salesOrderCST);
			$args = array();
			$args['conditions'] = array('dsi.group_id'=>$groupID,'dsi.item_status <='=>1);
			$args['order_by'] = array('dsi.id'=>'asc');
			$salesOrderItems = $this->sales_order->get_sales_order_items($args);
                        if(empty($salesOrderItems))
                        {
                             $salesOrderItems = $this->sales_order->get_sales_order_itemss($args);
                        }
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_order/view_sales_order',array('userTypes'=>$user_types,'sales_order'=>$salesOrders,'sales_order_items'=>$salesOrderItems,'cst_enabled'=>$cstEnabled,'salesOrderID'=>$salesOrderID));
		$this->template->other_script(array('sales/sales_order_report'));
		$this->template->other_script(array('sales/sales_order'));
		$this->template->render();
	}

	#======================================================

	public function pdf(){

		if(!$this->uri->segment(3)){
			echo "<script>alert('".$this->lang->line('invalid-sales-order')."');window.close();</script>";
		}
		$salesOrderID = $this->uri->segment(3);
		if($this->if_exists('dms_sales_orders',array('id'=>$salesOrderID,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-sales-order')."');window.close();</script>";
		}
		$pdf_name = 'sales_order';
		$this->load->model('sales/Sales_order_model','sales_order');
		$this->load->library('Stock');
		$this->load->library('My_pdf');
		$this->load->library('To_words');

		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();
		$sales_orders = array();
		$pdf_contents = '';
		$args = array();

$so_date=$this->db->select(array('so_date'))->from('dms_sales_orders')->where(array('id'=>$salesOrderID))->get()->result_array();
$dt = $so_date[0]['so_date'];
$l_date = '2017-07-01';
if($dt<$l_date)
{
	$args['select'] = array('dso.branch_id','dso.so_no','dso.so_date','dso.group_id','dso.customer_type_id','dso.customer_id','dso.user_id','dso.area_id','dso.remarks','dso.so_status','dso.so_discount_per','dso.so_discount_amt','dso.cess','dm.designation_name as customer_type','am.area','dsi.item_id','dsi.qty','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','im.item_name','im.item_code','um.symbol');

		$args['join'] = array('designation_master dm'=>'dso.customer_type_id=dm.id','area_master am'=>'dso.area_id=am.id','dms_sales_items1 as dsi'=>'dso.group_id=dsi.group_id','item_master as im'=>'dsi.item_id=im.id','unit_master as um'=>'dsi.unit_id=um.id');
}
else
{
       $args['select'] = array('dso.branch_id','dso.so_no','dso.so_date','dso.group_id','dso.customer_type_id','dso.customer_id','dso.user_id','dso.area_id','dso.remarks','dso.so_status','dso.so_discount_per','dso.so_discount_amt','dso.cess','dm.designation_name as customer_type','am.area','dsi.item_id','dsi.qty','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','dsi.cgst_amt','dsi.sgst_amt','im.item_name','im.item_code','um.symbol');

       $args['join'] = array('designation_master dm'=>'dso.customer_type_id=dm.id','area_master am'=>'dso.area_id=am.id','dms_sales_items1 as dsi'=>'dso.group_id=dsi.group_id','item_master as im'=>'dsi.item_id=im.id','unit_master as um'=>'dsi.unit_id=um.id');

}
		$args['conditions'] = array('dso.id'=>$salesOrderID,'dso.status'=>1,'dsi.status'=>1,'dsi.item_status <='=>1);
		$sales_orders = $this->sales_order->get_sales_order($args);
		if(empty($sales_orders)){
			echo "<script>alert('".$this->lang->line('invalid-sales-order')."');window.close();</script>";
		}else{
			$groupID = $sales_orders[0]['group_id'];
			$pdf_name .= '_no_'.$sales_orders[0]['so_no'].'_'.date('d/m/Y',strtotime($sales_orders[0]['so_date']));
			$cstEnabled = 0;
			$args=array();
			$args['select'] = array('dsi.id');
			$args['conditions'] = array('dsi.group_id'=>$groupID,'dsi.item_status <='=>1);
if($dt<$l_date)
{
			$salesOrderCST = $this->sales_order->get_sales_order_items($args);
}
else
{
                        $salesOrderCST = $this->sales_order->get_sales_order_itemss($args);
}
			$cstEnabled = count($salesOrderCST);
			$pdf_contents = $this->load->view('sales/sales_order/sales_order_pdf',array('sales_orders'=>$sales_orders,'cst_enabled'=>$cstEnabled),true);
		}
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}

	#======================================================

}
?>