<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_return extends MY_Controller{
	
	public function __construct()
	{
		parent::__construct();
		
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"sales_return/report");
		#---------------- Checking Financial year is enabled / closed-----------------#
		
		$this->load->model('sales/sales_return_model','sales_obj');
		$this->load->model('vouchers/voucher_model','vouchers');
		$this->load->library(array('stock'));
		$this->createdBY = $this->session->userdata('id');
		$this->branchID = $this->session->userdata('under_id');
		#-----------checking branch_type
		$this->branch_status = 0;
		if($this->dms->branch_type()){
			$this->branch_status = 1;
		}
	}
	
	public function add()
	{
		#----------loading models
		$this->load->model('designations/designation_master_model','desig');
		$this->load->model('customers/customer_type_model','customer_type');
		
		#----------voucher type
		$vtype = $this->uri->segment(4);
		$vtype_id = $vtype;		
		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($vtype);
		
		#-----------sales cst checking details
		$sales_cst = $this->stock->get_constant(array('sales_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();
		
		#------------cess %
		$cess = $this->stock->get_cess();
		
		$Ckargs = array();
		$Ckargs['columns'] = array('id','s_status');
		$Ckargs['conditions'] = array('created_by'=>$this->createdBY,'status'=>-1,'branch_id'=>$this->branchID);
		$sales_return_temp = $this->sales_obj->get_bills($Ckargs);

		if(!empty($sales_return_temp)){
			if($sales_return_temp[0]['s_status'] == 1){
				$this->message->set($this->lang->line('pending-sales-return-exists'),'e');
				redirect('preturn_to_sreturn/sales_return/');
			}
		}
				
		#-----------sales_return date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales_obj->next_bill_no($vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus']){
			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";
			
			#------------checking cst enabled or not
			$cst_status = $this->sales_obj->get_cst($group_id);
			if($cst_status){
				$sales_cst = $cst_status;
			}	
		}
		else{
			$group_id = $this->stock->get_group_id('dms_sales_return_items');	
		}
		
		#-------------adding data to sales_return temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');			
			$this->form_validation->set_rules('customer_type','lang:customer-type','required|xss_clean');
			$this->form_validation->set_rules('customer_id','lang:customer-name','required|xss_clean');
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|callback_check_bill_qty');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]');			
			
			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
				
				unset($item_array['vtype_id']);
				unset($item_array['bill_no']);
				unset($item_array['bill_date']);
				unset($item_array['return_bill_no']);
				unset($item_array['customer_type']);
				unset($item_array['customer_id']);
				unset($item_array['btn_add']);
				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				
				#------------checking same item,godown,unit with same group_id exists
				$sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
				if($sales_temp_item_result == 0)
				{	
					#-----------bill date and next bill no
					if($result_array['vstatus'] == 0)//data not in dms_sales_returns
					{
						$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
						$sales_temp_array['branch_id'] = $this->session->userdata('under_id');
						$sales_temp_array['group_id'] = $group_id;
						$sales_temp_array['bill_no'] = $this->input->post('bill_no',true);
						$sales_temp_array['bill_date'] = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
							$sales_temp_array['return_bill_no'] = $this->input->post('return_bill_no',true);							
						}
						$sales_temp_array['customer_type_id'] = $this->input->post('customer_type',true);
						$sales_temp_array['customer_id'] = $this->input->post('customer_id',true);
						$sales_temp_array['status'] = -1;
						$voucher_date = $sales_temp_array['bill_date'];
						$this->sales_obj->insert("dms_sales_returns",$sales_temp_array);																						
					}				
				
					#--------------adding sales_return items
					$sales_items_id = $this->sales_obj->insert("dms_sales_return_items",$item_array);
					if($sales_items_id)
					{
						#--------------adding temporary stock balance in dms_stocks							
						$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate']);
						if($stock_bal_temp)
						{							
							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'stock_date' => $voucher_date,'stock_status' => 8,'table_id' => $sales_items_id,'status' => -1));
						}
						$this->message->set($this->lang->line('sales_return-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales_return-add-error'),'e');
					}
				}
				else{
					$this->message->set($this->lang->line('sales_return-add-error'),'e');
				}
				redirect('sales_return/add/v-type/'.$vtype);
			}
		}
		
		#------------saving sales_return voucher
		if(isset($_POST['btn_save']))
		{
			#-----------validation
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');			
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');			
			#-----------saving data
			if($this->form_validation->run('btn_save') === true)
			{				
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $this->input->post('remarks',true),'payment_mode' => $this->input->post('payment_mode',true),'status' => 1);
				
				$sales_entry_check = $this->sales_obj->get_bills(array('columns' => array('bill_date','return_bill_no'),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					if($this->sales_obj->update(array('table' => 'dms_sales_returns','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id)))){
						$this->sales_obj->update(array('table' => 'dms_sales_return_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id)));
						
						#-------------changing bill status in dms_sales
						if($sales_entry_check[0]['return_bill_no'] > 0){
							$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 3),'conditions' => array('id' => $sales_entry_check[0]['return_bill_no'])));
						}					
												
						#-------------enabling temporarily added stocks							
						$sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1)));
						foreach($sales_items_array as $key => $value)
						{													
							$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 8,'table_id' => $value['id'])));																					
						}						
						$this->message->set($this->lang->line('sales_return-save-success'));
					}
					else{
						$this->message->set($this->lang->line('sales_return-save-error'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('sales_return-save-error'),'e');
				}
				redirect('sales_return/add/v-type/'.$vtype);
			}
		}

		#------------item details / unit details / godown details
		$units = $goDowns = $customers = array();
		$units[''] = "Select";$custType = "";
		
		#------------sales_return temp data
		$sales_temp_data = array();
		$stock_count = $primary_unit['symbol'] = $cust_id = $return_bill = "";
		if($result_array['vstatus'])
		{
			#------------sales_return temp data
			$sales_temp_data = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.godown_id','b.cst'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));
			
			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];
			
			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];
			
			if($result_array['return_bill_no'] > 0)
			{
				$return_bill = $result_array['return_bill_no'];
				$customerTypes = $this->sales_obj->get_customer_type($return_bill);	
				$customers = $this->sales_obj->get_customer($return_bill);				
				$return_bills[$return_bill] = $this->sales_obj->get_bill_no($return_bill);
				$items = $this->sales_obj->get_bill_items($return_bill);
			}
			else
			{
				$return_bills = $this->sales_obj->get_sales_bills();
				if($this->branch_status){
					$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
				}
				else{
					$customerTypes = $this->desig->listing(array('id'=>2));
				}
				if($custType == 2){
					$this->load->model('customers/customer_master_model','customer_master');
					$customers = $this->customer_master->listing(array('conditions'=>array('id'=>$cust_id)));							
				}
				else if($custType == 1){						
					$this->load->model('branches/branch_model','branches');
					$customers = $this->branches->listing(array('id ='=>$cust_id));		
				}
				else{
					$this->load->model('retailers/counter_model','retailer_master');
					$customers = $this->retailer_master->listing(array('id'=>$cust_id));		
				}
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);		
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				$customerTypes[''] = 'Select';ksort($customerTypes);
				$customers[''] = 'Select';ksort($customers);
				$return_bills[''] = 'Select';ksort($return_bills);
			}
			
			#------------area details
			$this->load->model('areas/area_model','area');
			$areas = $this->area->listing();						
		}
		else
		{
			$sales_array = $this->input->post('sales',true);
											
			#------------customer type
			if($sales_array['customer_type'] != ""){				
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != ""){				
				$cust_id = $sales_array['customer_id'];
			}
			
			if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
				$return_bill = $this->input->post('return_bill_no',true);
				$customerTypes = $this->sales_obj->get_customer_type($return_bill);
				$customers = $this->sales_obj->get_customer($return_bill);				
				$return_bills[$return_bill] = $this->sales_obj->get_bill_no($return_bill);					
				$items = $this->sales_obj->get_bill_items($return_bill);			
			}
			else
			{
				if($this->branch_status){
					$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
				}
				else{
					$customerTypes = $this->desig->listing(array('id'=>2));
				}				
				$return_bills = $this->sales_obj->get_sales_bills();
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);		
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				$customerTypes[''] = 'Select';ksort($customerTypes);
				$customers[''] = 'Select';ksort($customers);
				$return_bills[''] = 'Select';ksort($return_bills);
			}			
			
			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}						
		}	
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);		
		}
		$areas[''] = 'Select';ksort($areas);		
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		
		#------------payment modes
		$payment_mode = $this->stock->payment_modes();
			
		#------------template	
		$this->template->title("New Sales Return Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales_return/report/v-type/'.$vtype));		
		$this->template->slice('dms/message');		
		$this->template->slice('sales/sales_return/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'return_bills' => $return_bills,'return_bill' => $return_bill,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'cust_id' => $cust_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol']));
		$this->template->other_script('sales/sales_return');
		$this->template->render();
	}
	
	public function delete_temp()
	{
		$vtype = $this->uri->segment(4);
		$id=$this->uri->segment(5,0);
		
		#-----------redirect uri
		$update_uri = $this->uri->uri_to_assoc(6);
		$redirect_uri = $this->uri->assoc_to_uri($update_uri);
		
		$result = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.return_bill_no','b.status'),'conditions' => array('b.id' => $id,'b.status !=' => 0)));
		if(!empty($result))
		{
			$row = $result[0];
			if($row['status'] == -1)
			{
				if($this->sales_obj->delete(array('table' => 'dms_sales_return_items','conditions' => array('id' => $id))))
				{
					#-------------deleting stock bal. from dms_stocks
					$this->sales_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 8)));
					
					$count = $this->sales_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
					if($count == 0){
						$this->sales_obj->delete(array('table' => 'dms_sales_returns','conditions' => array('group_id' => $row['group_id'])));
					}
					$this->message->set($this->lang->line('sales_return-item-delete-success'));
				}
				else
				{
					$this->message->set($this->lang->line('sales_return-item-delete-error'),'e');
				}
			}
			else
			{
				#-------------deleting item from dms_sales_return_items				
				$this->sales_obj->update(array('table' => 'dms_sales_return_items','data' => array('status' => 0),'conditions' => array('id' => $id)));
				
				#-------------deleting stock bal. from dms_stocks
				$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 8)));
				
				#-------------checking whether sales_return bill is deleted
				$count = $this->sales_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
				if($count == 0){
					
					#-------------deleting sales_return bill
					$this->sales_obj->update(array('table' => 'dms_sales_returns','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));	
					
					#-------------updating sales_bill status
					if($row['return_bill_no'] > 0)
					{													
						$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 0),'conditions' => array('id' => $row['return_bill_no'])));
					}			
				}
				$this->message->set($this->lang->line('sales_return-item-delete-success'));			
			}
		}
		redirect($redirect_uri);
	}
	
	public function update_temp()
	{
		#----------voucher type
		$vtype = $this->uri->segment(4);
		
		#----------sales_return temp data
		$sales_temp_id = $this->uri->segment(5);
		
		$row = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.bill_date','a.return_bill_no','b.item_id','b.qty','b.unit_id','b.rate','cst','godown_id'),'conditions' => array('b.id' => $sales_temp_id,'b.created_by' => $this->session->userdata('id'))));
		if(!empty($row))
		{			
			$sales_temp_data = $row[0];
			$rules = "callback_check_bill_qty";
			if($sales_temp_data['return_bill_no'] > 0){
				$rules = "callback_check_bill_qty[$sales_temp_data[return_bill_no].$sales_temp_data[item_id].$sales_temp_id]";
			}
			
			#-----------validation
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity',"required|xss_clean|greater_than[0]|".$rules);
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]');	
			
			#-----------redirect uri
			$update_uri = $this->uri->uri_to_assoc(6);
			$redirect_uri = $this->uri->assoc_to_uri($update_uri);
			
			#-----------updating temporary data
			if($this->form_validation->run() === true)
			{
				$item_temp_array = $this->input->post(NULL,true);
				$cst = 0;
				if(array_key_exists('cst',$item_temp_array)){
					$cst = $item_temp_array['cst'];
				}
				
				$this->sales_obj->update_others(array('table' => 'dms_sales_return_items','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));
				$this->message->set($this->lang->line('sales_return-edit-temp-success'));				
				
				#--------------updating temporary stock balance in dms_stocks															
				$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate']);
				if($stock_bal_temp)
				{												
					$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate']),'conditions' => array('stock_status' => 8,'table_id' => $sales_temp_id)));
				}						
				redirect($redirect_uri);
			}
			
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($vtype);
			
			#-----------sales cst checking details
			$sales_cst = $this->stock->get_constant(array('sales_cst'));
			
			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();								

			#------------checking cst enabled or not
			$cst_status = $this->sales_obj->get_cst($sales_temp_data['group_id']);
			if($cst_status){
				$sales_cst = $cst_status;
			}
			
			#------------item details / unit details / godown details
			$units = $goDowns = array();
			$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
			$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
			$goDowns[''] = 'Select';
			ksort($goDowns);
			$units = $this->stock->get_units($sales_temp_data['item_id']);
			
			#------------sales_return date
			$sale_date = $sales_temp_data['bill_date'];
			
			#------------stock count of this item
			$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_date);
			
			#------------primary unit details
			$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

			#------------template	
			$this->template->title("Update Sales Return Voucher");
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'sales_return/add/v-type/'.$vtype,$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'sales_return/report/v-type/'.$vtype,$this->lang->line('go-back') => array($redirect_uri)));
			$this->template->slice('dms/message');		
			$this->template->slice('sales/sales_return/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_date));
			$this->template->other_script('sales/sales_return');
			$this->template->render();
		}
		else
		{
			redirect(base_url());
		}		
	}
	
	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
	
	public function report()
	{	
		#----------voucher type
		$vtype = $this->uri->segment(4);
		$vtype_id = $vtype;
		$conditions = array('vtype_id' => $vtype,'status' => 1);
		$like_array = array();$vnos="";			
				
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($vtype);
		
		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($vtype);
		
		#----------pagination
		$this->load->library('pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('sales_return/report/v-type/'.$vtype);	
		$config['uri_segment'] = 5;
		
		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true || $this->uri->segment(5) == 'vt')
		{
			if($this->input->post('vtype_id',true))
			{
				$conditions['vtype_id'] = $this->input->post('vtype_id',true);
				$config['base_url'] = $config['base_url'].'/vt/'.$conditions['vtype_id'];
				$config['uri_segment'] = 7;	
				$vtype_id = $conditions['vtype_id'];
				if($this->input->post('bill_no',true) && !empty($this->input->post('bill_no',true)))
				{
					$vnos = $this->input->post('bill_no',true);					
					$like_array['bill_no'] = $vnos;
					$config['base_url'] = $config['base_url'].'/vn/'.$vnos;
					$config['uri_segment'] = 9;
				}
			}
			elseif($this->uri->segment(5) == 'vt')
			{
				$conditions['vtype_id'] = $this->uri->segment(6);
				$config['base_url'] = $config['base_url'].'/vt/'.$conditions['vtype_id'];
				$config['uri_segment'] = 7;	
				$vtype_id = $conditions['vtype_id'];
				if($this->uri->segment(7) == 'vn'){
					$like_array['bill_no'] = $this->uri->segment(8);
					$vnos = $like_array['bill_no'];
					$config['base_url'] = $config['base_url'].'/vn/'.$vnos;
					$config['uri_segment'] = 9;
				}
			}				
		}	
		#----------total rows
		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'like' => $like_array,'numrows'=>true));
		
		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}
		
		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);	
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';	
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		
		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();
		
		#----------sales_return report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Sales Return Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'sales_return/add/v-type/'.$vtype,$this->lang->line('report') => 'no_link'));		
		$this->template->slice('sales/sales_entry/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos));
		$this->template->slice('dms/message');
		if(!empty($sales_array))
		{	
			$this->template->slice('sales/sales_return/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();		
	}
	
	public function view()
	{
		#----------voucher type
		$vtype = $this->uri->segment(4);
		$vtype_id = $vtype;
		
		#----------sales_return primary key
		$sales_id = $this->uri->segment(5);
		
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($vtype);
		
		#----------go_back url
		$redirect_uri = $this->uri->uri_to_assoc(6);		
		
		#----------sales_return data
		$sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.payment_mode','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.godown_id','b.cst'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));
		
		#----------template
		$this->template->title("Sales Return Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("view"));
		$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'sales_return/add/v-type/'.$vtype,$this->lang->line('report') => 'sales_return/report/v-type/'.$vtype,$this->lang->line("view") => 'no_link',$this->lang->line("go-back") => array($this->uri->assoc_to_uri($redirect_uri))));
		$this->template->slice('dms/message');
		if(!empty($sales_array))
		{
			#------------loading model
			$this->load->model('customers/customer_type_model','customer_type');
			
			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();
			
			#------------checking cst enabled or not
			$sales_cst = $this->sales_obj->get_cst($sales_array[0]['group_id']);
			
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);
			
			#-------------return bill details
			$return_bill_no = "";
			if($sales_array[0]['return_bill_no'] > 0){																
				$return_bill_no = $this->sales_obj->get_bill_no($sales_array[0]['return_bill_no']);
			}					
			
			$this->template->slice('sales/sales_return/view',array('sales_array' => $sales_array,'return_bill_no' => $return_bill_no,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'area_id' => $area_id,'payment_mode' => $payment_mode));
		}
		$this->template->render();
	}		
	
	public function update()
	{
		#----------voucher type
		$vtype = $this->uri->segment(4);
		$vtype_id = $vtype;
		
		#----------sales_return primary key
		$sales_id = $this->uri->segment(5);
		
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($vtype);
		
		#----------go_back url
		$redirect_uri = $this->uri->uri_to_assoc(6);	
		
		#-----------sales cst checking details
		$sales_cst = $this->stock->get_constant(array('sales_cst'));
		
		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();
		
		#------------cess %
		$cess = $this->stock->get_cess();
		
		#------------bill group_id and date	
		$item_details = $this->sales_obj->get_group($sales_id);	

		#-------------adding items to sales_return bill
		if(isset($_POST['btn_add']))
		{
			$rules = "callback_check_bill_qty";
			if($item_details['return_bill_no'] > 0){
				$rules = "callback_check_bill_qty[$item_details[return_bill_no]]";
			}
			
			#-----------validation			
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');			
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity',"required|xss_clean|greater_than[0]|".$rules);
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]');
			
			#-----------adding items
			if($this->form_validation->run('btn_add') === true)
			{				
				$item_array['group_id'] = $item_details['group_id'];
				$item_array['item_id'] = $this->input->post('item_id',true);								
				$item_array['qty'] = $this->input->post('qty',true);
				$item_array['unit_id'] = $this->input->post('unit_id',true);
				$item_array['rate'] = $this->input->post('rate',true);
				$item_array['godown_id'] = $this->input->post('godown_id',true);
				$item_array['status'] = 1;
				$sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
				if($sales_temp_item_result == 0){
					$sales_items_id = $this->sales_obj->insert("dms_sales_return_items",$item_array);
					if($sales_items_id)
					{
						#--------------adding stock balance in dms_stocks							
						$stock_bal = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate']);
						if($stock_bal)
						{							
							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal['qty'],'unit_id' => $stock_bal['primary_unit'],'rate' => $stock_bal['rate'],'stock_date' => $item_details['bill_date'],'stock_status' => 8,'table_id' => $sales_items_id));
						}
						$this->message->set($this->lang->line('sales_return-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales_return-add-error'),'e');
					}
				}
				else{
					$this->message->set($this->lang->line('sales_return-add-error'),'e');
				}
				$update_uri = $this->uri->uri_to_assoc(1);
				redirect($this->uri->assoc_to_uri($update_uri));
			}			
		}

		#------------saving sales_return voucher
		if(isset($_POST['btn_update']))
		{						
			#-----------validation
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');

			#-----------updating data
			if($this->form_validation->run('btn_update') === true)
			{
				$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
				$sales_entry_array=array('bill_no' => $this->input->post('bill_no',true),'bill_date' => $bill_date,'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $this->input->post('remarks',true),'payment_mode' => $this->input->post('payment_mode',true),'status' => 1);
				if($this->sales_obj->update(array('table' => 'dms_sales_returns','data' => $sales_entry_array,'conditions' => array('id' => $sales_id))))
				{					
					$this->message->set($this->lang->line('sales_return-edit-success'));
				}
				else
				{
					$this->message->set($this->lang->line('sales_return-edit-error'),'e');
				}
				$update_uri = $this->uri->uri_to_assoc(6);
				redirect($this->uri->assoc_to_uri($update_uri));
			}
		}

		#----------sales_return data
		$sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.payment_mode','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.godown_id','b.cst'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));
		
		#----------template
		$this->template->title("Edit Sales Return");
		$this->template->main_heading($this->lang->line("edit")." ".$this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'sales_return/add/v-type/'.$vtype,$this->lang->line('report') => 'sales_return/report/v-type/'.$vtype,$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($this->uri->assoc_to_uri($redirect_uri))));		
		$this->template->slice('dms/message');
		if(!empty($sales_array))
		{
			$stock_count = $primary_unit['symbol'] = "";
			
			#------------loading model
			$this->load->model('customers/customer_type_model','customer_type');
			
			#------------checking cst enabled or not
			$cst_status = $this->sales_obj->get_cst($sales_array[0]['group_id']);
			if($cst_status){
				$sales_cst = $cst_status;
			}
			
			#------------customer type and customer details
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			
			#------------item details / unit details / godown details
			$units = $goDowns = array();
			$units[''] = "Select";
			
			#------------return bill details
			$return_bill_no = "";
			if($sales_array[0]['return_bill_no'] == 0)
			{
				$args['select'] = array('id','item_code','item_name');						
				$items = $this->stock->get_stock_items($args);				
			}			
			else
			{			
				$return_bill_no = $this->sales_obj->get_bill_no($sales_array[0]['return_bill_no']);
				$items = $this->sales_obj->get_bill_items($sales_array[0]['return_bill_no']);
			}
			
			#------------payment modes
			$payment_modes = $this->stock->payment_modes();			
			
			if(empty($items)){
				$this->message->set($this->lang->line('no-items-found'),'i');
			}
				
			#------------item details / unit details / godown details			
			if($this->input->post('item_id',true)){
				$itemID = $this->input->post('item_id',true);
				$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
				$units = $this->stock->get_units($itemID);		
			}
			
			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array[0]['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array[0]['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}					
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);	
			
			#------------area details
			$this->load->model('areas/area_model','area');			
			$areas = $this->area->listing();
			
			$areas[''] = 'Select';ksort($areas);
			$items[''] = 'Select';ksort($items);
			$goDowns[''] = 'Select';ksort($goDowns);		
			
			$this->template->slice('sales/sales_return/edit',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'payment_mode' => $sales_array[0]['payment_mode'],'voucher_name' => $voucher_name,'payment_modes' => $payment_modes,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'areas' => $areas,'return_bill_no' => $return_bill_no));
			$this->template->other_script('sales/sales_return');
		}		
		$this->template->render();
	}
	
	public function delete()
	{
		$vtype = $this->uri->segment(4);
		$id=$this->uri->segment(5,0);
		
		#-----------redirect uri
		$update_uri = $this->uri->uri_to_assoc(6);
		$redirect_uri = $this->uri->assoc_to_uri($update_uri);
		
		$result = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.return_bill_no','b.id'),'conditions' => array('a.id' => $id)));
		if(!empty($result))
		{
			$row = $result[0];

			if($this->sales_obj->update_others(array('table' => 'dms_sales_returns','data' => array('status' => 0),'conditions' => array('id' => $id))))
			{
				#-------------deleting sales_return_items of sales_return								
				$this->sales_obj->update_others(array('table' => 'dms_sales_return_items','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));
				
				#-------------updating sales_bill status
				if($row['return_bill_no'] > 0)
				{													
					$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 0),'conditions' => array('id' => $row['return_bill_no'])));
				}
					
				foreach($result as $key => $value)
				{
					#-------------deleting stock bal. from dms_stocks
					$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 8)));
				}					
				$this->message->set($this->lang->line('sales_return-delete-success'));
			}
			else
			{
				$this->message->set($this->lang->line('sales_return-delete-error'),'e');
			}
		}
		redirect($redirect_uri);
	}
	
	public function check_bill_qty($qty,$values = NULL)
	{		
		if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
			$item_id = $this->input->post('item_id',true);
			$bill_id = $this->input->post('return_bill_no',true);
			$count = $this->sales_obj->get_item_count($bill_id,$item_id);
			$qty += $this->sales_obj->get_sales_return_item_count($bill_id,$item_id);
			if($qty > $count){
				return false;
			}
			return true;
		}
		elseif($values != NULL){
			$exp = explode(".",$values);
			$bill_id = $exp[0];
			if($this->input->post('item_id',true) && $this->input->post('item_id',true) != ""){
				$item_id = $this->input->post('item_id',true);
				$qty += $this->sales_obj->get_sales_return_item_count($bill_id,$item_id);
			}
			else{
				$item_id = $exp[1];
				$purchase_return_item_id = $exp[2];
				$qty += $this->sales_obj->get_sales_return_item_count($bill_id,$item_id,$purchase_return_item_id);
			}						
			$count = $this->sales_obj->get_item_count($bill_id,$item_id);
			if($qty > $count){				
				return false;
			}
			return true;
		}		
	}
		
}
?>