<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_to_purchase extends MY_Controller{

	var $companyID,$branchID,$createdBY,$fiscal_start_date,$fiscal_end_date;
	public function __construct()
	{
		parent::__construct();

		#$this->check_access_right();
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add');
		fiscal_status($this->uri->segment(2),$method_array,"my_bills/purchase_bills");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

		$this->load->model('purchase/Purchase_model','purchase');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		#----------voucher type
		$this->vtype = 5;
	}

	public function add()
	{
		if(!$this->dms->have_access(463)){
			redirect('access/');
		}

		#----------voucher type
		$vtype_id = $this->vtype;

		$this->template->title($this->lang->line("purchase"));
		$this->template->main_heading($this->lang->line("purchase"));
		$this->template->breadcrumb(array($this->lang->line("purchase") => 'no_link',$this->lang->line('report') => 'purchase/report'));

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		#-----------purchase cst checking details
		$purchase_cst = $this->stock->get_constant(array('purchase_cst'));
		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();
		#------------cess %
		$cess = $this->stock->get_cess();
		#-----------purchase date and next bill no
		$result_array = $this->purchase->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		$units = $items = $goDowns = $purchase_temp_data = array();
		$vendors = $this->stock->get_vendors();
		$payment_modes = $this->stock->payment_modes();
		$args=array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		$goDowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID),'listing'=>1));
		$goDowns[''] = 'Select';
		ksort($goDowns);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}

		$args = array();
		$args['columns'] = array('a.group_id','a.pid','a.vendor_id','a.invoice_no','a.invoice_date','a.pid','a.p_status','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.payment_mode','a.cr_period','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_percent','b.vat_amt','b.cst');
		$args['conditions'] = array('a.created_by' =>$this->createdBY,'vtype_id' => $vtype_id,'a.status =' => -1);#,'b.status =' => -1

		$purchase_temp_data = $this->purchase->get_purchases($args);

		if(!empty($purchase_temp_data)){

			$salesID = $purchase_temp_data[0]['pid'];
			$pStatus = $purchase_temp_data[0]['p_status'];

			if($pStatus != 4){
				redirect('purchase/add');
			}
			$this->db->select(array('bill_no','bill_date'));
			$this->db->from('dms_sales');
			$this->db->where(array('id'=>$salesID));
			$sales = $this->db->get()->row_array();

			$this->purchase->update_others(array('table'=> 'dms_purchases','data'=>array('invoice_no'=>$sales['bill_no'],'invoice_date'=>$sales['bill_date']),'conditions'=>array('created_by' =>$this->createdBY,'vtype_id' => $vtype_id,'status =' => -1)));

			$invoice_no = $sales['bill_no'];
			$invoice_date = $sales['bill_date'];
			$vendor_id = $purchase_temp_data[0]['vendor_id'];
			$group_id = $purchase_temp_data[0]['group_id'];
			$purchasePayMode = $purchase_temp_data[0]['payment_mode'];
			$cd_status = 1;$ccd = $cd_no = $pdc = "";
			$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' =>'dms_purchases','a.table_group_id' =>$group_id)));
			if(!empty($cheque_dd_array)){
				$cd_status = 0;
				$ccd = $cheque_dd_array[0]['cash_type'];
				$cd_no = $cheque_dd_array[0]['cd_no'];
				$pdc = $cheque_dd_array[0]['pdc'];
			}
		}else{
			$this->message->set($this->lang->line('invalid-purchase'),'e');
			redirect('my_bills/purchase_bills');
		}

		#------------saving purchase voucher
		if(isset($_POST['btn_save'])){
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date|is_date|check_date['.date('Y-m-d').'.<=]|check_date['.$invoice_date.'.>=]');
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$vtype_id.$group_id");
			foreach($purchase_temp_data as $key=>$pItem){
				$this->form_validation->set_rules('godown_id_'.$pItem['id'],'lang:godown','required|xss_clean');
			}

			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			if($this->form_validation->run('btn_save') === true){

				$bill_num = $this->input->post('bill_no');
				$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
				$bill_freight = $this->input->post('freight');
				$bill_other_exp = $this->input->post('other_expense');
				$narration = $this->input->post('remarks');
				$purchaseTotalAmount = $this->input->post('grand_total_amount');

				$savePurchase = array();
				$savePurchase['table'] = 'dms_purchases';
				$savePurchase['data'] = array('bill_no'=>$bill_num,'bill_date'=>$bill_date,'narration'=>$narration,'status'=>1);
				$savePurchase['conditions'] = array('created_by'=>$this->createdBY,'group_id'=>$group_id,'status ='=>-1);
				echo $group_id;
				$args = array();
				$args['columns'] = array('id','company_id','branch_id','group_id','vtype_id','vno','vorder_no','vorder_no','vdate','dr_ledger','cr_ledger','vamount','narration','table_name','table_group_id','status');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('table_name'=>'dms_purchases','table_group_id'=>$group_id);
				$purchase_vouchers = $this->dms->get_data($args);

				#----------------------------------------------------------------------------------------------------

				$delivery_exists = 1;
				$args = array();
				$args['columns'] = array('ddn.id as dnote_id','ddn.bill_status as dnote_bill_status');
				$args['table'] = 'dms_sales as ds';
				$args['conditions'] = array('ds.id'=>$salesID);
				$args['join'] = array('table'=>'dms_delivery_notes as ddn','on'=>'ds.group_id=ddn.group_id','type'=>'inner');
				$check_sales = $this->dms->get_data($args);

				if(!empty($check_sales)){

					$dnoteID = $check_sales[0]['dnote_id'];
					$dnoteStatus = $check_sales[0]['dnote_bill_status'];# 2 = approve and added to stock as receipt-note
					$args = array();
					$args['columns'] = array('id');
					$args['table'] = 'dms_receipt_notes';
					$args['conditions'] = array('branch_id'=>$this->branchID,'pid'=>$dnoteID,'p_status'=>4);
					$check_receipt = $this->dms->get_data($args);

					if(!empty($check_receipt) && $dnoteStatus == 2){
						$delivery_exists = 0;
					}
				}

				#-----------------------------------------------------------------------------------------------------
				$this->db->trans_start();
				if($this->purchase->update_others($savePurchase)){

					$voucher_status =1;
					if($purchasePayMode > 2){
						$voucher_status = 3;
					}else if($purchasePayMode == 2){
						$vendorDetails = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' =>$vendor_id)));
						$purchasePayMode = $vendorDetails[0]['ledger_id'];//customer
					}
					#------------------------------------------------------------------------------------------
					$this->purchase->update_others(array('table' => 'dms_vouchers','data' => array('vno' =>$bill_num,'vdate' =>$bill_date),'conditions' => array('group_id' => $purchase_vouchers[0]['group_id'])));
					if($purchasePayMode > 2){
						$this->purchase->update_others(array('table' => 'dms_voucher_banks','data' => array('vdate' => $bill_date),'conditions' => array('group_id' => $purchase_vouchers[0]['group_id'])));
					}
					#------------------------------------------------------------------------------------------

					foreach($purchase_temp_data as $key=>$pItem){

						$pItemID = $pItem['id'];
						$godown_id = $this->input->post('godown_id_'.$pItemID);
						$itemID = $pItem['item_id'];
						$qty = $pItem['qty'];
						$rate = $pItem['rate'];
						$amount = $pItem['amount'];
						$unitID = $pItem['unit_id'];
						$salesID = $pItem['pid'];
						$savePurchaseItems = array();
						$savePurchaseItems['table'] = 'dms_purchase_items';
						$savePurchaseItems['data'] = array('godown_id'=>$godown_id,'status'=>1);
						$savePurchaseItems['conditions'] = array('id'=>$pItemID,'status'=>-1);

						if($this->purchase->update_others($savePurchaseItems)){
							if(!empty($delivery_exists)){
								$convertedStock = $this->stock->unit_conversion($itemID,$unitID,$qty,$rate,$amount);
								if(!empty($convertedStock)){
									$this->purchase->insert('dms_stocks',array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'godown_id' =>$godown_id,'item_id' =>$itemID,'qty' => $convertedStock['qty'],'unit_id' => $convertedStock['primary_unit'],'rate' => $convertedStock['rate'],'amount' => $convertedStock['amount'],'stock_date' =>$bill_date,'stock_status' =>2,'table_group_id'=>$group_id,'table_id' => $pItemID,'status' =>1));
								}
							}
						}
					}
				$this->db->update('dms_sales',array('bill_status'=>2),array('id'=>$salesID));
				$this->db->trans_complete();
				$this->message->set($this->lang->line('purchase-save-success'));
				redirect('my_bills/purchase_bills');
				}
			}
		}

		$this->template->slice('dms/message');
		$this->template->slice('sales/purchase/sales_to_purchase',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'vendors' => $vendors,'vendor_id' => $vendor_id,'invoice_no' => $invoice_no,'invoice_date' => $invoice_date,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'purchase_temp_data' => $purchase_temp_data,'payment_modes' => $payment_modes,'godowns'=>$goDowns,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'payment_mode'=>$purchasePayMode,'bill_prefix'=>$bill_prefix));
		$this->template->other_script('purchase/sales_to_purchase');
		$this->template->render();
	}

	#-----------------------------------------------------------------------------------------

	public function bill_no_exists($bill_no,$v_details = NULL){

		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->purchase_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	#-----------------------------------------------------------------------------------------

}
?>