<?php if( !defined('BASEPATH'))exit('No direct script access allowed');

class Sales_upload_excel extends MY_Controller{

	public function __construct()
	{
		parent ::__construct();
		$this->check_access_right();
		$this->load->library('My_excel');
		$this->load->model('sales/Sales_model','sales');
		$this->load->model('sales/Sales_upload_model','salesupload');
	}

	public function upload_bill()
	{
		$this->load->library('Stock');
		$continue = 1;
		$error_bill_no =array();
		//$error_rows = array();
		//$error_string = "";
		if($this->uri->segment(3) !='')
		{
			$error_bill_no = $this->uri->uri_to_assoc(3);
			$this->uri->rsegment(3);
		}
		if($this->input->post('upload',TRUE))
		{
			$this->form_validation->set_rules('sales_file','lang:sales-bill','callback_file_empty');
			if($this->form_validation->run() == TRUE)
			{
				if($_FILES['sales_file']['name'] != '')
				{
					$this->load->library('Image');
					$file_name = $this->image->random_name($_FILES['sales_file']['name']);
					$fpart1 ="bill_".date('YmdHis');
					$ext = pathinfo($_FILES['sales_file']['name'], PATHINFO_EXTENSION);
					$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls')
					{
						$this->message->set($this->lang->line('sales-invalid-filetype'),'e');
					}
					else
					{
						#file uploading
						$config['upload_path'] =  FCPATH.'assets/files/sales/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						$this->load->library('Upload');
						$this->upload->initialize($config);

						if($this->upload->do_upload('sales_file'))
						{
							$data['sales_file'] = $file_name;
							$file = FCPATH."assets/files/sales/".$file_name;
							if (!empty($file) && file_exists($file))
							{
								$this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
								$last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow();
								$i=2;
								$bill_no_temp = "";
								$invalid_dates = array('','0000-00-00','1970-01-01','0',' ');

								#----------cess %
								$cess = $this->stock->get_cess();

								#----------godown id
								$godown_id = $this->salesupload->get_main_godown_id();

								#------------presumptive tax checking
								$presumptive_tax = $this->stock->get_tax_type();
								$voucher_amount = $vat_amount = $cess_amount = $freight_amount = $other_expense_amount = $cst_amount = 0;

								for($i=2;$i<=$last_row;$i++)
								{
									$error_rows = array();

									#-----------------read from excel
									$bill_no = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('A'.$i)->getValue());//bill no

									#-------------bill date
									$d_date = $this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue();
									$d_date = PHPExcel_Style_NumberFormat::toFormattedString($d_date, 'YYYY-MM-DD');
									if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$d_date)){
									   $d_date='';
									}
									$d_date = date('Y-m-d',strtotime($d_date));

									$cust_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());//customer type	

									$cust = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('D'.$i)->getValue());//vendor

									$item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('E'.$i)->getValue());//item code

									$item_name = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('F'.$i)->getValue());//item name

									$item_qty = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('G'.$i)->getValue());//qty

									$item_unit = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('H'.$i)->getValue());//unit

									$item_rate = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('I'.$i)->getValue());//rate

									$item_amount = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('J'.$i)->getValue());//amount

									$item_discount_amount = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('K'.$i)->getValue());//discount amount

									$cgst_amt = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('L'.$i)->getValue());//cgst amount

									$sgst_amt = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('M'.$i)->getValue());//sgst amount

									$freight = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('N'.$i)->getValue());//bill freight

									$other_expense = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('O'.$i)->getValue());//other expense

									$bill_discount_amt = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('P'.$i)->getValue());//bill discount amount

									$payment_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('Q'.$i)->getValue());// C => cash, Cr => credit, B => bank

									$pymnt_mod = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('R'.$i)->getValue());//ledger_id

									$credit_period = getTrim($this->my_excel->excelObj->getActiveSheet()->getCell('S'.$i)->getValue());//credit period

									if(empty($bill_no) || in_array($d_date,$invalid_dates) || empty($cust_type) || empty($cust) || empty($item_code) || empty($item_name) || empty($item_qty) || empty($item_unit))
									{
										if(empty($bill_no)){
											$error_rows['bill_no'] = $this->lang->line('invalid-bill-no');
										}
										if(in_array($d_date,$invalid_dates)){
											$error_rows['bill_date'] = $this->lang->line('invalid-bill-date');
										}
										if(empty($cust_type)){
											$error_rows['customer_type'] = $this->lang->line('invalid-customer-type');
										}										
										if(empty($cust)){
											$error_rows['customer'] = $this->lang->line('invalid-customer');
										}
										if(empty($item_code)){
											$error_rows['item_code'] = $this->lang->line('invalid-item-code');
										}
										if(empty($item_name)){
											$error_rows['item_name'] = $this->lang->line('invalid-item-name');
										}
										if(empty($item_qty)){
											$error_rows['item_qty'] = $this->lang->line('invalid-item-qty');
										}
										if(empty($item_unit)){
											$error_rows['item_unit'] = $this->lang->line('invalid-item-unit');
										}
									}
									else
									{
										#----------------checking bill date is currnt finacual year/and closed financial year
										$bill_check = $this->salesupload->check_bill_date($d_date);
										$check_date = $this->form_validation->valid_date($d_date);

										$item_id = $this->salesupload->get_item_id($item_code,$item_name);//item id
										$unit_id = $this->salesupload->get_unit_id($item_unit);// unit id
										$vendor_id = $this->salesupload->get_customer_id($cust_type,$cust);//customer id

										if((!empty($bill_check) || empty($check_date)) || empty($vendor_id) || empty($item_id) || empty($unit_id))
										{
											if(!empty($bill_check) || empty($check_date))
											{
												$error_rows['bill_date'] = $this->lang->line("bill-date-not-between-fiscal-year");
											}
											if(empty($vendor_id))
											{
												$error_rows['vendor_id'] = $this->lang->line("customer-not-exist");
											}
											if(empty($item_id))
											{
												$error_rows['item_id'] = $this->lang->line("item-not-exist");
											}
											if(empty($unit_id))
											{
												$error_rows['unit_id'] = $this->lang->line("unit-not-exist");
											}
										}
										else
										{
											$sales_item['item_id'] = $item_id;
											$sales_item['godown_id'] = $godown_id;
											$sales_item['qty'] = $item_qty;//need to change
											$sales_item['unit_id'] = $unit_id;
											$sales_item['rate'] = 0;
											$sales_item['amount'] = $item_amount;
											if($item_amount != 0){
												$sales_item['rate'] = (float)$item_amount/(float)$item_qty;
											}
											$sales_item['discount_per'] = round_this(((float)$item_discount_amount * 100) / (float)$item_amount);
											$sales_item['discount_amt'] = $item_discount_amount;
										//	$sales_item['cst'] = $cst;
											$sales_item['item_status'] = 2;
											$payment_mode = $this->salesupload->get_payment_mode_id($payment_type,$pymnt_mod);

											//transaction started
											$this->db->trans_start();

											if(!$this->if_exists('dms_sales',array('vtype_id' => 6,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $bill_no,'bill_date' => $d_date)))
											{
												#---------vat
										/*		if(empty($presumptive_tax)){
													if(empty($cst)){
														$sales_item['vat_percent'] = $this->stock->get_item_vat($item_id);
														$sales_item['vat_amt'] = $vat_amt;
														$vat_amount = $vat_amt;
													}
												}    */


$sales_item['cgst']=$this->stock->get_item_cgst($item_id);
$sales_item['sgst']=$this->stock->get_item_sgst($item_id);
$sales_item['cgst_amt'] = $cgst_amt;
$sales_item['sgst_amt'] = $sgst_amt;

$vat_amount = (float)$cgst_amt+(float)$sgst_amt;

												#----------total calculation
												$voucher_amount = ((float)$item_amount - (float)$item_discount_amount - (float)$bill_discount_amt);
												$freight_amount = $freight;
												$other_expense_amount = $other_expense;

											//	$cst_amount = ((($item_amount - $item_discount_amount)*$cst)/100);
											//	$cess_amt = (($vat_amount+$cst_amount)*$cess)/100;
											//	$cess_amount = $cess_amt;

												$sales['vtype_id'] = 6;
												$sales['branch_id'] = $this->session->userdata('under_id');
												$sales['bill_no'] = $bill_no;
												$sales['bill_date']= $d_date;
if($cust_type == 'BRANCH')
{
      $sales['customer_type_id'] = 1;
}
else if($cust_type == 'AR')
{
      $sales['customer_type_id'] = 3;
}
else if($cust_type == 'CUSTOMER')
{
      $sales['customer_type_id'] = 2;
}								
												$sales['group_id'] = $sales_item['group_id'] = $this->stock->get_group_id('dms_sales_items1');
												$sales['s_status'] = 0;
												$sales['customer_id'] = $vendor_id;

												$sales['bill_discount_amt'] = $bill_discount_amt;
												$sales['bill_freight'] = $freight;
												$sales['other_expense'] = $other_expense;

												$sales['cess'] = $cess;

												$sales['payment_mode'] = $payment_mode;
												$sales['cr_period'] = $credit_period;
												$this->salesupload->f_save('dms_sales',$sales);
											}
											else
											{
												#---------vat
											/*	if(empty($presumptive_tax)){
													if(empty($cst)){
														$sales_item['vat_percent'] = $this->stock->get_item_vat($item_id);
														$sales_item['vat_amt'] = $vat_amt;
														$vat_amount += $vat_amt;
													}
												}       */


$sales_item['cgst_amt'] = $cgst_amt;
$sales_item['sgst_amt'] = $sgst_amt;

$vat_amount = (float)$cgst_amt+(float)$sgst_amt;




												#----------total calculation
												(float)$voucher_amount += ((float)$item_amount - (float)$item_discount_amount - (float)$bill_discount_amt);
												(float)$freight_amount += (float)$freight;
												(float)$other_expense_amount += (float)$other_expense;

											//	$cst_amount += ((($item_amount - $item_discount_amount)*$cst)/100);
											//	$cess_amt = (($vat_amount+$cst_amount)*$cess)/100;
											//	$cess_amount += $cess_amt;
											}

											if(isset($sales_item['group_id']) && !empty($sales_item['group_id']))
											{
												#------------checking same item,godown,unit with same group_id exists
												$sales_temp_item_result = $this->sales->get_sales_gst(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $sales_item['group_id'],'item_id' => $item_id,'godown_id' => $sales_item['godown_id'],'unit_id' => $unit_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
												if($sales_temp_item_result == 0)
												{
													$sales_items_id = $this->salesupload->f_save('dms_sales_items1',$sales_item);
//echo $sales_items_id;
//echo "hi";
													if($sales_items_id)
													{

														#--------------adding stock balance in dms_stocks
														$stock_bal_temp = $this->stock->unit_conversion($item_id,$unit_id,$item_qty,$sales_item['rate'],$sales_item['amount']);
														if($stock_bal_temp)
														{
															$this->sales->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $sales_item['godown_id'],'item_id' => $item_id,'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $d_date,'stock_status' => 6,'table_group_id' => $sales_item['group_id'],'table_id' => $sales_items_id));
														}

														if($payment_mode == 2){
															if($this->dms->branch_type())
															{
if($cust_type == 'BRANCH')
{
																$vendor_ledger_id = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
}
else if($cust_type == 'AR')
{
       $vendor_ledger_id = $this->dms->get_data(array('table' =>'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
}
else if($cust_type == 'CUSTOMER')
{
       $vendor_ledger_id = $this->dms->get_data(array('table' =>'customer_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
}
																$sales['payment_mode'] = $vendor_ledger_id[0]['ledger_id'];
echo $sales['payment_mode'];
															}
															else
															{
																$vendor_ledger_id = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
																$sales['payment_mode'] = $vendor_ledger_id[0]['ledger_id'];
															}
														}

														$voucher_data = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => array('id','group_id','dr_ledger'),'conditions' => array('table_name' => 'dms_sales','table_group_id' => $sales_item['group_id']),'order_by' => 'dr_ledger','order' => 'asc'));

														$voucher_array = array();
														if(!$voucher_data && $bill_no_temp != $bill_no)
														{
															$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 6,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $d_date,'dr_ledger' => 4,'cr_ledger' => $sales['payment_mode'],'vamount' => $voucher_amount,'table_name' => 'dms_sales','table_group_id' => $sales['group_id'],'status' => 1);

															#-----------VAT
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 6,'vno' => $bill_no,'vorder_no' => 2,'vdate' => $d_date,'dr_ledger' => 11,'cr_ledger' => $sales['payment_mode'],'vamount' => $vat_amount,'table_name' => 'dms_sales','table_group_id' => $sales['group_id'],'status' => 1);

															#-----------CESS
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 6,'vno' => $bill_no,'vorder_no' => 3,'vdate' => $d_date,'dr_ledger' => 15,'cr_ledger' => $sales['payment_mode'],'vamount' => 0,'table_name' => 'dms_sales','table_group_id' => $sales['group_id'],'status' => 1);

															#-----------Freight
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 6,'vno' => $bill_no,'vorder_no' => 4,'vdate' => $d_date,'dr_ledger' => 13,'cr_ledger' => $sales['payment_mode'],'vamount' => $freight_amount,'table_name' => 'dms_sales','table_group_id' => $sales['group_id'],'status' => 1);

															#-----------Other Expense
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 6,'vno' => $bill_no,'vorder_no' => 5,'vdate' => $d_date,'dr_ledger' => 14,'cr_ledger' => $sales['payment_mode'],'vamount' => $other_expense_amount,'table_name' => 'dms_sales','table_group_id' => $sales['group_id'],'status' => 1);

															#-----------inserting to voucher
															$this->sales->f_saves('dms_vouchers',$voucher_array);
														}
														else
														{
															if($bill_no_temp == $bill_no && count($voucher_data) == 5)
															{
																$voucher_array[] = array('id' => $voucher_data[0]['id'],'vamount' => $voucher_amount);

																#-----------VAT
																$voucher_array[] = array('id' => $voucher_data[1]['id'],'vamount' => $vat_amount);

																#-----------Freight
																$voucher_array[] = array('id' => $voucher_data[2]['id'],'vamount' => $freight_amount);

																#-----------Other Expense
																$voucher_array[] = array('id' => $voucher_data[3]['id'],'vamount' => $other_expense_amount);

																#-----------CESS
																$voucher_array[] = array('id' => $voucher_data[4]['id'],'vamount' => 0);

																#-----------inserting to voucher
																$this->sales->update_batch('dms_vouchers',$voucher_array,'id');
															}
														}
													}
												}
											}

											#----------transaction completed
											$this->db->trans_complete();
											$bill_no_temp = $bill_no;
										}
									}
									if(!empty($error_rows))
									{
										if(empty($error_string)){
											$error_string = "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
										else{
											$error_string .= "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
									}
								}
								if(!empty($error_string))
								{
									?>
									<script>localStorage.setItem('perrors',"<?php echo $error_string;?>");</script>
									<?php
								}
							}
							else{
								$continue = 0;
								$this->message->set($this->lang->line('invalid-filetype'),'e');
							}
						}
						else{
							$continue=0;
							$this->message->set($this->lang->line('invalid-filetype'),'e');
						}
						if($continue ==1){
							$this->message->set($this->lang->line('sales-bill-uploaded','s'));
							//redirect('sales_upload_excel/upload_bill');
						}
					}
				}
			}
		}

		#--------------------template
		$this->template->title($this->lang->line('sales-bill').' '.$this->lang->line('upload'));
		$this->template->main_heading($this->lang->line('sales-bill').' '.$this->lang->line('upload'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line('sales') => 'sales/add',$this->lang->line('report') => 'sales/report',$this->lang->line('upload')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('sales/upload_bill/upload');
		$this->template->render();
	}

	public function file_empty()
	{
		if(isset($_FILES['sales_file']) && !empty($_FILES['sales_file']['name'])){
			return true;
		}else{
			return false;
		}
	}
}
?>