<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Secdms extends MY_Controller{


		function __construct(){
			parent :: __construct();
		}


		#----------------------------------------------

		#date : 17-10-2014
		#purpose : change password (for user herself)
		function change_pwd(){

			$this->form_validation->set_rules('current_password','lang:current-pwd','required|trim|xss_clean|callback_compare_with_db_password');
			$this->form_validation->set_rules('new_password','lang:new-pwd','required|trim|xss_clean|callback_special_chara_check|callback_compare_passwords');
			$this->form_validation->set_rules('confirm_password','lang:confirm-pwd','required|trim|xss_clean|callback_compare_passwords');

			if($this->form_validation->run() == TRUE){

				$password = password_hash($this->input->post('new_password',TRUE),PASSWORD_DEFAULT);
				$this->db->update('users',array('password'=>$password),array('id'=>$this->session->userdata('id')));
				$this->message->set($this->lang->line('password-changed'));
				$this->message->append_msg('Auto logout in <span class="timer">10</span> seconds.'.$this->lang->line('login-again-new-pwd'),'i');
				
				#auto time out script
				$this->template->other_script('users/change_pwd/timer_logout');

			}

			$this->template->title('Change password');
			$this->template->main_heading($this->lang->line('change-pwd'));
			$this->template->breadcrumb(array($this->lang->line('security')=>'no_link',$this->lang->line('change-pwd')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('users/change_pwd/change_pwd');
			$this->template->render();
		}

		#----------------------------------------------

		function compare_with_db_password(){

			$current_pwd = $this->input->post("current_password",TRUE);

			#get current pwd from db
			$row = $this->db->select('password')->get_where('users',array('id'=>$this->session->userdata('id')))->row_array();
			if(!password_verify($current_pwd,$row['password'])){
				
				$this->form_validation->set_message('compare_with_db_password',$this->lang->line('not-match-wth-current-pwd'));
				return FALSE;
			
			}else{
			
				return TRUE;
			}
		}

		#----------------------------------------------

		function special_chara_check(){

			if(preg_match('/[\'^£$%&*()}{~?><>,|=_+¬-]/', $this->input->post('new_password',TRUE)))
			{
				$this->form_validation->set_message('special_chara_check',$this->lang->line('Cant-include-other-spec-charas'));
				return FALSE;
			
			}

			return TRUE;
		}

		#------------------------------------------------

		function compare_passwords(){

			if($this->input->post('new_password',TRUE) != $this->input->post('confirm_password',TRUE)){
				$this->form_validation->set_message('compare_passwords',$this->lang->line('pwds-not-match'));
				return FALSE;
			}else{
				return TRUE;
			}
		}

		#-------------------------------------------------

		#date : 18-10-2014
		#purpose : change employee password(mostlt by admin)
		function change_emp_pwd(){

			if(!$this->uri->segment(3)){
				redirect('access/');
			}

			$this->form_validation->set_rules('new_password','lang:password','required|xss_clean|trim|callback_special_chara_check');
			if($this->form_validation->run() == TRUE){

				$password = $this->input->post('new_password',TRUE);
				$user = $this->uri->segment(3,-100);

				$password = password_hash($password,PASSWORD_DEFAULT);
				$this->db->update('users',array('password'=>$password),array('id'=>$user));
				$this->message->set($this->lang->line('emp-password-changed'));
			}

			$this->template->title('Change employee password');
			$this->template->main_heading($this->lang->line('change-emp-pwd'));
			$this->template->breadcrumb(array($this->lang->line('change-emp-pwd')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('users/change_pwd/change_emp_pwd');
			$this->template->render();
		}
		#-------------------------------------------------
	}

?>