<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sms extends MY_Controller{

    public function __construct(){
		parent::__construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_requests/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	public function pending(){
		$this->template->title('sms');
		$this->template->main_heading($this->lang->line('pending-sms'));
		$this->template->breadcrumb(array($this->lang->line('pending-sms') => 'no_link'));
		$this->load->model('sms/Sms_model','sms');
		$this->load->model('sales/Sales_model','sales');
		$this->load->library('Stock');
		$this->load->library('Targets');
		$offset=0;$postedCheck=array();$insertCount=0;

		$this->form_validation->set_rules('request','','xss_clean');
		$this->form_validation->set_rules('status','','xss_clean');
		if($this->form_validation->run() === true){

			$postedCKs = $this->input->post('request');
			$updateStatus = $this->input->post('status');
			if(empty($postedCKs)){
				$this->message->set($this->lang->line('please-check-request'),'e');
			}else{
				$messageArray = array('3'=>'sms-request-approved','2'=>'sms-request-rejected');
				$this->db->trans_start();
				foreach($postedCKs as $key=>$reqID){

					#------------------------------------------------------------------------------
					$args = array();
					$args['select'] = array('ds.bill_ref_no','dsl.user_id','dsl.id as sales_id','dsl.group_id','dsl.bill_date','uc.id as client_id','uc.designation_id');
					$args['conditions'] = array('ds.id'=>$reqID);
					$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as uc'=>'ds.user_id=uc.id');
					$salesBill = $this->sms->get_all($args);

					$user_id = $salesBill[0]['user_id'];
					$clientID = $salesBill[0]['client_id'];
					$group_id = $salesBill[0]['group_id'];
					$salesBillID = $salesBill[0]['sales_id'];
					$designation_id = $salesBill[0]['designation_id'];
					$bill_date = $salesBill[0]['bill_date'];

					if(empty($user_id)){
						$user_id = $clientID;
						if($this->sms->update_bill(array('user_id'=>$clientID),array('id'=>$salesBillID))){
						}
					}
					#=======================================================
					$upSts=$updateStatus;	$message=NULL;
					$sales_items_array = $this->sales->get_sales_items(array('columns' => array('item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id)));
					$total_points = 0;$user_points=0;
					if(!empty($user_id)){
						foreach($sales_items_array as $key => $value){

							$conditions = array('designation_id'=>$designation_id,'user_id'=>$user_id);
							$getPrevPoint = $this->sms->get_user_point($conditions);
							#--------------calculating user points-------------------
							$user_points += $this->targets->get_bill_points($designation_id,$user_id,$value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$bill_date);

						}
					}

					if($user_points > 0){

						$target_id = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => $designation_id,'a.user_id' => $user_id,'a.status' => 1),'bill_date' => $bill_date));
						if($target_id){
							$pre_total_point = $this->targets->get_points(array('up.designation_id' => $designation_id,'up.user_id' => $user_id,'up.targets_id' => $target_id['id'],'ds.status >'=>3,'ds.status <'=>6));

							if($this->targets->get_points(array('up.group_id' => $group_id)) > 0){
								$this->sales->update_others(array('table' => 'user_points','data' => array('designation_id' => $designation_id,'user_id' => $user_id,'sms_point' => $user_points,'actual_point'=>$user_points),'conditions' => array('group_id' => $group_id,'status' => 1)));
							}else{

								$this->sales->insert('user_points',array('designation_id' => $designation_id,'user_id' => $user_id,'targets_id' => $target_id['id'],'group_id' => $group_id,'sms_point' => $user_points,'actual_point' => $user_points));
							}

							$cur_total_points = $pre_total_point + $user_points;
							if(floor($cur_total_points) != floor($pre_total_point) && $cur_total_points > 0){

								$message = $this->targets->get_message($target_id['id'],$cur_total_points);
								$client_mobile_no = $this->dms->get_user_mobile_no($user_id);

							}else{

								$message = NULL;
								if($updateStatus == 3){
									$upSts = 5;
								}else{
									$upSts = 0;
								}
							}

						}
					}

					if($this->sms->update(array('status'=>$upSts,'message'=>$message,'updated_by'=>$this->createdBY,'updated_on'=>date('Y-m-d H:i:s')),array('id'=>$reqID))){
						$insertCount++;
					}

				}
				$this->db->trans_complete();
			}
			if($updateStatus == 2){
				$this->message->set($insertCount.$this->lang->line('sms-request-approved'));
				redirect('sms/rejected');
			}else{
				$this->message->set($insertCount.$this->lang->line('sms-request-rejected'));
				redirect('sms/approved');
			}
		}

		$args = array();
		$args['select'] = array('ds.*','dsl.bill_no','dsl.id as sales_id','concat(uc.fname," ",uc.lname) as client_name','dm.designation_name as user_type');
		$args['conditions'] = array('ds.status'=>1,'dsl.status'=>1);
		$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as uc'=>'ds.user_id=uc.id','designation_master as dm'=>'ds.user_type=dm.id');
		$pending_sms = $this->sms->get_all($args);

		if(empty($pending_sms))
                {
			$this->message->set($this->lang->line('no-new-request-found'),'i');
		}

		$sms_users = $this->sms->sms_user();
		$sms_user = $sms_users[0];
		// print_r($sms_user);
		$username = $sms_user['username'];
		$password = $sms_user['password'];
		$route = $sms_user['sms_type'];
		$balance = $this->sms->sms_balance($username,$password,$route);
		//echo $balance;


		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sms/pending_sms_requests',array('pending_lists'=>$pending_sms,'count'=>$offset+1,'posted_check'=>$postedCheck));
		$this->template->other_script('sms/sms');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();
	}

	#-----------------------------------------------------------------------

	public function approved(){

		$this->template->title('sms');
		$this->template->main_heading($this->lang->line('approved-sms'));
		$this->template->breadcrumb(array($this->lang->line('approved-sms') => 'no_link'));
		$this->load->model('sms/Sms_model','sms');
		$this->load->library('Stock');
		$this->load->library('Targets');
		$offset =0;$links=NULL;
		$this->load->library('Pagination');


		$sms_users = $this->sms->sms_user();
		$sms_user = $sms_users[0];
		//print_r($sms_user);
		$username = $sms_user['username'];
		$password = $sms_user['password'];
		$route = $sms_user['sms_type'];
		$msg_balance = $this->sms->sms_balance($username,$password,$route);
		//echo $msg_balance;

		//$msg_send_status = $this->sms->send('9746600483','hello hello');
		//print_r($msg_send_status);
	//	print_r($msg_send_status);



		#for pagination
		$config['uri_segment'] = 3;
		$config['per_page'] = $this->per_page();

		$args = array();
		$args['select'] = array('ds.id');
		$args['conditions'] = array('ds.status >='=>3);
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->sms->get_all($args);

		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('sms/approved');
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		# /for pagination

		$args = array();
		$args['select'] = array('ds.*','dsl.bill_no','dsl.id as sales_id','ds.status','ds.message','ds.user_id','concat(up.fname," ",up.lname) as updated_by','concat(uc.fname," ",uc.lname) as client_name','p.sms_point','dm.designation_name as user_type','uc.mobile as client_mobile_no','ud.mobile as driver_mobile_no');
		$args['conditions'] = array('ds.status'=>3);
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.updated_by=up.id','users as uc'=>'ds.user_id=uc.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id','users as ud'=>'ds.driver_id=ud.id');
		$pending_sms = $this->sms->get_all($args);
		//echo "<pre>";
		//print_r($pending_sms);

		if(empty($pending_sms)){
			$this->message->set($this->lang->line('empty-approved-list'),'i');
		}
		$this->form_validation->set_rules('request','','xss_clean');
             if(isset($_POST['post_request']))
             {
		if($this->form_validation->run() === true){

			$postedCKs = $this->input->post('request');
			if(empty($postedCKs)){
				$this->message->set($this->lang->line('please-check-request'),'e');
			}else{


				#---------for sms sending check balance msg ------------
				$sms_users = $this->sms->sms_user();
				$sms_user = $sms_users[0];
				//print_r($sms_user);
				$username = $sms_user['username'];
				$password = $sms_user['password'];
				$route = $sms_user['sms_type'];
				$msg_balance = $this->sms->sms_balance($username,$password,$route);
				//echo $msg_balance;


				#---------for sms sending check balance msg ------------



				$this->db->trans_start();
				foreach($postedCKs as $key=>$reqID){
					$pre_sms_point = $pending_sms_point = 0;
                                        echo "<script>alert($reqID);</script>";
         $userid=$this->db->query("select user_id from dms_sms where id='$reqID' ")->result_array();
                                        $uid =$userid[0]['user_id'];
                                        
					$args = array();
					$args['select'] = array('sum(p.sms_point) as sms_point');
					$args['conditions'] = array('ds.status >'=>3,'ds.status <'=>6,'ds.user_id'=>$uid);
					//$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.updated_by=up.id','users as uc'=>'ds.user_id=uc.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id');
					$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.user_id=up.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id');
					$pre_sms_points = $this->sms->get_all($args);
					//print_r($pre_sms_points);
					if(!empty($pre_sms_points)){
						$pre_sms_point = $pre_sms_points[0]['sms_point'];
					} 



/*
 $total =0;
                                        
                   $user_pointss= $this->db->query("select sms_point from user_points where user_id='$uid' ")->result_array();
                   foreach($user_pointss as $point)
                   {
                       $total += $point['sms_point'];
                    }  

 $pre_sms_point = $total;

               */                                  






					$args = array();
					$args['select'] = array('p.targets_id','p.sms_point','up.mobile','up.fname','p.id');
					$args['conditions'] = array('ds.status'=>3,'ds.id'=>$reqID);
					//$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.updated_by=up.id','users as uc'=>'ds.user_id=uc.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id');


					$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.user_id=up.id','users as uc'=>'ds.user_id=uc.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id');
					$pending_sms_points = $this->sms->get_all($args);
					//	print_r($pending_sms_points);
					//die;

					if(!empty($pending_sms_points)){
						$pending_sms_point = $pending_sms_points[0]['sms_point'];
					}
// $user_points = $pre_sms_point+$pending_sms_point;


					
					if($pending_sms_point > 0){
 
                             $user_pointss= $this->db->query("select sms_point  from user_points where user_id='$uid' ")->result_array();                   
$total =0;
foreach($user_pointss as $us)
{
$total += $us['sms_point'];
                                             
}
echo $total;
$user_points=$total;  
                                                 $name=$pending_sms_points[0]['fname'];
                                           
						$message = $this->targets->get_message($pending_sms_points[0]['targets_id'],$pending_sms_point,$user_points,$name);
				
						if($msg_balance > 0 ){

								$user_mobile = $pending_sms_points[0]['mobile'];


							$msg_send_status = $this->sms->send($user_mobile,$message);

							//$msg_send_status = $this->sms->send($user_mobile,$message);

							if($this->sms->update(array('status'=>5,'message'=>$message,'updated_by'=>$this->createdBY,'updated_on'=>date('Y-m-d H:i:s')),array('id'=>$reqID))){
								$insertCount++;
							}


						}

						else{
							if($this->sms->update(array('status'=>4,'message'=>$message,'updated_by'=>$this->createdBY,'updated_on'=>date('Y-m-d H:i:s')),array('id'=>$reqID))){
								$insertCount++;
							}
						}


					}else{
						if($this->sms->update(array('status'=>6,'message'=>'','updated_by'=>$this->createdBY,'updated_on'=>date('Y-m-d H:i:s')),array('id'=>$reqID))){
							$insertCount++;
						}
					}

				}
				$this->db->trans_complete();
				$this->message->set($insertCount.$this->lang->line('sms-request-approved'));
				redirect('sms/approved');
			}
		}
}
else if(isset($_POST['post_reject']))
{
          if($this->form_validation->run() === true)
          {
		$postedCKs = $this->input->post('request');
		if(empty($postedCKs))
                {
			$this->message->set($this->lang->line('please-check-request'),'e');
		}
                else
                {
                        $this->db->trans_start();
			foreach($postedCKs as $key=>$reqID)
                        {
                            $this->sms->update(array('status'=>2,'updated_by'=>$this->createdBY,'updated_on'=>date('Y-m-d H:i:s')),array('id'=>$reqID));
								
			    

                        }

                       
                }
         }
}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sms/approved_sms_requests',array('pending_lists'=>$pending_sms,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script('sms/sms');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();


	}

	#------------------------------------------------------------------------

	public function rejected(){

		$this->template->title('sms');
		$this->template->main_heading($this->lang->line('rejected-sms'));
		$this->template->breadcrumb(array($this->lang->line('rejected-sms') => 'no_link'));

		$this->load->model('sms/Sms_model','sms');
		$offset =0;$links=NULL;
		$this->load->library('Pagination');

		#for pagination
		$config['uri_segment'] = 3;
		$config['per_page'] = $this->per_page();

		$args = array();
		$args['select'] = array('ds.id');
		$args['conditions'] = array('ds.status'=>2);
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->sms->get_all($args);

		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('sms/rejected');
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		# /for pagination

		$args = array();
		$args['select'] = array('ds.*','dsl.bill_no','dsl.id as sales_id','ds.status','ds.message','concat(up.fname," ",up.lname) as updated_by','concat(uc.fname," ",uc.lname) as client_name','dm.designation_name as user_type','uc.mobile as client_mobile_no');
		$args['conditions'] = array('ds.status'=>2);
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.updated_by=up.id','users as uc'=>'ds.user_id=uc.id','designation_master as dm'=>'ds.user_type=dm.id');
		$pending_sms = $this->sms->get_all($args);

		if(empty($pending_sms)){
			$this->message->set($this->lang->line('empty-rejected-list'),'i');
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sms/rejected_sms_requests',array('pending_lists'=>$pending_sms,'count'=>$offset+1,'links'=>$links));
		$this->template->render();

	}

	#------------------------------------------------------------------------

	public function edit_point(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$sms_id = $this->uri->segment(3);
		if($this->if_exists('dms_sms',array('id'=>$sms_id)) === false){
			redirect('sms/approved');
		}
		$this->template->title('sms');
		$this->template->main_heading($this->lang->line('edit-user-points'));
		$this->template->breadcrumb(array($this->lang->line('approved-sms') => 'sms/approved',$this->lang->line('edit-user-points')=>'no_link'));

		$this->load->model('sms/Sms_model','sms');

		$args = array();
		$args['select'] = array('ds.*','dsl.bill_no','dsl.id as sales_id','dsl.bill_date','ds.status','ds.message','concat(up.fname," ",up.lname) as updated_by','concat(uc.fname," ",uc.lname) as client_name','p.id as point_id','p.sms_point','p.actual_point','dm.designation_name as user_type','uc.mobile as client_mobile_no');
		$args['conditions'] = array('ds.id'=>$sms_id,'ds.status'=>3);
		$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.updated_by=up.id','users as uc'=>'ds.user_id=uc.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id');
		$sms_points = $this->sms->get_all($args);
		$act_point = 0;
		if(empty($sms_points)){
			$this->message->set($this->lang->line('empty-approved-list'),'i');
		}else{
			$act_point = $sms_points[0]['actual_point'];
			$point_id = $sms_points[0]['point_id'];
		}
		$this->form_validation->set_rules('sms_point','lang:edited-point','required|numeric');
		if($this->form_validation->run() === true){

			$sms_point = $this->input->post('sms_point');
			if($this->sms->update_point(array('data'=>array('sms_point'=>$sms_point),'conditions'=>array('id'=>$point_id)))){
				$this->message->set($this->lang->line('user-point-updated'),'s');
				redirect('sms/approved');
			}

		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sms/edit_point',array('sms_points'=>$sms_points));
		$this->template->render();

	}

	#--------------------------------------------------------------------------------------------------

	public function pending_sms(){

		$this->template->title('sms');
		$this->template->main_heading($this->lang->line('pending-sms'));
		$this->template->breadcrumb(array($this->lang->line('pending-sms') => 'no_link'));

		$this->load->model('sms/Sms_model','sms');
		$offset =0;$links=NULL;
		$this->load->library('Pagination');

		#for pagination
		$config['uri_segment'] = 3;
		$config['per_page'] = $this->per_page();

		$args = array();
		$args['select'] = array('ds.id');
		$args['conditions'] = array('ds.status'=>4);
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->sms->get_all($args);

		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('sms/pending_sms');
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		# /for pagination

		$args = array();
		$args['select'] = array('ds.*','dsl.bill_no','dsl.id as sales_id','ds.status','ds.message','concat(up.fname," ",up.lname) as updated_by','concat(uc.fname," ",uc.lname) as client_name','p.sms_point','dm.designation_name as user_type','uc.mobile as client_mobile_no','ud.mobile as driver_mobile_no');
		$args['conditions'] = array('ds.status'=>4);
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.updated_by=up.id','users as uc'=>'ds.user_id=uc.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id','users as ud'=>'ds.driver_id=ud.id');
		$pending_sms = $this->sms->get_all($args);

		if(empty($pending_sms)){
			$this->message->set($this->lang->line('empty-pending-sms'),'i');
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sms/pending_sms_list',array('pending_lists'=>$pending_sms,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script('sms/sms');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();
	}

	#-------------------------------------------------------------

	public function history(){

		$this->template->title('sms');
		$this->template->main_heading($this->lang->line('sms-history'));
		$this->template->breadcrumb(array($this->lang->line('sms-history') => 'no_link'));

		$this->load->model('sms/Sms_model','sms');
		$offset =0;$links=NULL;
		$this->load->library('Pagination');

		#for pagination
		$config['uri_segment'] = 3;
		$config['per_page'] = $this->per_page();

		$args = array();
		$args['select'] = array('ds.id');
		$args['conditions'] = array('ds.status'=>5);
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->sms->get_all($args);

		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('sms/history');
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		# /for pagination

		$args = array();
		$args['select'] = array('ds.*','dsl.bill_no','dsl.id as sales_id','ds.status','ds.message','concat(up.fname," ",up.lname) as updated_by','concat(uc.fname," ",uc.lname) as client_name','p.sms_point','dm.designation_name as user_type','uc.mobile as client_mobile_no','ud.mobile as driver_mobile_no');
		$args['conditions'] = array('ds.status'=>5);
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
                $args['order_by']='created_on';
                $args['order']='DESC';
		$args['join'] = array('dms_sales as dsl'=>'ds.bill_ref_no=dsl.group_id','users as up'=>'ds.updated_by=up.id','users as uc'=>'ds.user_id=uc.id','user_points as p'=>'ds.bill_ref_no=p.group_id','designation_master as dm'=>'ds.user_type=dm.id','users as ud'=>'ds.driver_id=ud.id');
		$pending_sms = $this->sms->get_all($args);

		if(empty($pending_sms)){
			$this->message->set($this->lang->line('empty-pending-sms'),'i');
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sms/sms_histroty',array('pending_lists'=>$pending_sms,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script('sms/sms');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();

	}

    public function sending(){
		$this->load->model('sms/Sms_model','sms');
		$this->load->model('customers/Customer_master_model','customer');
		//$customers = $this->customer->get_all(); print_r($customers);
		
		$offset =0;$links=NULL;
		$this->load->library('Pagination');
		
		$curdate = date('Y-m-d H:i:s');

        $sms_users = $this->sms->sms_user();
        $sms_user = $sms_users[0];
		$username = $sms_user['username'];
		$password = $sms_user['password'];
		$route = $sms_user['sms_type'];
		$msg_balance = $this->sms->sms_balance($username,$password,$route);
		
		$branches = $this->db->get_where('branch_master',array('status'=>1))->result_array();
		$templates = $this->db->get_where('dms_sms_templates',array('status'=>1))->result_array();
		
		$branch_id=''; $from_date=$to_date=date('Y-m-d'); $customers=$condition=array();
        if(isset($_POST['btn_get'])){
            $this->form_validation->set_rules('branch','lang:branch','xss_clean');
            $this->form_validation->set_rules('from_date','From Date','xss_clean|valid_date');
		    $this->form_validation->set_rules('to_date','To Date','xss_clean|valid_date');
            if($this->form_validation->run() === true){
                $branch_id = $this->input->post('branch');
                $from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
                $to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
                if($branch_id!=''){
                    $condition['c.branch_id'] = $branch_id;
                }
                if($from_date!='' && $from_date!='0000-00-00'){
                    $condition['b.bill_date >='] = $from_date;
                }
                if($to_date!='' && $to_date!='0000-00-00'){
                    $condition['b.bill_date <='] = $to_date;
                }
                
                $customers = $this->db->select(array('c.*','b.bill_no','bm.branch_name'))->from('customer_master c')->join('dms_booking b','c.id=b.customer_id')->join('branch_master bm','c.branch_id=bm.id')->where($condition)->where(array('c.mobile_no !='=>'','c.status'=>1))->where('LENGTH(c.mobile_no)>=10', null, false)->order_by('c.id')->group_by('b.customer_id')->get()->result_array();
            }
            if(empty($customers)){
                $this->message->set('No Result Found','i');
            }
        }

        if(isset($_POST['btn_send'])){
            $this->form_validation->set_rules('template','Template','required|xss_clean');
            $this->form_validation->set_rules('message','Message','required|xss_clean');
            $this->form_validation->set_rules('request','','xss_clean');
            if($this->form_validation->run() === true){
                $template_id = $this->input->post('template');
                $message = $this->input->post('message');
                $postedCKs = $this->input->post('request');
                if(empty($postedCKs)){
                    $this->message->set($this->lang->line('please-check-request'),'e');
                }else{
                    $this->db->trans_start();
                    if($msg_balance>0){
                        foreach($postedCKs as $key=>$reqID){
                            $customer = $this->db->get_where('customer_master',array('id'=>$reqID))->row_array();
                            if($customer){
                                if($this->sms->send($customer['mobile_no'],$message,$temp_id)){
                                    $this->db->query("insert into customer_sms values('','$customer[fname]','$reqID','$customer[mobile_no]','$message','$curdate')");
                                    $this->message->set($this->lang->line('message-sent'),'e');
                                }else{
                                    $this->message->set($this->lang->line('message-not-sent'),'e');
                                }
                            }
                        }
                    }else{
                        $this->message->set('No Credit Balance Left','e');
                    }
                }
            }  
        }

        $this->template->title('sms');
		$this->template->main_heading($this->lang->line('send-sms'));
		$this->template->breadcrumb(array($this->lang->line('send-sms') => 'no_link'));
        $this->template->slice('dms/message');
		$this->template->slice('sms/sms_send',array('customers'=>$customers,'msg_balance'=>$msg_balance,'templates'=>$templates,'branches'=>$branches,'branch_id'=>$branch_id,'from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->other_script('sms/sms');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();
    }
    
    public function customer(){
		$this->template->title('sms');
		$this->template->main_heading($this->lang->line('customer-sms'));
		$this->template->breadcrumb(array($this->lang->line('customer-sms') => 'no_link'));

		$this->load->model('sms/Sms_model','sms');
		$offset =0;$links=NULL;
		$this->load->library('Pagination');

		#for pagination
		$config['uri_segment'] = 3;
		$config['per_page'] = $this->per_page();


		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('sms/customer');
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		# /for pagination

		$pending_sms = $this->db->query("select * from customer_sms order by created_on DESC")->result_array();

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sms/sms_customer',array('pending_lists'=>$pending_sms,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script('sms/sms');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();

	}

}

?>
