<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Stock_item_register extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();

		$this->load->library(array('Stock','Stock_summary','Accounts'));
	}

	public function index($id = NULL)
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$item_id = $tbp = $redirect_uri = "";$stock_array = array();

		#-------------breadcrumb
		$breadcrumb = array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('item-wise-stock') => 'no_link');

		#------------uri array
		$uri_array = $this->uri->uri_to_assoc(3);

		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('item_id','lang:item','xss_clean|required');
			$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|valid_date');
			$from_date = $this->input->post('from_date',true);
			$this->form_validation->set_rules('to_date','lang:to-date',"xss_clean|required|valid_date|check_date[$from_date.>=]");
			if($this->form_validation->run() === true)
			{
				$item_id = $this->input->post('item_id',true);
				$redirect_uri = "/sid/".$item_id;
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		else
		{
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = $this->session->userdata('from_date');
				$to_date = $this->session->userdata('to_date');

				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));

				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
			if(isset($uri_array['id']) || isset($uri_array['mid']))
			{
				if(isset($uri_array['id'])){
					$item_id = $uri_array['id'];
					$redirect_uri = "/id/".$item_id;
					$breadcrumb[$this->lang->line("go-back")] = "stock_monthly_reports/index/id/".$item_id;
				}
				elseif(isset($uri_array['mid'])){
					$item_id = $uri_array['mid'];
					$redirect_uri = "/mid/".$item_id;
					$breadcrumb[$this->lang->line("go-back")] = "stock_monthly_reports/index/mid/".$item_id;
				}
				if(isset($uri_array['rtype']))
				{
					$tbp = $uri_array['rtype'];
					$redirect_uri .= "/rtype/".$tbp;
					$breadcrumb[$this->lang->line("go-back")] .= "/rtype/".$tbp;
				}
			}
			if(isset($uri_array['sid']))
			{
				$item_id = $uri_array['sid'];
				$redirect_uri = "/sid/".$item_id;
			}
		}

		if(!empty($item_id) && !empty($from_date) && !empty($to_date))
		{
			$pre_from_date = date('Y-m-d',(strtotime($from_date)-86400));
			$pre_to_date = date('Y-m-d',(strtotime($to_date)-86400));

			#-----------starting fiscal year details
			$fiscal_details = $this->dms->get_default();

			#-------------opening stock calculation
			if($fiscal_start_date == $from_date)
			{
				$opening_item_qty = $this->accounts->item_bal_qty($item_id,$fiscal_details['start_date'],$pre_from_date);

				if($opening_item_qty > 0)
				{
					#-----------last closed year details
					$closed_details = $this->accounts->last_closed_yr($fiscal_start_date);

					#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
					$stock_value_type = $this->dms->stock_value_type($closed_details['id']);

					$opening_item_rate = $this->accounts->item_rate($item_id,$closed_details['start_date'],$closed_details['end_date'],0,$stock_value_type);
				}
				else
				{
					#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
					$stock_value_type = $this->dms->stock_value_type();

					$opening_item_qty = $this->stock_summary->item_opening_qty($item_id,$fiscal_start_date);
					$opening_item_rate = $this->stock_summary->item_opening_rate($item_id,$fiscal_start_date);
				}
			}
			else
			{
				#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
				$stock_value_type = $this->dms->stock_value_type();

				$opening_item_qty = $this->accounts->item_bal_qty($item_id,$fiscal_details['start_date'],$pre_from_date);
				$opening_item_rate = $this->accounts->item_rate($item_id,$fiscal_start_date,$pre_to_date,0,$stock_value_type);
			}

			#----------opening value
			$opening_item_value = round_this($opening_item_qty * $opening_item_rate);

			#----------stock distinct dates between selected dates
			//$stock_date_array = $this->stock_summary->stock_dates($item_id,$from_date,$to_date);

			$stock_array = $this->stock_summary->item_register($item_id,$from_date,$to_date,$opening_item_qty);
		}

		#-------------stock item details
		$item_array = $this->stock->get_stock_items();
		$item_array[''] = "Select";
		ksort($item_array);
		
		#-------------template
		$this->template->title('Item Wise Stock Register');
		$this->template->main_heading('Item Wise Stock Register');

		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_search',array('from_date' => $from_date,'to_date' => $to_date,'item_array' => $item_array,'item_id' => $item_id));
		if(!empty($stock_array) || !empty($opening_item_qty))
		{
			#---------item unit name
			$unit = "";
			$unit_details = $this->stock_summary->getItemUnit($item_id);
			if($unit_details){
				$unit = $unit_details['symbol'];
			}

			$this->template->append('stock_summary/stock_item_register',array('opening_item_qty' => $opening_item_qty,'opening_item_value' => $opening_item_value,'unit' => $unit,'stock_array' => $stock_array,'from_date' => $from_date,'to_date'=>$to_date,'item_id'=>$item_id,'redirect_uri' => $redirect_uri));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
	
	public function stock_item(){
	    
	    $from_date = $to_date = $cdate = date('Y-m-d');
		$item_array = array();
		$item_group_id = $skey = "";
        if(isset($_POST['btn_search'])){
		    $this->form_validation->set_rules('item_group_id','lang:item-type','required|xss_clean');
		    $this->form_validation->set_rules('skey','lang:item','required|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			
			if($this->input->post('from_date',true)){
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true){
			    $item_group_id = $this->input->post('item_group_id',true);
			    $skey = $this->input->post('skey',true);
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				
				$item_array = $this->db->query("select * from item_master where item_group_id='$item_group_id' and(item_code like '%$skey%' or item_name like '%$skey%' or model_no like '%$skey%') and status='1'")->result_array();
			}
		}
		
		$this->load->model('products/Item_model','item_obj');
		$item_groups = $this->item_obj->item_group_listing();
		$item_groups[''] = 'Select';
		ksort($item_groups);
		
		$this->template->title('Item Stock');
		$this->template->main_heading('Item Stock');
		$this->template->breadcrumb(array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('branch-stock') => 'no_link'));
		$this->template->slice('stock_summary/stock_item_search',array('item_groups'=>$item_groups,'item_group_id'=>$item_group_id,'skey'=>$skey,'from_date' => $from_date,'to_date' => $to_date,'astatus' => 1));
		if(!empty($item_array)){
			$this->template->append('stock_summary/stock_item',array('item_array' => $item_array,'from_date'=>$from_date,'to_date'=>$to_date));
		    $this->template->slice('dms/modals/more_details');
		    
		}else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}