<?php if(! defined('BASEPATH')) exit('No direct script access alloed');

	class Stock_transfer extends MY_Controller{
		var $company_Id,$branch_Id,$created_By;
		public function __construct(){

			parent ::__construct();
			$this->check_access_right();
			$this->load->model('stocks/Stock_transfer_model','stocktransfer');
			$this->load->model('branches/Branch_model','branch');
			$this->load->library('Stock');

			$this->company_Id = $this->session->userdata('company_id');
			$this->branch_Id = $this->session->userdata('under_id');
			$this->created_By = $this->session->userdata('id');
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete',' pending','approve','approved_transfer');
			fiscal_status($this->uri->segment(2),$method_array,"stock_transfer/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#		

		}
		#---------------------------------------------------
		public function add(){
			$this->load->library('Stock');
			$this->load->model('vouchers/Voucher_model','voucher');
			$temp_stock_items = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.created_by'=>$this->session->userdata('id'),'stk_tr_itm.status'=>-1)));
			$transfer_Id =$this->stocktransfer->get_transfer_id(); $t_date = NULL;

			#loading models and listing functions
			$this->load->model('godown/Godown_model','godown');
			$godown_from = array();
			$godown_from[''] = 'Select';
			ksort($godown_from);
			
			$t_date = cdateFormat(date('Y-m-d'));

			#repopulte value
			if($this->input->post('add_stock') || $this->input->post('save_stock'))
			{
				$transfer_Id = $this->input->post('transfer_no');
				$t_date = cdateFormat($this->input->post('transfer_date'));
			}
			else
			{
				if($this->uri->segment(3) != '')
				{
					$re_pop = $this->uri->uri_to_assoc(3);
					if(!empty($re_pop))
					{
						if(isset($re_pop['transfer_no']))
						{
							$transfer_Id = $re_pop['transfer_no'];	
						}
						if(isset($re_pop['transfer_date']))
						{
							$t_date = cdateFormat($re_pop['transfer_date']);
						}
					}
				}
			}
			
			if($this->input->post('add_stock'))
			{
				$this->form_validation->set_rules('transfer_no','lang:transfer-id','required|trim|xss_clean');
				$this->form_validation->set_rules('transfer_date','lang:date','valid_date|required|xss_clean');
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|callback_check_item[-1]');
				$this->form_validation->set_rules('qty','lang:quantity','required|greater_than[0]|xss_clean');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				//$this->form_validation->set_rules('godown_from_id','lang:godown','required|xss_clean');
				
				if($this->input->post('item_id'))
				{
					$units = $this->stock->get_units($this->input->post('item_id'));
				/*	$godown_from =  $this->stock->get_item_godowns(array('item_id'=>$this->input->post('item_id'),'listing'=>1));
					$godown_from[''] = 'Select';
					ksort($godown_from);*/
				}

				if($this->form_validation->run('add_stock') == TRUE)
				{
					$data = $this->input->post(NULL,TRUE);
					$re_pop['transfer_no'] = $data['transfer_no'];
					$re_pop['transfer_date'] = $data['transfer_date'];
					$transfer_items['item_id'] = $data['item_id'];
					$transfer_items['godown_from_id'] = $this->stock->get_branch_godown($this->branch_Id);//$data['godown_from_id'];
					$transfer_items['qty'] = $data['qty'];
					$transfer_items['unit_id'] = $data['unit_id'];
					$transfer_items['sale_rate'] = $data['sale_rate'];
					$transfer_items['status'] = -1;

					#temperarly saving stock transfer items
					if($this->stocktransfer->f_save('dms_stock_transfer_items',$transfer_items))
					{
						redirect('stock_transfer/add/'.$this->uri->assoc_to_uri(array_filter($re_pop)));
					}
				}
			}
			
			if($this->input->post('save_stock'))
			{
				$this->form_validation->set_rules('transfer_no','lang:transfer-id','required|trim|xss_clean');
				$this->form_validation->set_rules('transfer_date','lang:date','valid_date|required|xss_clean');
				$this->form_validation->set_rules('godown_to_id','lang:transfer-to','required|trim|xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','trim|xss_clean');
				$this->form_validation->set_rules('other_expense','lang:other-expense','trim|xss_clean');
				$this->form_validation->set_rules('narration','lang:narration','trim|xss_clean');

				if($this->form_validation->run('save_stock') == TRUE)
				{
					$data = $this->input->post(NULL,TRUE);
					$transfer_data['branch_id'] = $this->branch_Id;
					$transfer_data['transfer_no'] = $data['transfer_no'];
					$transfer_data['transfer_date'] =  date('Y-m-d',strtotime($data['transfer_date']));
					$transfer_data['godown_to_id'] = $data['godown_to_id'];
					$transfer_data['freight'] = $data['freight'];
					$transfer_data['other_expense'] = $data['other_expense'];
					$transfer_data['narration'] = $data['narration'];
					$transfer_data['group_id'] =$group_id = $this->stock->get_group_id('dms_stock_transfers');
					$transfer_data['st_status'] = 0;
					#checking for godown from id and to id is same 
					$godownCheck = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.created_by'=>$this->session->userdata('id'),'stk_tr_itm.status'=>-1,'stk_tr_itm.godown_from_id'=>$data['godown_to_id'])));

					if(empty($godownCheck))
					{
						#saving stock transfer data 
						if($this->stocktransfer->f_save('dms_stock_transfers',$transfer_data))
						{
							#updating and group id and status of dms_stock_transfer items
							$stock_transfer_id = $this->db->insert_id();
							$flag = 0;
							$branch_godown =  $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
							if(array_key_exists($transfer_data['godown_to_id'],$branch_godown))
							{
								foreach($temp_stock_items as $key=>$temp)
								{
									$this->stocktransfer->my_update('dms_stock_transfer_items',array('group_id'=>$group_id,'status'=>1),array('id'=>$temp['id']));
                                    
                                    $branch_id = $this->session->userdata('under_id');
                                    $godown_id = $this->stock->get_branch_godown($branch_id); 
                                    //$stock_count = $this->stock->get_stock_count($godown_id,$temp['item_id']);
                                    $primary_unit = $this->stock->get_primary_unit($temp['item_id']);
                                    
                                    //$this->stocktransfer->my_update('item_stock',array('qty' => $stock_count),array('branch_id' =>$this->session->userdata('under_id'),'item_id' =>$temp['item_id']));
                                                                        
									#saving dms stocks data for mds stocks 
									$conversion = $this->stock->unit_conversion($temp['item_id'],$temp['unit_id'],$temp['qty']);
									$stock['unit_id'] = $conversion['primary_unit'];
									$stock['qty'] = -$conversion['qty'];
									$stock['company_id'] = $this->company_Id;
									$stock['branch_id'] = $this->branch_Id;
									$stock['item_id'] = $temp['item_id'];
									$stock['stock_date'] = $transfer_data['transfer_date'] ;
									$stock['stock_status'] =10;
									$stock['godown_id'] = $temp['godown_from_id'];
									$stock['table_id'] = $temp['id'];
									$stock['table_group_id'] = $group_id;
									#ssaving stock data minus quantity for godown from id
									$this->stocktransfer->f_save('dms_stocks',$stock);
									
									$stock_count = $this->stock->get_stock_count($temp['godown_from_id'],$temp['item_id']);

									$this->stocktransfer->my_update('item_stock',array('qty' => $stock_count),array('branch_id' =>$this->session->userdata('under_id'),'item_id' =>$temp['item_id']));

									#ssaving stock data plus  quantity fot godown to id
									$branch_to_id = $this->stocktransfer->get_branch($transfer_data['godown_to_id']);
									$stock['branch_id'] = $branch_to_id;
									$stock['godown_id'] = $transfer_data['godown_to_id'];
									$stock['status'] = 1; 
									$stock['qty'] = $conversion['qty'];									
									$this->stocktransfer->f_save('dms_stocks',$stock);
									
									$rate_array = array();
									$rate_array['branch_id'] = $branch_to_id;
									$rate_array['item_id'] = $temp['item_id'];
									$rate_array['rate'] = $temp['rate'];;
									$rate_array['valid_from'] = $transfer_data['transfer_date'] ;
									$rate_array['status'] = 1; 
									$this->stocktransfer->f_save('dms_item_sales_rate',$rate_array);
									
								}
								$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
								$voucher_no = $this->voucher->get_voucher_number($voucher['vtype_id']);
								if(!empty($transfer_data['freight']) && $transfer_data['freight'] > 0)
								{
									#creating payment voucher 
									$voucher['company_id'] = $this->company_Id;
									$voucher['branch_id'] = $this->branch_Id;
									$voucher['group_id'] = $voucher_group_id;
									$voucher['vtype_id'] = 1;
									$voucher['vno'] = $voucher_no;
									$voucher['vorder_no'] =1;
									$voucher['vdate'] = $transfer_data['transfer_date'];
									$voucher['dr_ledger'] = 13;
									$voucher['cr_ledger'] = 1;
									$voucher['vamount'] = $transfer_data['freight'];
									$voucher['narration'] = $transfer_data['narration'];
									$voucher['table_name'] ='dms_stock_transfers';
									$voucher['table_group_id'] = $group_id;
									$this->stocktransfer->f_save('dms_vouchers',$voucher);
								}
								if(!empty($transfer_data['other_expense']) && $transfer_data['other_expense'] > 0)
								{
									#creating payment voucher 
									$voucher['company_id'] = $this->company_Id;
									$voucher['branch_id'] = $this->branch_Id;
									$voucher['group_id'] = $voucher_group_id;
									$voucher['vtype_id'] = 1;
									$voucher['vno'] = $voucher_no;
									$voucher['vorder_no'] =2;
									$voucher['vdate'] = $transfer_data['transfer_date'];
									$voucher['dr_ledger'] = 14;
									$voucher['cr_ledger'] = 1;
									$voucher['vamount'] = $transfer_data['other_expense'];
									$voucher['narration'] = $transfer_data['narration'];
									$voucher['table_name'] ='dms_stock_transfers';
									$voucher['table_group_id'] = $group_id;
									$this->stocktransfer->f_save('dms_vouchers',$voucher);
								}
								$this->stocktransfer->update(array('st_status'=>1,'approved_by'=>$this->created_By,'approved_on'=>date('Y-m-d H:i:s')),array('id'=>$stock_transfer_id));
                            }
							else
							{
								foreach($temp_stock_items as $key=>$temp)
								{
									$this->stocktransfer->my_update('dms_stock_transfer_items',array('group_id'=>$group_id,'status'=>1),array('id'=>$temp['id']));

									#saving dms stocks data for mds stocks 
									$conversion = $this->stock->unit_conversion($temp['item_id'],$temp['unit_id'],$temp['qty']);
									$stock['unit_id'] = $conversion['primary_unit'];
									$stock['qty'] = -$conversion['qty'];
									$stock['company_id'] = $this->company_Id;
									$stock['branch_id'] = $this->branch_Id;
									$stock['item_id'] = $temp['item_id'];
									$stock['stock_date'] = $transfer_data['transfer_date'] ;
									$stock['stock_status'] =10;
									$stock['godown_id'] = $temp['godown_from_id'];
									$stock['table_id'] = $temp['id'];
									$stock['table_group_id'] = $group_id;
									$stock['status'] = -1;
									#ssaving stock data minus quantity for godown from id
									$this->stocktransfer->f_save('dms_stocks',$stock);
									
								    $stock_count = $this->stock->get_stock_count($temp['godown_from_id'],$temp['item_id']);

									$this->stocktransfer->my_update('item_stock',array('qty' => $stock_count),array('branch_id' =>$this->session->userdata('under_id'),'item_id' =>$temp['item_id']));

									#ssaving stock data plus  quantity fot godown to id
									$branch_to_id = $this->stocktransfer->get_branch($transfer_data['godown_to_id']);
									$stock['branch_id'] = $branch_to_id;
									$stock['godown_id'] = $transfer_data['godown_to_id'];
									$stock['status'] = -1; 
									$stock['qty'] = $conversion['qty'];									
									$this->stocktransfer->f_save('dms_stocks',$stock);	
									
									$rate_array = array();
									$rate_array['branch_id'] = $branch_to_id;
									$rate_array['item_id'] = $temp['item_id'];
									if($temp['rate'] == null)
									{
									    $temp['rate'] =0;
									}
									$rate_array['rate'] = $temp['rate'];
									$rate_array['valid_from'] = $transfer_data['transfer_date'] ;
									$rate_array['status'] = 1; 
									$this->stocktransfer->f_save('dms_item_sales_rate',$rate_array);
								}
								$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
								$voucher_no = $this->voucher->get_voucher_number($voucher['vtype_id']);
								if(!empty($transfer_data['freight']) && $transfer_data['freight'] > 0)
								{
									$voucher['company_id'] = $this->company_Id;
									$voucher['branch_id'] = $this->branch_Id;
									$voucher['group_id'] = $voucher_group_id;
									$voucher['vtype_id'] = 2;
									$voucher['vno'] = $voucher_no;
									$voucher['vorder_no'] =1;
									$voucher['vdate'] = $transfer_data['transfer_date'];
									$voucher['dr_ledger'] = 1;
									$voucher['cr_ledger'] = 13;
									$voucher['vamount'] = $transfer_data['freight'];
									$voucher['narration'] = $transfer_data['narration'];
									$voucher['table_name'] ='dms_stock_transfers';
									$voucher['table_group_id'] = $group_id; 
									$this->stocktransfer->f_save('dms_vouchers',$voucher);
								}
								if(!empty($transfer_data['other_expense']) && $transfer_data['other_expense'] > 0)
								{
									#receipt voucher
									$voucher['company_id'] = $this->company_Id;
									$voucher['branch_id'] = $this->branch_Id;
									$voucher['group_id'] = $voucher_group_id;
									$voucher['vtype_id'] = 2;
									$voucher['vno'] = $voucher_no;
									$voucher['vorder_no'] = 2;
									$voucher['vdate'] = $transfer_data['transfer_date'];
									$voucher['dr_ledger'] = 1;
									$voucher['cr_ledger'] = 14;
									$voucher['vamount'] = $transfer_data['other_expense'];
									$voucher['narration'] = $transfer_data['narration'];
									$voucher['table_name'] ='dms_stock_transfers';
									$voucher['table_group_id'] = $group_id; 
									$this->stocktransfer->f_save('dms_vouchers',$voucher);
                                }
							} 

							$this->message->set($this->lang->line('stock-transfer-saved'),'s');
							redirect('stock_transfer/add');
						}
						else
						{
							$this->message->set($this->lang->line('stock-transfer-not-saved'),'e');
							redirect('stock_transfer/add');
						}
					}
					else
					{
						$this->message->set($this->lang->line('godown-are-same'),'e');
					}
				}
			}

			$godown_to = $this->godown->opt_listing();
			$godown_to[''] = 'Select';
			ksort($godown_to);

			$this->load->model('products/Item_model','item');
			//$items = $this->stock->get_stock_items();
			$items=array();
			$items[''] = 'Select';
			ksort($items);

			$units[''] = 'Select';
			ksort($units);
		    //$godowns = $this->stock->get_item_godowns(array('item_id'=>1,'listing'=>1)); print_r($godowns);
			#template
			$this->template->title('Stock Transfer');
			$this->template->main_heading($this->lang->line('stock-transfer'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer') =>'no_link',$this->lang->line('report')=>'stock_transfer/report',$this->lang->line('pending-report') =>'stock_transfer/pending',$this->lang->line('approved-report')=>'stock_transfer/approved_transfer'));
			$this->template->slice('dms/message');
			$this->template->slice('stock_transfer/add',array('godown_from'=>$godown_from,'godown_to'=>$godown_to,'items'=>$items,'units'=>$units,'temp_stock_items'=>$temp_stock_items,'transfer_Id'=>$transfer_Id,'t_date'=>$t_date,'stock_count'=>$stock_count,'primary_unit'=>$primary_unit));
			$this->template->other_script('stocks/stock_adjustment');
			//$this->template->other_script('sales/sales_order');
			$this->template->render();
		}
		
		public function getData() {
            $searchTerm = $this->input->get('q'); // Get the search term from AJAX
            $page = $this->input->get('page'); // Get the page number from AJAX
            $data = $this->stock->fetchProducts($searchTerm, $page);
            
            // Format the response as required by Select2
            $response = array(
                'items' => $data['results'],
                'total_count' => $data['total_count']
            );
            
            echo json_encode($response);
        }
		
		
		#---------------------------------------------------
		public function check_item($item_id,$status){
			$unit_id = $this->input->post('unit_id',TRUE);
			$godown_id = $this->input->post('godown_from_id',TRUE);
			$qty = $this->input->post('qty',TRUE);
			if(!empty($unit_id) && !empty($godown_id) && !empty($qty)){

				$rows = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.item_id'=>$item_id,'stk_tr_itm.qty'=>$qty,'stk_tr_itm.unit_id'=>$unit_id,'stk_tr_itm.godown_from_id'=>$godown_id,'stk_tr_itm.status'=>$status),'numrows'=>TRUE));
				if($rows >0){
					return false;
				}
				return true;
			}
			else{
				return $item_id;
			}
		}
		#-------------------------------------------------------
		public function remove_temp_item(){
			if(!$this->uri->segment(3)){ 
				redirect('users/logout');
			}
			$temp_id= $this->uri->segment(3);
			if($this->if_exists('dms_stock_transfer_items',array('id'=>$temp_id,'created_by'=>$this->created_By,'status'=>-1)) === false){
				echo 'hai'; die;
				redirect('stock_transfer/add');
			}else{
				if($this->stocktransfer->delete_temp(array('status'=>-1,'id'=>$temp_id))){
					$call_ck_uri = $this->uri->uri_to_assoc(4);
					redirect($this->uri->assoc_to_uri($call_ck_uri));
				}
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
			}
			
		}
		#-------------------------------------------------------
		public function edit_temp_item(){
			if(!$this->uri->segment(3)){ 
				redirect('users/logout');
			}
			$temp_id= $this->uri->segment(3);
			$call_bck_uri = $this->uri->uri_to_assoc(4);
			$go_back = $this->uri->assoc_to_uri($call_bck_uri);
			$this->load->library('Stock');
		
			if($this->if_exists('dms_stock_transfer_items',array('id'=>$temp_id,'created_by'=>$this->created_By,'status'=>-1)) === false){
				redirect('stock_transfer/add');
			}
			#get all tempdata
			$tr_temp_item = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.created_by'=>$this->session->userdata('id'),'stk_tr_itm.status'=>-1,'stk_tr_itm.id'=>$temp_id)))[0];
			#validation
			$this->form_validation->set_rules('item_id','lang:item-name',"required|xss_clean|callback_check_temp_item[$temp_id.-1]");
			$this->form_validation->set_rules('qty','lang:quantity','required|greater_than[0]|xss_clean');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('godown_from_id','lang:godown','required|xss_clean');
			if($this->form_validation->run() == TRUE){
				$data = $this->input->post(NULL,TRUE);
				$data['status'] = -1;
				if($this->stocktransfer->my_update('dms_stock_transfer_items',$data,array('id'=>$temp_id))){
						$this->message->set($this->lang->line('stock-transfer-item-updated'),'s');
						redirect($this->uri->assoc_to_uri($call_bck_uri));
				}
				$this->message->set($this->lang->line('stock-transfer-item-not-updated'),'e');
				redirect($this->uri->assoc_to_uri($call_bck_uri));
			}

			#loading models and listing functions
			$this->load->model('godown/Godown_model','godown');
			$godown = $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
			$godown[''] = 'Select';
			ksort($godown);

			$this->load->model('products/Item_model','item');
			$items = $this->item->listing(array('id'=>$tr_temp_item['item_id']));
			ksort($items);

			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();

			if($this->input->post('item_id')){
				$units = $this->stock->get_units($this->input->post('item_id'));
			}
			$units[''] = 'select';
			ksort($units);

			$this->template->title('Stock Transfer Item Update');
			$this->template->main_heading($this->lang->line('stock-transfer-item'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer') =>'stock_transfer/add',$this->lang->line('update')=>'no_link',$this->lang->line('go-back')=>$go_back));
			$this->template->slice('stock_transfer/edit_item',array('godown'=>$godown,'items'=>$items,'units'=>$units,'stock_item'=>$tr_temp_item));
			$this->template->render();

		}
		#------------------------------------------------------------
		public function check_temp_item($item_id,$string){
			$string = explode('.', $string);
			$id = $string[0];
			$status = $string[1];
			$unit_id = $this->input->post('unit_id',TRUE);
			$godown_id = $this->input->post('godown_from_id',TRUE);
			$qty = $this->input->post('qty',TRUE);
			if(!empty($unit_id) && !empty($godown_id) && !empty($qty)){

				$rows = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.item_id'=>$item_id,'stk_tr_itm.qty'=>$qty,'stk_tr_itm.unit_id'=>$unit_id,'stk_tr_itm.godown_from_id'=>$godown_id,'stk_tr_itm.status'=>$status,'stk_tr_itm.id !='=>$id),'numrows'=>TRUE));
				if($rows >0){
					return false;
				}
				return true;
			}
			else{
				return $item_id;
			}
		}
		#------------------------------------------------------------
		public function report(){
			$links = NULL;
			$offset = NULL;
			$stock_transfers = NULL;
			$filter_data = array('from_date'=>'','to_date'=>'','tno'=>'');

			if(isset($_POST['search']) || $this->uri->segment(4) !=''){
				$filter_data = $this->input->post(NULL,TRUE);
				if(isset($_POST['search'])){
					$filter_data = $this->input->post(NULL,TRUE);
				}else{
					$filter_data = $this->uri->uri_to_assoc(3);
				}
				$filter_data = array_filter($filter_data);
				$count = count($filter_data);

				if($count==0){
					$this->message->set($this->lang->line('use-one-search'),'e');
				}else{
					if(isset($_POST['search'])){
						if(isset($filter_data['from_date']) && $filter_data['from_date'] != ''){
							$this->form_validation->set_rules('from_date','lang:date','valid_date');
						}
						if(isset($filter_data['to_date']) && $filter_data['to_date'] != ''){
							$this->form_validation->set_rules('to_date','lang:date','valid_date');
						}
						if(isset($filter_data['tno']) && $filter_data['tno'] != ''){
							$this->form_validation->set_rules('tno','lang:transfer-id','xss_clean');
						}
					}
					if($this->form_validation->run() == TRUE || $this->uri->segment(3)){
						if(isset($filter_data['from_date']) && $filter_data['from_date']!=''){
							$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
							$conditions['stk_trs.transfer_date >='] = $from_date;
							$filter_data['from_date'] = $from_date;
						}
						if(isset($filter_data['to_date']) && $filter_data['to_date']!=''){
							$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
							$conditions['stk_trs.transfer_date <='] = $to_date;
							$filter_data['to_date'] = $to_date;
						}
						if(isset($filter_data['tno']) && $filter_data['tno']!=''){
						    $tno = $filter_data['tno'];
							$conditions['stk_trs.transfer_no'] = $tno;
							$filter_data['tno'] = $tno;
						}
						if(!empty($from_date) && !empty($to_date)){
							$conditions['stk_trs.transfer_date >='] = $from_date;
							$conditions['stk_trs.transfer_date <='] = $to_date;
						}
					}
				}
				#set dummy filter data again for the unset values
				if(!isset($filter_data['from_date'])){ $filter_data['from_date'] = ''; }else{$filter_data['from_date'] = cdateFormat($filter_data['from_date']);}
				if(!isset($filter_data['to_date'])){ $filter_data['to_date'] = ''; }else{$filter_data['to_date'] = cdateFormat($filter_data['to_date']);}
			}
			if($this->session->userdata('id') !='-2' && $this->session->userdata('id') !='-1'){
			    $conditions['stk_trs.created_by'] = $this->session->userdata('id');
			}
			
			$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->stocktransfer->get_all_stock_transfer(array('numrows'=>TRUE,'conditions'=>$conditions));
   	 		if($config['total_rows']==0){
   	 			$this->message->set($this->lang->line('no-result-found'),'i');
   	 		}
   	 		$config['base_url'] = base_url('stock_transfer/report').'/'.$this->uri->assoc_to_uri(array_filter($filter_data));
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = count(array_filter($filter_data))*2+3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';	
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);
   	 		$stock_transfers = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>$conditions,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
			
			$this->template->title('Stock Transfer Reports');
			$this->template->main_heading($this->lang->line('stock-transfer'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer')=>'stock_transfer/add',$this->lang->line('report')=>'no_link',$this->lang->line('pending-report') =>'stock_transfer/pending',$this->lang->line('approved-report')=>'stock_transfer/approved_transfer'));
			$this->template->slice('dms/message');
			$this->template->slice('stock_transfer/select_search',array('offset'=>$offset,'links'=>$links,'stock_transfers'=>$stock_transfers,'data'=>$filter_data));
			$this->template->other_script('stocks/stock_transfer');
			$this->template->slice('dms/modals/more_details');
			$this->template->render();
		}
		#-------------------------------------------------------------
		public function update($id){
			$stock_transfer_id = $id;
			if(empty($stock_transfer_id)){redirect('stock_transfer/report');}
			if($this->if_exists('dms_stock_transfers',array('id'=>$stock_transfer_id,'status'=>1)) === false){
				redirect('stock_transfer/report');
			}
			$call_bck_uri = $this->uri->uri_to_assoc(4);
			$go_back = $this->uri->assoc_to_uri($call_bck_uri);

			$this->load->library('Stock');
			$this->load->model('vouchers/Voucher_model','voucher');
			$godown_from = array();
			$godown_from[''] = 'Select';
			ksort($godown_from);
			#get stock transfer details
			$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.id'=>$stock_transfer_id)))[0];
			$transfer_Id = $stock_transfer['transfer_no']; $t_date =  $stock_transfer['transfer_date'];
			$transfer_group_id = $stock_transfer['group_id'];
			#get stocktransfer item details;
			$stock_transfer_items = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.group_id'=>$transfer_group_id,'stk_tr_itm.status'=>1)));
			#loading models and listing functions
			$this->load->model('godown/Godown_model','godown');
			$godown_from = $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
			$godown_from[''] = 'Select';
			ksort($godown_from);
			if($this->input->post('add_stock') || $this->input->post('update_stock')){
				$transfer_Id = $this->input->post('transfer_no');
				$t_date = cdateFormat($this->input->post('transfer_date'));
			}
			else{
				

				if($this->uri->segment(3) != ''){

					$re_pop = $this->uri->uri_to_assoc(3);
					if(!empty($re_pop)){
						if(isset($re_pop['transfer_no'])){

							$transfer_Id = $re_pop['transfer_no'];	
						}
						if(isset($re_pop['transfer_date'])){
							$t_date = cdateFormat($re_pop['transfer_date']);
						}
						

					}
				}
			}
			if($this->input->post('add_stock')){
				$this->form_validation->set_rules('transfer_no','lang:transfer-id','required|trim|xss_clean');
				$this->form_validation->set_rules('transfer_date','lang:date','valid_date|required|xss_clean');
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|callback_check_item[1]');
				$this->form_validation->set_rules('qty','lang:quantity','required|greater_than[0]|xss_clean');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('godown_from_id','lang:godown','required|xss_clean');
				
				if($this->input->post('item_id')){
					$units = $this->stock->get_units($this->input->post('item_id'));
					$godown_from =  $this->stock->get_item_godowns(array('item_id'=>$this->input->post('item_id'),'listing'=>1));
					$godown_from[''] = 'Select';
					ksort($godown_from);
				}

				if($this->form_validation->run('add_stock') == TRUE){
					$data = $this->input->post(NULL,TRUE);
					$re_pop['transfer_no'] = $data['transfer_no'];
					$re_pop['transfer_date'] = $data['transfer_date'];
					$transfer_date = date('Y-m-d',strtotime($data['transfer_date']));
					$godown_to_id = $data['godown_to_id'];
					$transfer_item['group_id'] = $transfer_group_id;
					$transfer_item['item_id'] = $data['item_id'];
					$transfer_item['godown_from_id'] = $data['godown_from_id'];
					$transfer_item['qty'] = $data['qty'];
					$transfer_item['unit_id'] = $data['unit_id'];
					$transfer_item['status'] = 1;

					if($godown_to_id != $transfer_item['godown_from_id']){
						#temperarly saving stock transfer items
						if($this->stocktransfer->f_save('dms_stock_transfer_items',$transfer_item)){
							$transfer_item_id = $this->db->insert_id();
							#saving dms stocks data for mds stocks 
							$conversion = $this->stock->unit_conversion($transfer_item['item_id'],$transfer_item['unit_id'],$transfer_item['qty']);
							$stock['unit_id'] = $conversion['primary_unit'];
							$stock['qty'] = -$conversion['qty'];
							$stock['item_id'] = $transfer_item['item_id'];
							$stock['company_id'] = $this->company_Id;
							$stock['branch_id'] = $this->branch_Id;
							$stock['stock_date'] = $transfer_date ;
							$stock['stock_status'] =10;
							$stock['godown_id'] = $transfer_item['godown_from_id'];
							$stock['table_id'] = $transfer_item_id;
							$stock['table_group_id'] = $transfer_group_id;
							#ssaving stock data minus quantity for godown from id
							$this->stocktransfer->f_save('dms_stocks',$stock);
							$stock['status'] = -1; 
							#ssaving stock data plus  quantity fot godown to id
							$branch_to_id = $this->stocktransfer->get_branch($godown_to_id);
							$stock['branch_id'] = $branch_to_id;
							$stock['godown_id'] = $godown_to_id;
							$stock['qty'] = $conversion['qty'];							
							$this->stocktransfer->f_save('dms_stocks',$stock);
							
						    $stock_count = $this->stock->get_stock_count($transfer_item['godown_from_id'],$transfer_item['item_id']);
						    
						    $this->purchase_obj->update_others(array('table' => 'item_stock','data' => array('qty' => $stock_count),'conditions' => array('branch_id' => $this->session->userdata('under_id'),'item_id' => $transfer_item['item_id'])));
						
							
							
							
							redirect('stock_transfer/update/'.$stock_transfer_id.'/'.$this->uri->assoc_to_uri(array_filter($re_pop)));
						}

					}
					else{
						$this->message->set('godwon from_id godown_to_id are same ','e');
					}
				}
				
			}
			if($this->input->post('update_stock')){
				$this->form_validation->set_rules('transfer_no','lang:transfer-id','required|trim|xss_clean');
				$this->form_validation->set_rules('transfer_date','lang:date','valid_date|required|xss_clean');
				$this->form_validation->set_rules('godown_to_id','lang:transfer-to','required|trim|xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','trim|xss_clean');
				$this->form_validation->set_rules('other_expense','lang:other-expense','trim|xss_clean');
				$this->form_validation->set_rules('narration','lang:narration','trim|xss_clean');

				if($this->form_validation->run('update_stock') == TRUE){
					$data = $this->input->post(NULL,TRUE);
					
					$transfer_data['transfer_no'] = $data['transfer_no'];
					$transfer_data['transfer_date'] =  date('Y-m-d',strtotime($data['transfer_date']));
					$transfer_data['godown_to_id'] = $data['godown_to_id'];
					$transfer_data['freight'] = $data['freight'];
					$transfer_data['other_expense'] = $data['other_expense'];
					$transfer_data['narration'] = $data['narration'];
					$transfer_data['st_status'] = 0;
					#checking for godown from id and to id is same 
					$godownCheck = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.group_id'=>$transfer_group_id,'stk_tr_itm.status'=>1,'stk_tr_itm.godown_from_id'=>$data['godown_to_id'])));
					if(empty($godownCheck)){
						#updatoing stock transfer data 
						if($this->stocktransfer->my_update('dms_stock_transfers',$transfer_data,array('id'=>$stock_transfer_id))){

							#update dms stock stock date 
							$this->stocktransfer->my_update('dms_vouchers',array('stock_date'=>$transfer_data['transfer_date']),array('table_group_id'=>$transfer_group_id,'stock_status'=>10));
							#updating voucher for freight and other expense
							$branch_godown =  $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
							if(!empty($transfer_data['freight']) && $transfer_data['freight']>0){
								#get voucher details 
								$voucher_details = $this->stocktransfer->get_vouchers(array('table_group_id'=>$transfer_group_id,'vorder_no'=>1));
								if(!empty($voucher_details)){

									if(array_key_exists($transfer_data['godown_to_id'],$branch_godown)){
										if($voucher_details['vtype_id'] != 1){
											$voucher['vtype_id'] = 1;
											$voucher['dr_ledger'] = 13;
											$voucher['cr_ledger'] = 1;
										}
										#creating payment voucher 
										$voucher['vdate'] = $transfer_data['transfer_date'];
										$voucher['vamount'] = $transfer_data['freight'];
										$voucher['narration'] = $transfer_data['narration'];
										
										$this->stocktransfer->my_update('dms_vouchers',$voucher,array('table_group_id'=>$transfer_group_id,'vorder_no'=>1,'table_name'=>'dms_stock_transfers'));
									}
									else{
										#receipt voucher
										if($voucher_details['vtype_id'] != 2){
											$voucher['vtype_id'] = 2;
											$voucher['dr_ledger'] = 1;
											$voucher['cr_ledger'] = 13;
										}
										
										$voucher['vdate'] = $transfer_data['transfer_date'];			
										$voucher['vamount'] = $transfer_data['freight'];
										$voucher['narration'] = $transfer_data['narration'];
										$this->stocktransfer->my_update('dms_vouchers',$voucher,array('table_group_id'=>$transfer_group_id,'vorder_no'=>1,'table_name'=>'dms_stock_transfers'));
									}

								}
								else{

									if(array_key_exists($transfer_data['godown_to_id'],$branch_godown)){
										#creating payment voucher 
										$voucher['company_id'] = $this->company_Id;
										$voucher['branch_id'] = $this->branch_Id;
										$voucher['group_id'] = $this->stock->get_group_id('dms_vouchers');
										$voucher['vtype_id'] = 1;
										$voucher['vno'] = $this->voucher->get_voucher_number($voucher['vtype_id']);
										$voucher['vorder_no'] =1;
										$voucher['vdate'] = $transfer_data['transfer_date'];
										$voucher['dr_ledger'] = 13;
										$voucher['cr_ledger'] = 1;
										$voucher['vamount'] = $transfer_data['freight'];
										$voucher['narration'] = $transfer_data['narration'];
										$voucher['table_name'] ='dms_stock_transfers';
										$voucher['table_group_id'] = $transfer_group_id;
										$this->stocktransfer->f_save('dms_vouchers',$voucher);
									}else{
										#receipt voucher
										$voucher['company_id'] = $this->company_Id;
										$voucher['branch_id'] = $this->branch_Id;
										$voucher['group_id'] = $this->stock->get_group_id('dms_vouchers');
										$voucher['vtype_id'] = 2;
										$voucher['vno'] = $this->voucher->get_voucher_number($voucher['vtype_id']);
										$voucher['vorder_no'] =1;
										$voucher['vdate'] = $transfer_data['transfer_date'];
										$voucher['dr_ledger'] = 1;
										$voucher['cr_ledger'] = 13;
										$voucher['vamount'] = $transfer_data['freight'];
										$voucher['narration'] = $transfer_data['narration'];
										$voucher['table_name'] ='dms_stock_transfers';
										$voucher['table_group_id'] = $transfer_group_id; 
										$this->stocktransfer->f_save('dms_vouchers',$voucher);
									}
								}
							}
							else{
								$this->stocktransfer->my_update('dms_vouchers',array('status'=>0),array('table_group_id'=>$transfer_group_id,'vorder_no'=>1,'table_name'=>'dms_stock_transfers'));
							}
							if(!empty($transfer_data['other_expense']) && $transfer_data['other_expense']>0){
								#get voucher details 
								$voucher_details = $this->stocktransfer->get_vouchers(array('table_group_id'=>$transfer_group_id,'vorder_no'=>2));
						
								if(!empty($voucher_details)){
									if(array_key_exists($transfer_data['godown_to_id'],$branch_godown)){
										if($voucher_details['vtype_id'] != 1){
											$voucher['vtype_id'] = 1;
											$voucher['dr_ledger'] = 14;
											$voucher['cr_ledger'] = 1;
										}
										#creating payment voucher 
										$voucher['vdate'] = $transfer_data['transfer_date'];
										$voucher['vamount'] = $transfer_data['other_expense'];
										$voucher['narration'] = $transfer_data['narration'];

										
										$this->stocktransfer->my_update('dms_vouchers',$voucher,array('table_group_id'=>$transfer_group_id,'vorder_no'=>2,'table_name'=>'dms_stock_transfers'));
									}else{
										#receipt voucher
										if($voucher_details['vtype_id'] != 2){
											$voucher['vtype_id'] = 2;
											$voucher['dr_ledger'] = 1;
											$voucher['cr_ledger'] = 14;
										}
										
										$voucher['vdate'] = $transfer_data['transfer_date'];									
										$voucher['vamount'] = $transfer_data['other_expense'];
										$voucher['narration'] = $transfer_data['narration'];
						
										$this->stocktransfer->my_update('dms_vouchers',$voucher,array('table_group_id'=>$transfer_group_id,'vorder_no'=>2,'table_name'=>'dms_stock_transfers'));
									}
								}
								else{
									$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
									$voucher_no = $this->voucher->get_voucher_number($voucher['vtype_id']);
									if(array_key_exists($transfer_data['godown_to_id'],$godown_from)){
										#creating payment voucher 
										$voucher['company_id'] = $this->company_Id;
										$voucher['branch_id'] = $this->branch_Id;
										$voucher['group_id'] = $voucher_group_id;
										$voucher['vtype_id'] = 1;
										$voucher['vno'] = $voucher_no;
										$voucher['vorder_no'] =2;
										$voucher['vdate'] = $transfer_data['transfer_date'];
										$voucher['dr_ledger'] = 14;
										$voucher['cr_ledger'] = 1;
										$voucher['vamount'] = $transfer_data['other_expense'];
										$voucher['narration'] = $transfer_data['narration'];
										$voucher['table_name'] ='dms_stock_transfers';
										$voucher['table_group_id'] = $transfer_group_id;
										$this->stocktransfer->f_save('dms_vouchers',$voucher);
									}
									else{
										#receipt voucher
										$voucher['company_id'] = $this->company_Id;
										$voucher['branch_id'] = $this->branch_Id;
										$voucher['group_id'] = $voucher_group_id;
										$voucher['vtype_id'] = 2;
										$voucher['vno'] = $voucher_no;
										$voucher['vorder_no'] = 2;
										$voucher['vdate'] = $transfer_data['transfer_date'];
										$voucher['dr_ledger'] = 1;
										$voucher['cr_ledger'] = 14;
										$voucher['vamount'] = $transfer_data['other_expense'];
										$voucher['narration'] = $transfer_data['narration'];
										$voucher['table_name'] ='dms_stock_transfers';
										$voucher['table_group_id'] = $transfer_group_id; 
										$this->stocktransfer->f_save('dms_vouchers',$voucher);
									}
								}

							}
							else{
								$this->stocktransfer->my_update('dms_vouchers',array('status'=>0),array('table_group_id'=>$transfer_group_id,'vorder_no'=>2,'table_name'=>'dms_stock_transfers'));
							}
							
							
							if(array_key_exists($transfer_data['godown_to_id'],$godown_from)){

								$this->stocktransfer->my_update('dms_stock_transfers',array('st_status'=>1),array('id'=>$stock_transfer_id));
								foreach ($stock_transfer_items as $key=>$stock) {

									if($stock['qty']!= -$stock['qty']){
										$branch_to_id = $this->stocktransfer->get_branch($transfer_data['godown_to_id']);
										$this->stocktransfer->my_update('dms_stocks',array('branch_id' => $branch_to_id,'godown_id'=>$transfer_data['godown_to_id'],'stock_date'=>$transfer_data['transfer_date'],'status'=>1),array('table_id'=>$stock['id'],'stock_status'=>10,'qty'=>$stock['qty']));

									}
									$this->stocktransfer->my_update('dms_stocks',array('stock_date'=>$transfer_data['transfer_date'],'status'=>1),array('table_id'=>$stock['id'],'stock_status'=>10));
								}
								$this->message->set($this->lang->line('stock-transfer-updated'),'s');
								redirect('stock_transfer/update/'.$stock_transfer_id);

							}else{
								foreach ($stock_transfer_items as $key=>$stock) {
									if($stock['qty']!= -$stock['qty']){
										$branch_to_id = $this->stocktransfer->get_branch($transfer_data['godown_to_id']);
										$this->stocktransfer->my_update('dms_stocks',array('branch_id' => $branch_to_id,'godown_id'=>$transfer_data['godown_to_id'],'stock_date'=>$transfer_data['transfer_date']),array('table_id'=>$stock['id'],'stock_status'=>10,'qty'=>$stock['qty']));

									}
									$this->stocktransfer->my_update('dms_stocks',array('stock_date'=>$transfer_data['transfer_date']),array('table_id'=>$stock['id'],'stock_status'=>10));
								}
								$this->message->set($this->lang->line('stock-transfer-updated'),'s');
								redirect('stock_transfer/update/'.$stock_transfer_id);
							}
							$this->message->set($this->lang->line('stock-transfer-not-updated'),'e');
								redirect('stock_transfer/update/'.$stock_transfer_id);
						}
					}else{
						$this->message->set($this->lang->line('godown-are-same'),'e');
					}
					
				}
			}
			#loading models and listing functions
			$this->load->model('godown/Godown_model','godown');
			$godown_to = $this->godown->opt_listing();
			$godown_to[''] = 'Select';
			ksort($godown_to);

			$this->load->model('products/Item_model','item');
			$items = $this->stock->get_stock_items();
			$items[''] = 'Select';
			ksort($items);
			
			$units[''] = 'select';
			ksort($units);

			#template
			$this->template->title('Stock Transfer Update');
			$this->template->main_heading($this->lang->line('stock-transfer'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer')=>'stock_transfer/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'stock_transfer/report'));
			$this->template->slice('dms/message');
			$this->template->slice('stock_transfer/update',array('godown_from'=>$godown_from,'godown_to'=>$godown_to,'items'=>$items,'units'=>$units,'stock_transfer_items'=>$stock_transfer_items,'transfer_Id'=>$transfer_Id,'t_date'=>$t_date,'stock_transfer'=>$stock_transfer));
			$this->template->other_script('stocks/stock_adjustment');
			$this->template->render();
		}
		#-------------------------------------------------------------
		public function edit_item(){
			if(!$this->uri->segment(3)){ 
				redirect('users/logout');
			}
			$stktfr_item_id= $this->uri->segment(3);
			$call_bck_uri = $this->uri->uri_to_assoc(4);
			$go_back = $this->uri->assoc_to_uri($call_bck_uri);
			$this->load->library('Stock');
		
			if($this->if_exists('dms_stock_transfer_items',array('id'=>$stktfr_item_id,'status'=>1)) === false){
				redirect($go_back);
			}
			#get all tempdata
			$stktfr_item = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.status'=>1,'stk_tr_itm.id'=>$stktfr_item_id)))[0];
			$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.group_id'=>$stktfr_item['group_id'])))[0];
			$godown_to_id = $stock_transfer['godown_to_id'];
			#get st
			#validation
			$this->form_validation->set_rules('item_id','lang:item-name',"required|xss_clean|callback_check_temp_item[$stktfr_item_id.1]");
			$this->form_validation->set_rules('qty','lang:quantity','required|greater_than[0]|xss_clean');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('godown_from_id','lang:godown','required|xss_clean');
			if($this->form_validation->run() == TRUE){
				$data = $this->input->post(NULL,TRUE);
				$data['status'] = 1;
				if($this->stocktransfer->my_update('dms_stock_transfer_items',$data,array('id'=>$stktfr_item_id))){
						#update dms stocks value.
						$conversion = $this->stock->unit_conversion($data['item_id'],$data['unit_id'],$data['qty']);
						$stock['unit_id'] = $conversion['primary_unit'];
						$stock['qty'] = -$conversion['qty'];
						$stock['item_id'] = $data['item_id'];
						$stock['godown_id'] = $data['godown_from_id'];
						#ssaving stock data minus quantity for godown from id
						$this->stocktransfer->my_update('dms_stocks',$stock,array('table_id'=>$stktfr_item_id,'godown_id'=>$stktfr_item['godown_from_id'],'stock_status'=>10));
						$branch_to_id = $this->stocktransfer->get_branch($godown_to_id);
						$stock['branch_id'] = $branch_to_id;
						$stock['godown_id'] = $godown_to_id;
						$stock['qty'] = $conversion['qty'];						
						$this->stocktransfer->my_update('dms_stocks',$stock,array('table_id'=>$stktfr_item_id,'godown_id'=>$godown_to_id,'stock_status'=>10));


						$this->message->set($this->lang->line('stock-transfer-item-updated'),'s');
						redirect($this->uri->assoc_to_uri($call_bck_uri));
				}
				$this->message->set($this->lang->line('stock-transfer-item-not-updated'),'e');
				redirect($this->uri->assoc_to_uri($call_bck_uri));
			}

			#loading models and listing functions
			$this->load->model('godown/Godown_model','godown');
			$godown = $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
			$godown[''] = 'Select';
			ksort($godown);

			$this->load->model('products/Item_model','item');
			$items = $this->item->listing(array('id'=>$stktfr_item['item_id']));
			ksort($items);
			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();

			if($this->input->post('item_id')){
				$units = $this->stock->get_units($this->input->post('item_id'));
			}
			$units[''] = 'select';
			ksort($units);

			$this->template->title('Stock Transfer Item Update');
			$this->template->main_heading($this->lang->line('stock-transfer-item'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer') =>'stock_transfer/add',$this->lang->line('update')=>'no_link',$this->lang->line('go-back')=>$go_back));
			$this->template->slice('stock_transfer/edit_item',array('godown'=>$godown,'items'=>$items,'units'=>$units,'stock_item'=>$stktfr_item));
			$this->template->render();

		}
		#-------------------------------------------------------------
		public function remove_item(){
			if(!$this->uri->segment(3)){ 
				redirect('users/logout');
			}
			$stktfr_item_id= $this->uri->segment(3);
			$call_ck_uri = $this->uri->uri_to_assoc(4);
			$go_back = $this->uri->assoc_to_uri($call_ck_uri);
			//echo $temp_id;die;
		
			if($this->if_exists('dms_stock_transfer_items',array('id'=>$stktfr_item_id,'status'=>1))=== false){
				//echo 'hai'; die;
				redirect($go_back );
			}else{
				//echo 'haiii';die;
				if($this->stocktransfer->my_update('dms_stock_transfer_items',array('status'=>0),array('id'=>$stktfr_item_id))){

					$this->stocktransfer->my_update('dms_stocks',array('status'=>0),array('table_id'=>$stktfr_item_id,'stock_status'=>10));
					$this->message->set($this->lang->line('stock-transfer-item-deleted'),'s');
					redirect($go_back);
				}
				$this->message->set($this->lang->line('stock-transfer-item-not-deleted'),'e');
				redirect($go_back);
			}
			
		}
		#-------------------------------------------------------------
		public function delete(){

			$stock_transfer_id = $this->uri->segment(3);
			$call_ck_uri = $this->uri->uri_to_assoc(4);
			$go_back = $this->uri->assoc_to_uri($call_ck_uri);
		
			if(empty($stock_transfer_id)){redirect('stock_transfer/report');}
			if($this->if_exists('dms_stock_transfers',array('id'=>$stock_transfer_id,'status'=>1)) === false){
				redirect('stock_transfer/report');
			}
			#get stock transfer details
			$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.id'=>$stock_transfer_id)))[0];
			$transfer_Id = $stock_transfer['transfer_no']; $t_date =  $stock_transfer['transfer_date'];
			$transfer_group_id = $stock_transfer['group_id'];
			#get stocktransfer item details;
			$stock_transfer_items = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.group_id'=>$transfer_group_id,'stk_tr_itm.status'=>1)));
			if(!empty($stock_transfer)){
				#update stock transfer 
				if($this->stocktransfer->my_update('dms_stock_transfers',array('status'=>0),array('id'=>$stock_transfer_id))){
					#update stock transfer items
					$this->stocktransfer->my_update('dms_stock_transfer_items',array('status'=>0),array('group_id'=>$transfer_group_id));
					foreach ($stock_transfer_items as $key=>$stock){
						$this->stocktransfer->my_update('dms_stocks',array('status'=>0),array('table_id'=>$stock['id'],'stock_status'=>10));
					}
					$this->stocktransfer->my_update('dms_vouchers',array('status'=>0),array('table_group_id'=>$transfer_group_id,'table_name'=>'dms_stock_transfers'));
					$this->message->set($this->lang->line('stock-transfer-deleted'),'s');
				}
				else{
					$this->message->set($this->lang->line('stock-transfer-not-deleted'),'e');
				}
				redirect($go_back);
			}
			redirect($go_back);
		}
		#-------------------------------------------------------------
		public function pending(){

			$this->load->model('godown/Godown_model','godown');
			$this->load->model('stocks/Stock_transfer_model','stocktransfer');
			$branchID = $this->session->userdata('under_id');
			$this->load->model('branches/Branch_model','branch');
			$godowns = $this->godown->listing(array('conditions'=>array('branch_id'=>$branchID)));
			$goDownIDs = array_keys($godowns);
			#update seenstatus
			$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.st_status'=>0,'stk_trs.branch_id !='=>$this->branch_Id),'togodown'=>$goDownIDs,'numrows'=>1));
   	 	
   	 		if($config['total_rows']==0){
   	 			$this->message->set($this->lang->line('no-result-found'),'i');
   	 		}
   	 		$config['base_url'] = base_url('stock_transfer/pending_request');
   	 		//$config['per_page'] = $this->per_page();
   	 		$config['per_page'] =20;
   	 		$config['uri_segment'] =3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';	
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);
   	 		
			$stock_transfers = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.st_status'=>0,'stk_trs.branch_id !='=>$this->branch_Id),'togodown'=>$goDownIDs,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
			#updating stock  seen status
			foreach ($stock_transfers as $key =>$stock) {
				if($stock['seen_status'] == 0){
					$this->db->update('dms_stock_transfers',array('seen_status'=>1),array('id'=>$stock['id']));
				}
			}
			if(!empty($stock_transfers)){
				$this->template->append('stock_transfer/pending_report',array('offset'=>$offset,'links'=>$links,'stock_transfers'=>$stock_transfers));
			}
			$this->template->title('Pending Stock Transfer Report');
			$this->template->main_heading($this->lang->line('pending-stock-transfer-report'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer')=>'stock_transfer/add',$this->lang->line('report')=>'stock_transfer/report',$this->lang->line('pending-report')=>'no_link',$this->lang->line('approved-report')=>'stock_transfer/approved_transfer'));
			$this->template->slice('dms/message');
			$this->template->render();
		}
		#-------------------------------------------------------------
		public function approve($id){
			$stock_transfer_id = $id;
			if(empty($stock_transfer_id)){redirect('stock_transfer/report');}
			if($this->if_exists('dms_stock_transfers',array('id'=>$stock_transfer_id,'status'=>1)) === false){
			//echo 'hai'; die;
				redirect('stock_transfer/report');
			}
			$call_bck_uri = $this->uri->uri_to_assoc(4);
			$go_back = $this->uri->assoc_to_uri($call_bck_uri);

			$this->load->library('Stock');
			$this->load->model('vouchers/Voucher_model','voucher');
			$this->load->model('godown/Godown_model','godown');
			#get stock transfer details
			$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.id'=>$stock_transfer_id)))[0];
			$transfer_Id = $stock_transfer['transfer_no']; $t_date =  $stock_transfer['transfer_date'];
			$transfer_group_id = $stock_transfer['group_id'];
			#get stocktransfer item details;
			$stock_transfer_items = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.group_id'=>$transfer_group_id,'stk_tr_itm.status'=>1)));
			
			$godown_to = $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
			ksort($godown_to);

			$this->form_validation->set_rules('freight','lang:freight','trim|xss_clean');
			$this->form_validation->set_rules('other_expense','lang:other-expense','trim|xss_clean');
			$this->form_validation->set_rules('narration','lang:narration','trim|xss_clean');
			$this->form_validation->set_rules('vdate','lang:date','trim|xss_clean');
			$this->form_validation->set_rules('st_status','lang:status','required|xss_clean');
			$this->form_validation->set_rules('approved_remarks','lang:remarks','trim|xss_clean');

			if($this->input->post(NULL,TRUE)){
				if($this->input->post('freight') > 0 || $this->input->post('other_expense') > 0){
					$this->form_validation->set_rules('vdate','lang:date','required|valid_date|trim|xss_clean');
				}
			}
			
			if($this->form_validation->run() == TRUE){
				$data = $this->input->post(NULL,TRUE);
				$stocks = $this->input->post('stock',TRUE);
				$update_transfer['st_status'] = $data['st_status'];
				$update_transfer['approved_remarks'] = $data['approved_remarks'];
				$update_transfer['approved_by'] = $this->created_By;
				$update_transfer['approved_on'] = date('Y-m-d H:i:s'); 
				#update stock transfer status approved
				if($this->stocktransfer->update($update_transfer,array('id'=>$stock_transfer_id))){
				    if($data['st_status']=='1'){ $st=1; }else{ $st=0; }
					foreach ($stocks as $stock_key=>$stock) {
					    $this->stocktransfer->my_update('dms_stocks',array('status'=>$st),array('table_id'=>$stock_key,'stock_status'=>10,'status'=>-1));
                        $branch_to_id = $this->stocktransfer->get_branch($stock['godown_to_id']);
						$this->stocktransfer->my_update('dms_stocks',array('branch_id' => $branch_to_id,'godown_id'=>$stock['godown_to_id'],'status'=>$st),array('table_id'=>$stock_key,'stock_status'=>10,'status'=>-1,'godown_id'=>$stock_transfer['godown_to_id']));
				        
				        #item stock
				        
				        $branch_id = $this->session->userdata('under_id');
                        $godown_id = $this->stock->get_branch_godown($branch_id);
                        $item_code=$data['itemcode'];
                        $item_id=$this->stocktransfer->get_item_id($item_code);
                        $stock_count = $this->stock->get_stock_count($godown_id,$item_id);
       
				        //$this->stocktransfer->my_update('item_stock',array('qty' => $stock_count),array('branch_id' =>$this->session->userdata('under_id'),'item_id' =>$item_id));
					}
					$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
					$voucher_no = $this->voucher->get_voucher_number($voucher['vtype_id']);
					
					if($data['st_status']=='1')
					{
    					if(!empty($data['freight']) && $data['freight'] >0){
    
    						$voucher['company_id'] = $this->company_Id;
    						$voucher['branch_id'] = $this->branch_Id;
    						$voucher['group_id'] = $voucher_group_id;
    						$voucher['vtype_id'] = 1;
    						$voucher['vno'] = $voucher_no;
    						$voucher['vorder_no'] =1;
    						$voucher['vdate'] = date('Y-m-d',strtotime($data['vdate']));
    						$voucher['dr_ledger'] = 13;
    						$voucher['cr_ledger'] = 1;
    						$voucher['vamount'] = $data['freight'];
    						$voucher['narration'] = $data['narration'];
    						$voucher['table_name'] ='dms_stock_transfers';
    						$voucher['table_group_id'] = $transfer_group_id;
    						$this->stocktransfer->f_save('dms_vouchers',$voucher);
    
    					}
    					if(!empty($data['other_expense']) && $data['other_expense'] >0){
    
    						#creating payment voucher 
    						$voucher['company_id'] = $this->company_Id;
    						$voucher['branch_id'] = $this->branch_Id;
    						$voucher['group_id'] = $voucher_no;
    						$voucher['vtype_id'] = 1;
    						$voucher['vno'] = $voucher_no;
    						$voucher['vorder_no'] =2;
    						$voucher['vdate'] = date('Y-m-d',strtotime($data['vdate']));
    						$voucher['dr_ledger'] = 14;
    						$voucher['cr_ledger'] = 1;
    						$voucher['vamount'] = $data['other_expense'];
    						$voucher['narration'] = $data['narration'];
    						$voucher['table_name'] ='dms_stock_transfers';
    						$voucher['table_group_id'] = $transfer_group_id;
    						$this->stocktransfer->f_save('dms_vouchers',$voucher);
    						
    
    					}
					}
					
					$this->message->set($this->lang->line('stock-tranfer-approved'),'s');
					redirect('stock_transfer/approved_transfer');
				}
				else{
					$this->message->set($this->lang->line('stock-tranfer-not-approved'),'s');
					redirect($go_back);
				}
			}
			
			$this->template->title('Stock Transfer Approve');
			$this->template->main_heading($this->lang->line('approve').' '.$this->lang->line('stock-transfer'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer')=>'stock_transfer/add',$this->lang->line('pending-report') =>'stock_transfer/pending',$this->lang->line('approve')=>'no_link',$this->lang->line('go-back')=>$go_back));
			$this->template->slice('stock_transfer/update_request',array('stock_transfer'=>$stock_transfer,'stock_transfer_items'=>$stock_transfer_items,'godown_to'=>$godown_to));
			$this->template->render();

		}
		#-------------------------------------------------------------
		public function approved_transfer(){
			$this->load->model('godown/Godown_model','godown');
			$this->load->model('stocks/Stock_transfer_model','stocktransfer');
			$branchID = $this->session->userdata('under_id');
			$this->load->model('branches/Branch_model','branch');
			$godowns = $this->godown->listing(array('conditions'=>array('branch_id'=>$branchID)));
			$goDownIDs = array_keys($godowns);
			//$count = 0;
			$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.st_status'=>1),'togodown'=>$goDownIDs,'numrows'=>1));
   	 		if($config['total_rows']==0){
   	 			$this->message->set($this->lang->line('no-result-found'),'i');
   	 		}
   	 		//$config['base_url'] = base_url('stock_transfer/pending_request');
   	 		$config['base_url'] = base_url('stock_transfer/approved_transfer');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] =3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);
			$stock_transfers = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.st_status'=>1),'togodown'=>$goDownIDs,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
			if(!empty($stock_transfers)){
				$this->template->append('stock_transfer/approved_report',array('offset'=>$offset,'links'=>$links,'stock_transfers'=>$stock_transfers));
			}
			$this->template->title('Approved Stock Transfer Report');
			$this->template->main_heading($this->lang->line('approved-stock-transfer-report'));
			$this->template->breadcrumb(array($this->lang->line('stock-transfer')=>'stock_transfer/add',$this->lang->line('report')=>'stock_transfer/report',$this->lang->line('pending-report')=>'stock_transfer/pending',$this->lang->line('approved-report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->other_script('stocks/stock_transfer');
			$this->template->slice('dms/modals/more_details');
			$this->template->render();

		}
		#--------------------------------------------------------------
		public function view()
		{
			#----------uri array
			$uri_array = $this->uri->uri_to_assoc(3);
			

			#----------breadcrumb
			$breadcrumb = array($this->lang->line('stock-transfer')=>'stock_transfer/add',$this->lang->line('report')=>'stock_transfer/report',$this->lang->line('view')=>'no_link');

			if(isset($uri_array['group_id']))
			{
				$stock_transfer_id = $uri_array['group_id'];
				if(isset($uri_array['id']) || isset($uri_array['mid']) || isset($uri_array['sid']))
				{
					if(isset($uri_array['id'])){
						$breadcrumb_url = "stock_item_register/index/id/".$uri_array['id'];
					}
					elseif(isset($uri_array['mid'])){
						$breadcrumb_url = "stock_item_register/index/mid/".$uri_array['mid'];
					}
					elseif(isset($uri_array['sid'])){
						$breadcrumb_url = "stock_item_register/index/sid/".$uri_array['sid'];
					}					
					if(isset($uri_array['rtype'])){
						$breadcrumb_url .= "/rtype/".$uri_array['rtype'];
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				$stock_transfer_id = $this->uri->segment(3);
				$call_back_uri = $this->uri->uri_to_assoc(4);				
				$breadcrumb[$this->lang->line("go-back")] = $this->uri->assoc_to_uri($call_back_uri);				
			}
			
			if($this->uri->segment(3) == 'group_id')
			{
			    $transfer_group_id = $this->uri->segment(4);
			    $stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.status'=>1,'stk_trs.group_id'=>$transfer_group_id)))[0];
			    $stock_transfer_id = $stock_transfer['id'];
			}
			
			if(empty($stock_transfer_id)){redirect('stock_transfer/report');}
			if($this->if_exists('dms_stock_transfers',array('id'=>$stock_transfer_id,'status'=>1)) === false)
			{
				redirect('stock_transfer/report');
			}			
			$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.status'=>1,'stk_trs.id'=>$stock_transfer_id)))[0];
			$transfer_group_id = $stock_transfer['group_id'];
			#get stocktransfer item details;
			$stock_transfer_items = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.group_id'=>$transfer_group_id,'stk_tr_itm.status'=>1)));
			$this->template->title($this->lang->line('stock-transfer').''.$this->lang->line('view'));
			$this->template->main_heading($this->lang->line('stock-transfer').''.$this->lang->line('view'));
			$this->template->breadcrumb($breadcrumb);
			$this->template->slice('stock_transfer/show_stock_transfer',array('stock_transfer'=>$stock_transfer,'stock_transfer_items'=>$stock_transfer_items));
			$this->template->render();
		}
		
		public function print_bill()
		{
			if(!$this->uri->segment(3))
    		{
    			echo "<script>alert('Invalid Transfer');window.close();</script>";
    		}
		    $transfer_id = $this->uri->segment(3);
    		
    		$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.status'=>1,'stk_trs.id'=>$transfer_id)))[0];
			if(empty($stock_transfer))
    		{
    			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
    		}
    		else
    		{
    			$transfer_group_id = $stock_transfer['group_id'];
    			$stock_transfer_items = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.group_id'=>$transfer_group_id,'stk_tr_itm.status'=>1)));
    			
    			$this->load->view('stock_transfer/print_bill',array('stock_transfer'=>$stock_transfer,'stock_transfer_items'=>$stock_transfer_items));
		    }
		}
		#--------------------------------------------------------------

	}
?>