<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Stocktransfer_to_wholesale extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('sales');
		fiscal_status($this->uri->segment(2),$method_array,"booking/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('wholesale/wholesale_model','wholesale_obj');
		$this->load->model('stocks/stock_transfer_model','stocktransfer');
		$this->load->model('customers/customer_type_model','customer_type');
		$this->load->model('branches/branch_model','branch_obj');
		$this->load->model('vouchers/voucher_model','vouchers');
		$this->load->library(array('stock','targets','sales_lib'));

		#----------voucher type
		$this->vtype = 17;
	}

	public function wholesale()
	{   
		#----------delivery primary key
		if($this->uri->segment(3))
		{
			$transfer_id = $this->uri->segment(3);

            $stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.status'=>1,'stk_trs.id'=>$transfer_id)))[0];
			if(!empty($stock_transfer))
			{
		        $vtype_id = $this->vtype;

		        $voucher_types = $this->vouchers->voucher_types($this->vtype);
		        $bill_prefix = $this->stock->get_voucher_prefix($this->vtype);

		        $voucher_name = $this->vouchers->voucher_name($this->vtype);

		        $sales_cst = $this->stock->get_constant(array('sales_cst'));

    		    $presumptive_tax = $this->stock->get_tax_type();
                $cess = $this->stock->get_cess();				

        		#-----------sales date and next bill no
        		$rules = "callback_bill_no_exists";
        		$disabled = "";
        		$result_array = $this->wholesale_obj->next_bill_no($this->vtype);
        		
        		$vtype_id = $result_array['vtype_id'];
        		$voucher_no = $result_array['bill_no'];
        		$voucher_date = $result_array['bill_date'];
        		if($result_array['vstatus'])
                { 
        			$disabled = "readonly";
        			$group_id = $result_array['group_id'];
        			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

        			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_wholesale as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_wholesale','a.table_group_id' => $group_id)));
        			if(!empty($voucher_details))
        			{
        				redirect("sales/update/id/".$voucher_details[0]['id']);
        			}  

        			#------------checking cst enabled or not
        		/*	$cst_status = $this->wholesale_obj->get_cst($group_id);
        			if($cst_status)
        			{
        				$sales_cst = $cst_status;
        			}*/
        		}
        		else
        		{ 
        			$group_id = $this->stock->get_group_id('dms_wholesale');
        		}
        		
        		$to_branch = $this->stock->get_godown_branch($stock_transfer['godown_to_id']);
            	$to_branch_name = $this->branch_obj->get_full_name($to_branch);
        		
        		$sales_temp_array = array();
                $sales_temp_array['vtype_id'] = $this->vtype;
                $sales_temp_array['branch_id'] = $this->branchID;
                $sales_temp_array['bill_no'] = $voucher_no;
                $sales_temp_array['bill_date'] = $voucher_date;
                $sales_temp_array['group_id'] = $group_id;
                $sales_temp_array['s_status'] = 1;
                $sales_temp_array['tid'] = $stock_transfer['id'];
                $sales_temp_array['branch_to_id'] = $to_branch;
                $sales_temp_array['godown_to_id'] = $stock_transfer['godown_to_id'];
                $sales_temp_array['status'] = -1;
                $sales_temp_array['bill_status'] = 0;
                
                $godown_id = $this->stock->get_branch_godown($this->branchID);
          	
            	$item_array = array();
                $item_array['group_id'] = $group_id;
                $item_array['status'] = -1;
        		$item_array['item_status'] = 2;
    				
    			$transfer_group_id = $stock_transfer['group_id'];
    			$stock_transfer_items = $this->stocktransfer->get_stock_transfer_items(array('conditions'=>array('stk_tr_itm.group_id'=>$transfer_group_id,'stk_tr_itm.status'=>1)));
    		    $cnt = count($stock_transfer_items);//print_r($cnt);
    		    if(isset($_POST['btn_add']))
		        {	  
		           $item_array = $this->input->post(NULL,true);
		            $sales = $this->input->post('sales',true);//print_r($sales);
		            
		            $sales_temp_array['bill_no'] = $sales['bill_no'];
                    $sales_temp_array['bill_date'] = date('Y-m-d',strtotime($sales['bill_date']));
                		
    			    for($i=1;$i<=$cnt;$i++)
                    { 
                        $result_array = $this->wholesale_obj->next_bill_no($this->vtype);
                        $item_code = $item_array['code'.$i];
                        $itemarray = array(); $data_salestemp = array();         
                        if($item_code!=null )  
                        { 
                            $item_id = $this->stock->get_item_datas($item_code);
                            $itemarray['item_id'] = $item_id;
                            
                            $cgst = $this->stock->get_item_cgst($itemarray['item_id']);
					        $sgst = $this->stock->get_item_sgst($itemarray['item_id']);
					
                            $sales_temp_item_result = $this->wholesale_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_id,'godown_id' => $godown_id,'unit_id' => 1,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
                            //print_r($sales_temp_item_result);
                            if($sales_temp_item_result == 0)
				            { 
				                $itemarray['group_id'] = $group_id;
                                $itemarray['qty'] = $item_array['qty'.$i];
                                $itemarray['unit_id'] = 1;
                                $itemarray['rate'] = $item_array['rate'.$i];
                                $itemarray['amount'] = $itemarray['qty']*$itemarray['rate'];
                                $itemarray['discount_per'] = 0;
                                $itemarray['discount_amt'] = 0;
                                $itemarray['taxable_amt'] = $itemarray['qty']*$itemarray['rate'];
                                $itemarray['cgst'] = $cgst;
                                $itemarray['sgst'] = $sgst;
                                $itemarray['cgst_amt'] = ($itemarray['taxable_amt']*$cgst)/100;
                                $itemarray['sgst_amt'] = ($itemarray['taxable_amt']*$sgst)/100;
                                $itemarray['cess_amt'] = 0;//($itemarray['taxable_amt']*$cess)/100;
                                $itemarray['godown_id'] = $godown_id;
                                $itemarray['status'] = -1;
                                $itemarray['item_status'] = 2;

                                #----------start transaction
            					$this->db->trans_start();
                                
            					#-----------bill date and next bill no
            					if($result_array['vstatus'] == 0)//data not in dms_sales
            					{
            					    $vtype_id = $sales_temp_array['vtype_id'];
                					$voucher_no = $sales_temp_array['bill_no'];
                					$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
                					$this->wholesale_obj->insert("dms_wholesale",$sales_temp_array);//print_r($sales_temp_array);
                				}
                				
                				$sales_items_id = $this->wholesale_obj->insert("dms_wholesale_items",$itemarray);
   					          
                                if($sales_items_id)
                				{
                					$this->message->set($this->lang->line('sales-add-success'));
                				}
                				else
            				    {
            					    $this->message->set($this->lang->line('sales-add-error'),'e');
            				    }
        
        					    #----------transaction completed
        					    $this->db->trans_complete();
				            }
        				}
        			//	redirect('stocktransfer_to_wholesale/wholesale');
    			    }
		        }
			    #------------saving sales voucher
        		if(isset($_POST['btn_save']))
        		{ 
        			#-----------validation
        			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
        			if($this->input->post('payment_mode',true) == 2)
                    {
        				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
        			}
        			elseif($this->input->post('payment_mode',true) > 2)
                    {
        				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
        				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
        				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
        			}
        			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
        			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
        			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
        			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
        			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

        			#-----------saving data
        
        			if($this->form_validation->run('btn_save') === true)
        			{
        				$payment_mode = $this->input->post('payment_mode',true);
        				$narration = $this->input->post('remarks',true);
        				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
        				$bill_discount_per = $this->input->post('bill_discount_per',true);
        				$freight = $this->input->post('freight',true);
        				$other_expense = $this->input->post('other_expense',true);
        				
				        $sales_entry_array=array('bill_discount_per' => $bill_discount_per,'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

                        $sales_entry_check = $this->wholesale_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.branch_to_id','a.tid'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));

        				if($sales_entry_check)
        				{
        					$bill_date = $sales_entry_check[0]['bill_date'];
        					$vtype_id = $sales_entry_check[0]['vtype_id'];
        					$bill_no = $sales_entry_check[0]['bill_no'];
                            $branch_to_id = $sales_entry_check[0]['branch_to_id']; 
                            $trans_id = $sales_entry_check[0]['tid']; 
                            $amount = $this->input->post('grand_total',true);
                            $vat = $this->input->post('vat_total',true);
                            $cesstotal = $this->input->post('cess_total',true);
                            $tot_amount = $amount+$vat+$cesstotal;
                    
        					#----------start transaction
        					$this->db->trans_start();
        					if($this->wholesale_obj->update(array('table' => 'dms_wholesale','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
        					{
                            /*    if($bill_discount_per>0)
                                {
                                    $voucher_amount=0;  $vat_amount=0; $round_off_amount=0; $cess_amount=0;
                                    $sales_items_array = $this->wholesale_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate'),'conditions' => array('group_id' => $group_id,'status!=' => 0,'item_status >' => 0)));
           						
            						foreach($sales_items_array as $key => $value)
            						{
            						    $it_up_id = $value['id'];
            						    $itid = $value['item_id']; 
            						    $itamt = $value['qty']*$value['rate'];
            						    $itdiscamt = ($itamt*$bill_discount_per)/100;
            						    $it_cgst = $this->stock->get_item_cgst($itid);
            						    $it_sgst = $this->stock->get_item_sgst($itid);
            						    
            						    $it_taxable = (($itamt-$itdiscamt)*100)/(100+$it_cgst+$it_sgst+$cess);
            						    $it_cgst_amt = ($it_taxable*$it_cgst)/100; 
            						    $it_sgst_amt = ($it_taxable*$it_sgst)/100; 
            						    $it_cess_amt = ($it_taxable*$cess)/100;
            						    
            						    $voucher_amount += $it_taxable;
            						    $vat_amount += $it_cgst_amt+$it_sgst_amt;
            						    $cess_amount += $it_cess_amt;
    						    
    						            $it_up_array = array('discount_per'=>$bill_discount_per,'discount_amt'=>$itdiscamt,'taxable_amt'=>$it_taxable,'cgst'=>$it_cgst,'sgst'=>$it_sgst,'cgst_amt'=>$it_cgst_amt,'sgst_amt'=>$it_sgst_amt,'cess_amt'=>$it_cess_amt);
    						
    						            $this->wholesale_obj->update(array('table' => 'dms_wholesale_items','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						        }
                                }
                                else
                                {  */
                                    $voucher_amount = $this->input->post('grand_total',true);
            						$round_off_amount = $this->input->post('round_off_amount',true);
            						$vat_amount = $this->input->post('vat_total',true);
            						$cess_amount = $this->input->post('cess_total',true);
                             //   }
 
                                $this->wholesale_obj->update(array('table' => 'dms_wholesale_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' =>0,'item_status >' => 0)));                     


        						#-------------adding bill to dms_vouchers
        						$voucher_status = 1;
        						
        						if($payment_mode > 2)
        						{
        							$bill_date_time = strtotime($bill_date);
        							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
        							$cheque_date_time = strtotime($cheque_date);
        							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
        							{
        								$voucher_status = 3;
        							}
        						}
        						elseif($payment_mode == 2)
        						{
        						    $branch_det = $this->db->select('ledger_id')->get_where('branch_master',array('id' => $branch_to_id))->row_array();
        							$payment_mode = $branch_det['ledger_id'];
        						}
        						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
        						$voucher_amount += $vat_amount;
        						$voucher_amount += $cess_amount;
        						$voucher_amount -= $bill_discount_amt;
        						$voucher_amount = get_rounded($voucher_amount);
        						
        						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $group_id,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 21,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_wholesale','table_group_id' => $group_id,'status' => $voucher_status);
        						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_wholesale','table_group_id' => $group_id),'numrows' => true));
        						if($voucher_data == 0)
        						{
        							$voucher_success = $this->wholesale_obj->insert('dms_vouchers',$voucher_array);
        							if($voucher_success)
        							{
        								if($payment_mode > 2)
        								{
        									$this->wholesale_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
        								}
        							}
        						}
        						
        						$this->wholesale_obj->update(array('table' => 'dms_stock_transfers','data' => array('bill_status' => 1),'conditions' => array('id' => $trans_id,'status !=' =>0)));                     

        						$this->message->set($this->lang->line('sales-save-success'));
        						redirect('wholesale/report');
        						
                             //   $lnk = 'wholesale/print_bill/id/'.$sls_id;
        					//	redirect($lnk);
        					}
        					else
        					{
        						$this->message->set($this->lang->line('sales-save-error'),'e');
        					}
        
        					#----------transaction completed
        					$this->db->trans_complete();
        				}
        				else
        				{
        					$this->message->set($this->lang->line('sales-save-error'),'e');
        				}
        				redirect('stock_transfer/report');
        			} 
        		} 
			    
			    $result_array = $this->wholesale_obj->next_bill_no($this->vtype);
			    #------------sales temp data
        		$sales_temp_data = array();$pricelists=array();
        		$price_list_id=""; $stock_count="";
        		if($result_array['vstatus'])
        		{ 
			        $sales_temp_data = $this->wholesale_obj->get_sales(array('columns' => array('a.group_id','a.branch_id','a.branch_to_id','a.godown_to_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));
        		    
        		}
        		
                $branch_det = $this->db->select(array('id','branch_name','ledger_id','area_id'))->from('branch_master')->where('id',$this->branchID)->get()->row_array();
                $branch_area = $branch_det['area_id'];
                
                #------------pricelist details
		        $pricelists = $this->customer_type->listing();
                $pricelists[''] = 'Select';ksort($pricelists);
                
                $this->load->model('areas/area_model','area');
			    $areas = $this->area->listing();
			    
			    #------------payment modes
		        $payment_mode = $this->stock->payment_modes();
                
                #------------cheque / dd details
        		$cd_status = 1;
        		if($this->input->post('payment_mode',true) > 2)
        		{
        			$cd_status = 0;
        		}
                
				#------------template
				$this->template->title("New $voucher_name Voucher");
				$this->template->main_heading($this->lang->line("$voucher_name"));
				$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link'));
				$this->template->slice('dms/message');
				$this->template->slice('wholesale/wholesale',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'pricelists' => $pricelists,'price_list_id' => $price_list_id,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'stock_transfer'=>$stock_transfer,'stock_transfer_items'=>$stock_transfer_items,'areas' => $areas,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'to_branch_name' => $to_branch_name,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'branch_area'=>$branch_area));
            	$this->template->other_script('wholesale/wholesale');
            	$this->template->render();   
		    } 
        }
	}

	public function bill_no_exists($bill_no)
	{
		$vtype_id = $this->input->post('vtype_id',true);
		$row = $this->wholesale_model->get_bills(array('columns' => array('id'),'conditions' => array('vtype_id' => $vtype_id,'bill_no' => $bill_no,'status !=' => 0),'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>