<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');	

	class Stocks extends MY_Controller{


		#---------------------------------------------------

		public function __construct(){
			parent :: __construct();
			if(!in_array($this->uri->segment(2),array('fs_request','request_bill'))){
				$this->check_access_right();
				
				#---------------- Checking Financial year is enabled / closed-----------------#
				$method_array = array('request');
				fiscal_status($this->uri->segment(2),$method_array,"stocks/report");	
				#---------------- Checking Financial year is enabled / closed-----------------#
			
			}
		}	
		

		#--------------------------------------------------

		#date : 18-6-2014
		#purpose : to show all available report options for stock request.
		public function index(){

			$this->template->title('Stock request reports');
			$this->template->main_heading($this->lang->line('stock-request-reports'));
			$this->template->breadcrumb(array($this->lang->line('stock-requests')=>'no_link',$this->lang->line('report')=>'no_link'));
			$this->template->slice('stocks/requests/reports/available_reports');
			$this->template->render();
		}

		#---------------------------------------------------

		#date : 17-6-2014
		#purpose : new stock request 
		public function request(){

			$submitted_data = FALSE; #set as dummy
			$more_items = array();

			#basic request details
			$this->form_validation->set_rules('req[customer_name]','lang:customer-name','required|xss_clean|trim');
			$this->form_validation->set_rules('req[customer_phone]','lang:customer-phone','required|xss_clean|trim');
			$this->form_validation->set_rules('req[date_of_delivery]','lang:delivery-date','required|xss_clean|trim');
			$this->form_validation->set_rules('req[delivery_address]','lang:delivery-address','required|xss_clean|trim');
			$this->form_validation->set_rules('req[payment_mode]','lang:payment-mode','required|xss_clean|trim');
			$this->form_validation->set_rules('req[expected_date_of_payment]','lang:expected-payment-date','required|xss_clean|trim');		
			$this->form_validation->set_rules('req[req_comments]','lang:comments','xss_clean|trim');
			$this->form_validation->set_rules('req[mason_id]','lang:mason','required');
			$this->form_validation->set_rules('req[area_id]','lang:area1','required|xss_clean|trim');


			if($this->input->post()){

				#mason validation - if new mason added
				if($this->input->post('is_mason') == 'yes'){
					$this->form_validation->set_rules('is_mason','is_mason','required');
					$this->form_validation->set_rules('mason[fname]','lang:fname','required|trim|xss_clean');
					$this->form_validation->set_rules('mason[lname]','lang:lname','required|trim|xss_clean');
					$this->form_validation->set_rules('mason[mobile]','lang:mobile','required|trim|xss_clean');
					$this->form_validation->set_rules('mason[mason_type]','lang:type','required|trim|xss_clean');
				}


				foreach($this->input->post('index') as $index){
					$this->form_validation->set_rules('item['.$index.'][item_id]','lang:item','required');
					$this->form_validation->set_rules('item['.$index.'][item_quantity]','lang:quantity','required|xss_clean');
					$this->form_validation->set_rules('item['.$index.'][item_unit]','lang:unit','required');
					$this->form_validation->set_rules('item['.$index.'][item_req_comments]','lang:comments','xss_clean');
				}

				$more_items = $this->input->post('item',TRUE);

				#unset first item
				unset($more_items[0]);
			}

			#dms lib
			$this->load->library('Dms');


			if($this->form_validation->run() == TRUE){

				#request details
				$request_data = $this->input->post('req');
				//echo '<pre>';print_r($request_data);


				#item details
				$items = $this->input->post('item',TRUE);
				//echo '<pre>';print_r($items);die;
				$this->load->model('stocks/Request_model','request');

				#if mason data is added
				if($this->input->post('is_mason') == 'yes'){
					$request_data['mason_id'] = $this->request->save_mason($this->input->post('mason'));
					#echo $this->db->last_query();
				}

				#request ID - randome number between 1000 & 999999999
				$request_data['request_ID'] = rand(1000,9999999);

				if($req_id = $this->request->save($request_data)){

					#if request is saved, then save the requested stock aslo
					foreach($items as $item){ $this->request->save_items($req_id,$item); }
					
					#Delete cache for stock request select query if any(like instant notification)
					$this->db->cache_delete('ajax','notify');


					$this->message->set($this->lang->line('request-sent').' YOUR REQUEST ID :'.$request_data['request_ID']);
				}else{
					#echo $this->db->last_query();die;
					$this->message->set($this->lang->line('request-could-not-sent'),'e');
				}

			}

			#decide whether to show/hide mason-add-form
			#echo '<pre>';print_r($_POST);
			$class = 'hide';
			if($this->input->post('is_mason') == 'yes'){ $class="";}

			$this->template->title('Request new stock');
			$this->template->main_heading($this->lang->line('new-stock-request'));
			$this->template->breadcrumb(array($this->lang->line('manage-stock')=>'stocks/',$this->lang->line('new')=>'no_link'));
		
			#list all cash n bank ledgers as payment modes
			$this->load->model('accounts/ledger/Ledger_model','ledger');
			$modes = $this->ledger->list_bank_n_cash();

			#masons list
			$this->load->model('users/Mason_model','mason');
			$masons = $this->mason->listing();
			$masons[0] = 'NIL'; ksort($masons);

			#get product-item list
			$items = $this->load->model('Products/Item_model','item');
			$items = $this->item->listing();
			$items[''] = 'Select an item';

			#get all units
			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);

			$this->template->slice('dms/message');
			$this->template->slice('stocks/requests/new/new_request',array('items'=>$items,'modes'=>$modes,'masons'=>$masons,'units'=>$units,'more_items'=>$more_items,'class'=>$class,'areas'=>$areas));
			$this->template->other_script('stocks/requests/add_more_items');
			$this->template->slice('dms/modals/forms/add_area_modal');
			$this->template->render();
			
		}

		#-----------------------------------------------------

		#date : 12-8-2014
		#purpose : view individual request
		public function request_bill($request_id = FALSE){

			if(!$request_id){ redirect('access/'); }

			$this->load->model('stocks/Request_model','request');
            
            #basic data validation
            $this->form_validation->set_rules('basic[customer_name]','lang:customer-name','required');
            $this->form_validation->set_rules('basic[customer_phone]','lang:customer-phone','required');
            $this->form_validation->set_rules('basic[delivery_address]','lang:delivery-address','required');
            $this->form_validation->set_rules('basic[date_of_delivery]','lang:delivery-date','required|is_date');
            $this->form_validation->set_rules('basic[payment_mode]','lang:payment-mode','required');
            $this->form_validation->set_rules('basic[expected_date_of_payment]','lang:expected-payment-date','required');
            
            #echo '<pre>'; print_r($_POST);die;

            #items validation
            if($this->input->post('ids')){
                foreach($this->input->post('ids') as $key=>$id){
                    $this->form_validation->set_rules('items['.$id.'][unit_price]','lang:price','required');
                    $this->form_validation->set_rules('items['.$id.'][item_quantity]','lang:quantity','required');
                    $this->form_validation->set_rules('items['.$id.'][item_unit]','lang:unit','required');
                    $this->form_validation->set_rules('items['.$id.'][gross_amount]','lang:gross_amount','required|is_money');
                    $this->form_validation->set_rules('items['.$id.'][vat_rate]','lang:vat-rate','required');
                    $this->form_validation->set_rules('items['.$id.'][net_amount]','lang:net_amount','required|is_money');
                    $this->form_validation->set_rules('items['.$id.'][item_req_comments]','lang:comments','trim|xss_clean');
                }
            }
            
            if($this->form_validation->run() == TRUE){
                
            	if(isset($_POST['ids'])){

            		$ids = $this->input->post('ids');
   		            $items = $this->input->post('items',TRUE);

    	            #if add-to-cart
            		if(isset($_POST['add_to_cart'])){

						#update data in the table 'sales'
						$this->request->add_to_cart(array('id'=>$this->uri->segment(3),'data'=>$this->input->post('basic',TRUE)));
						
   		             	#get active cart
   		             	#$this->load->library('Cart_lib');
   		             	$cart_id = $this->cart_lib->prepare_cart();

	                	#loop through each item & updata if necessary
	                	foreach($ids as $key=>$id){
	                		$this->request->add_items_to_cart(array('id'=>$id,'cart_id'=>$cart_id,'data'=>$items[$id]));
	                		#echo $this->db->last_query().'<br/>';
	                	}

	                	$this->message->set($this->lang->line('order-added-to-cart'));
	                	$this->message->add_to_cart_msg($this->uri->segment(3));
					}

					#if-reject-order
					if(isset($_POST['reject'])){

						#sales table
						$this->request->reject_order(array('order_id'=>$this->uri->segment(3),'checked_items'=>count($items),'data'=>$this->input->post('basic',TRUE)));

						#loop through each item & updata if necessary
	                	foreach($ids as $key=>$id){
	                		$this->request->reject_items(array('id'=>$id,'data'=>$items[$id]));
	                	}
					}

            	}else{
            		$this->message->set($this->lang->line('pls-check-atleast-one-item'),'e');
            	}
            }
            
            error_reporting(E_ALL);

			$this->template->title('Request bill');
			$this->template->main_heading($this->lang->line('update-stock-sale'));
			
			#masons listing
			$this->load->model('users/Mason_model','mason');
			$masons = $this->mason->listing();
			$masons[0] = 'No mason'; ksort($masons);

			#ledger listing
			$this->load->model('accounts/ledger/Ledger_model','ledger');
			$ledgers = $this->ledger->list_bank_n_cash();

			#unit listing
			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();

			#get request data
			$rqst = $this->request->get_basic_details($request_id);
			//echo '<pre>';print_r($rqst);//die;
			$this->template->breadcrumb(array($this->lang->line('stock-requests')=>'no_link','<span class="badge">'.$rqst['request_ID'].'</span>'=>'no_link'));

			#requested items
			$items = $this->request->get_items_for_rqst($request_id);

			//echo '<hr>';echo '<pre>';print_r($items);die;

			#VAT details
			$this->load->model('products/Item_model','item');

			$this->template->slice('dms/message');
			$this->template->slice('stocks/requests/reports/update_as_sale',array('rqst'=>$rqst,'items'=>$items,'ledgers'=>$ledgers,'units'=>$units,'masons'=>$masons));
            
            #Jquery
            $this->template->other_script('stocks/requests/update_as_sale');
    
			$this->template->render();
		}

		#-----------------------------------------------------
		#date : 25-7-2014
		#purpose : get logged in user's stock requests
		public function my_request(){

			$this->template->title('My stock requests');
			$this->template->main_heading($this->lang->line('my-requests'));
			$this->template->breadcrumb(array($this->lang->line('stock-requests')=>'stocks/request',$this->lang->line('my-requests')=>'no_link'));

			$this->load->model('stocks/Request_model','request');

			#report with pagination
			$this->load->library('Pagination');
			$config['per_page'] = $this->per_page();
			$config['total_rows'] = $this->request->get_all(array('s.user_id'=>$this->session->userdata('id'),'total'=>1));


			$config['base_url'] = base_url('stocks/my_request');
			$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			$offset = $this->uri->segment(3,0);

			$requests = $this->request->get_all(array('s.user_id'=>$this->session->userdata('id'),'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
			#echo $this->db->last_query();
			#find out how many items for each requests
			$total_items = FALSE;
			if(!empty($requests)){
				foreach($requests as $rqst){
					$total_items[$rqst['request_ID']] = $this->request->get_items(array('rs.request_id'=>$rqst['id'],'total'=>1));
				}
			}

			#load dms library
			$this->load->library('Dms');
			$this->template->slice('dms/message');

			$this->template->slice('stocks/requests/mine/my_requests',array('requests'=>$requests,'links'=>$links,'offset'=>$offset,'total_items'=>$total_items));
			$this->template->other_script('stocks/my_requests/update_stock');
			$this->template->slice('dms/modals/forms/update_stock_modal');

			$this->template->render();
		}

		#------------------------------------------------------
		#date : 30-7-2014
		#purpose : get stock request complete report
		public function report(){

			$this->template->title('Stock requests report');
			$this->template->main_heading($this->lang->line('stock-requests'));
			$this->template->breadcrumb(array($this->lang->line('stock-requests')=>'stocks/requests'));

			#list all designations
			$this->load->model('designations/Designation_master_model','designation');
			$desgs = $this->designation->listing();
			$desgs['all'] = 'All'; ksort($desgs);

			$this->template->other_script('stocks/advanced_filter');
			$this->template->slice('stocks/requests/mine/filter_options',array('desgs'=>$desgs));
			$this->template->render();
		}
		#-------------------------------------------------------
		#date:8-08-2014
		#search requests with request Id
		public function search_by_request(){

			$this->load->model('stocks/Request_model','request');
			#defining dummy arry 
			
			$user_lists = array(''=>'Select');
			#validation for search functions
			$this->form_validation->set_rules('search_type','lang:from','xss_clean');
			$this->form_validation->set_rules('to_date','lang:to','is_date|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from','is_date|xss_clean');
			$this->form_validation->set_rules('request_id','lang:from','xss_clean');
			$this->form_validation->set_rules('area_id','lang:from','xss_clean');
			$this->form_validation->set_rules('user_type','lang:from','xss_clean');
			//$this->form_validation->set_rules('user_id','User','xss_clean');

			$page_uri = array();

		
			#validation for search functions
			

			if($this->form_validation->run()==true || $this->uri->segment(3) == 'advanced'){
				#checking data is posted or via pagination url
				if($this->input->post(NULL,TRUE)){

					$data = $this->input->post(NULL,TRUE);

				}
				else{
					$data = $this->uri->uri_to_assoc(4);


					if(!isset($data['search_type'])){ $data['search_type'] = 'request'; }
					//echo '<pre>';print_r($data);die;
				}

				//echo '<pre>';print_r($data);
				if(!empty($data['search_type']) && ($data['search_type']=='request') ){

					$search_type = $data['search_type'];
					#defining pagination urisegment array
					

					#checking to date field is enpty 
					if(!empty($data['from_date']) && (!empty($data['to_date']))){
						
						$from_date = date('Y-m-d',strtotime($data['from_date']));
						$to_date = date('Y-m-d',strtotime($data['to_date']));

						#
						$conditions['DATE(s.created_on) >='] = $from_date;
						$conditions['DATE(s.created_on) <='] = $to_date;

						#defining pagination urisegment array
						$page_uri['search_type'] = $search_type;
						$page_uri['from_date'] = $from_date;
						$page_uri['to_date'] = $to_date;

					}
					if(!empty($data['from_date']) && (empty($data['to_date']))){

						$from_date = date('Y-m-d',strtotime($data['from_date']));
						$conditions['DATE(s.created_on)'] = $from_date;
						
						#defining pagination urisegment array
						$page_uri['search_type'] = $search_type;
						$page_uri['from_date'] = $from_date;
						$page_uri['to_date'] = $from_date;
						//$conditions['s.created_on <='] = $to_date ;
					}
					if(!empty($data['to_date']) && (empty($data['from_date']))){
						
						$to_date = date('Y-m-d',strtotime($data['to_date']));
						$conditions['DATE(s.created_on)'] = $to_date;
						
						#defining pagination urisegment array
						$page_uri['search_type'] = $search_type;
						$page_uri['to_date'] = $to_date;
						$page_uri['from_date'] =$to_date;
						//$conditions['s.created_on <='] = $to_date ;
					}
					if(!empty($data['area_id'])){
						$area_id = $data['area_id'];
						$conditions['area_id'] = $area_id;

						#defining pagination urisegment array
						$page_uri['area_id'] = $area_id;
					}else{
						$data['area_id'] = '';
					}
					if(!empty($data['request_id'])){
						$request_id = $data['request_id'];
						$conditions['s.id'] = $request_id; 
						#defining pagination urisegment array
						$page_uri['request_id'] = $request_id;

					}else{
						$data['request_id'] = '';
					}

				}

				#
				if(!empty($data['search_type']) && ($data['search_type']=='delivery')){

					$search_type = $data['search_type'];
					#defining pagination urisegment array
					$page_uri['search_type'] = $search_type;

					#checking to date field is enpty 
					if(!empty($data['from_date']) && (!empty($data['to_date']))){
						
						$from_date = date('Y-m-d',strtotime($data['from_date']));
						$to_date = date('Y-m-d',strtotime($data['to_date']));

						#
						$conditions['DATE(s.created_on) >='] = $from_date;
						$conditions['DATE(s.created_on) <='] = $to_date;

						#defining pagination urisegment array
						$page_uri['from_date'] = $from_date;
						$page_uri['to_date'] = $to_date;

					}
					if(!empty($data['from_date']) && (empty($data['to_date']))){

						$from_date = date('Y-m-d',strtotime($data['from_date']));
						$conditions['DATE(s.created_on)'] = $from_date;
						
						#defining pagination urisegment array
						$page_uri['from_date'] = $from_date;
						$page_uri['to_date'] = $from_date;

						//$conditions['s.created_on <='] = $to_date ;
					}
					if(!empty($data['to_date']) && (empty($data['from_date']))){
						
						$to_date = date('Y-m-d',strtotime($data['to_date']));
						$conditions['DATE(s.created_on)'] = $to_date;
						
						#defining pagination urisegment array
						$page_uri['to_date'] = $to_date;
						$page_uri['from_date'] = 
						$to_date;
						//$conditions['s.created_on <='] = $to_date ;
					}



					if(!empty($data['area_id'])){
						$area_id = $data['area_id'];
						$conditions['area_id'] = $area_id;

						#defining pagination urisegment array
						$page_uri['area_id'] = $area_id;
					}else{
						$data['area_id'] = '';
					}
					if(!empty($data['request_id'])){
						$request_id = $data['request_id'];
						$conditions['s.id'] = $request_id; 
						#defining pagination urisegment array
						$page_uri['request_id'] = $request_id;

					}else{
						$data['request_id'] = '';
					}
				}

			
		

				$conditions['total'] = 1;
				
				
				
				$this->load->library('Pagination');
				$config['per_page'] = $this->per_page();
				$config['total_rows'] = $this->request->get_all($conditions);
				//echo $this->db->last_query();
				//echo '<pre>';print_r($config['total_rows']);die;

					//echo 'hai';die;
					//echo '<pre>';print_r($page_uri);
				$config['base_url'] = base_url('stocks/search_by_request/advanced/'.$this->uri->assoc_to_uri($page_uri));
				#find count of pagination array
				$count = count($page_uri);
				$count = ($count * 2) + 4;
				$config['uri_segment'] = $count;
				$offset = $this->uri->segment($count,0);
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$this->pagination->initialize($config);
				$links = $this->pagination->create_links();
				//$offset = $this->uri->segment(3,0);

				$conditions['order_by'] = 'created_on';
				$conditions['order'] = 'DESC';
				$conditions['limit']  = $config['per_page']; 
				$conditions['offset'] = $offset;
				unset($conditions['total']);
				//echo '<pre>';print_r($conditions); die;

				$requests = $this->request->get_all($conditions);
				#echo $this->db->last_query();
				#find out how many items for each requests
				$total_items = FALSE;
				if(!empty($requests)){
					foreach($requests as $rqst){
						$total_items[$rqst['request_ID']] = $this->request->get_items(array('rs.request_id'=>$rqst['id'],'total'=>1));
					}
				}

					
			}


			#request-list = 
			$request_list = $this->request->get_request_list();
			$request_list[''] = 'Select';
			//$request_list['All'] = 'All';
			ksort($request_list);
			//echo '<pre>';print_r($request_list);die;
			//$from_date = date(CAL_FORMAT,strtotime($from_date));
			//$to_date = date(CAL_FORMAT,strtotime($to_date));
			
			#define user_types array
			$user_types = array(''=>'Select','employee'=>'Employee','mason'=>'Mason','engineer'=>'Engineer','contractor'=>'Contractor','AR'=>'AR');
			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);

			#search types =
			$search_types = array('request'=>'Request Date','delivery'=>'Delivery Date');
			
			if($this->uri->segment(3) == 'advanced'){

				if(!isset($page_uri['search_type'])){ $page_uri['search_type'] = 'request'; }
				if(!isset($page_uri['from_date'])){ $page_uri['from_date'] = ''; }
				if(!isset($page_uri['to_date'])){ $page_uri['to_date'] = ''; }
				if(!isset($page_uri['request_id'])){ $page_uri['request_id'] = ''; }
				if(!isset($page_uri['area_id'])){ $page_uri['area_id'] = ''; }
				
			} 
			else{
				$page_uri = array('search_type' =>'','from_date'=>'','to_date'=>'','request_id'=>'','area_id'=>'');
			}

			#for search form class
			$p_class = 'no-collapse'; 
			#load dms library
			$this->load->library('Dms');
			
			$this->template->slice('stocks/requests/reports/search',array('request_list'=>$request_list,'user_types'=>$user_types,'areas'=>$areas,'search_types'=>$search_types,'user_lists'=>$user_lists,'page_uri'=>$page_uri));
			if($this->form_validation->run()==TRUE || $this->uri->segment(3) == 'advanced' &&(!empty($requests))){

					$this->template->slice('stocks/requests/reports/search_reports',array('requests'=>$requests,'links'=>$links,'offset'=>$offset,'total_items'=>$total_items,'request_list'=>$request_list,'user_types'=>$user_types));
			
			}

			$this->template->slice('dms/message');
			
			

			#template
			$this->template->title('Stock Requests');
			$this->template->main_heading($this->lang->line('manage-stock'));
			$this->template->render();



		}
		#--------------------------------------------------------

	}

?>