<?php if(! defined('BASEPATH')) exit('No direct script access allowed');
	
class Units extends MY_Controller{

	public function __construct(){

		parent::__construct();
		$this->check_access_right();
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"units/report");	
		#---------------- Checking Financial year is enabled / closed-----------------#
		$this->load->model('products/Unit_model','unit');
	}

	#---------------------------------------------------

	public function add()
	{
		#simple & compound classes
		$simple_class="simple";
		$compound_class="compound hide";

		#determine which type was submitted
		$this->form_validation->set_rules('unit_type','lang:unit-type','trim');
		if($this->input->post()){
			if($this->input->post('unit_type') == 0){
				$this->form_validation->set_rules('formal_name','lang:name','required|xss_clean|max_length[32]');
				$this->form_validation->set_rules('symbol','lang:symbol','required|xss_clean|max_length[32]|callback_does_simple_unit_exist');
				$this->form_validation->set_rules('decimal_places','lang:decimal-places','xss_clean|is_natural|less_than[5]');
				
			}else{

				$simple_class = 'simple hide';
				$compound_class = 'compound';
				$this->form_validation->set_rules('first_unit','lang:first-unit','required|xss_clean');
				$this->form_validation->set_rules('conversion','lang:conversion','required|xss_clean|numeric');
				$this->form_validation->set_rules('second_unit','lang:second-unit','required|xss_clean|callback_compo_units_same|callback_does_compound_unit_exists');
			}
		}
		#form-validation run
		if($this->form_validation->run() === TRUE){
			if($this->unit->save($this->input->post(NULL,TRUE))){
				$this->message->set($this->lang->line('unit-saved'));
				redirect('units/add');
			}else{
				$this->message->set($this->lang->line('unit-not-saved'),'e');
			}
		}
		$this->template->title($this->lang->line('manage-units'));
		$this->template->main_heading($this->lang->line('manage-units'));
		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('units')=>'no_link',$this->lang->line('report')=>'units/report'));
		$this->template->slice('dms/message');				
		$this->template->other_script('units/simple_compound');
		$unit_types = array(0 => 'simple',1 => 'compound');
		#available units
		$units = $this->unit->listing();
		$this->template->slice('preferences/units/new',array('unit_types'=>$unit_types,'units'=>$units,'simple_class'=>$simple_class,'compound_class'=>$compound_class,'units'=>$units));
		$units = $this->unit->get_data();
		if(!empty($units)){
			$this->template->append('preferences/units/report',array('units'=>$units));
		}
		$this->template->slice('dms/modals/delete_confirm');
		$this->template->render();
	}

	#---------------------------------------------------

	public function update(){			
		
		$id = $this->uri->segment(3,0);
		$unit_details = $this->unit->get_data(array('id' => $id));
		if(!$unit_details){			
			redirect('units/report');
		}
		$unit = $unit_details[0];
		
		if($unit['unit_type'] == 0){

			$this->form_validation->set_rules('formal_name','lang:name','required|xss_clean|max_length[32]|is_edit_unique[unit_master.formal_name]');
			$this->form_validation->set_rules('symbol','lang:symbol','required|xss_clean|max_length[32]|is_edit_unique[unit_master.symbol]');
			$this->form_validation->set_rules('decimal_places','lang:decimal-places','xss_clean|is_natural|less_than[5]');
		}else{
			$this->form_validation->set_rules('first_unit','lang:first-unit','required|xss_clean');
			$this->form_validation->set_rules('conversion','lang:conversion','required|xss_clean');
			$this->form_validation->set_rules('second_unit','lang:second-unit','required|xss_clean|callback_compo_units_same|callback_does_compound_unit_exists');
		}
		if($this->form_validation->run() === true)
		{
			$data = $this->input->post(NULL,TRUE);
			if($unit['unit_type'] == 0)
			{
				if($this->unit->update(array('data' => $data,'conditions' => array('id'=>$id))))
				{
					$this->message->set($this->lang->line('unit-updated'));
				}
			}
			else
			{
				$first_unit = $this->unit->unit_symbol($data['first_unit']);
				$second_unit = $this->unit->unit_symbol($data['second_unit']);
				$formal_name = $first_unit." of ".$data['conversion']." ".$second_unit."s";
				if($this->unit->update(array('data' => array('formal_name' => $formal_name,'symbol' => $formal_name,'first_unit' => $data['first_unit'],'conversion' => $data['conversion'],'second_unit' => $data['second_unit']),'conditions' => array('id'=>$id))))
				{
					$this->message->set($this->lang->line('unit-updated'));
				}
			}
			redirect('units/report');
		}
		$this->template->title($this->lang->line('manage-units'));
		$this->template->main_heading($this->lang->line('update-units'));
		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('units')=>'units/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'units/report'));
		$this->template->slice('dms/message');
		
		if($unit['unit_type'] == 0){
			$this->template->slice('preferences/units/simple_update',array('unit'=>$unit));
		}else{
			$units = $this->unit->listing();
			$this->template->slice('preferences/units/compound_update',array('unit'=>$unit,'units'=>$units));
		}
		$this->template->render();
	}
	
	#---------------------------------------------------

	public function delete(){

		$id = $this->uri->segment(3,0);
		if($this->unit->get_data(array('id'=>$id)))
		{
			if($this->unit->item_count($id) == 0)
			{
				if(!$this->unit->get_compound_data($id)){
					if($this->unit->update(array('data' => array('status' => 0),'conditions' => array('id'=>$id)))){
						$this->message->set($this->lang->line('unit-deleted'));
					}else{
						$this->message->set($this->lang->line('unit-not-deleted'),'e');
					}
				}else{
					$this->message->set($this->lang->line('simple-unit-not-deleted'),'e');
				}
			}
			else
			{
				$this->message->set($this->lang->line('delete-item-unit-warning'),'w');
			}
		}
		redirect('units/report');
	}

	#---------------------------------------------------

	public function report(){			

		$units = $this->unit->get_data();		
		$this->template->title($this->lang->line('manage-units'));
		$this->template->main_heading($this->lang->line('manage-units'));	
		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('units')=>'units/add',$this->lang->line('report')=>'no_link'));		
		if(!empty($units)){
			$this->template->append('preferences/units/report',array('units'=>$units));	
		}
		else{	
			$this->message->set($this->lang->line('no-result-found'),'i');		
		}
		$this->template->slice('dms/message');
		$this->template->slice('dms/modals/delete_confirm');
		$this->template->render();
	}

	#------------------------------------------------------	

	#date : 20-6-2014
	#purpose : check first_unit & second_unit are same
	public function compo_units_same(){

		$first_unit = $this->input->post('first_unit');
		$second_unit = $this->input->post('second_unit');

		if($first_unit == $second_unit){
			$this->form_validation->set_message('compo_units_same',$this->lang->line('first-second-unit-should-not-same'));
			return FALSE;
		}else{
			return TRUE;
		}
	}

	#-----------------------------------------------------	

	#date : 20-6-2014
	#purpose : check whether simple unit symbol already exists
	public function does_simple_unit_exist($symbol){

		$row = $this->unit->get_data(array('symbol'=>$symbol));
		if(!empty($row)){
			$this->form_validation->set_message('does_simple_unit_exist',$this->lang->line('symbol-already-exist'));
			return FALSE;
		}else{
			return TRUE;
		}
	}

	#--------------------------------------------------------

	#date : 20-6-2014
	#purpose : check whether compound unit exists
	public function does_compound_unit_exists()
	{
		$first_unit = $this->input->post('first_unit',true);
		$second_unit = $this->input->post('second_unit',true);
		$unitID = $this->uri->segment(3);
		$row = $this->unit->get_compound_data($first_unit,$second_unit,$unitID);
		
		if($row)
		{
			$this->form_validation->set_message('does_compound_unit_exists',$this->lang->line('compound-already-exist'));
			return FALSE;
		}
		return true;
	}		
}
?>