<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class User_points extends MY_Controller{

	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	#------------------------------------------------------------------------------

	public function __construct(){

		parent::__construct();
		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	#------------------------------------------------------------------------------

	public function add(){

		$this->template->title($this->lang->line('user-bonus-points'));
		$this->template->main_heading($this->lang->line('add-bonus-points'));
		$this->template->breadcrumb(array($this->lang->line('user-bonus-points') => 'no_link'));

		$user_types = $users = $targets = array();
		$user_type=$user_id=NULL;
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('users/User_point_model','user_points');
		$this->load->library(array('Stock','Targets'));
		$user_types = $this->designations->desig_listing();

		$uri_array = $this->uri->uri_to_assoc(3);
		if(!empty($uri_array)){
			if(isset($uri_array['utype'])){
				$user_type = $uri_array['utype'];
			}
			if(isset($uri_array['uid'])){
				$user_id = $uri_array['uid'];
			}
		}

		$this->form_validation->set_rules('user_type','lang:user-type','xss_clean|trim|required');
		$this->form_validation->set_rules('user_id','lang:user','xss_clean|trim|required');
		$this->form_validation->set_rules('target_id','lang:target','trim|xss_clean|required');
		$this->form_validation->set_rules('point','lang:point','trim|xss_clean|required');

		if($this->form_validation->run() === true){

			$user_type = $this->input->post('user_type');
			$user_id = $this->input->post('user_id');
			$target_id = $this->input->post('target_id');
			$point = $this->input->post('point');
			$group_id = $this->user_points->get_bonus_group_id();

			$pre_total_point = $this->targets->get_points(array('up.designation_id' => $user_type,'up.user_id' => $user_id,'up.targets_id' => $target_id,'ds.status >'=>3,'ds.status <'=>6));
			$this->user_points->save('user_points',array('designation_id' => $user_type,'user_id' => $user_id,'targets_id' => $target_id,'group_id' =>$group_id,'sms_point' => $point,'actual_point' => $point));
			$sms_point = $point+$pre_total_point;
			$message = $this->targets->get_message($target_id,$sms_point);
			$this->user_points->save('dms_sms',array('company_id' =>$this->companyID,'bill_ref_no' =>$group_id,'user_type' => $user_type,'user_id' =>$user_id,'message'=>$message,'status'=>3));
			$this->message->set($this->lang->line('bonus-point-saved'));
			redirect('user_points/add');
		}

		if(!empty($user_type)){
			$users = $this->dms->list_user($user_type);
		}
		if(!empty($user_id)){
			$args = array();
			$args['columns'] = array('a.id','a.target_type','a.valid_from','a.valid_to','b.qty','b.amount','b.points','itm.item_type','um.symbol');
			$args['conditions'] = array('user_id'=>$user_id);
			$args['join'] = array('item_type_master as itm'=>'b.item_group_id=itm.id','unit_master as um'=>'b.unit_id=um.id');
			$args['all_data'] = 1;
			$user_targets = $this->targets->get_targets($args);

			if(!empty($user_targets)){
				foreach($user_targets as $key=>$target){
					if(empty($target['target_type'])){
						$targets[$target['id']] = $target['item_type'].' - '.$target['qty'].' '.$target['symbol'].' '.$target['points'].' points .    [ '.dateFormat($target['valid_from']).' - '.dateFormat($target['valid_to']).' ]';
					}else{
						$targets[$target['id']] = $target['item_type'].' - '.$target['amount'].' '.get_currency().' '.$target['points'].' points .    [ '.dateFormat($target['valid_from']).' - '.dateFormat($target['valid_to']).' ]';
					}
				}
			}
		}

		$users[''] = 'Select';
		ksort($users);
		$user_types[''] = 'Select';
		ksort($user_types);
		$targets[''] = 'Select';
		ksort($targets);
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('users/points/add_bonus_point',array('user_types'=>$user_types,'users'=>$users,'targets'=>$targets,'user_type'=>$user_type,'user_id'=>$user_id));
		$this->template->other_script(array('user_points/user_points'));
		$this->template->render();
	}

	#------------------------------------------------------------------------------

	public function report(){

		$this->template->title($this->lang->line('user-points'));
		$this->template->main_heading($this->lang->line('user-points'));
		$this->template->breadcrumb(array($this->lang->line('user-points') => 'no_link'));

		$user_types = $users = $user_points = array();
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('users/User_point_model','user_points');
		#$user_types = $this->designations->listing(array('utype_status >'=>0,'utype_status <'=>4));
		$user_types = $this->designations->desig_listing();

		#-----get select user points............................
		$this->form_validation->set_rules('user_type','lang:user-type','xss_clean|required');
		$this->form_validation->set_rules('user_id','lang:user','xss_clean|required');
		$links=$user_type_id=$user_id=NULL;$offset=$total_points=0;
		if($this->input->post('user_type')){
			$user_type_id = $this->input->post('user_type');
			if(!empty($user_type_id)){
				$users = $this->dms->list_user($user_type_id);
			}
		}
		$gift_status = $msg_status = array();
		$gift_status[0] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$gift_status[2] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$gift_status[1] = '<label class="pending">'.$this->lang->line('pending').'</label>';
		$gift_status[3] = '<label class="approved">'.$this->lang->line('approved').'</label>';

		$msg_status[0] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$msg_status[1] = '<label class="pending">'.$this->lang->line('pending').'</label>';
		$msg_status[2] = '<label class="rejected">'.$this->lang->line('rejected').'</label>';
		$msg_status[3] = '<label class="pending">'.$this->lang->line('message-sending').'</label>';
		$msg_status[4] =  '<span class="pending">'.$this->lang->line('message-sending').'</span>';
		$msg_status[5] = '<span class="approved">'.$this->lang->line('message-sent').'</span>';
		$msg_status[6] = '<span class="rejected">'.$this->lang->line('message-not-sent').'</span>';

		if($this->form_validation->run() === true){

			$user_type_id = $this->input->post('user_type');
			$user_id = $this->input->post('user_id');

		}else{
			if($this->uri->segment(3) && !empty($this->uri->segment(3)) && is_numeric($this->uri->segment(3))){
					$user_type_id = $this->uri->segment(3);
			}
			if($this->uri->segment(4) && !empty($this->uri->segment(4)) && is_numeric($this->uri->segment(4))){
					$user_id = $this->uri->segment(4);
			}
		}

		$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
		if(!empty($user_type_id) && !empty($user_id)){
			#-------Pagination
			$this->load->library('Pagination');
			$config['uri_segment'] = 5;
			$config['per_page'] = $this->per_page();
			$config['base_url'] = base_url('user_points/report/'.$user_type_id.'/'.$user_id);

			$args = array();
			$args['select'] = array('up.created_on');
			$args['join'] = array('dms_sms as ds'=>'up.group_id=ds.bill_ref_no');
			$args['conditions'] = array('up.designation_id'=>$user_type_id,'up.user_id'=>$user_id);
			$args['order_by'] = 'up.created_on';
			$args['order'] = 'desc';
			$args['num_rows'] = 1;
			$config['total_rows'] = $this->user_points->get($args);
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			#---------------------------------------

			$args = array();
			$args['select'] = array('sum(up.sms_point) as total_points');
			$args['join'] = array('dms_sms as ds'=>'up.group_id=ds.bill_ref_no');
			$args['conditions'] = array('up.designation_id'=>$user_type_id,'up.user_id'=>$user_id);
			$args['order_by'] = 'up.created_on';
			$args['order'] = 'desc';
			$user_points_array = $this->user_points->get($args);

			if(!empty($user_points_array)){
				$total_points = $user_points_array[0]['total_points'];
			}

			$args = array();
			$args['select'] = array('up.created_on as point_date','up.sms_point','ds.driver_id','ds.bill_ref_no','ds.user_type','ds.user_id','ds.message','ds.status as msg_status');
			$args['join'] = array('dms_sms as ds'=>'up.group_id=ds.bill_ref_no');

			$args['conditions'] = array('up.designation_id'=>$user_type_id,'up.user_id'=>$user_id);
			$args['order_by'] = 'up.created_on';
			$args['order'] = 'desc';
			$args['limit'] = $config['per_page'];
			$args['offset'] = $offset;
			$user_points = $this->user_points->get($args);

			if(empty($user_points)){
				$this->message->set($this->lang->line('no-user-point-found'),'e');
			}

		}

		$user_types[''] = $users[''] = 'Select';
		ksort($user_types);ksort($users);
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('users/points/user_point_report',array('user_types'=>$user_types,'users'=>$users,'user_points'=>$user_points,'count'=>$offset+1,'gift_status'=>$gift_status,'msg_status'=>$msg_status,'links'=>$links,'total_points'=>$total_points,'user_type_id'=>$user_type_id,'user_id'=>$user_id));
		$this->template->other_script(array('user_points/user_points'));
		$this->template->render();

	}

	#----------view points--------------------------------------------------------------------

        public function view(){

                $this->template->title($this->lang->line('view-points'));
		$this->template->main_heading($this->lang->line('view-points'));
		$this->template->breadcrumb(array($this->lang->line('view-points') => 'no_link'));

                $user_types = $users = $user_points = array();
		$this->load->model('designations/Designation_master_model','designations');
                $this->load->model('users/User_model','user');
		$this->load->model('users/User_point_model','user_points');

             //   $user_point = $this->user_points->get();
                $user_point=array();
                $users= $this->db->query("select distinct user_id,designation_id from user_points")->result_array();
           /*     foreach($users as $user)
                { 
                   $user_id = $user['user_id'];
                   $des = $user['designation_id'];
                   $user_name = $this->user->get_fname_lname($user_id);
                   $desig = $this->designations->get_name($des); 
                
                    $total =0;
                   $user_points= $this->db->query("select sms_point from user_points where user_id='$user_id' ")->result_array();
                   foreach($user_points as $point)
                   {
                       $total += $point['sms_point'];
                    } 
                   //  $user_point = array('user'=>$user_name,'des'=>$desig,'total'=>$total);
                 
                } 
                   $user_point = array('user_name'=>$user_name,'desig'=>$desig); */
             

                $this->template->slice('dms/message');
		$this->template->slice('users/points/user_point_view',array('user_point'=>$user_point,'users'=>$users));
                $this->template->other_script(array('user_points/user_points'));
		$this->template->render();

        }
        public function my_point(){
                $this->template->title($this->lang->line('view-points'));
		$this->template->main_heading($this->lang->line('view-points'));
		$this->template->breadcrumb(array($this->lang->line('view-points') => 'no_link'));

                $user_types = $users = $user_points = array();

                $this->load->model('designations/Designation_master_model','designations');
                $this->load->model('users/User_model','user');
		$this->load->model('users/User_point_model','user_points');
                $this->load->model('targets/Target_model','target');
               
                $user_id = $this->session->userdata('id');
                $args = array();
                $args['select'] = array('sum(up.sms_point) as total_points');
                $args['conditions'] = array('up.user_id'=>$user_id);
                $user_points = $this->user_points->get($args);
                
                $total = $user_points[0]['total_points'];

                $args = array();
                $args['select'] = array('up.targets_id','up.sms_point','up.created_on');
                $args['conditions'] = array('up.user_id'=>$user_id);
                $det_points = $this->user_points->get($args);
 

                $this->template->slice('dms/message');
		$this->template->slice('users/points/my_points',array('user_id'=>$user_id,'total'=>$total,'det_points'=>$det_points));
                $this->template->other_script(array('user_points/user_points'));
		$this->template->render();

        }
}
?>