<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Vat_detailed_reports extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();

		$this->load->library(array('Tax','Stock'));
	}

	public function index()
	{
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['ttyp']) && isset($uri_array['vp']) && isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{		
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));

			#----------validating dates
			if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date))
			{
				redirect('users/logout');
			}
			else
			{
				if(!$this->form_validation->check_date($from_date,$to_date.".<="))
				{
					redirect('users/logout');
				}
			}

			#-------------voucher details
			$voucher_array = $this->tax->getVouchers($uri_array['ttyp'],$uri_array['vp'],$uri_array['fdate'],$uri_array['tdate']);
                    
			#-------------template
			$this->template->title('GST Classification Vouchers');
			$this->template->main_heading('GST Classification Vouchers');
			$this->template->breadcrumb(array($this->lang->line('tax-reports') => 'no_link',$this->lang->line('vat-classification') => 'no_link',lang('go-back') => "vat_reports/index/".$from_date."/".$to_date));
			//$this->template->slice('tax_reports/tax_search',array('from_date' => $from_date,'to_date' => $to_date));
			if(!empty($voucher_array))
			{
			
				$this->template->append('tax_reports/vat_detailed_report',array('from_date' => $from_date,'to_date' => $to_date,'voucher_array' => $voucher_array,'uri_array' => $uri_array));
			}
			else
			{
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
			$this->template->slice('dms/message');
			$this->template->render();
		}
		else
		{
			redirect('vat_reports');
		}
	}
}