<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Vat_reports extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->load->library(array('Tax','Stock'));
	}

	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('d-m-Y');
		$cess = $this->stock->get_cess();

		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				//$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		elseif($this->uri->segment(3) && $this->uri->segment(4))
		{
			$from_date = date('Y-m-d',strtotime($this->uri->segment(3)));
			$to_date = date('Y-m-d',strtotime($this->uri->segment(4)));

			#----------validating dates
			if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
				redirect('users/logout');
			}
			else{
				if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
					redirect('users/logout');
				}
			}
		}
                
		$sales_array = $purchase_array = $cess_array = $wholesales_array = array();
		if(!empty($from_date) && !empty($to_date))
		{
            if($taxes = $this->tax->getAllTaxesgst())
			{  
				foreach($taxes as $tkey => $tvalue)
				{
					$sales = $this->tax->getTotalSalesGst($tvalue['cgst'],$from_date,$to_date);
					if($sales){
						$sales_array[] = $sales;
					}
					$sales_return = $this->tax->getTotalSalesReturnGst($tvalue['cgst'],$from_date,$to_date);
					if($sales_return){
						$sales_array[] = $sales_return;
					}
					$wholesales = $this->tax->getTotalWholesalesGst($tvalue['cgst'],$from_date,$to_date);
					if($wholesales){
						$wholesales_array[] = $wholesales;
					}
					
					$purchase = $this->tax->getTotalPurchaseGst($tvalue['cgst'],$from_date,$to_date);
					if($purchase){
						$purchase_array[] = $purchase;
					}
					$purchase_return = $this->tax->getTotalPurchaseReturnGst($tvalue['cgst'],$from_date,$to_date);
					if($purchase_return){
						$purchase_array[] = $purchase_return;
					}
				}
			}

			$cess1 = $this->tax->getTotalSalesCess($cess,$from_date,$to_date);
			if($cess1){
			    $cess_array[] = $cess1;
			}
			
			$cess_return = $this->tax->getTotalSalesReturnCess($cess,$from_date,$to_date);
			if($cess_return){
			    $cess_array[] = $cess_return;
			}
		}

		#-------------template
		$this->template->title('GST Computation');
		$this->template->main_heading('GST Computation');
		$this->template->breadcrumb(array($this->lang->line('tax-reports') => 'no_link',$this->lang->line('vat-computation') => 'no_link'));
		$this->template->slice('tax_reports/tax_search',array('from_date' => $from_date,'to_date' => $to_date));
		if(!empty($sales_array) || !empty($purchase_array))
		{
			$this->template->append('tax_reports/vat_report',array('from_date' => $from_date,'to_date' => $to_date,'sales_array' => $sales_array,'purchase_array' => $purchase_array,'cess_array' => $cess_array,'wholesale_array'=>$wholesales_array));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}
?>