<?php if(! defined('BASEPATH')) exit('No direct script access allowed');

	class Vehicle_types extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			$this->load->model('vehicle_types/Vehicle_type_model','type');
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"vehicle_types/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
				
		}
	 #------------------------------------------
		public function report(){
			#get all datas from tables#
			#get counters
			$this->load->library('Pagination');
			$this->load->model('vehicle_types/Vehicle_type_model','type');
			$config['base_url'] = base_url('vehicle_types/report');
			$config['total_rows'] = $this->type->get_all(array('company_id'=>$this->session->userdata('company_id'),'status'=>1),1);
			//print_r($config['total_rows']);die;
			$config['per_page'] = $this->per_page();
			$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);

			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			
			$types = $this->type->get_all(array('company_id'=>$this->session->userdata('company_id'),'status'=>1),NULL,$config['per_page'],$offset);
			
			$links = $this->pagination->create_links();

			if(empty($types))
			{
				$this->message->set($this->lang->line('no-results-found'),'i');
			}

			$this->template->title($this->lang->line('vehicle-type-settings'));
			$this->template->main_heading($this->lang->line('vehicle-type-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('vehicle types')=>'vehicle_types/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/vehicle_types/report',array('types'=>$types,'count'=>$offset,'links'=>$links));
			
			#delete_confirm
			$this->template->slice('dms/modals/delete_confirm');
			$this->template->render();
		}
	 #------------------------------------------
		public function add(){

			#validation
			$this->form_validation->set_rules('vehicle_type','lang:type','trim|xss_clean|required|callback_does_exist');
			$this->form_validation->set_rules('description','lang:description','trim|xss_clean');
			if($this->form_validation->run() == true){

					$data = $this->input->post(NULL,TRUE);
					$data['created_by'] = $this->session->userdata('id');
					$data['company_id'] = $this->session->userdata('company_id');

					if($this->db->insert('vehicle_type_master',$data)){
						$this->message->set($this->lang->line('vehicle-type-saved'));
					}
					else{
						$this->message->set($this->lang->line('vehicle-type-not-saved'));
					}
					redirect('vehicle_types/report');

			}
			$this->template->title($this->lang->line('vehicle-type-settings'));
			$this->template->main_heading($this->lang->line('vehicle-type-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('vehicle types')=>'vehicle_types/report',$this->lang->line('new')=>'no_link'));
			$this->template->slice('preferences/vehicle_types/new');
			$this->template->render();
		}
		
		#--------------------------------------------------------	
		#date : 21-6-2014
		#use :  callback validation for vehicle type
		
		public function does_exist($vehicle_type){
		
			$row = $this->db->get_where('vehicle_type_master',array('company_id'=>$this->session->userdata('company_id'),'vehicle_type'=>$vehicle_type,'status'=>1))->row_array();
			
			if(!empty($row)){
				$this->form_validation->set_message('does_exist',$this->lang->line('vehicle-type-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}		
		}




	
	 #------------------------------------------
	 
		public function update($id){

			if(empty($id) && !$this->input->post()){
				redirect('vehicle_types/report');
			}
			$id = $this->uri->segment(3);

			#get details of correspondind id
			$types = $this->db->get_where('vehicle_type_master',array('id'=>$id,'status'=>1))->row_array();
			if(empty($types)){
				redirect('vehicle_types/report');
			}
			#validation#
			$this->form_validation->set_rules('vehicle_type','lang:type','trim|xss_clean|required|is_edit_unique[vehicle_type_master.vehicle_type]');
			$this->form_validation->set_rules('description','lang:description','trim|xss_clean');
			if($this->form_validation->run() == true){

				$data = $this->input->post(NULL,TRUE);
				$data['created_by'] = $this->session->userdata('id');
				if($this->db->update('vehicle_type_master',$data,array('id'=>$id))){
					$this->message->set($this->lang->line('vehicele-type-updated'),'s');
				}
				else{
					$this->message->set($this->lang->line('vehicle-type-not-updated'),'e');
				}
				redirect('vehicle_types/report');
			}
			
			$this->template->title($this->lang->line('vehicle-type-settings'));
			$this->template->main_heading($this->lang->line('vehicle-type-settings'));
			$this->template->breadcrumb(array($this->lang->line('preferences')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('vehicle types')=>'vehicle_types/report',$this->lang->line('update')=>'no_link'));
			$this->template->slice('preferences/vehicle_types/update',array('type'=>$types));
			$this->template->render();

		}
	 #------------------------------------------
		public function delete($id){

			if(empty($id)){
				redirect('vehicle_types/report');
			}
			$id = $this->uri->segment(3);
			if($this->if_exists('vehicle_type_master',array('id'=>$id,'status'=>1)) === false){
				redirect('vehicle_types/report/report');
			}
			#checking condition
			if( $this->type->check_in_delete($id) === false){
				if($this->db->update('vehicle_type_master',array('status'=>0),array('id'=>$id))){
					$this->message->set($this->lang->line('vehicle-type-deleted'),'s');
				}
				else{
					$this->message->set($this->lang->line('vehicle-type-not-deleted'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-vehicle-type'),'w');
			}
			
			redirect('vehicle_types/report');
		}
	 #------------------------------------------
	}
?>