<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Vehicles extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			$this->load->model('vehicles/Vehicle_model','vehicle');
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete','add_fuel','delete_fuel','edit_fuel','insurance','insurance_edit','insurance_delete','insurance_report');
			fiscal_status($this->uri->segment(2),$method_array,"vehicles/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
			$this->companyID = $this->session->userdata('company_id');
		}

	 #--------------------------------------
		public function index(){
			#get all general link assigned for this employee
			
			$this->db->select('mm.*');
			$this->db->from('menu_master mm');
			
			if($this->session->userdata('id') !=-1){
				$this->db->join('user_privileges up','up.menu_id=mm.id');
				$this->db->where('up.user_group','individual');
				$this->db->where('up.owner_id',$this->session->userdata('id'));
			}
			$this->db->where('mm.menu_group','vehicles');
			$this->db->where('mm.menu_parent !=','0');
			$this->db->order_by('menu_order','ASC');
			$menus = $this->db->get()->result_array();
			
			
			$this->template->title('Vehicles');
			$this->template->main_heading($this->lang->line('vehicle-setting'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'no_link'));
			$this->template->slice('preferences/general/link_list',array('menus'=>$menus));
			$this->template->render();
		}
	 #--------------------------------------
		public function report(){
			#pagination and all details
			$this->load->library('Pagination');
			$config['base_url'] = base_url('vehicles/report');
			if($this->session->userdata('id') == -1 || $this->session->userdata('id') == -2){
				$config['total_rows'] = $this->vehicle->get_all(array('conditions'=>array('vm.company_id'=>$this->session->userdata('company_id')),'numrows'=>TRUE));
			}
			else{
				$config['total_rows'] = $this->vehicle->get_all(array('conditions'=>array('vm.company_id'=>$this->session->userdata('company_id'),'vm.under_id'=>$this->session->userdata('under_id')),'numrows'=>TRUE));
			}

			if($config['total_rows'] == 0){ $this->message->set($this->lang->line('no-items-found'),'i');}
			$config['per_page'] = $this->per_page();
			$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);
			
			if($this->session->userdata('id') == -1 || $this->session->userdata('id') == -2){

				$vehicles = $this->vehicle->get_all(array('conditions'=>array('vm.company_id'=>$this->session->userdata('company_id')),'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

			}
			else{
				$vehicles = $this->vehicle->get_all(array('conditions'=>array('vm.company_id'=>$this->session->userdata('company_id'),'vm.under_id'=>$this->session->userdata('under_id')),'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
				
			}

			$this->template->title($this->lang->line('vehicle-master').' '.$this->lang->line('settings'));
			$this->template->main_heading($this->lang->line('vehicle-master').' '.$this->lang->line('settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('vehicle-master')=>'vehicles/add',$this->lang->line('report')=>'no_link'));

			$this->template->slice('dms/message');
			if(!empty($vehicles)){

				$this->template->slice('preferences/vehicles/new_report',array('vehicles'=>$vehicles,'offset'=>$offset,'links'=>$links));
			}
			$this->template->slice('dms/modals/more_details');
   	 		$this->template->other_script('vehicles/insurance_remainder_add');
			$this->template->render();
		}
	 #--------------------------------------
		public function add(){
			
			#validation#
			if($this->form_validation->run('vehicles/add') == true){

				$data = $this->input->post(NULL,TRUE);
				$data['insurance_valid_from'] = ($data['insurance_valid_from'] != '')?date('Y-m-d',strtotime($data['insurance_valid_from'])):'';
				$data['insurance_valid_to'] = ($data['insurance_valid_to'] != '')?date('Y-m-d',strtotime($data['insurance_valid_to'])):'';
				$data['created_by'] = $this->session->userdata('id');
				$data['company_id'] = $this->session->userdata('company_id');
				$data['under_id'] = $this->session->userdata('under_id');
				if($this->db->insert('vehicle_master',$data)){

					$this->message->set($this->lang->line('vehicle-saved'));
				}
				else{
					$this->message->set($this->lang->line('vehicle-not-saved'));
				}
				redirect('vehicles/report');
			}
			#vehicle type listing
			$this->load->model('vehicle_types/Vehicle_type_model','type');
			$types = $this->type->listing(array('company_id'=>$this->session->userdata('company_id')));
			$types[''] = 'Select A Type';
			ksort($types);
			$this->template->title($this->lang->line('vehicle-master').' '.$this->lang->line('settings'));
			$this->template->main_heading($this->lang->line('vehicle-master').' '.$this->lang->line('settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('vehicle-master')=>'vehicles/report',$this->lang->line('new')=>'no_link'));

			$this->template->slice('preferences/vehicles/new',array('types'=>$types));
			$this->template->render();
		}
	 #---------------------------------------

		#date : 3-6-2014
		#purpose : fuel filling data report
		public function fuel_filling(){
			$filter_data = array('vehicle_id'=>'','from_date'=>cdateFormat(date('Y-m-d')),'to_date'=>cdateFormat(date('Y-m-d')));
			$conditions =array();

			if(isset($_POST['search']) || $this->uri->segment(4) !=''){

				$filter_data = $this->input->post(NULL,TRUE);
					
				if(isset($_POST['search'])){

					$filter_data = $this->input->post(NULL,TRUE);
				}
				else{
						
					$filter_data = $this->uri->uri_to_assoc(3);
			
				}
				$filter_data = array_filter($filter_data);
				$count = count($filter_data);

				if($count==0){
					$this->message->set($this->lang->line('use-one-search'),'e');
				}
				else{

					if(isset($_POST['search'])){
						//$this->form_validation->set_rules('vehicle_id','lang:from','trim|xss_clean');
						//$this->form_validation->set_rules('from_date','lang:from','required|trim|xss_clean|callback_is_date');
						//$this->form_validation->set_rules('to_date','lang:to','required|trim|xss_clean|callback_is_date');
						if(isset($filter_data['vehicle_id']) && $filter_data['vehicle_id'] != ''){
							$this->form_validation->set_rules('vehicle_id','lang:vehicle','trim|xss_clean');
						}
						$this->form_validation->set_rules('vehicle_id','lang:vehicle','trim|xss_clean');
						//$this->form_validation->set_rules('from_date','lang:from','required|trim|xss_clean|callback_is_date');
						if(isset($filter_data['from_date']) && $filter_data['from_date'] != ''){
							$this->form_validation->set_rules('from_date','lang:from','required|trim|xss_clean|callback_is_date');
						}

						if(isset($filter_data['to_date']) && $filter_data['to_date'] != ''){
							$this->form_validation->set_rules('to_date','lang:to','required|trim|xss_clean|callback_is_date');
						}
									
					}

					if($this->form_validation->run() == TRUE || $this->uri->segment(3)){

						//$conditions['stock.stock_status !='] = 0;

						if(isset($filter_data['from_date']) && $filter_data['from_date']!=''){
							$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
							$conditions['fuel.filling_date >='] = $from_date;
							$filter_data['from_date'] = $from_date;
						}

						if(isset($filter_data['to_date']) && $filter_data['to_date']!=''){
							$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
							$conditions['fuel.filling_date <='] = $to_date;
							$filter_data['to_date'] = $to_date;
						}
						if(!empty($from_date)&& !empty($to_date)){

							$conditions['fuel.filling_date >='] = $from_date;
							$conditions['fuel.filling_date <='] = $to_date;
						}
						if(isset($filter_data['vehicle_id']) && $filter_data['vehicle_id'] != ''){

							$conditions['vehicle_id']  = $filter_data['vehicle_id'];

							
						}

						
						
					}
					
				}
				#set dummy filter data again for the unset values
				if(!isset($filter_data['vehicle_id'])){ $filter_data['vehicle_id'] = ''; }
				if(!isset($filter_data['from_date'])){ $filter_data['from_date'] = ''; }else{$filter_data['from_date'] = cdateFormat($filter_data['from_date']);}
				if(!isset($filter_data['to_date'])){ $filter_data['to_date'] = ''; }else{$filter_data['to_date'] = cdateFormat($filter_data['to_date']);}
			}
			else{

					if($filter_data['from_date']!=''){
							$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
							$conditions['fuel.filling_date >='] = $from_date;
							$filter_data['from_date'] = $from_date;
					}

					if($filter_data['to_date']!=''){
						$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
						$conditions['fuel.filling_date <='] = $to_date;
						$filter_data['to_date'] = $to_date;
					}
					if(!empty($from_date)&& !empty($to_date)){

						$conditions['fuel.filling_date >='] = $from_date;
						$conditions['fuel.filling_date <='] = $to_date;
					}
					if( $filter_data['vehicle_id'] != ''){

						$conditions['vehicle_id']  = $filter_data['vehicle_id'];

						
					}

			}

			$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->vehicle->get_all_fuel($conditions,1);
   	 			//echo  $config['total_rows'];
   	 		//echo $this->db->last_query();die;
   	 		$config['per_page'] = $this->per_page();
   	 		if($config['total_rows']==0){
   	 			$this->message->set($this->lang->line('no-result-found'),'i');
   	 		}
   	 		if(isset($_POST['search']) || $this->uri->segment(4) !=''){
   	 		   $config['base_url'] = base_url('vehicles/fuel_filling').'/'.$this->uri->assoc_to_uri(array_filter($filter_data));
   	 		   $config['uri_segment'] = count(array_filter($filter_data))*2+3;
   	 		   $offset = $this->uri->segment($config['uri_segment'],0);
   	 		}
   	 		else{
   	 			$config['base_url'] = base_url('vehicles/fuel_filling');
				$config['per_page'] = $this->per_page();
				$config['uri_segment'] = 3;
				$start = ($this->uri->segment(3))?$this->uri->segment(3):0;
   	 		}
   	 		
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';	
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

   	 		$fuels = $this->vehicle->get_all_fuel($conditions,0,$offset,$config['per_page']);
			$vehicles = $this->vehicle->listing(array('company_id'=>$this->session->userdata('company_id')));
			if(!empty($vehicles)){
				$vehicles[''] = 'All';	
			}
			
			ksort($vehicles);
			$fmodes = array('0'=>'N-A','1'=>'Ordinary','2'=>'Extra Premium');
			
			#for fmodes in view		
			$this->template->title('Vehicle fuel filling');
			$this->template->main_heading($this->lang->line('fuel-filling-data'));
			$this->template->breadcrumb(array($this->lang->line('vehicles')=>'no_link',$this->lang->line('fuel-filling')=>'vehicles/add_fuel',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			#when passing date for pagination#
			$this->template->slice('vehicles/fuel/search',array('vehicles'=>$vehicles,'data'=>$filter_data,'fuels'=>$fuels,'links'=>$links,'offset'=>$offset,'fmodes'=>$fmodes));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('fuel/show_fuelfill');
			$this->template->render();
		}

	 #----------------------------------------
		#date : 3-6-2014
		#purpose : add fuel 
		
		public function add_fuel(){
			$this->load->library('Stock');
			$this->load->model('vouchers/Voucher_model','voucher');
			#validation#
			if($this->form_validation->run('vehicles/add_fuel')==true){
				$data = $this->input->post(NULL,TRUE);
				$data['filling_date'] = date('Y-m-d',strtotime($this->input->post('filling_date',true)));
				$data['company_id'] = $this->session->userdata('company_id');
				//echo '<pre>';print_r($data);die;
				if($this->vehicle->f_save('vehicle_fuel_fillings',$data)){
					$voucher_id = $this->db->insert_id();
					//echo $voucher_id;die;
					#creating payment voucher 
					$voucher['company_id'] =  $this->session->userdata('company_id');
					$voucher['branch_id'] =$this->session->userdata('under_id');
					$voucher['group_id'] = $this->stock->get_group_id('dms_vouchers');
					$voucher['vtype_id'] = 1;
					$voucher['vno'] = $this->voucher->get_voucher_number($voucher['vtype_id']);
					$voucher['vorder_no'] =1;
					$voucher['vdate'] = $data['filling_date'];
					$voucher['dr_ledger'] = 16;
					$voucher['cr_ledger'] = $data['payment_mode'];
					$voucher['vamount'] = $data['fuel_amount'];
					$voucher['narration'] = $data['pump_name'];
					$voucher['table_name'] ='vehicle_fuel_fillings';
					$voucher['table_group_id'] = $voucher_id;
					$this->vehicle->f_save('dms_vouchers',$voucher);
					$this->message->set($this->lang->line('fuel-fill-saved'));
				}
				else{
					$this->message->set($this->lang->line('fuel-fill-not-saved'));	
				}
				redirect('vehicles/fuel_filling');
			}
			
			$this->template->title('Add fuel filling');
			$this->template->main_heading($this->lang->line('add-fuel-filling-data'));
			$this->template->breadcrumb(array($this->lang->line('vehicles')=>'no_link',$this->lang->line('fuel-filling')=>'no_link',$this->lang->line('report')=>'vehicles/fuel_filling'));
			
			
			$vehicles = $this->vehicle->listing(array('company_id'=>$this->session->userdata('company_id')));
			$vehicles[''] = 'Select a vehicle';
			ksort($vehicles);
			#print_r($vehicles);
			 #payment mode
		    $payment_mode = $this->stock->payment_modes();
		    unset($payment_mode[2]);

			$fmodes = array('0'=>'N-A','1'=>'Ordinary','2'=>'Extra Premium');
			
			$driver = $this->user->listing(array('designation_id'=>7,'company_id'=>$this->session->userdata('company_id')));
			//echo $this->db->last_query();die;
			$driver[''] = 'Select a driver';
			ksort($driver);
			
			$this->template->slice('vehicles/fuel/add',array('vehicles'=>$vehicles,'driver'=>$driver,'fmodes'=>$fmodes,'payment_mode'=>$payment_mode));
			$this->template->other_script('vehicles/autocomplete_pump_name');
			$this->template->render();

		}
	 #----------------------------------------
		public function delete($id){

			if(empty($id)){
				redirect('vehicles/report');
			}

			$id = $this->uri->segment(3);
			$vehicle = $this->vehicle->get_all(array('conditions'=>array('vm.id'=>$id)));
			if(empty($vehicle)){
				redirect('vehicles/report');
			}
			if($this->vehicle->check_in_delete($id) === true){
				if($this->vehicle->my_update('vehicle_master',array('status'=>0),array('id'=>$id))){
					$this->message->set($this->lang->line('vehicel-deleted'),'s');
				}
				else{
					$this->message->set($this->lang->line('vehicel-not-deleted'),'e');
				}

			}else{
				$this->message->set($this->lang->line('can-not-delete-vehicle'),'w');
			}
			redirect('vehicles/report');
		}
	 #----------------------------------------
		public function update($id){

			if(empty($id) && !$this->input->post()){

				redirect('vehicles/report');
			}

			$id = $this->uri->segment(3);
			#get details of id 
			$vehicle = $this->db->get_where('vehicle_master',array('id'=>$id,'status'=>1))->row_array();
			if(empty($vehicle)){
				redirect('vehicles/report');
			}
			#get vehiccle listing
			$this->load->model('vehicle_types/Vehicle_type_model','type');
			$types = $this->type->listing();

			#validation#
			if($this->form_validation->run('vehicles/update') == true){

				$data = $this->input->post(NULL,TRUE);
				$data['insurance_valid_from'] = ($data['insurance_valid_from'] != '')?date('Y-m-d',strtotime($data['insurance_valid_from'])):'';
				$data['insurance_valid_to'] = ($data['insurance_valid_to'] != '')?date('Y-m-d',strtotime($data['insurance_valid_to'])):'';
				$data['created_by'] = $this->session->userdata('id');

				if($this->db->update('vehicle_master',$data,array('id'=>$id))){
					$this->message->set($this->lang->line('vehicel-updated'),'s');
				}
				else{
					$this->message->set($this->lang->line('vehicel-not-updated'),'e');	
				}
				redirect('vehicles/report');
			}
			if($vehicle['insurance_valid_from'] == "0000-00-00" || $vehicle['insurance_valid_from'] == "1970-01-01"){
				$vehicle['insurance_valid_from'] = '';
			}else{
				$vehicle['insurance_valid_from'] = cdateFormat($vehicle['insurance_valid_from']);
			}
			if($vehicle['insurance_valid_to'] == "0000-00-00" || $vehicle['insurance_valid_to'] == "1970-01-01"){
				$vehicle['insurance_valid_to'] = '';
			}else{
				$vehicle['insurance_valid_to'] = cdateFormat($vehicle['insurance_valid_to']);
			}

			$this->template->title($this->lang->line('edit-vehicle'));
			$this->template->main_heading($this->lang->line('edit-vehicle'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('vehicles')=>'vehicles/',$this->lang->line('vehicle-master')=>'vehicles/report',$this->lang->line('update')=>'no_link'));
			$this->template->slice('preferences/vehicles/update',array('vehicle'=>$vehicle,'types'=>$types));
			$this->template->render(); 
		}

	 #----------------------------------------
	 	public function delete_fuel($id){

			if(empty($id)){
				redirect('vehicles/fuel_filling');
			}

			$id = $this->uri->segment(3);
			$fuel = $this->vehicle->get_all_fuel(array('fuel.id'=>$id));
			if(empty($fuel)){
				redirect('vehicles/fuel_filling');	
			}
			if($this->db->update('vehicle_fuel_fillings',array('status'=>0),array('id'=>$id))){
				$this->vehicle->my_update('dms_vouchers',array('status'=>0),array('table_name'=>'vehicle_fuel_fillings','table_group_id'=>$id));
				$this->message->set($this->lang->line('fuel-data-deleted'),'s');
			}
			else{
				$this->message->set($this->lang->line('fuel-data-not-deleted'));
			}
			redirect('vehicles/fuel_filling');
		}
	 #---------------------------------------
	 	public function edit_fuel($id){
	 		$this->load->library('Stock');
	 		if(empty($id) && !$this->input->post()){

				redirect('vehicles/fuel_filling');
			}

			$id = $this->uri->segment(3);
			$fuel = $this->vehicle->get_all_fuel(array('fuel.id'=>$id));
			if(empty($fuel)){
				redirect('vehicles/fuel_filling');	
			}


			#vehicel listing
			$vehicles = $this->vehicle->listing();
			$vehicles[''] = 'Select a vehicle';
			
			#fuel modes
			$fmodes = array('0'=>'N-A','1'=>'Ordinary','2'=>'Extra Premium');

			#driver listing
			$driver = $this->user->listing();
			$driver[''] = 'Select a driver';
			if($this->form_validation->run('vehicles/edit_fuel') == true){

				$data = $this->input->post(NULL,TRUE);
				$data['filling_date'] = date('Y-m-d',strtotime($this->input->post('filling_date',true)));
				//$data['created_by'] = $this->session->userdata('id');
				//echo '<pre>';print_r($data);die;

				if($this->vehicle->my_update('vehicle_fuel_fillings',$data,array('id'=>$id))){
					#update voucher details.
					$voucher['vdate'] = $data['filling_date'];
					$voucher['vamount'] = $data['fuel_amount'];
					$voucher['narration'] = $data['pump_name'];
					$voucher['cr_ledger'] = $data['payment_mode'];

					$this->vehicle->my_update('dms_vouchers',$voucher,array('table_name'=>'vehicle_fuel_fillings','table_group_id'=>$id));
					//echo $this->db->last_query();die;
					$this->message->set($this->lang->line('fuel-data-updated'),'s');
				}
				else{
					$this->message->set($this->lang->line('fuel-data-not-updated'));
				}
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));

			}
			$payment_mode = $this->stock->payment_modes();
		    unset($payment_mode[2]);

	 		$this->template->title('Edit fuel Filling Details');
	 		$this->template->main_heading($this->lang->line('edit-fuel'));
	 		$this->template->breadcrumb(array($this->lang->line('vehicles')=>'no_link',$this->lang->line('fuel-filling')=>'vehicles/add_fuel',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'vehicles/fuel_filling'));
	 		$this->template->slice('vehicles/fuel/update',array('fuel'=>$fuel[0],'vehicles'=>$vehicles,'fmodes'=>$fmodes,'driver'=>$driver,'payment_mode'=>$payment_mode));
	 		$this->template->render();
	 	} 
	 #---------------------------------------
	 	public function search_fuelfill(){

	 	}
     #------------------------------------------
	 #date 13_08_2014
	 #purpose add vehicle maintances
     	public function maintenance(){

	     	#vehicle list
		    //$this->load->model('vehicles/Vehicle_model','vehicle');
		    $vehicle_list = $this->vehicle->listing(array('under_type'=>$this->session->userdata('under_type')));
		    $vehicle_list[''] = 'Select A Vehicle';
		    ksort($vehicle_list);

		    #payment mode
		    $this->load->model('accounts/ledger/Ledger_model','ledger');
		    $payment_mode = $this->ledger->list_bank_n_cash();
	        $this->template->title('Vehicles');
			$this->template->main_heading($this->lang->line('vehicle maintenance'));
			$this->template->breadcrumb(array($this->lang->line('vehicle')=>'no_link',$this->lang->line('report')=>'no_link'));
			//$this->template->slice('dms/message');
	        $this->template->slice('preferences/vehicles/maintenance/add',array('vehicle_list'=>$vehicle_list,'payment_mode'=>$payment_mode));
	        $this->template->render();


   	 	}
	 #---------------------------------------------
   	 #date:1-10-2014
   	 #purpose:vehicle insurance seetings
   	 	public function insurance(){
   	 		$this->load->library('Stock');
			$this->load->model('vouchers/Voucher_model','voucher');

   	 		$class = 'hide';
		    $checked = FALSE;
   	 		$this->form_validation->set_rules('vehicle_id','lang:vehicle-no','trim|xss_clean|required');
   	 		$this->form_validation->set_rules('insurance_no','lang:insurance-no','trim|xss_clean');
   	 		$this->form_validation->set_rules('insurance_company','lang:insurance-no','trim|xss_clean');
   	 		$this->form_validation->set_rules('insurance_amount','lang:insurance-no','trim|xss_clean');
   	 		$this->form_validation->set_rules('premium_amount','lang:premium-amount','|trim|xss_clean|required');
   	 		$this->form_validation->set_rules('premium_date','lang:premium-date','is_date|required');
   	 		$this->form_validation->set_rules('description','lang:insurance-no','trim|xss_clean'); 	 		
   	 		if(isset($_POST['paid_status'])){
   	 			$class='';
   	 			$checked = TRUE;

   	 			$this->form_validation->set_rules('payment_mode','lang:payment-mode','|trim|xss_clean|required');
   	 			$this->form_validation->set_rules('payment_date','lang:payment-date','valid_date|required');
   	 		}

   	 		if($this->form_validation->run()==TRUE){

   	 			$data = $this->input->post(NULL,TRUE);
				if($this->vehicle->save_insurance($data)){
					if($this->input->post('paid_status')){
						$insurance_id = $this->db->insert_id();
						#creating payment voucher 
						$voucher['company_id'] =  $this->session->userdata('company_id');
						$voucher['branch_id'] =$this->session->userdata('under_id');
						$voucher['group_id'] = $this->stock->get_group_id('dms_vouchers');
						$voucher['vtype_id'] = 1;
						$voucher['vno'] = $this->voucher->get_voucher_number($voucher['vtype_id']);
						$voucher['vorder_no'] =1;
						$voucher['vdate'] = date('Y-m-d',strtotime($data['payment_date']));
						$voucher['dr_ledger'] = 16;
						$voucher['cr_ledger'] = $data['payment_mode'];
						$voucher['vamount'] = $data['premium_amount'];
						$voucher['narration'] = $data['description'];
						$voucher['table_name'] ='vehicles_insurance';
						$voucher['table_group_id'] = $insurance_id;
						$this->vehicle->f_save('dms_vouchers',$voucher);
					}
					$this->message->set($this->lang->line('save-insurance'),'s');
				}
				else{
					$this->message->set($this->lang->line('save-not-insurance'),'e');
				}
				redirect('vehicles/insurance_report');
   	 		}
   	 		$vehicle_list = $this->vehicle->listing(array('company_id'=>$this->session->userdata('company_id')));
   	 		$vehicle_list[''] = 'Select A Vehicle';
		    ksort($vehicle_list);
		    #payment mode
		    $payment_mode = $this->stock->payment_modes();
		    unset($payment_mode[2]);
   	 		#template
   	 		$this->template->title('Vehicles Insurance Settings');
   	 		$this->template->main_heading($this->lang->line('vehicles-insurance'));
   	 		$this->template->breadcrumb(array($this->lang->line('vehicles')=>'no_link',$this->lang->line('insurance')=>'no_link',$this->lang->line('report')=>'vehicles/insurance_report'));
   	 		$this->template->slice('preferences/vehicles/insurance/add',array('vehicle_list'=>$vehicle_list,'payment_mode'=>$payment_mode,'class'=>$class,'checked'=>$checked));
   	 		$this->template->other_script('vehicles/insurance_remainder_add');
   	 		$this->template->render();
   	 	}


   	 #----------------------------------------------
   	 #date:6-10-2014
   	 #purpose:vehicle insurance settings report;
   	 	public function insurance_report(){
   	 		#pagination
   	 		$this->load->library('Pagination');
   	 		if($this->session->userdata('id') == -1 || $this->session->userdata('id') == -2){
				$config['total_rows'] = $this->vehicle->get_all_insurance(array('numrows'=>TRUE));			}
			else{
				$config['total_rows'] = $this->vehicle->get_all_insurance(array('numrows'=>TRUE,'conditions'=>array('insurance.created_by'=>$this->session->userdata('id'))));
			}
   	 		//echo  $this->db->last_query();
   	 		if($config['total_rows'] == 0){
   	 			$this->message->set($this->lang->line('no-insurance-data'),'i');
   	 		}
   	 		$config['base_url'] = base_url('vehicles/insurance_report');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';	
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);
   	 		if($this->session->userdata('id') == -1 || $this->session->userdata('id') == -2){
   	 			$insurances = $this->vehicle->get_all_insurance(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
   	 		}else{
   	 			$insurances = $this->vehicle->get_all_insurance(array('conditions'=>array('insurance.created_by'=>$this->session->userdata('id')),'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
   	 		}
   	 		//print_r($insurances);die;
   	 		#template
   	 		$this->template->title('Vehicles Insurance Report');
   	 		$this->template->main_heading($this->lang->line('vehicles-insurance'));
   	 		$this->template->breadcrumb(array($this->lang->line('vehicles')=>'no_link',$this->lang->line('insurance')=>'vehicles/insurance',$this->lang->line('report')=>'no_link'));
   	 		$this->template->slice('dms/message');
   	 		if(!empty($insurances)){
   	 			$this->template->slice('preferences/vehicles/insurance/report',array('links'=>$links,'offset'=>$offset,'insurances'=>$insurances));
   	 		}
   	 		$this->template->slice('dms/modals/more_details');
   	 		$this->template->other_script('vehicles/insurance_remainder_add');
   	 		$this->template->render();

   	 	}

   	 #----------------------------------------------
   	 #date:6-10-2014
   	 #purpose:vehicles insurance details edit;
   	 	public function insurance_edit(){
   	 		$this->load->library('Stock');
			$this->load->model('vouchers/Voucher_model','voucher');
   	 		$ins_id = $this->uri->segment(3);
   	 		if(empty($ins_id)){ redirect('vehicles/insurance_report');}

   	 		#get details of insid
   	 		$insurances = $this->vehicle->get_all_insurance(array('conditions'=>array('insurance.id'=>$ins_id)))[0];
   	 		if(empty($insurances)){
   	 			redirect('vehicles/insurance_report');
   	 		}
   	 		if($insurances['paid_status']==1){
   	 			$class = '';
		    	$checked =TRUE;
   	 			
   	 		}
   	 		else{
		    	$class = 'hide';
		    	$checked = FALSE;
   	 		}
   	 		#validation parts
   	 		$this->form_validation->set_rules('vehicle_id','lang:vehicle-no','trim|xss_clean|required');
   	 		$this->form_validation->set_rules('insurance_no','lang:insurance-no','trim|xss_clean');
   	 		$this->form_validation->set_rules('insurance_company','lang:insurance-no','trim|xss_clean');
   	 		$this->form_validation->set_rules('insurance_amount','lang:insurance-no','trim|xss_clean');
   	 		$this->form_validation->set_rules('premium_amount','lang:premium-amount','|trim|xss_clean|required');
   	 		$this->form_validation->set_rules('premium_date','lang:premium-date','is_date|required');
   	 		$this->form_validation->set_rules('description','lang:insurance-no','trim|xss_clean');
   	 		
   	 		if(isset($_POST['paid_status'])){
   	 			$class='';
   	 			$checked = TRUE;
   	 			$this->form_validation->set_rules('payment_mode','lang:payment-mode','|trim|xss_clean|required');
   	 			$this->form_validation->set_rules('payment_date','lang:payment-date','valid_date|required');
   	 		}

   	 		if($this->form_validation->run()==TRUE){
   	 			$data = $this->input->post(NULL,TRUE);
   	 			$data['premium_date'] = date('Y-m-d',strtotime($data['premium_date']));
	    		$data['payment_date'] = (isset($data['payment_date']))?date('Y-m-d',strtotime($data['payment_date'])):'';
	    		if(!$this->input->post('paid_status')){
	    			$data['payment_mode'] = 0;
	    			$data['payment_date'] = '';
	    			$data['paid_status'] = 0;
	    		}
   	 			if($this->vehicle->my_update('vehicles_insurance',$data,array('id'=>$ins_id))){
   	 				#checking alerady voucher exist
   	 				$row = $this->db->select(array('id','vdate','vamount'))->get_where('dms_vouchers',array('table_name'=>'vehicles_insurance','table_group_id'=>$ins_id,'status'=>1))->num_rows();
   	 				if($this->input->post('paid_status')){
   	 					//echo $row; die;
   	 					if($row==1){
   	 						$voucher['vdate'] = $data['payment_date'] ;
   	 						$voucher['vamount'] = $data['premium_amount'];
							$voucher['narration'] = $data['description'];
							$voucher['cr_ledger'] = $data['payment_mode'];
							$this->vehicle->my_update('dms_vouchers',$voucher,array('table_name'=>'vehicles_insurance','table_group_id'=>$ins_id));
   	 					}
   	 					else{
   	 						$insurance_id = $ins_id;
							#creating payment voucher 
							$voucher['company_id'] =  $this->session->userdata('company_id');
							$voucher['branch_id'] =$this->session->userdata('under_id');
							$voucher['group_id'] = $this->stock->get_group_id('dms_vouchers');
							$voucher['vtype_id'] = 1;
							$voucher['vno'] = $this->voucher->get_voucher_number($voucher['vtype_id']);
							$voucher['vorder_no'] =1;
							$voucher['vdate'] = $data['payment_date'] ;
							$voucher['dr_ledger'] = 16;
							$voucher['cr_ledger'] = $data['payment_mode'];
							$voucher['vamount'] = $data['premium_amount'];
							$voucher['narration'] = $data['description'];
							$voucher['table_name'] ='vehicles_insurance';
							$voucher['table_group_id'] = $insurance_id;
							$this->vehicle->f_save('dms_vouchers',$voucher);
   	 					}
   	 				}
   	 				else{
   	 					if($row ==1){
   	 						$this->vehicle->my_update('dms_vouchers',array('status'=>0),array('table_name'=>'vehicles_insurance','table_group_id'=>$ins_id));

   	 					}
   	 				}
   	 				$this->message->set($this->lang->line('update-insurance'));
				}
				else{
					$this->message->set($this->lang->line('update-not-insurance'));
				}

				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));die;
   	 		}
   	 		#vehicle list
   	 		$vehicle_list = $this->vehicle->listing();
   	 		$vehicle_list[''] = 'Select A Vehicle';
		    ksort($vehicle_list);

		    $this->load->library('Stock');
		    $payment_mode = $this->stock->payment_modes();
		    if($insurances['payment_date'] == "0000-00-00" || $insurances['payment_date'] == "1970-01-01"){
				$insurances['payment_date'] = '';
			}else{
				$insurances['payment_date'] = cdateFormat($insurances['payment_date']);
			}
			$insurances['premium_date'] = cdateFormat($insurances['premium_date']);

   	 		$this->template->title($this->lang->line('edit').' '.$this->lang->line('vehicles-insurance'));
   	 		$this->template->main_heading($this->lang->line('vehicles-insurance'));
   	 		$this->template->breadcrumb(array($this->lang->line('vehicles')=>'no_link',$this->lang->line('insurance')=>'vehicles/insurance',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'vehicles/insurance_report'));
   	 		$this->template->slice('preferences/vehicles/insurance/edit',array('vehicle_list'=>$vehicle_list,'payment_mode'=>$payment_mode,'class'=>$class,'checked'=>$checked,'ins'=>$insurances));
   	 		$this->template->other_script('vehicles/insurance_remainder_add');
   	 		$this->template->render();

   	 	}
   	 #----------------------------------------------
   	 	public function insurance_delete(){

   	 		$ins_id = $this->uri->segment(3);
   	 		if(empty($ins_id)){ redirect('vehicles/insurance_report');}
   	 		$insurances = $this->vehicle->get_all_insurance(array('conditions'=>array('insurance.id'=>$ins_id)))[0];
   	 		if(empty($insurances)){
   	 			redirect('vehicles/insurance_report');
   	 		}

   	 		if($this->vehicle->my_update('vehicles_insurance',array('status'=>0),array('id'=>$ins_id))){
   	 			$this->vehicle->my_update('dms_vouchers',array('status'=>0),array('table_name'=>'vehicles_insurance','table_group_id'=>$ins_id));
   	 			$this->message->set($this->lang->line('delete-insurance'),'s');
   	 		}
   	 		else{
   	 			$this->message->set($this->lang->line('delete-not-insurance'),'e');
   	 		}
   	 		redirect('vehicles/insurance_report');
   	 	}
   	 #----------------------------------------------
   	 	public function single_insurance_report(){

   	 		$ins_id = $this->uri->segment(3);
   	 		if(empty($ins_id)){ redirect('dms/');}
   	 		#get details of $ins_id
   	 		$insurances =  $this->vehicle->get_all_insurance(array('conditions'=>array('insurance.id'=>$ins_id)));
   	 		$links = '';
   	 		$offset =0;

   	 		$this->template->title('Vehicles Insurance Report');
   	 		$this->template->main_heading($this->lang->line('vehicles-insurance'));
   	 		$this->template->breadcrumb(array($this->lang->line('vehicles-insurance')=>'vehicles/insurance',$this->lang->line('report')=>'no_link'));
   	 		$this->template->slice('dms/message');
   	 		$this->template->slice('preferences/vehicles/insurance/single_user_report',array('links'=>$links,'offset'=>$offset,'insurances'=>$insurances));
   	 		$this->template->render();

   	 	}
   	 #----------------------------------------------

	public function check_vehicle_no($str){

			$this->db->select(array('id'));
			$this->db->from('vehicle_master');
			$this->db->where(array('status'=>1,'company_id'=>$this->companyID,'vehicle_no'=>$str));
			$check_row = $this->db->get()->row_array();
			if(empty($check_row)){
				return TRUE;
			}else{
				return FALSE;
			}
	}
	
	}
?>