<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Voucher_prefix extends MY_Controller
{
	var $company_id;
	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('update');
		fiscal_status($this->uri->segment(2),$method_array,"voucher_prefix/index");	
		#---------------- Checking Financial year is enabled / closed-----------------#
		
		$this->load->model('accounts/Voucher_prefix_model','vprefix');
		$this->template->title('Voucher Prefix');
		$this->template->main_heading($this->lang->line('voucher-prefix-settings'));
		$this->company_id = $this->session->userdata('company_id');
	}
	
	public function index()
	{		
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('voucher-prefix') => 'no_link',$this->lang->line('set') => 'voucher_prefix/update'));
		
		
		$default_vouchers = $this->vprefix->get_voucher_type(array('conditions'=>array('dvt.company_id'=>0)));

		$inner_vouchers = array();
		foreach($default_vouchers as $key => $default_voucher){

			$voucher_id = $default_voucher['id'];
			$voucher_name = $default_voucher['vtype'];
			$inner_voucher = $this->vprefix->get_voucher_type(array('conditions'=>array('dvt.vid'=>$voucher_id,'dvt.company_id'=>$this->company_id)));

			$inner_vouchers[$voucher_id] = $inner_voucher;
		}
		
		$data = $this->vprefix->get();

		$this->template->slice('dms/message');	
		$this->template->slice('preferences/voucher_prefixes/report',array('voucher_prefix' => $data,'inner_vouchers'=>$inner_vouchers));
		$this->template->render();		
	}
	
	public function update()
	{
		$data = $this->vprefix->get();
		$default_vouchers = $this->vprefix->get_voucher_type(array('conditions'=>array('dvt.company_id'=>0)));
		$inner_vouchers = array();
		foreach($default_vouchers as $key => $default_voucher){
			
			$this->form_validation->set_rules("vprefix$default_voucher[id]",'lang:voucher-prefix','xss_clean|max_length[16]');
			$voucher_id = $default_voucher['id'];
			$voucher_name = $default_voucher['vtype'];
			$inner_voucher = $this->vprefix->get_voucher_type(array('conditions'=>array('dvt.vid'=>$voucher_id,'dvt.company_id'=>$this->company_id)));
			$inner_vouchers[$voucher_id] = $inner_voucher;
			if(!empty($inner_voucher)){
				foreach($inner_voucher as $inn_key=>$inn_vchr){
					$this->form_validation->set_rules("vprefix$inn_vchr[id]",'lang:voucher-prefix','xss_clean|max_length[16]');
				}
			}
		}		
		
		if($this->form_validation->run() == true)
		{
			$prefix_data = $this->input->post(NULL,true);
			foreach($prefix_data as $vchr_id => $prefix_name)
			{
				$voucher_prefix_id = substr($vchr_id,7);
				if($this->vprefix->update(array('vid' => $voucher_prefix_id,'vprefix' => $prefix_name)))
				{
					$this->message->set($this->lang->line('voucher-prefix-edit-success'));
				}
			}
			redirect('voucher_prefix/index');
		}
		$vprefix_data = $this->vprefix->get_voucher_type(array('conditions'=>array('dvt.company_id'=>0)));
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('voucher-prefix') => 'voucher_prefix/index',$this->lang->line('set') => 'no_link'));

		$this->template->slice('dms/message');	
		$this->template->slice('preferences/voucher_prefixes/report',array('voucher_prefix' => $data,'inner_vouchers'=>$inner_vouchers,'prefix_status' => 1));
		$this->template->render();
	}	
}