<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Voucher_types extends MY_Controller
{
	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('index','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"voucher_types/report");	
		#---------------- Checking Financial year is enabled / closed-----------------#
		
		$this->load->model('accounts/Voucher_types_model','vtype');
		$this->template->title('Voucher Types');
		$this->template->main_heading($this->lang->line('voucher-type-settings'));
	}
	
	public function index()
	{		
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('voucher-types') => 'no_link',$this->lang->line('report') => 'voucher_types/report'));
		
		$this->form_validation->set_rules('vid','lang:voucher-type','required|xss_clean');
		$this->form_validation->set_rules('vtype','lang:voucher-name','required|xss_clean|max_length[32]|is_unique[dms_voucher_types.vtype]');
		if($this->form_validation->run() === true)
		{
			$data = $this->input->post(NULL,true);
			if($this->vtype->insert($data))
			{
				$this->message->set($this->lang->line('voucher-type-add-success'));				
			}
			else
			{		
				$this->message->set($this->lang->line('voucher-type-add-error'),'e');
			}
			redirect('voucher_types/index');
		}
		
		$voucher_types = $this->vtype->get_types();
		$this->template->slice('dms/message');	
		$this->template->slice('preferences/voucher_types/add',array('voucher_types' => $voucher_types));
		
		$voucher_array = $this->vtype->get();
		$this->template->slice('preferences/voucher_types/report',array('voucher_array' => $voucher_array));
		$this->template->render();		
	}
	
	public function update()
	{
		$id = $this->uri->segment(3,0);
		$vtype_data = $this->vtype->get_update_data($id);		
		if($vtype_data)
		{
			if($vtype_data['company_id'] != 0)
			{
				#----------validation
				$this->form_validation->set_rules('vid','lang:voucher-type','required|xss_clean');
				$this->form_validation->set_rules('vtype','lang:voucher-name','required|xss_clean|max_length[32]|is_unique[dms_voucher_types.vtype]');	
				if($this->form_validation->run() == true)
				{			
					$data = $this->input->post(NULL,true);
					if($this->vtype->update(array('data' => array('vid' => $data['vid'],'vtype' => $data['vtype']),'conditions' => array('id' => $data['vtype_id'])))){
						$this->message->set($this->lang->line('voucher-type-edit-success'));
					}
					else{
						$this->message->set($this->lang->line('voucher-type-edit-error'),'e');
					}
					redirect('voucher_types/report');
				}

				#----------voucher types				
				$voucher_types = $this->vtype->get_types();
				
				$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('voucher-types') => 'voucher_types/index',$this->lang->line('update') => 'no_link',$this->lang->line('report') => 'voucher_types/report'));			
				$this->template->slice('dms/message');
				$this->template->slice('preferences/voucher_types/edit',array('voucher_types' => $voucher_types,'vtype_data' => $vtype_data));	
				$this->template->render();
			}
			else
			{
				$this->message->set($this->lang->line('def-data-not-changed'),'e');
				redirect('voucher_types/report');
			}
		}
		else
		{ 
			redirect('voucher_types/report'); 
		}
	}
	
	public function report()
	{
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('voucher-types') => 'voucher_types/index',$this->lang->line('report') => 'no_link'));
		$this->template->slice('dms/message');		
		$voucher_array = $this->vtype->get();
		$this->template->slice('preferences/voucher_types/report',array('voucher_array' => $voucher_array));
		$this->template->slice('dms/modals/delete_confirm');
		$this->template->render();
	}
	
	public function delete()
	{
		$id = $this->uri->segment(3,0);
		$vtype_data = $this->vtype->get_update_data($id);		
		if($vtype_data)
		{
			if($vtype_data['company_id'] != 0)
			{
				if(!$this->vtype->check_voucher_type($id,$vtype_data['vid']))
				{
					if($this->vtype->update(array('data' => array('status' => 0),'conditions' => array('id' => $id)))){
						$this->message->set($this->lang->line('voucher-type-delete-success'));
					}
					else{
						$this->message->set($this->lang->line('voucher-type-delete-error'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('voucher-type-stock-voucher-delete-error'),'w');
				}
			}
			else
			{
				$this->message->set($this->lang->line('def-data-not-changed'),'e');
			}
		}
		redirect('voucher_types/report');
	}
}