<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Wholesale extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branch_id = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('report');
		fiscal_status($this->uri->segment(2),$method_array,"sales/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('wholesale/Wholesale_model','wholesale_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->model('branches/Branch_model','branch_obj');
        $this->load->model('products/Item_model','item');
		$this->load->library(array('Stock','Targets','Dms'));
		
		#----------voucher type
		$this->vtype = 17;
	}
	
	public function report()
	{
		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1); 
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('wholesale/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
        
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows

		$config['total_rows'] = $this->wholesale_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->wholesale_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Whole Sale Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'no_link'));
		$this->template->slice('wholesale/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'wholesale'));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/wholesale');
		if(!empty($sales_array))
		{
			$this->template->slice('wholesale/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();
	}
	
	public function update()
	{
	    $uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$sales_id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "wholesale/report/".$this->uri->assoc_to_uri($uri_array);
			
			$vtype_id = $this->vtype;

		    $voucher_types = $this->vouchers->voucher_types($this->vtype);
		    $bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		    $voucher_name = $this->vouchers->voucher_name($this->vtype);
			
			$sales_temp_data = $this->wholesale_obj->get_sales(array('columns' => array('a.group_id','a.bill_no','a.bill_date','a.branch_id','a.branch_to_id','a.godown_to_id','a.payment_mode','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cr_period','a.narration','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status' => 1)));
        	$group_id = $sales_temp_data[0]['group_id'];
			if(isset($_POST['btn_update']))
			{
			    $this->form_validation->set_rules('sales[bill_date]','lang:bill-date',"required|xss_clean|valid_date");
			    $this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
				if($this->input->post('payment_mode',true) == 2)
				{
					$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
				}
				elseif($this->input->post('payment_mode',true) > 2)
				{
					$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
					$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
					$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$item_details[bill_date].>=]");
				}
			    $this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
				
			    if($this->form_validation->run('btn_update') === true)
				{ 
				    $sal_tem = $this->input->post('sales',true);
				    $bill_date = date('Y-m-d',strtotime($sal_tem['bill_date']));
					$bill_no = $this->input->post('bill_no',true);
					$narration = $this->input->post('remarks',true);
					$payment_mode = $this->input->post('payment_mode',true);
					$bill_discount_amt = $this->input->post('bill_discount_amt',true);
					$bill_discount_per = $this->input->post('bill_discount_per',true);
					$freight = $this->input->post('freight',true);
					$other_expense = $this->input->post('other_expense',true);
					
					$up_date_time = date('Y-m-d H:i:s');
                    
					$sales_entry_array = array('bill_date' => $bill_date,'bill_discount_per' => $bill_discount_per,'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'status' => 1,'updated_by'=>$this->session->userdata('id'),'updated_on'=>$up_date_time);

					$this->db->trans_start();
                    
					if($this->wholesale_obj->update(array('table' => 'dms_wholesale','data' => $sales_entry_array,'conditions' => array('id' => $sales_id))))
					{
					    $voucher_amount = $this->input->post('grand_total',true);
            			$round_off_amount = $this->input->post('round_off_amount',true);
            			$vat_amount = $this->input->post('vat_total',true);
            			$cess_amount = $this->input->post('cess_total',true);
            			
            			$voucher_status = 1;
        						
        				if($payment_mode > 2)
        				{
        					$bill_date_time = strtotime($bill_date);
        					$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
        					$cheque_date_time = strtotime($cheque_date);
        					if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
        					{
        						$voucher_status = 3;
        					}
        				}
        				elseif($payment_mode == 2)
        				{
        					$branch_det = $this->db->select('ledger_id')->get_where('branch_master',array('id' => $branch_to_id))->row_array();
        					$payment_mode = $branch_det['ledger_id'];
        				}
        				
        				$voucher_amount += $vat_amount;
        				$voucher_amount += $cess_amount;
        				$voucher_amount -= $bill_discount_amt;
        				$voucher_amount = get_rounded($voucher_amount);
            			
            			$voucher_array = array('vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 21,'vamount' => $voucher_amount,'narration' => $narration);
        				
        				$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => array('id','group_id'),'conditions' => array('table_name' => 'dms_wholesale','table_group_id' => $group_id)));
        				if(!empty($voucher_data))
        				{
        				    $voucher_id = $voucher_data[0]['id'];
        				    $voucher_group_id = $voucher_data[0]['group_id'];
        				    if($this->wholesale_obj->update(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('id' => $voucher_id))))
        				    {
        				        if($payment_mode > 2)
        						{
        						    $voucher_bank_data = $this->dms->get_data(array('table' =>'dms_voucher_banks','columns' => 'id','conditions' => array('group_id' => $voucher_group_id)));
        				            if(!empty($voucher_bank_data))
        						    {
        						        $voucher_bank_id = $voucher_bank_data[0]['id'];
        						        $this->wholesale_obj->update(array('table' => 'dms_voucher_banks','data' => array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date),'conditions' => array('id' => $voucher_bank_id)));
        						    }
        						    else
        						    {
        						        $this->wholesale_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
        						    }
        						}
        					}
        				}
			    
		                redirect($redirect_uri);
					}          
				}      
			}
			
		    $to_branch_name = $this->branch_obj->get_full_name($sales_temp_data[0]['branch_to_id']);	
		    
		    $branch_det = $this->db->select(array('id','branch_name','ledger_id','area_id'))->from('branch_master')->where('id',$this->branchID)->get()->row_array();
            $branch_area = $branch_det['area_id'];
            
            $this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			    
			#------------payment modes
		    $payment_mode = $this->stock->payment_modes();
                
            #------------cheque / dd details
        	$cd_status = 1;
        	if($sales_temp_data[0]['payment_mode'] > 2)
        	{
        		$cd_status = 0;
        	}
		    
		    #------------template
			$this->template->title("Update Wholesale Bill");
			$this->template->main_heading($this->lang->line("wholesale"));
			$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("wholesale") => 'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('wholesale/update',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'sales_temp_data' => $sales_temp_data,'areas' => $areas,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'to_branch_name' => $to_branch_name,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'branch_area'=>$branch_area));
            $this->template->other_script('wholesale/wholesale');
            $this->template->render();   
		}
	}
	
	public function delete()
	{
		#----------sales primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "wholesale/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->wholesale_obj->get_sales(array('columns' => array('a.group_id','a.tid','a.s_status','a.status','a.created_by','b.id','b.item_status'),'conditions' => array('a.id' => $id,'a.status !=' => 0,'b.item_status >' => 0)));
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1)
				{
					if($row['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->wholesale_obj->update_others(array('table' => 'dms_wholesale','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{
						$this->wholesale_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_wholesale','table_group_id' => $row['group_id'])));

						if($row['s_status'] != 1)
						{
							foreach($result as $key => $value)
							{
								$this->wholesale_obj->update_others(array('table' => 'dms_wholesale_items','data' => array('status' => 0),'conditions' => array('id' => $value['id'])));
							}
						}
                        else
                        {
                            $this->wholesale_obj->update_others(array('table' => 'dms_stock_transfers','data' => array('bill_status' => 0),'conditions' => array('id' => $row['tid'])));
                        }
					    $this->message->set($this->lang->line('sales-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-delete-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}
	
	public function print_bill()
	{
		if(!$this->uri->segment(4))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$wholesale_id = $this->uri->segment(4);
		if($this->if_exists('dms_wholesale',array('id'=>$wholesale_id,'status'=>1)) === false)
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		} 

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('To_words');	

		#----------sales data
	    $sales_array = $this->wholesale_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.branch_to_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $wholesale_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
        $bill_date=$sales_array[0]['bill_date'];
        $gr_id = $sales_array[0]['group_id'];

		if(empty($sales_array))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		else
		{ 
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$branch_name = $this->branch_obj->get_full_name($sales_array[0]['branch_to_id']);
			
			$branch = $this->db->select(array('branch_name','branch_address','branch_landline','branch_mobile','gstin','branch_email'))->get_where('branch_master',array('id'=>$sales_array[0]['branch_to_id']))->row_array();
            $branch_name =  $branch['branch_name'];
            $branch_address = $branch['branch_address'];	
            $branch_mobile = $branch['branch_mobile'];
            $branch_gstn = $branch['gstin'];
			
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);						
						
			$this->load->view('wholesale/print_bill',array('sales_array' => $sales_array,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'branchname' => $branch_name,'branchaddr' => $branch_address,'branchmob' => $branch_mobile,'branchgstn' => $branch_gstn,'area_id' => $area_id,'payment_mode' => $payment_mode));
		}		
	}
}
?>