<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Notify extends MY_Controller{

		var $companyID,$branchID,$createdBY,$fiscal_start_date,$fiscal_end_date;
		public function __construct(){
			parent :: __construct();
			$this->companyID = $this->session->userdata('company_id');
			$this->branchID = $this->session->userdata('under_id');
			$this->createdBY = $this->session->userdata('id');
			
			$fiscals = $this->dms->get_fiscal_year();
			$this->fiscal_start_date = $fiscals['start_date'];
			$this->fiscal_end_date = $fiscals['end_date'];
		}


	#----------------------------------------------------------
		
		#date : 24-7-2014
		#purpose : get instant target notification for an employee
		public function notify_my_targets(){

			// set php runtime to unlimited
			set_time_limit(0);

			#user type
			///$type =NULL;
			
			// main loop
			#while (true) {

				$this->db->select(array('targets.*','ti.qty','ti.amount','itm.item_type'))->from('targets');
				$this->db->join('target_items ti','targets.id=ti.targets_id');
				$this->db->join('item_type_master itm','ti.item_group_id=itm.id');
				$this->db->where('targets.user_id',$this->session->userdata('id'));
				$this->db->where('targets.seen_status',0);
				$this->db->where('targets.status',1);
				//$this->db->where('targets.accomplish_status',0);
				#$this->db->where('targets.user_type',$type);
				$qry = $this->db->order_by('targets.valid_to','ASC')->get();

				$count = $qry->num_rows();
				$result = array();
				if($count >0){
					
			    	$result = array('count'=>$count);
			    	$result['targets'] = $qry->result();										
				}
				$json = json_encode($result);
			    echo $json;

/*				$last_ajax_call_count = isset($_GET['cc']) ? (int)$_GET['cc'] :-1;

   			
			    // if no timestamp delivered via ajax or data.txt has been changed SINCE last ajax timestamp
			    if ($last_ajax_call_count == -1 || $count != $last_ajax_call_count) {

			    	$result = array('count'=>$count);
			    	$result['targets'] = $qry->result();
			      	
			        // encode to JSON, render the result (for AJAX)
			        $json = json_encode($result);
			        echo $json;

			        // leave this loop step
			        break;

				    } else {
				        // wait for 1 sec (not very sexy as this blocks the PHP/Apache process, but that's how it goes)
				        sleep(1);
				        continue;
				    }
			}*/
		}

	#----------------------------------------------------------
		
		#date : 30-7-2014
		#purpose : get instant new stock request notification
	/*	public function notify_new_request(){


			// set php runtime to unlimited
			set_time_limit(0);

			#user type
			if($this->session->userdata('user_type') == 'employee'){ $type = 'emp'; }
			else if($this->session->userdata('user_type') == 'branch'){ $type = 'branch'; }
			else if($this->session->userdata('user_type') == 'AR'){ $type = 'AR'; }
			else{ $type = 'ace'; } #admin/contractor/engineer

			
			// main loop
			while (true) {

				#$this->db->cache_on();
				$this->db->select(array('sales.*'));
				$this->db->from('sales');
				$this->db->join('users','users.id=sales.user_id');
				$this->db->where('users.company_id',$this->session->userdata('company_id'));
				$this->db->where('final_status',0);
				$this->db->order_by('sales.date_of_delivery','DESC');
				$qry = $this->db->get();
				#$this->db->cache_off();

				//echo $this->db->last_query();	

				
				$count = $qry->num_rows();

				$last_ajax_call_count = isset($_GET['cc']) ? (int)$_GET['cc'] :-1;

   			
			    // if no timestamp delivered via ajax or data.txt has been changed SINCE last ajax timestamp
			    if ($last_ajax_call_count == -1 || $count != $last_ajax_call_count) {

			    	$result = array('count'=>$count);
			    	$result['requests'] = $qry->result();
			      	
			        // encode to JSON, render the result (for AJAX)
			        $json = json_encode($result);
			        echo $json;

			        // leave this loop step
			        break;

				    } else {
				        // wait for 1 sec (not very sexy as this blocks the PHP/Apache process, but that's how it goes)
				        sleep( 1 );
				        continue;
				    }
			}
		}*/

	#----------------------------------------------------------	
		#date:22-09-2014
		#purpose:notify new task;
		public function notify_new_task(){

			/*set_time_limit(0);

			#user type
			if($this->session->userdata('user_type') == 'employee'){ $type = 'emp'; }
			else if($this->session->userdata('user_type') == 'branch'){ $type = 'branch'; }
			else if($this->session->userdata('user_type') == 'AR'){ $type = 'AR'; }
			else{ $type = 'ace'; } #admin/contractor/engineer
*/
			
			// main loop
			#while (true) {

				$this->db->select('tasks.*');
				$this->db->from('employee_tasks tasks');
				$this->db->where('employee_id',$this->session->userdata('id'));
				$this->db->where('status',1);
				$this->db->where('seen_status',0);
				$this->db->order_by('task_date','ASC');
				$qry = $this->db->get();

				//echo $this->db->last_query();	

				$result=array();
				$count = $qry->num_rows();
				if($count >0){
			    	$result = array('count'=>$count);
			    	$result['tasks'] = $qry->result();
			    	$result['current_count'] = $count;
			    	//$result['last_count'] = $last_ajax_call_count;
			      	
			        // encode to JSON, render the result (for AJAX)
			        
			        
				}
				$json = json_encode($result);
				echo $json;	

/*				$last_ajax_call_count = isset($_GET['cc']) ? (int)$_GET['cc'] :-1;

   			
			    // if no timestamp delivered via ajax or data.txt has been changed SINCE last ajax timestamp
			    if ($last_ajax_call_count == -1 || $count != $last_ajax_call_count) {

			    	$result = array('count'=>$count);
			    	$result['tasks'] = $qry->result();
			    	$result['current_count'] = $count;
			    	$result['last_count'] = $last_ajax_call_count;
			      	
			        // encode to JSON, render the result (for AJAX)
			        $json = json_encode($result);
			        echo $json;

			        // leave this loop step
			        break;

				    } else {
				        // wait for 1 sec (not very sexy as this blocks the PHP/Apache process, but that's how it goes)
				        sleep(1);
				        continue;
				    }
			}*/

		}
	#-----------------------------------------------------------


	#=========================================================
	
	public function notify_request_update(){
		
		$jsonArray = array();
		$this->db->select(array('id','request_no','request_date'));
		$this->db->from('dms_purchase_requests');
		$this->db->where(array('requested_by'=>$this->createdBY,'req_status >='=>2,'status'=>1,'seen_status'=>0));
		$this->db->where("request_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$this->db->order_by('request_date','DESC');
		$qry = $this->db->get();
		$count = $qry->num_rows();
		if($count >0){
			$jsonArray['count'] = $count;
			$jsonArray['requests'] = $qry->result_array();
			echo json_encode($jsonArray);
		}else{
			die;
		}
	}
	
	#=========================================================
	
		public function notify_new_request(){

			$json = NULL;
			$this->db->select(array('id'));
			$this->db->from('dms_purchase_requests');
			$this->db->where(array('requested_to'=>$this->branchID,'req_status'=>0,'status'=>1));
			$this->db->where("request_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
			$this->db->order_by('request_date','DESC');
			$qry = $this->db->get();
			$count = $qry->num_rows();

			if($count >0){
			    	$result = array('count'=>$count);
			    	$result['requests'] = "$count new request[s] found !";
			        $json = json_encode($result);
			}
			echo $json;
		}

		#===============================================
		
		public function notify_new_purchase(){

			$count=0;$json = NULL;
			$mainBranch = $this->dms->get_main_branch();# get main branch id
			$args = array();
			$args['columns'] = array('id','branch_id','designation_id','department_id');
			$args['conditions'] = array('id'=>$this->createdBY);
			$userDetails = $this->dms->get_users($args)[$this->createdBY];

			if(!empty($userDetails)){
				$departmentID = $userDetails['department_id'];
				$designationID = $userDetails['designation_id'];
				$userBranch = $userDetails['branch_id'];
				if($designationID == 3){
					$user_type = 3;
				}else{
					$user_type = 1;
				}
			}
			$this->load->model('sales/Sales_model','sales');
			$conditions = array('branch_id'=>$mainBranch,'customer_type_id'=>$user_type,'customer_id'=>$userBranch,'bill_status'=>0,'status'=>1);

			$args = array();
			$args['columns'] = array('id');
			$args['numrows'] = 1;
			$args['conditions'] = $conditions;
			$count = $this->sales->get_bills($args);
			if($count >0){
			    	$result = array('count'=>$count);
			        $json = json_encode($result);
			}
			echo $json;
						
		}
		
	#-------------------------------------------------------------------------------------------
	
		public function notify_new_delivery_notes(){
		
			$count=0;$json = NULL;
			$mainBranch = $this->dms->get_main_branch();
			$args = array();
			$args['columns'] = array('id','branch_id','designation_id','department_id');
			$args['conditions'] = array('id'=>$this->createdBY);
			$userDetails = $this->dms->get_users($args)[$this->createdBY];

			if(!empty($userDetails)){
				$departmentID = $userDetails['department_id'];
				$designationID = $userDetails['designation_id'];
				$userBranch = $userDetails['branch_id'];
				if($designationID == 3){
					$user_type = 3;
				}else{
					$user_type = 1;
				}
			}

			$this->load->model('sales/Delivery_note_model','delivery_note');
			$conditions = array('branch_id'=>$mainBranch,'customer_type_id'=>$user_type,'customer_id'=>$userBranch,'bill_status'=>0,'status'=>1);
			
			$args = array();
			$args['columns'] = array('id');
			$args['numrows'] = 1;
			$args['conditions'] = $conditions;
			$count = $this->delivery_note->get_bills($args);
			if($count >0){
			    	$result = array('count'=>$count);
			        $json = json_encode($result);
			}
			echo $json;
		}
	
	#--------------------------------------------------------------------------------------------
	
	public function notify_sales_return_requests(){
		
		$json = NULL;
		$this->load->model('purchase/Purchase_return_model','purchase_return');
		$count=0;
		$args = array();
		$args['columns'] = array('id');
		$args['numrows'] = 1;
		$args['conditions'] = array('vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID,'p_status'=>0,'status'=>1,'bill_status'=>0);
		$count = $this->purchase_return->get_bills($args);		
		
		if($count >0){
				$result = array('count'=>$count);
				$result['requests'] = "$count new sales return request[s] found !";
				$json = json_encode($result);
		}
		echo $json;
	}
	
	#-------------------------------------------------------------------------------------------
	
	public function notify_new_receipt_abs(){
		
		$count=0;
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$args = array();
		$args['select'] = array('dvab.id');
		$args['conditions'] = array('dvab.customer_type_id'=>0,'dvab.customer_id'=>$this->branchID,'dvab.bill_status'=>0,'dvab.status'=>1);
		$args['num_rows'] = 1;
		$row_count = $this->receipt_against_bill->get($args);	
		if($row_count >0){
				$count = $row_count;
		}
		echo json_encode(array('count'=>$count));
	}
	
	#------------------------------------------------------------------------------------------
	public function notify_stock_transfer_request(){
		$this->load->model('godown/Godown_model','godown');
		$this->load->model('stocks/Stock_transfer_model','stocktransfer');
		$branchID = $this->session->userdata('under_id');
		$this->load->model('godown/Godown_model','godown');
		$godowns = $this->godown->listing(array('conditions'=>array('branch_id'=>$branchID)));
		$goDownIDs = array_keys($godowns);
		$count = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.seen_status'=>0,'stk_trs.st_status'=>0,'stk_trs.branch_id !='=>$branchID),'togodown'=>$goDownIDs,'numrows'=>1));
		//echo $count; die;
		$result=array();
		if($count >0){
				$result = array('count'=>$count);
				/*$json = json_encode($result);
				echo $json;*/
		}
		$json = json_encode($result);
		echo $json;	


	}
	#------------------------------------------------------------------------------------------
	
	public function get_new_rejection_ins(){
		
		$count=0;
		$this->load->model('purchase/Rejection_out_model','rejection_out');
		$args = array();
		$args['columns'] = array('id');
		$args['conditions'] = array('vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID,'p_status'=>0,'status'=>1,'bill_status'=>0);
		$args['numrows'] = 1;
		$row_count = $this->rejection_out->get_bills($args);	
		if($row_count > 0){
				$count = $row_count;
		}
		echo json_encode(array('count'=>$count));
	}
	
	#------------------------------------------------------------------------------------------
	
	
	}

?>