<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_return_ajax extends MY_Controller
{
	public function get_next_bill()
	{
		$vtype = $this->input->get('vtype');
		$this->load->library('Stock');
		$this->load->model('purchase/Purchase_return_model','purchase');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$result_array = $this->purchase->next_bill_no($vtype);
		$result_array['bill_date'] = cdateFormat($result_array['bill_date']);
		$result_array['bill_prefix'] = $this->stock->get_voucher_prefix($vtype);
		echo json_encode($result_array);
	}

	/*public function get_next_bill_no()
	{
		$vtype = $this->uri->segment(4);
		$this->load->model('purchase/Receipt_note_model','receipt');
		$bill_no = $this->receipt->next_bill($vtype);
		echo $bill_no;
	}

	public function get_receipt_next_bill()
	{
		$vtype = $this->input->get('vtype');
		$this->load->model('purchase/Receipt_note_model','purchase');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$result_array = $this->purchase->next_bill_no($vtype);
		$result_array['bill_date'] = cdateFormat($result_array['bill_date']);
		echo json_encode($result_array);
	}*/

	public function get_vendors()
	{
		$bill_no = $this->input->get('bill_no');
		$this->load->model('purchase/Purchase_return_model','purchase');
		if(!empty($bill_no)){
			$vendors = $this->purchase->get_vendor($bill_no);
		}
		else{
			if($this->dms->branch_type()){
				$this->load->library('Stock');
				$vendors = $this->stock->get_vendors();
			}
			else{
				$vendors[$this->dms->get_main_branch()] = $this->dms->get_main_branch('',1);
			}
		}
		echo json_encode($vendors);
	}

	public function get_items()
	{
		$bill_no = $this->input->get('bill_no');
		if(!empty($bill_no)){
			$this->load->model('purchase/Purchase_return_model','purchase');
			$items = $this->purchase->get_bill_items($bill_no);
                        if(empty($items))
                        {
                             $items=$this->purchase->get_bill_itemss($bill_no);

                        }  
		}
		else{
			$this->load->library('Stock');
			$items = $this->stock->get_stock_items(array('id','item_code','item_name'));
		}
		echo json_encode($items);
	}

	#-----------------------------------------------------------------------------------------

	public function view_return_bill(){

		$return_id = $this->uri->segment(4);
		if(!empty($return_id)){

			$this->load->model('purchase/Purchase_return_model','purchase_return');
			$this->load->model('vouchers/Voucher_model','vouchers');
			$this->load->library('Stock');
			$purchase_array = $this->purchase_return->get_purchases(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.payment_mode','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' =>$return_id,'a.status !=' => 0,'b.status !=' => 0,'a.branch_id'=>'')));
			if(!empty($purchase_array)){

				$presumptive_tax = $this->stock->get_tax_type();
				$purchase_cst = $this->purchase_return->get_cst($purchase_array[0]['group_id']);
				$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);
				$payment_mode = $this->stock->ledger_name($purchase_array[0]['payment_mode']);
				#--------------cheque / dd details
				$cd_status = 1;$ccd = $cd_no = $pdc = "";
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_purchase_returns','a.table_group_id' => $purchase_array[0]['group_id'],'a.branch_id'=>'')));


				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}
				$vendors = array();
				$return_bill_no = "";
				if($purchase_array[0]['return_bill_no'] > 0){
					$return_bill_no = $this->purchase_return->get_bill_no($purchase_array[0]['return_bill_no']);
				}
				$requested_branch_id = $purchase_array[0]['vendor_id'];
				$requested_by = $this->stock->get_customer(1,$requested_branch_id);
				$vendors[$requested_branch_id] = $requested_by;
				$this->load->view('purchase/purchase_return/view',array('purchase_array' => $purchase_array,'return_bill_no' => $return_bill_no,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'vendors' => $vendors,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc));
			}else{
				die('No input file specified !');
			}

		}else{
			die('No input file specified !');
		}
	}

	#-----------------------------------------------------------------------------------------
}