<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_ajax extends MY_Controller
{
	public function get_next_bill()
	{
		$vtype = $this->input->get('vtype');
		$this->load->library(array('Stock'));
		$this->load->model('sales/Sales_model','sales');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$result_array = $this->sales->next_bill_no($vtype);
		$result_array['bill_date'] = cdateFormat($result_array['bill_date']);
		$result_array['bill_prefix'] = $this->stock->get_voucher_prefix($vtype);
		echo json_encode($result_array);
	}

	public function get_next_bill_no()
	{
		$vtype = $this->uri->segment(4);
		$this->load->model('sales/Delivery_note_model','delivery');
		$bill_no = $this->delivery->next_bill($vtype);
		echo $bill_no;
	}

	public function get_delivery_next_bill()
	{
		$vtype = $this->input->get('vtype');
		$this->load->library(array('Stock'));
		$this->load->model('sales/Delivery_note_model','sales');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$result_array = $this->sales->next_bill_no($vtype);
		$result_array['bill_date'] = cdateFormat($result_array['bill_date']);
		$result_array['bill_prefix'] = $this->stock->get_voucher_prefix($vtype);
		echo json_encode($result_array);
	}

	#------------------------------------------------------------------------------------------

	public function view_bill(){

		$sales_id = $this->uri->segment(4);
		if(!empty($sales_id)){
			$cd_status = 1;$ccd = $cd_no = $pdc = "";
			$this->load->model('sales/Sales_model','sales');
			$this->load->model('vouchers/Voucher_model','vouchers');
			$this->load->library('Stock');
			$this->load->model('customers/Customer_type_model','customer_type');

			$sales_array = $this->sales->get_sales(array('columns' => array('a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $sales_id,'a.branch_id'=>'')));

			if(!empty($sales_array)){

				$presumptive_tax = $this->stock->get_tax_type();
				$sales_cst = $this->sales->get_cst($sales_array[0]['group_id']);
				$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
				$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
				$user_type = $this->dms->get_desig($sales_array[0]['user_id'],1);
				$user = $this->dms->get_user_name($sales_array[0]['user_id']);
				$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
				$area_id = $this->dms->get_area($sales_array[0]['area_id']);
				$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);

				$cd_status = 1;$ccd = $cd_no = $pdc = "";
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_sales','a.table_group_id' => $sales_array[0]['group_id'])));
				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}
				$this->load->view('sales/sales_entry/view',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'user_type' => $user_type['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc));

			}else{
				die('No input file specified !');
			}
		}else{
			die('No input file specified !');
		}
	}

	#---------------------------------------------------------------------------

	public function view_delivery_note(){

		$dnote_id = $this->uri->segment(4);

		if(!empty($dnote_id)){

			$this->load->model('sales/Delivery_note_model','delivery_note');
			$this->load->model('vouchers/Voucher_model','vouchers');
			$this->load->library('Stock');
			$this->load->model('customers/Customer_type_model','customer_type');

			$dnote_array = $this->delivery_note->get_sales(array('columns' => array('a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $dnote_id,'a.branch_id'=>'')));

			if(!empty($dnote_array)){

				$presumptive_tax = $this->stock->get_tax_type();
				$sales_cst = $this->delivery_note->get_cst($dnote_array[0]['group_id']);
				$voucher_type = $this->vouchers->voucher_name($dnote_array[0]['vtype_id']);
				$customer_name = $this->stock->get_customer($dnote_array[0]['customer_type_id'],$dnote_array[0]['customer_id']);
				$user_type = $this->dms->get_desig($dnote_array[0]['user_id'],1);
				$user = $this->dms->get_user_name($dnote_array[0]['user_id']);
				$pricelist = $this->customer_type->get_pricelist($dnote_array[0]['pricelist_id']);
				$area_id = $this->dms->get_area($dnote_array[0]['area_id']);
				$this->load->view('sales/delivery_note/view',array('sales_array' => $dnote_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'user_type' => $user_type['designation_name'],'user' => $user,'pricelist' => $pricelist,'area_id' => $area_id));

			}else{
				die('No input file specified !');
			}
		}else{
			die('No input file specified !');
		}
	}
	#---------------------------------------------------------------------------
}