<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Stock_ajax extends MY_Controller{

    #---------------------------------------------------demo
		public function get_items(){

			$v = $this->input->get('vendor_id'); 
		    $this->load->model('purchase/Purchase_model','purchase');
			$ars = $this->purchase->find_item($v);
			if(!empty($ars))
			{
	            echo json_encode($ars);
			}
			    
		}
	
	#---------------------------------------------------demo

	public function get_primary_unit(){

		$itemID = $this->uri->segment(4);
		$this->load->library('Stock');
		$itemPrimaryUnits = $this->stock->get_primary_unit($itemID);
		if(!empty($itemPrimaryUnits)){
			echo '<span title="'.$itemPrimaryUnits['formal_name'].'"> '.$itemPrimaryUnits['symbol'].'</span>';
		}else{
			echo NULL;
		}

	}

	#--------------------------------------------------------------
	
	public function get_all_items(){
	    
	    $q = $this->input->get('search');
	    
	    $this->load->library('Stock');
	    $json = [];
	    
		$data = $this->stock->get_all_items($q);
		$cnt = count($data);
		foreach($data as $dat)
		{
		    $iname = $dat['item_code'].' / '.$dat['item_name'].'/'.$dat['model_no'];
		    
		    $json[] = array('id'=>$dat['id'], 'text'=>$iname);
		}
		
		echo json_encode(array('total_count'=>$cnt,'items'=>$json));
	}
	
	public function get_all_items_purchase(){
	    
	    $q = $this->input->get('search');
	    
	    $this->load->library('Stock');
	    $json = [];
	    
		$data = $this->stock->get_all_items($q);
		$cnt = count($data);
		foreach($data as $dat)
		{
		    $iname = $dat['item_code'].' / '.$dat['item_name'].'/'.$dat['model_no'];
		    
		    $json[] = array('id'=>$dat['id'], 'text'=>$iname);
		}
		
		echo json_encode(array('total_count'=>$cnt,'items'=>$json));
	}
	
	public function get_voucher_items(){
	    
	    $skey = $this->input->get('search');
	    $vtype = $this->input->get('vtype');
	    
	    $this->load->library('Stock');
	    $json = [];
	    
		$datas = $this->stock->get_voucher_items_key($vtype,$skey);
		$count = count($datas);
		foreach($datas as $data){
		    $iname = $data['item_code'].' / '.$data['item_name'].' / '.$data['model_no'];
		    $json[] = array('id'=>$data['id'], 'text'=>$iname);
		}
		
		echo json_encode(array('total_count'=>$count,'items'=>$json));
	}

	public function get_item_godowns(){

		$itemID = $this->input->get('item_id');
		$this->load->library('Stock');
		$godowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
		
		$fgodwn = $this->stock->get_first_godown(array('item_id'=>$itemID));
		
		echo json_encode(array($godowns,$fgodwn));

	}
	public function get_item_godowns1(){

		$itemID = $this->input->get('item_id');
		$this->load->library('Stock');
		$godowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
		
		echo json_encode(array($godowns));

	}

	#-------------------------------------------------------------

	public function get_item_units(){

		$itemID = $this->input->get('item_id');
		$this->load->library('Stock');
		$units = $this->stock->get_units($itemID);
		reset($units);
		$primary_key = key($units);
		$units_array = array($units,$primary_key);
		echo json_encode($units_array);
	}

        #-------------------------------------------------------------

        public function get_unit_name(){

		$unitID = $this->input->get('unit_id');
		$this->load->library('Stock');
		$units = $this->stock->get_symbol($unitID);
		reset($units);
		$primary_key = key($units);
		$units_array = array($units,$primary_key);
		echo json_encode($units_array);
	}

	#-------------------------------------------------------------

	public function get_item_group_units(){

		$item_group_id = $this->input->get('item_group_id');
		$this->load->library('Stock');
		$units = $this->stock->get_item_group_units($item_group_id);
		reset($units);
		$primary_key = key($units);
		$units_array = array($units,$primary_key);
		echo json_encode($units_array);
	}

	#--------------------------------------------------------------

	public function get_users(){

		$user_type = $this->input->get('user_type');
		$this->load->library('Dms');
		$users = $this->dms->get_users(array('conditions'=>array('designation_id'=>$user_type,'branch_id'=>$this->session->userdata('under_id'))));
		echo json_encode($users);

	}

	#--------------------------------------------------------------

	public function get_so_dis_amt(){

		$discPercent = $this->input->get('disc_per');
		$amount = $this->input->get('amount');
		$discAmt = ($amount*$discPercent)/100;
		$vat = 0;
		if($this->input->get('vat')){
			$vat = round_this((($amount - $discAmt) * $this->input->get('vat')) / 100);
		}
		echo json_encode(array(round_this($discAmt),$vat));
	}

	#-------------------------------------------------------------

	public function get_so_dis_per(){

		$discAmt = $this->input->get('disc_amt');
		$amount = $this->input->get('amount');
		$discPer=0;
		if(!empty($amount)){
			$discPer = ($discAmt*100)/$amount;
		}
		$vat = 0;
		if($this->input->get('vat')){
			$vat = round_this((($amount - $discAmt) * $this->input->get('vat')) / 100);
		}
		echo json_encode(array(round_this($discPer),$vat));
	}

	#-------------------------------------------------------------

	public function get_so_bill_dis_amt(){

		$disPercent = $this->input->get('disc_per');
		$totalBillNetAmount = $this->input->get('total');

		if($disPercent <= 100){
			$discAmount = ($totalBillNetAmount*$disPercent)/100;
		}else{
			$discAmount = ($totalBillNetAmount*100)/100;
		}

		$discAmount = round_this($discAmount);
		if($discAmount <= $totalBillNetAmount){
			$gnTotalAmount = $totalBillNetAmount-$discAmount;
		}else{
			$gnTotalAmount = 0;
		}
		echo json_encode(array(0=>$discAmount,1=>numberFormat(get_rounded($gnTotalAmount)),2=>numberFormat(round_off($gnTotalAmount))));

	}

	#-------------------------------------------------------------

	public function get_so_bill_dis_per(){

		$discAmount = ($this->input->get('disc_amt'));
		$totalBillNetAmount = $this->input->get('total');
		$discPer=0;
		if($discAmount <= $totalBillNetAmount)
		{
			$discPer = ($discAmount*100)/$totalBillNetAmount;
		}
		$gnTotalAmount = $totalBillNetAmount-$discAmount;
		echo json_encode(array(0=>$discPer,1=>numberFormat(get_rounded($gnTotalAmount)),2=>numberFormat(round_off($gnTotalAmount))));

	}

	#-------------------------------------------------------------

	public function get_rounded_amount(){

		$roundBy = $this->input->get('round');
		$GnTotalAmount = $this->input->get('total');
		$gnTotal = ($GnTotalAmount-$roundBy);
		echo json_encode(array($gnTotal));

	}

	#-------------------------------------------------------------


	public function get_item_rate(){

		$itemID = $this->uri->segment(4);
		$this->load->library('Stock');
		$rate = $this->stock->get_item_rate($itemID);
		echo $rate;

	}
	
	public function get_item_det()
	{
	    $itemID = $this->input->get('item_id');
		$this->load->library('Stock');
		$item_det = $this->stock->get_item($itemID,array('item_name','model_no','hsn'));
		echo json_encode(array(0=>$item_det['item_name'],1=>$item_det['model_no'],2=>$item_det['hsn']));
	}

    public function get_item_rates(){

        $user_id = $this->session->userdata('id');
		$itemID = $this->input->get('item_id');
		$this->load->library('Stock');
		$rate = $this->stock->get_item_rate($itemID);
		$item = $this->stock->get_item($itemID,array('item_code','item_group_id'));
		$group = $item['item_group_id'];
		$v =1;
		if($group == 11 || $group == 4 || $group == 12 || $group == 16 || $group == 17)
		{
		 $v =2;
		}
		else if($group == 15 || $group == 14)
		{
		   $v = 3;
		}
		$code = substr($item['item_code'],0,$v);
        echo json_encode(array($group,$rate,$user_id,$code));
	}

    public function get_item_hsn(){

		$itemID = $this->uri->segment(4);
        $this->load->library('Stock');
		$hsn = $this->stock->get_item_hsn($itemID);		               		
		echo $hsn;
	}

    public function get_group_hsn(){

		$groupID = $this->uri->segment(4);
        $this->load->library('Stock');
		$hsn = $this->stock->get_group_hsn($groupID);		               		
		echo $hsn;
	}
	#--------------------------------------------------------------

	public function get_customers(){

		$custType = $this->input->get('cust_type');
		$customers = array();
		$customers[0] = array();
		$customers[1] = array();
		if($custType ==1){
			$this->load->model('branches/Branch_model','branches');
			$customers[0] = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
		}else if($custType ==2){
			$this->load->model('customers/Customer_master_model','customer_master');
			$customers[0] = $this->customer_master->listing();
			#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
			$this->load->model('designations/Designation_master_model','designations');
			$customers[1] = $this->designations->listing(array('utype_status'=>1));
		}else if($custType ==3){
			$this->load->model('retailers/Counter_model','retailer_master');
			$customers[0] = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
		}else{
			$customers[0] = array();
		}
		echo json_encode($customers);

	}

	#-----------------------------------------------------------------------------

	public function get_stock_bal()
	{
		$item_id = $this->uri->segment(4);
		$bill_date = date('Y-m-d',strtotime($this->uri->segment(5))); 
		$branch_id = $this->session->userdata('under_id');
		$this->load->library('Stock');
		$godown_id = $this->stock->get_branch_godown($branch_id);     
		$stock_count = $this->stock->get_stock_count($godown_id,$item_id,$bill_date);

		#------------primary unit details
		$primary_unit = $this->stock->get_primary_unit($item_id);
		if($stock_count > 0)
		{
		    echo $stock_count." ".$primary_unit['symbol'];
		}
		else
		{
		    echo "Out of Stock";
		}
	}
    
    public function get_stock_bal1()
	{
		$godown_id = 2;               
		$item_id = $this->uri->segment(4);
		$bill_date = date('Y-m-d');                
		$this->load->library('Stock');
		$stock_count = $this->stock->get_stock_count($godown_id,$item_id,$bill_date);		
		echo $stock_count;
	}
	
	public function get_product_stock()
	{
	    
		$skey = ($this->input->get('skey'))?$this->input->get('skey',true):$this->uri->segment(4);
		//$skey = $this->input->get('skey');
        
		$this->load->library('Stock');
		$this->load->library('Pagination');
		$config['per_page'] = 5;
		$items1 = $this->stock->get_search_items($skey);
		$config['total_rows'] = count($items1);
		$config['base_url'] = base_url('products/search/skey/'.$skey);
		$config['uri_segment'] = 5;
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
		$items = $this->stock->get_search_items_per($skey,$offset,$config['per_page']);
	
	    $this->load->view('products/search/search_result',array('items'=>$items,'links'=>$links));
	}

        #----------------------------------------------------------------------------

        public function get_tpoint()
	{
		$cust_id = $this->uri->segment(4);
		$total_point=$this->db->select('point')->from('customer_total_point')->where('cid',$cust_id)->get()->row_array();
                $total_points = $total_point['point'];		
		echo $total_points;
	}


	#---------------------------------------------------------------

	public function show_stock_ajax_data(){

		$stock_adjust_id  = $this->input->get('stk_adjust_id');
		#get details of stock adjustemnts;
		$this->load->model('stocks/Stock_adjustment_model','stockadjust');
		$stock_adjust = $this->stockadjust->get_all_stock_adust_data(array('conditions'=>array('stk_adj.id'=>$stock_adjust_id)))[0];
		#get details of stock adjust items for stock adjust id;
		$stock_items = $this->stockadjust->get_all_stock_adust_items(array('conditions'=>array('stk_adj_itm.adjustment_id'=>$stock_adjust_id)));
		$this->load->view('products/stocks/adjustment/show_adjustment',array('stock_adjust'=>$stock_adjust,'stock_items'=>$stock_items));

	}

	#---------------------------------------------------------------

	public function get_rounded(){
		$gnTotalAmount = $this->input->get('amount');               
		$round_off = numberFormat(round_off($gnTotalAmount));
		$gnTotalAmount = numberFormat(get_rounded($gnTotalAmount));
                
		echo json_encode(array(0=>$gnTotalAmount,1=>$round_off));
	}

	#---------------------------------------------------------------

	public function get_rounded_rate(){
		$uri_array = $this->uri->uri_to_assoc(4);
		$rate = 0;$vat = 0;
		if(isset($uri_array['amount']) && !empty($uri_array['amount'])){
			$rate = $uri_array['amount']/$uri_array['qty'];
			if(isset($uri_array['vat']) && !empty($uri_array['vat'])){
				if(isset($uri_array['discount'])){
					$uri_array['amount'] -=$uri_array['discount'];
				}
				$vat  = round_this(($uri_array['amount'] * $uri_array['vat'])/100);
			}
		}
		$round_off = round_this($rate);
		echo json_encode(array('round' => $round_off,'vat' => $vat));
	}

	#---------------------------------------------------------------

	public function get_rounded_amt(){
		$uri_array = $this->uri->uri_to_assoc(4);
		$amount = 0;$vat = 0;
		if(isset($uri_array['rate']) && !empty($uri_array['rate'])){
			$amount = $uri_array['rate'] * $uri_array['qty'];
			if(isset($uri_array['vat']) && !empty($uri_array['vat'])){
				$vat  = round_this(($amount * $uri_array['vat'])/100);
			}
		}
		$round_off = round_this($amount);
		echo json_encode(array('round' => $round_off,'vat' => $vat));
	}

	public function get_qty_rate_amt()
	{
		$rate = $this->input->get('rate');
		$qty = $this->input->get('qnty');
		$cess = $this->input->get('cess');
		$amount = ($qty*$rate);
		$vat = 0; $cess_amt=0;
		if($this->input->get('vat'))
		{
			$vat = round_this(($amount * $this->input->get('vat')) / 100);
		}
		if($cess)
		{
			$cess_amt = round_this(($amount * $cess) / 100);
		}
		
		echo json_encode(array(round_this($amount),$vat,$cess_amt));
	}
	
	public function get_tax_amt()
	{
	    $rate = $this->input->get('rate');
		$qty = $this->input->get('qnty');
		$gst = $this->input->get('gst');
		$cess = $this->input->get('cess');
		$amount = ($qty*$rate);
		
		$taxable = ($amount*100)/(100+(2*$gst)+$cess);
		
		$gst_amt = 0; $cess_amt=0;
		$gst_amt = round_this(($taxable * $gst) / 100);
		$cess_amt = round_this(($taxable * $cess) / 100);
		
		echo json_encode(array(round_this($amount),$gst_amt,$cess_amt));
	}
    
    public function get_customer()
	{
		$mob = $this->input->get('mob');		
		$cust_qr=$this->db->select(array('fname','lname','address','email_id'))->from('customer_master')->where('mobile_no',$mob)->get()->row_array();
        $customer = $cust_qr['fname']." ".$cust_qr['lname'];	
        $address = $cust_qr['address'];
        $mailid = $cust_qr['email_id'];
        
		
		echo json_encode(array(0=>$customer,1=>$address,2=>$mailid));
	}

        public function get_match_items(){ 

		$dv1 = $this->input->get('dv1'); 
                $dv2 = $this->input->get('dv2');
		$dv3 = $this->input->get('dv3');
                $dv4 = $this->input->get('dv4');
		$nv1 = $this->input->get('nv1');
                $nv2 = $this->input->get('nv2');
		$nv3 = $this->input->get('nv3');
                $nv4 = $this->input->get('nv4');
                $radd = $this->input->get('radd'); 
            
                $cond=array();
              
                if($dv1 != '' && $dv1 != '0')
                {
                      $cond['dv1']=$dv1;
                }
                if($dv2 != '' && $dv2 != '0')
                {
                      $cond['dv2']=$dv2;
                }
                if($dv3 != '' && $dv3 != '0')
                {
                      $cond['dv3']=$dv3;
                }
                if($dv4 != '' && $dv4 != '0')
                {
                      $cond['dv4']=$dv4;
                }
                if($nv1 != '' && $nv1 != '0')
                {
                      $cond['nv1']=$nv1;
                }
                if($nv2 != '' && $nv2 != '0')
                {
                      $cond['nv2']=$nv2;
                }
                if($nv3 != '' && $nv3 != '0')
                {
                      $cond['nv3']=$nv3;
                }
                if($nv4 != '' && $nv4 != '0')
                {
                      $cond['nv4']=$nv4;
                }
                if($radd != '' && $radd != '0')
                {
                      $cond['padd']=$radd;
                }                
		 
                $this->load->library('Stock');
                $args['select'] = array('id','item_code','item_name');
                $args['conditions']= $cond;
		$items =$this->stock->get_stock_items($args);               		
		echo json_encode($items);

	}
      
      #-----------------------------------------------------------------------------------------demo
        public function get_itemsofsales(){ 

                $cond=array();
                $this->load->library('Stock');
                $cond['item_types!='] = 'medicine';
                $args['select'] = array('id','item_code','item_name');
                $args['conditions']= $cond;
	        	$items =$this->stock->get_stock_items($args);               		
		echo json_encode($items);

	}
	
	public function get_itemsofmed(){ 

                $cond=array();
                $this->load->library('Stock');
                $cond['item_types'] ='medicine';
                $args['select'] = array('id','item_code','item_name');
                $args['conditions']= $cond;
	        	$items =$this->stock->get_stock_items($args);               		
		echo json_encode($items);

	}
	public function get_single_item(){ 
                $cond=array();
                $i = $this->input->get('item'); 
                $this->load->library('Stock');
                $cond['id'] =$i;
                $args['select'] = array('id','item_code','item_name');
                $args['conditions']= $cond;
                $item = $this->stock->get_single_item($args);
	        	echo json_encode($item);

	}
      #-----------------------------------------------------------------------------------------demo
        public function get_lens_items(){ 

		$dia = $this->input->get('dia'); 
                $tint = $this->input->get('tint');
		$coat = $this->input->get('coat');
                $pow = $this->input->get('pow');
		$lwid = $this->input->get('lwid');
                $mat = $this->input->get('mat');                
		$manu = $this->input->get('manu');
                $lrate = $this->input->get('lrate');
                $hrate = $this->input->get('hrate');                 
            
                $cond=array();
                $cond['item_types']='lens';
              
                if($dia != '' && $dia != '0')
                {
                      $cond['diametre']=$dia;
                }
                if($tint != '' && $tint != '0')
                {
                      $cond['tint']=$tint;
                }
                if($coat != '' && $coat != '0')
                {
                      $cond['coating']=$coat;
                }
                if($pow != '' && $pow != '0')
                {
                      $cond['lpower']=$pow;
                }
                if($lwid != '' && $lwid != '0')
                {
                      $cond['lwidth']=$lwid;
                }
                if($mat != '' && $mat != '0')
                {
                      $cond['material']=$mat;
                }
                if($manu != '' && $manu != '0')
                {
                      $cond['item_manufacturer_id']=$manu;
                }                           
		
                $this->load->library('Stock');
                //$args['select'] = array('id','item_code','item_name');
                $args['conditions']= $cond;
                $args['lrate'] = $lrate;
                $args['hrate'] = $hrate;
		$items =$this->stock->get_stock_count_items($args);               		
		echo json_encode($items);

	}
        public function get_frame_items(){ 

		$bwid = $this->input->get('bwid'); 
                $alen = $this->input->get('alen');
		$gend = $this->input->get('gend');
                $shap = $this->input->get('shap');
		$col = $this->input->get('col');
                $ftype = $this->input->get('ftype');
                $size = $this->input->get('size');
		$manu = $this->input->get('manu');                 
            
                $cond=array();
                $cond['item_types']='frame';
                if($bwid != '' && $bwid != '0')
                {
                      $cond['bwidth']=$bwid;
                }
                if($alen != '' && $alen != '0')
                {
                      $cond['alength']=$alen;
                }
                if($gend != '' && $gend != '0')
                {
                      $cond['gender']=$gend;
                }
                if($shap != '' && $shap != '0')
                {
                      $cond['shape']=$shap;
                }
                if($col != '' && $col != '0')
                {
                      $cond['color']=$col;
                }
                if($ftype != '' && $ftype != '0')
                {
                      $cond['frame_type']=$ftype;
                }
                if($size != '' && $size != '0')
                {
                      $cond['size']=$size;
                }
                if($manu != '' && $manu != '0')
                {
                      $cond['item_manufacturer_id']=$manu;
                }                           
		
                $this->load->library('Stock');                
                $args['conditions']= $cond;
		$items =$this->stock->get_stock_count_items($args);               		
		echo json_encode($items);

	}
        public function get_contact_items(){ 

		$ltype = $this->input->get('ltype'); 
                $lcol = $this->input->get('lcol');		
		$manu = $this->input->get('manu');                 
            
                $cond=array();
                $cond['item_types']='contact';
                if($ltype != '' && $ltype != '0')
                {
                      $cond['lens_type']=$ltype;
                }
                if($lcol != '' && $lcol != '0')
                {
                      $cond['clens_color']=$lcol;
                }                
                if($manu != '' && $manu != '0')
                {
                      $cond['item_manufacturer_id']=$manu;
                }                           
		
                $this->load->library('Stock');                
                $args['conditions']= $cond;
		$items =$this->stock->get_stock_count_items($args);               		
		echo json_encode($items);

	}
        public function get_other_items(){ 

		$ocol = $this->input->get('ocol'); 
                $olcol = $this->input->get('olcol');
                $ogend = $this->input->get('ogend');		
		$manu = $this->input->get('manu');                 
            
                $cond=array();
                $cond['item_types']='other';
                if($ocol != '' && $ocol != '0')
                {
                      $cond['ocolor']=$ocol;
                }
                if($olcol != '' && $olcol != '0')
                {
                      $cond['olens_color']=$olcol;
                }     
                if($ogend != '' && $ogend != '0')
                {
                      $cond['ogender']=$ogend;
                }               
                if($manu != '' && $manu != '0')
                {
                      $cond['item_manufacturer_id']=$manu;
                }                           
		
                $this->load->library('Stock');                
                $args['conditions']= $cond;
		$items =$this->stock->get_stock_count_items($args);               		
		echo json_encode($items);

	}
        public function get_pages(){

		$itmgrp = $this->input->get('itgrp');
		$pages = array();$cond=array();$pages1=array();
                $this->load->model('products/Item_model','item');

                $company_id = $this->session->userdata('company_id');
		$cond['company_id'] = $company_id;
		$cond['status'] = 1;
                $cond['item_group_id'] = $itmgrp;
                $pages  = $this->db->select(array('id','item_name','item_code'))->get_where('item_master',$cond)->result_array();
                $count=0;$i=1;
                $pages1[0] = "Page 1";
                foreach($pages as $p)
                {
                        $id = $p['id'];
                        $count++;
                        if($count%300==0)
                        { 
                                $i++;
                                $pages1[$count] = "Page ".$i;                             
                        }
                }
						                 
		echo json_encode($pages1);
	}


        public function get_vendor_items(){

		$vendorID = $this->input->get('vendor_id');
		$this->load->library('Stock');
		$items = $this->stock->get_vendor_items(array('vendor_id'=>$vendorID,'listing'=>1));
		echo json_encode($items);

	}
        public function get_ref_no()
	{		
		$ref_qr=$this->db->select('max(ref_no) as ref')->from('dms_sales')->where('status',1)->get()->row_array();
                $refno= $ref_qr['ref']+1;		
		
		echo json_encode(array(0=>$refno));
	}
	public function get_item_dats(){

		$item_code =  $this->input->get('item_code');
		$this->load->library('Stock');
		$data = $this->stock->get_item_dats($item_code);
		
		$itm = $data['name'];
		$cqty = $data['cqty'];
		$rte = $data['rate'];
		$taxable = $data['taxable'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$css = $data['cess_amt'];
		
		echo json_encode(array(0=>$itm,1=>$cqty,2=>$rte,3=>$taxable,4=>$cgt,5=>$sgt,6=>$css));

	}
	#-------------------------------------------------------------------------------------------------------------------
	
		public function get_item_datsnew(){

		$item_code =  $this->input->get('item_code');
		$this->load->library('Stock');
		$data = $this->stock->get_item_datsnew($item_code);
		
		$itm = $data['name'];
		
		$unit = $data['unit'];
		
		
		echo json_encode(array(0=>$itm,1=>$unit));

	}
	
#-------------------------------------------------------------------------------------------------------------------
	
		public function get_item_stockcount(){

		$item_code =  $this->input->get('item_code');
		$this->load->library('Stock');
		$data = $this->stock->get_item_stockcount($item_code);
		
		$itm = $data['name'];
		$rte = $data['rate'];
		$lcost = $data['landingcost'];
		$unit = $data['unit'];
		
		
		echo json_encode(array(0=>$itm,1=>$rte,2=>$lcost,3=>$unit));

	}	
	
	
	#---------------------------------------------------------------------------------------------------------------------
	public function get_item_purchase(){

		$item_code =  $this->input->get('item_code');
		$this->load->library('Stock');
		$data = $this->stock->get_item_purchase($item_code);
		
		$itm = $data['name'];
		$cqty = $data['cqty'];
		$rte = $data['rate'];
		$amt = $data['amount'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$gnd = $data['grand'];
		
		echo json_encode(array(0=>$itm,1=>$cqty,2=>$rte,3=>$amt,4=>$cgt,5=>$sgt,6=>$gnd));

	}
	
	
	public function get_item_dats1(){

		$item_name =  $this->input->get('item_name');
		$this->load->library('Stock');
		$data = $this->stock->get_item_dats1($item_name);
		
		$itm = $data['code'];
		$cqty = $data['cqty'];
		$rte = $data['rate'];
		$taxable = $data['taxable'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$css = $data['cess_amt'];
		
		echo json_encode(array(0=>$itm,1=>$cqty,2=>$rte,3=>$taxable,4=>$cgt,5=>$sgt,6=>$css));

	}
	
	public function get_item_gscs(){

		$item_code =  $this->input->get('item_code');
		$qty = $this->input->get('qty');
		$rate = $this->input->get('rate');
		$this->load->library('Stock');
		$data = $this->stock->get_item_gscs($item_code,$qty,$rate);
		 
		$taxable = $data['taxable'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$css = $data['cess_amt'];
		$amt = $data['amount'];
		echo json_encode(array(0=>$taxable,1=>$cgt,2=>$sgt,3=>$css,4=>$amt));
	}
#--------------------------------------------------------------------------------------------------------------------------

public function get_item_amount(){

		$item_code =  $this->input->get('item_code');
		$qty = $this->input->get('qty');
		$rate = $this->input->get('rate');
		$this->load->library('Stock');
		$data = $this->stock->get_item_amount($item_code,$qty,$rate);
		 
	/*	$taxable = $data['taxable'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$css = $data['cess_amt'];*/
		$amt = $data['amount'];
		echo json_encode(array(0=>$amt));
	}
#-------------------------------------------------------------------------------------------------------------------------

public function get_item_stockamount(){

		$item_code =  $this->input->get('item_code');
		$qty = $this->input->get('qty');
		$rate = $this->input->get('rate');
		$this->load->library('Stock');
		$data = $this->stock->get_item_stockamount($item_code,$qty,$rate);
		 
	/*	$taxable = $data['taxable'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$css = $data['cess_amt'];*/
		$amt = $data['amount'];
		echo json_encode(array(0=>$amt));
	}
#--------------------------------------------------------------------------------------------------------------------------
	public function get_item_wholesale(){

		$item_code =  $this->input->get('item_code');
		$qty = $this->input->get('qty');
		$rate = $this->input->get('rate');
		$this->load->library('Stock');
		$data = $this->stock->get_item_wholesale($item_code,$qty,$rate);
		 
		$taxable = $data['taxable'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$css = $data['cess_amt'];
		$amt = $data['amount'];
		echo json_encode(array(0=>$taxable,1=>$cgt,2=>$sgt,3=>$css,4=>$amt));
	}
	
	public function get_item_purch(){

		$item_code =  $this->input->get('item_code');
		$qty = $this->input->get('qty');
		$rate = $this->input->get('rate');
		$this->load->library('Stock');
		$data = $this->stock->get_item_purch($item_code,$qty,$rate);
		 
		$amt = $data['amount'];
		$cgt = $data['cgst_amt'];
		$sgt = $data['sgst_amt'];
		$gnd = $data['grand'];
		echo json_encode(array(0=>$amt,1=>$cgt,2=>$sgt,3=>$gnd));
	}
	
	public function get_target_map(){
	    $branch_id = $this->session->userdata('under_id');
	    $branch_det = $this->db->get_where('branch_master',array('id'=>$branch_id))->row_array();
	    if($branch_det['tstatus']==1 && $branch_det['target_a']>0){
	        $targeta = $branch_det['target_a'];
	        $targetb = $branch_det['target_b'];
	        $targetc = $branch_det['target_c'];
	        $max = ($targeta*125)/100;
	        
	        $percentc = round(($targetc/$max)*100);
	        $percentb = round(($targetb/$max)*100);
	        $percenta = round(($targeta/$max)*100);
	        
	        $start = date('Y-m-01');
	        $end = date('Y-m-t');
	        $data = $this->db->query("select sum(vamount) as total from dms_vouchers where branch_id='$branch_id' and status=1 and vdate >= '$start' and vdate <= '$end' and vtype_id in (6,15,16,40,41)")->row_array();
	        $achieve = $collection = $data['total'];
	        if($collection>$max){ $collection=$max; }
	        $percent = round(($collection/$max)*100);
	        $class='';
	        if($collection<=$targetc){
	            $class='#A4FBA4';
	        }else if($collection>$targetc && $collection <=$targetb){
	            $class='#38A638';
	        }else if($collection >$targetb){
	            $class='#0C580C';
	        }
	        
	        $this->load->view('users/target',array('targeta'=>$targeta,'targetb'=>$targetb,'targetc'=>$targetc,'percentc'=>$percentc,'percentb'=>$percentb,'percenta'=>$percenta,'achieve'=>$achieve,'collection'=>$collection,'percent'=>$percent,'class'=>$class));
	    }
	}
}
?>