<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Account_group_report_excel extends MY_Controller{

		public function __construct(){

			parent ::__construct();

		}
	  #----------------------------------------------------------
		public function report(){
			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$sub_group_id = $this->uri->segment(4);
			$from_date = $this->uri->segment(5);
			$to_date = $this->uri->segment(6);

			if(!empty($from_date) && !empty($to_date) && !empty($sub_group_id)){
				$next_date = date('Y-m-d',(strtotime($to_date)+86400));
				
				#---------ledgers of selected sub_group
				$ledger_array = $this->accounts->get_legders(array('columns' => array('a.id','a.ledger_name','a.dc'),'conditions' => array('a.sgroup_id' => $sub_group_id)));
				if(!empty($ledger_array))
				{
					foreach($ledger_array as $key => $value)
					{
						$dr_amount = $cr_amount = 0;
						$opening_bal = 0;//$this->accounts->opening_bal($value['id'],$to_date);
						$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,0,$from_date);
						if($value['dc'] == 'dr')
						{
							$voucher_amount = $opening_bal + ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']);
							if($voucher_amount > 0)
							{
								$dr_amount = $voucher_amount;
							}
							else
							{
								$cr_amount = -$voucher_amount;
							}
						}
						else
						{
							$voucher_amount = $opening_bal + ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']);
							if($voucher_amount > 0)
							{
								$cr_amount = $voucher_amount;
							}
							else
							{
								$dr_amount = -$voucher_amount;
							}
						}
						if($dr_amount > 0 || $cr_amount > 0)
						{
							$voucher_array[$value['id']] = array('ledger_name' => $value['ledger_name'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
						}
					}
				}
				#---------------Excel-------------------------------
				$subgroup_name = $this->accounts->account_group_name($sub_group_id);
				$head = "Account Group Report From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
				$subhead = " Subgroup : ".$subgroup_name;
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);

				$line = $this->my_excel->get_line();
				$line = $line+1;
				$this->my_excel->merge_cell('A'.$line.':D'.$line);
				$this->my_excel->set_cell_value('A'.$line,$subhead);
				$this->my_excel->set_font_size('A'.$line);
				$this->my_excel->set_bold('A'.$line);

				#get start line  line
				$line = $this->my_excel->report_head_line();
				//$line = $line+1;
				$this->my_excel->merge_cell('C'.$line.':D'.$line);
					#merging and styling for head
				$next_line = $line+1;
				$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
				$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
				$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
				$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");

				#first row head
				$headings = array('A'=>'#','B'=>'Particulars','C'=>'Closing Balance');
				$head_width = array('B'=>40,'C'=>50,);
				$this->my_excel->set_report_head($headings,array(),$line,NULL);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(3, 'A' . $line);	
				$line = $line+1;
				#second row width
				$headings = array('C'=>'Debit','D'=>'Credit');
				$head_width = array('C'=>25,'D'=>25);
				$this->my_excel->set_report_head($headings,array(),$line,3);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(5, 'A' . $line);
				$i=1;
	            $line = $line+1;
				$total_dr = $total_cr = 0;
				foreach($voucher_array as $key => $value){
					$this->my_excel->set_cell_value('A'.$line,$i);
					$this->my_excel->set_cell_value('B'.$line, stringFormat($value['ledger_name']));
					$this->my_excel->set_cell_value('C'.$line,$value['dr_amount']);
					$this->my_excel->set_cell_value('D'.$line,$value['cr_amount']);
					#excel styles
					$this->my_excel->set_data_align('A'.$line);
					$this->my_excel->set_wrap_text('B'.$line);	
					$this->my_excel->number_format('C'.$line);
					$this->my_excel->number_format('D'.$line);
					$i++;
					$line++;

					$total_dr += $value['dr_amount'];
					$total_cr += $value['cr_amount'];

				}
				#total value calcularion
				$this->my_excel->merge_cell('A'.$line.':B'.$line);
				$this->my_excel->set_cell_value('A'.$line,'Grand Total');
				$this->my_excel->set_data_align('A'.$line,"R");
				$this->my_excel->set_cell_value('C'.$line,$total_dr);
				$this->my_excel->set_cell_value('D'.$line,$total_cr);
				$this->my_excel->number_format('C'.$line);
				$this->my_excel->number_format('D'.$line);
				$this->my_excel->set_bold('A'.$line.':D'.$line);
				$this->my_excel->set_border('A4:D'.$line);
				$this->my_excel->output_excel();


			}
			else{
				echo "<script>alert('".$this->lang->line('invalid-account-group-report')."');window.close();</script>";
			}

		}
	  #----------------------------------------------------------
	}
?>