<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Customer_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');   

	}

	public function customer_data()
	{
		$this->load->model('customers/Customer_master_model','customer');
		$this->load->library(array('Stock'));
		
		$from_date = $to_date = $cur_date = date('Y-m-d');
   	 	$cond = "";
   	 	
		$uri_array = $this->uri->uri_to_assoc(4);
		if(isset($uri_array['bid']))
		{
			$bid = $uri_array['bid'];
			$cond .= " and b.branch_id='$bid'";
		}
		if(isset($uri_array['fdate']))
		{
		    $from_date = $uri_array['fdate'];
		}
		if(isset($uri_array['tdate']))
		{
		    $to_date = $uri_array['tdate'];
		}
		
		$cond .= " and b.bill_date between '$from_date' and '$to_date'";
		
		//$customers = $this->db->query("select distinct a.customer_id,a.bill_no,a.bill_date,a.branch_id,b.branch_name,c.fname,c.lname,c.mobile_no,c.address,d.* from dms_sales as a join branch_master as b on a.branch_id=b.id join customer_master as c on a.customer_id=c.id  where a.status=1 $cond order by a.id desc")->result_array();
        $customers = $this->db->query("select b.bill_no,b.bill_date,c.fname,c.lname,c.address,c.mobile_no,c.email_id,d.* from dms_booking as b inner join customer_master as c on b.customer_id=c.id left join doctor_description as d on b.group_id=d.group_id  where b.status=1 $cond order by b.id asc")->result_array();
        if(!empty($customers)){
			#---------------------------------
			$head = "Customer Report";
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$nline = $line+1;
			$eline = $line+2;
			$this->my_excel->set_font_size('A'.$line.':AA'.$eline,12);
			$this->my_excel->set_bold('A'.$line.':AA'.$eline);
			/*$this->my_excel->set_bg_color_range('A'.$line,26);
			$this->my_excel->set_bg_color_range('A'.$nline,26);
			$this->my_excel->set_bg_color_range('A'.$eline,26);*/

			$this->my_excel->set_bg_color_range(26, 'A' . $line);
			$this->my_excel->set_bg_color_range(26, 'A' . $nline);
			$this->my_excel->set_bg_color_range(26, 'A' . $eline);

			$this->my_excel->set_data_align('A'.$line.':'.'AA'.$eline,'M');
			$this->my_excel->set_border('A'.$line.':'.'AA'.$eline);
			
			$this->my_excel->set_column_width('A',8);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->merge_cell('A'.$line.':A'.$eline);
			$this->my_excel->set_column_width('B',35);
			$this->my_excel->set_cell_value('B'.$line,'Customer Name');
			$this->my_excel->merge_cell('B'.$line.':B'.$eline);
			$this->my_excel->set_column_width('C',35);
			$this->my_excel->set_cell_value('C'.$line,'Address');
			$this->my_excel->merge_cell('C'.$line.':C'.$eline);
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Mobile');
			$this->my_excel->merge_cell('D'.$line.':D'.$eline);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Email');
			$this->my_excel->merge_cell('E'.$line.':E'.$eline);
			$this->my_excel->set_column_width('F',10);
			$this->my_excel->set_cell_value('F'.$line,'Bill No.');
			$this->my_excel->merge_cell('F'.$line.':F'.$eline);
			$this->my_excel->set_column_width('G',10);
			$this->my_excel->set_cell_value('G'.$line,'Bill Date');
			$this->my_excel->merge_cell('G'.$line.':G'.$eline);
			$this->my_excel->set_cell_value('H'.$line,'Right Eye');
			$this->my_excel->merge_cell('H'.$line.':Q'.$line);
			$this->my_excel->set_cell_value('R'.$line,'Left Eye');
			$this->my_excel->merge_cell('R'.$line.':AA'.$line);
			$this->my_excel->set_cell_value('H'.$nline,'DV');
			$this->my_excel->merge_cell('H'.$nline.':K'.$nline);
			$this->my_excel->set_cell_value('L'.$nline,'NV');
			$this->my_excel->merge_cell('L'.$nline.':O'.$nline);
			$this->my_excel->set_cell_value('P'.$nline,'ADD');
			$this->my_excel->merge_cell('P'.$nline.':P'.$eline);
			$this->my_excel->set_cell_value('Q'.$nline,'IPD');
			$this->my_excel->merge_cell('Q'.$nline.':Q'.$eline);
			$this->my_excel->set_cell_value('R'.$nline,'DV');
			$this->my_excel->merge_cell('R'.$nline.':U'.$nline);
			$this->my_excel->set_cell_value('V'.$nline,'NV');
			$this->my_excel->merge_cell('V'.$nline.':Y'.$nline);
			$this->my_excel->set_cell_value('Z'.$nline,'ADD');
			$this->my_excel->merge_cell('Z'.$nline.':Z'.$eline);
			$this->my_excel->set_cell_value('AA'.$nline,'IPD');
			$this->my_excel->merge_cell('AA'.$nline.':AA'.$eline);
			$this->my_excel->set_column_width('H',8);
			$this->my_excel->set_cell_value('H'.$eline,'SPH');
			$this->my_excel->set_column_width('I',8);
			$this->my_excel->set_cell_value('I'.$eline,'CYL');
			$this->my_excel->set_column_width('J',8);
			$this->my_excel->set_cell_value('J'.$eline,'AXIS');
			$this->my_excel->set_column_width('K',8);
			$this->my_excel->set_cell_value('K'.$eline,'V/N');
			$this->my_excel->set_column_width('L',8);
			$this->my_excel->set_cell_value('L'.$eline,'SPH');
			$this->my_excel->set_column_width('M',8);
			$this->my_excel->set_cell_value('M'.$eline,'CYL');
			$this->my_excel->set_column_width('N',8);
			$this->my_excel->set_cell_value('N'.$eline,'AXIS');
			$this->my_excel->set_column_width('O',8);
			$this->my_excel->set_cell_value('O'.$eline,'V/N');
			$this->my_excel->set_column_width('R',8);
			$this->my_excel->set_cell_value('R'.$eline,'SPH');
			$this->my_excel->set_column_width('S',8);
			$this->my_excel->set_cell_value('S'.$eline,'CYL');
			$this->my_excel->set_column_width('T',8);
			$this->my_excel->set_cell_value('T'.$eline,'AXIS');
			$this->my_excel->set_column_width('U',8);
			$this->my_excel->set_cell_value('U'.$eline,'V/N');
			$this->my_excel->set_column_width('V',8);
			$this->my_excel->set_cell_value('V'.$eline,'SPH');
			$this->my_excel->set_column_width('W',8);
			$this->my_excel->set_cell_value('W'.$eline,'CYL');
			$this->my_excel->set_column_width('X',8);
			$this->my_excel->set_cell_value('X'.$eline,'AXIS');
			$this->my_excel->set_column_width('Y',8);
			$this->my_excel->set_cell_value('Y'.$eline,'V/N');
			$this->my_excel->set_bg_color_range(24, 'A' . $eline);
			#------------------------------------------------------
			$line = $eline+1;
			$i=1;
            foreach($customers as $key => $customer){
				$this->my_excel->set_border('A'.$line.':'.'AA'.$line);
				$this->my_excel->set_data_align('A'.$line,'M');
				$this->my_excel->set_data_align('D'.$line.':'.'AA'.$line,'M');
				
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_cell_value('B'.$line,$customer['fname'].' '.$customer['lname']);
				$this->my_excel->set_cell_value('C'.$line,$customer['address']);
				$this->my_excel->set_cell_value('D'.$line,$customer['mobile_no']);
				$this->my_excel->set_cell_value('E'.$line,$customer['email_id']);
				$this->my_excel->set_cell_value('F'.$line,$customer['bill_no']);
				$date = dateFormat($customer['bill_date']);
				$this->my_excel->set_cell_value('G'.$line,$date);
				$this->my_excel->set_cell_value('H'.$line,$customer['rdv1']);
				$this->my_excel->set_cell_value('I'.$line,$customer['rdv2']);
				$this->my_excel->set_cell_value('J'.$line,$customer['rdv3']);
				$this->my_excel->set_cell_value('K'.$line,$customer['rdv4']);
				$this->my_excel->set_cell_value('L'.$line,$customer['rnv1']);
				$this->my_excel->set_cell_value('M'.$line,$customer['rnv2']);
				$this->my_excel->set_cell_value('N'.$line,$customer['rnv3']);
				$this->my_excel->set_cell_value('O'.$line,$customer['rnv4']);
				$this->my_excel->set_cell_value('P'.$line,$customer['radd']);
				$this->my_excel->set_cell_value('Q'.$line,$customer['ripg']);
				$this->my_excel->set_cell_value('R'.$line,$customer['ldv1']);
				$this->my_excel->set_cell_value('S'.$line,$customer['ldv2']);
				$this->my_excel->set_cell_value('T'.$line,$customer['ldv3']);
				$this->my_excel->set_cell_value('U'.$line,$customer['ldv4']);
				$this->my_excel->set_cell_value('V'.$line,$customer['lnv1']);
				$this->my_excel->set_cell_value('W'.$line,$customer['lnv2']);
				$this->my_excel->set_cell_value('X'.$line,$customer['lnv3']);
				$this->my_excel->set_cell_value('Y'.$line,$customer['lnv4']);
				$this->my_excel->set_cell_value('Z'.$line,$customer['ladd']);
				$this->my_excel->set_cell_value('AA'.$line,$customer['lipg']);
				
				$i++; $line++;
			}

			$this->my_excel->output_excel();
		} 
	}
}	