<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Delivery_note_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function delivery_note()
	{
		$this->load->model('sales/Delivery_note_model','sales');
		$this->load->library(array('Stock'));
		$vtype_id = 10;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		$presumptive_tax = $this->stock->get_tax_type();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------delivery report datas
		$sales_array=$this->sales->get_bills(array('conditions' => $conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			$head = "Delivery Note Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'Sl.No.');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',15);
			$this->my_excel->set_cell_value('D'.$line,'Del Note No.');
			$this->my_excel->set_column_width('E',20);
			$this->my_excel->set_cell_value('E'.$line,'Customer Type');
			$this->my_excel->set_column_width('F',35);
			$this->my_excel->set_cell_value('F'.$line,'Customer');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Net. Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
			$this->my_excel->set_bg_color_range('A'.$line,6);


			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($sales_array as $key => $value){

				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
                                $l_date = '2017-07-01';
                                $b_date = $value['bill_date'];
                                if($b_date < $l_date)
                                {
				       $item_details = $this->sales->get_sales_items(array('columns' => array('item_id','qty','rate','amount','discount_amt','vat_amt','cst'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
				       foreach($item_details as $item_key => $item_value):
					      $tax_amount = 0;
					      $net_value = ($item_value['amount']-$item_value['discount_amt']);
					      if(empty($presumptive_tax))
                                              {
						     if($item_value['cst'] == 0)
                                                     {
							    $vat = $this->stock->get_item_vat($item_value['item_id']);
							    $tax_amount = $item_value['vat_amt'];
						     }
                                                     else
                                                     {
							    $tax_amount = ($item_value['cst']*$net_value)/100;
						     }
					      }
					      $total_tax_amount += $tax_amount;
			 		      $total_amount += $net_value;
				       endforeach;
				       $total_amount += $total_tax_amount;
				       if(!empty($presumptive_tax))
                                       {
					      $presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					      $total_amount += $presum_amount;
				       }
				       $cess_amount = (($total_tax_amount+$presum_amount)*$value['cess'])/100;
				       $total_amount += (($cess_amount+$value['bill_freight']+$value['other_expense'])-$value['bill_discount_amt']);
                                }
                                else
                                {
                                       $item_details = $this->sales->get_sales_itemss(array('columns' => array('item_id','qty','rate','amount','discount_amt','cgst_amt','sgst_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
				       foreach($item_details as $item_key => $item_value):
					      $tax_amount = 0;
					      $net_value = ($item_value['amount']-$item_value['discount_amt']);
					      
					      $cgst = $this->stock->get_item_cgst($item_value['item_id']);
                                              $sgst = $this->stock->get_item_sgst($item_value['item_id']);
                                              $vat = $cgst+$sgst;
					      $tax_amount = $item_value['cgst_amt']+$item_value['sgst_amt'];
						     
					      $total_tax_amount += $tax_amount;
			 		      $total_amount += $net_value;
				       endforeach;
				       $total_amount += $total_tax_amount;
				       $total_amount += (($value['bill_freight']+$value['other_expense'])-$value['bill_discount_amt']);

                                }
				#------------------------------------------
				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('c'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$value['bill_no']);
				$this->my_excel->set_cell_value('D'.$line,$value['dno']);
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);
				$customer_type=$this->dms->desig_name($value['customer_type_id']);
				$this->my_excel->set_cell_value('E'.$line,$customer_type);
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('F'.$line,$customer_name);
				$total_amount = get_rounded($total_amount);
				$total_value = $total_value + $total_amount;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$line++;
			}
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'G');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();
		}
	}
}