<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');
	
class Fuel_filling_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function fuel_filling()
	{	$this->load->library('My_excel');
		$this->load->model('vehicles/Vehicle_model','vehicle');
		$from_date = date('Y-m-d',strtotime($this->uri->segment(4)));
		$to_date  =  date('Y-m-d',strtotime($this->uri->segment(5)));
		$vehicle_id =$this->uri->segment(6);
		if($vehicle_id == 'All'){
			$conditions['fuel.filling_date >='] = $from_date;
			$conditions['fuel.filling_date <=']	= $to_date;
			$conditions['fuel.company_id'] = $this->session->userdata('company_id');
		}
		else{
			$conditions['fuel.filling_date >='] = $from_date;
			$conditions['fuel.filling_date <='] = $to_date;
			$conditions['fuel.vehicle_id'] = $vehicle_id;
			$conditions['fuel.company_id'] = $this->session->userdata('company_id');
		}
		$fmodes = array('0'=>'N-A','1'=>'Ordinary','2'=>'Extra Premium');
		$fuels = $this->vehicle->get_all_fuel($conditions,0);
		if(!empty($fuels)){

			#------------------------------------------------
			$head = "Fuel filling Report  ".dateFormat($from_date)." to ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','J');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_column_width('A',5);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Vehicle No');
			$this->my_excel->set_column_width('C',25);
			$this->my_excel->set_cell_value('C'.$line,'Driver');
			$this->my_excel->set_column_width('D',15);
			$this->my_excel->set_cell_value('D'.$line,'Bill No.');
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Fuel Quantity');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Date of Filling');
				
			$this->my_excel->set_column_width('G',25);
			$this->my_excel->set_cell_value('G'.$line,'Last Odometer Reading');
			$this->my_excel->set_column_width('H',25);
			$this->my_excel->set_cell_value('H'.$line,'Name of Petrol Pump');
			$this->my_excel->set_column_width('I',15);
			$this->my_excel->set_cell_value('I'.$line,'Fuel Mode');
			
			$this->my_excel->set_column_width('J',15);
			$this->my_excel->set_cell_value('J'.$line,'Fuel Price');
			//$this->my_excel->set_bg_color_range('A'.$line,9);
			$this->my_excel->set_bg_color_range(9, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'J'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'J'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($fuels as $fuel){

				$this->my_excel->set_border('A'.$line.':'.'J'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_cell_value('B'.$line,$fuel['vehicle_no']);
				$this->my_excel->set_cell_value('C'.$line,$fuel['fname'].' '.$fuel['lname']);
				$this->my_excel->set_data_align('D'.$line,'L');
				$this->my_excel->set_cell_value('D'.$line,$fuel['bill_no']);
				$this->my_excel->set_data_align('E'.$line,NULL);
				$this->my_excel->set_cell_value('E'.$line,$fuel['fuel_quantity']);
				$this->my_excel->set_data_align('F'.$line,NULL);
				$this->my_excel->set_cell_value('F'.$line,date(DATE_FORMAT,strtotime($fuel['filling_date'])));
					
				$this->my_excel->set_data_align('G'.$line,'L');
				$this->my_excel->set_cell_value('G'.$line,$fuel['last_odometer_reading']);
				$this->my_excel->set_cell_value('H'.$line,$fuel['pump_name']);
				$this->my_excel->set_cell_value('I'.$line,$fmodes[$fuel['fuel_mode']]);
				$total_value = $total_value + $fuel['fuel_amount'];
				$this->my_excel->set_data_align('J'.$line,'R');
				$amt = numberFormat($fuel['fuel_amount']);
				$this->my_excel->set_cell_value('J'.$line,$amt);
				$line++;
			}
			$total_value1=numberFormat($total_value);
			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_border('A'.$line.':'.'J'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'I'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('J'.$line,$total_value1);
			$this->my_excel->set_data_align('J'.$line,'R');
			$this->my_excel->output_excel();
		}
		else{
			echo "<script>alert('".$this->lang->line('invalid-fuel-filling')."');window.close();</script>";
		}

	}
}