<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Ledger_report_excel extends MY_Controller{

		public function __construct(){

			parent ::__construct();

		}
	  #--------------------------------------------------------
		public function report(){
			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$this->load->model('accounts/ledger_report/Ledger_report_model','ledger');
			$ledger_id = $this->uri->segment(4);
			$from_date = $this->uri->segment(5);
			$to_date = $this->uri->segment(6);
			$user_id = $this->uri->segment(7);
            $this->branchID = $this->session->userdata('under_id');
			if(!empty($ledger_id) && !empty($from_date) && !empty($to_date)){

                if($user_id !='')
    			{ 
    			    $vouchers = $this->ledger->getVouchers1($this->branchID,$ledger_id,$user_id,$from_date,$to_date);
    			}
    			else
    			{
				    $vouchers = $this->ledger->getVouchers($this->branchID,$ledger_id,$from_date,$to_date);
    			}
				$opening_bal = $this->accounts->opening_bal($ledger_id,$from_date);
				$open_voucher_bal = $this->accounts->voucher_bal($ledger_id,$from_date);
				$dc = $this->accounts->get_dc($ledger_id);
				if($dc == 'dr'){
					$opening_bal += ($open_voucher_bal['dr_amount'] - $open_voucher_bal['cr_amount']);
				}
				else{
					$opening_bal += ($open_voucher_bal['cr_amount'] - $open_voucher_bal['dr_amount']);
				}

				#-------------------excel-----------------------------
				$head = "Ledger Wise Report From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
				$ledger_name = $this->accounts->get_ledger_name($ledger_id);
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);
				$subhead = "Ledger : ".$ledger_name;

				$line = $this->my_excel->get_line();
				$line = $line+1;
				$this->my_excel->merge_cell('A'.$line.':D'.$line);
				$this->my_excel->set_cell_value('A'.$line,$subhead);
				$this->my_excel->set_font_size('A'.$line);
				$this->my_excel->set_bold('A'.$line);
				
				if($user_id!='')
				{
				    $user = "Staff : ".get_username($user_id);
				
    				$line = $line+1;
    				$this->my_excel->merge_cell('A'.$line.':D'.$line);
    				$this->my_excel->set_cell_value('A'.$line,$user);
    				$this->my_excel->set_font_size('A'.$line);
    				$this->my_excel->set_bold('A'.$line);
				}

				#get start line  line
				$line = $this->my_excel->report_head_line();

				#first row head
				$headings = array('A'=>'#','B'=>'Date','C'=>'Particulars','D'=>'Voucher Types','E'=>'Voucher No','F'=>'Debit','G'=>'Credit');
				$head_width = array('B'=>12,'C'=>30,'D'=>30,'E'=>15,'F'=>20,'G'=>20);
				$this->my_excel->set_report_head($headings,array(),$line,NULL);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(7, 'A' . $line);

				$i=1;
				$line =$line+1;
				$total_dr = $total_cr = 0;

				if($vouchers)
				{
					foreach($vouchers as $key => $value)
					{
						$bill_details = $this->ledger->getVoucherBill($value['group_id']);
						$vamount = $this->ledger->getBillAmount($value['group_id'],$ledger_id);
						$dr_amount = $cr_amount = 0;
						if($dc == 'dr'){
							$bill_amount = ($vamount['dr_amount'] - $vamount['cr_amount']);
							if($bill_amount > 0){
								$dr_amount = $bill_amount;
							}
							elseif($bill_amount < 0){
								$cr_amount = -$bill_amount;
							}
						}
						else{
							$bill_amount = ($vamount['cr_amount'] - $vamount['dr_amount']);
							if($bill_amount > 0){
								$cr_amount = $bill_amount;
							}
							elseif($bill_amount < 0){
								$dr_amount = -$bill_amount;
							}
						}
						if($bill_details['dr_ledger'] == $ledger_id){
							$particular_id = $bill_details['cr_ledger'];
						}
						else{
							$particular_id = $bill_details['dr_ledger'];
						}
						$ledger_name = $this->accounts->get_ledger_name($particular_id);

						$total_dr += $dr_amount;
						$total_cr += $cr_amount;

						$this->my_excel->set_cell_value('A'.$line,$i);
						$this->my_excel->set_cell_value('B'.$line,dateFormat($bill_details['vdate']));
						$this->my_excel->set_cell_value('C'.$line,stringFormat($ledger_name));
						$this->my_excel->set_cell_value('D'.$line,stringFormat($bill_details['vtype']));
						$this->my_excel->set_cell_value('E'.$line,$bill_details['vno']);
						$this->my_excel->set_cell_value('F'.$line,$dr_amount);
						$this->my_excel->set_cell_value('G'.$line,$cr_amount);

						#excel styles
						$this->my_excel->set_data_align('A'.$line);
						$this->my_excel->set_data_align('B'.$line);
						$this->my_excel->set_data_align('E'.$line,'L');
						$this->my_excel->set_wrap_text('C'.$line);
						$this->my_excel->number_format('F'.$line);
						$this->my_excel->number_format('G'.$line);

						$line++;
						$i++;
					}
				}

				#opening balance,current total,closing calculation
				$grand_dr = $total_dr;
				$grand_cr = $total_cr;
				$opening_bal_dr = $opening_bal_cr = 0;
				if($dc == 'dr')
				{
					if($opening_bal > 0){
						$opening_bal_dr = $opening_bal;
						$opening_bal_cr = 0;
					}
					else{
						$opening_bal_dr = 0;
						$opening_bal_cr = -$opening_bal;
					}
					$grand_dr += $opening_bal_dr;
					$grand_cr += $opening_bal_cr;
					$grand_dr -= $grand_cr;
					if($grand_dr > 0){
						$grand_cr = 0;
					}
					else{
						$grand_cr = -$grand_dr;
						$grand_dr = 0;
					}
				}
				elseif($dc == 'cr')
				{
					if($opening_bal > 0){
						$opening_bal_cr = $opening_bal;
						$opening_bal_dr = 0;
					}
					else{
						$opening_bal_cr = 0;
						$opening_bal_dr = -$opening_bal;
					}
					$grand_dr += $opening_bal_dr;
					$grand_cr += $opening_bal_cr;
					$grand_cr -= $grand_dr;
					if($grand_cr > 0){
						$grand_dr = 0;
					}
					else{
						$grand_dr = -$grand_cr;
						$grand_cr = 0;
					}
				}
				#opening balenace row
				$this->my_excel->merge_cell('A'.$line.':E'.$line);
				$this->my_excel->set_cell_value('A'.$line,'Opening Balance');
				$this->my_excel->set_data_align('A'.$line,"R");
				$this->my_excel->set_cell_value('F'.$line,$opening_bal_dr);
				$this->my_excel->set_cell_value('G'.$line,$opening_bal_cr);
				$this->my_excel->number_format('F'.$line);
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_bold('F'.$line.':G'.$line);

				$line = $line+1;
				#current total row
				$this->my_excel->merge_cell('A'.$line.':E'.$line);
				$this->my_excel->set_cell_value('A'.$line,'Current Total');
				$this->my_excel->set_data_align('A'.$line,"R");
				$this->my_excel->set_cell_value('F'.$line,$total_dr);
				$this->my_excel->set_cell_value('G'.$line,$total_cr);
				$this->my_excel->number_format('F'.$line);
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_bold('F'.$line.':G'.$line);

				$line = $line+1;
				#Closing Balance row
				$this->my_excel->merge_cell('A'.$line.':E'.$line);
				$this->my_excel->set_cell_value('A'.$line,'Closing Balance');
				$this->my_excel->set_data_align('A'.$line,"R");
				$this->my_excel->set_cell_value('F'.$line,$grand_dr);
				$this->my_excel->set_cell_value('G'.$line,$grand_cr);
				$this->my_excel->number_format('F'.$line);
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_bold('A'.$line.':G'.$line);
				$this->my_excel->set_border('A4:G'.$line);

				$this->my_excel->output_excel();

			}else{
				echo "<script>alert('".$this->lang->line('invalid-ledger-report')."');window.close();</script>";
			}
		}
	}
?>