<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');
	
class Ledgers_excel extends MY_Controller{

	public function __construct(){

		parent :: __construct();
		$this->load->library('My_excel');
	}

	public function ledgers()
	{
		$this->load->model('accounts/Ledger_model','ledger');
		$this->load->library('Accounts');
		$conditions = array();
		$sub_group= $this->uri->segment(4);
		if($sub_group!='')
			{$conditions = array('b.sgroup_id'=>$sub_group);	}
		$ledgers = $this->ledger->get(array('conditions' => $conditions,'order_by' => 'b.ledger_name','order' => 'asc'));
		if(!empty($ledgers)){ 
			$head = "Ledger Report On ".dateFormat(date('Y-m-d'));
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','E');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':E'.$line,12);
			$this->my_excel->set_bold('A'.$line.':E'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',35);
			$this->my_excel->set_cell_value('B'.$line,'Ledger Name');
			$this->my_excel->set_column_width('C',25);
			$this->my_excel->set_cell_value('C'.$line,'Sub Group');
			$this->my_excel->set_column_width('D',25);
			$this->my_excel->set_cell_value('D'.$line,'Opening Balance');
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Dr / Cr');
			//$this->my_excel->set_bg_color_range('A'.$line,4);
			$this->my_excel->set_bg_color_range(5, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'E'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'E'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'E'.$line,NULL);
			
			$i=0;
			$line = $line+1;
			#------------------------------------------------------
			foreach($ledgers as $ledger){
				//$open_bal_array = $this->accounts->cur_open_bal($ledger['id'],1);
				$this->my_excel->set_border('A'.$line.':'.'E'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_cell_value('B'.$line,$ledger['ledger_name']);
				$this->my_excel->set_cell_value('C'.$line,$ledger['sub_group']);
				$this->my_excel->set_data_align('D'.$line,'R');
				//$open_amount=numberFormat($open_bal_array['open_amount']);
				$open_amount='';
				$this->my_excel->set_cell_value('D'.$line,$open_amount);
				$this->my_excel->set_data_align('E'.$line,NULL);
				$this->my_excel->set_cell_value('E'.$line,'');
				$line++;
			}
			$this->my_excel->output_excel();
		}
	}
}