<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');
	
class Opening_stock_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function opening_stock()
	{
		
		$postGodown = $postItem =NULL;
		$this->load->model('products/Opening_stock_model','opening_stock');
		$this->load->library(array('Stock'));
		if($this->uri->segment(4)=='postItem'){	
			if($this->uri->segment(5) != 'postGodown'){ 
				$postItem = $this->uri->segment(5);
				if($this->uri->segment(7) != NULL){
					$postGodown = $this->uri->segment(7);
				}
			}
			else if($this->uri->segment(7)){ 
				$postGodown = $this->uri->segment(7);
			}
			else {
				$postGodown = $this->uri->segment(6);
			}
		}
		$fiscalStartDate = $this->dms->get_fiscal_year()['start_date'];
		$args = array();
		$conditions = array('ds.stock_status'=>0);
		if($postItem != NULL){
		$conditions['ds.item_id'] = $postItem;}
		if($postGodown != NULL){
		$conditions['ds.godown_id'] = $postGodown;}
		$fiscalStartDate = $this->dms->get_fiscal_year()['start_date'];
		$args['select'] = array('ds.item_id','ds.godown_id','ds.qty','ds.unit_id','ds.rate','ds.stock_date','ds.stock_status','gm.godown_code','gm.godown_name','im.item_code','im.item_name','um.symbol','um.formal_name');
		$args['conditions'] = $conditions;
		$openingStocks = $this->opening_stock->getAll($args);
		if(!empty($openingStocks)){

			$StockOpenings = array();
			foreach($openingStocks as $key=>$openingStock){
			
				$itemID = $openingStock['item_id'];
				$goDownID = $openingStock['godown_id'];
				$actOpening = $this->stock->get_actual_opening($itemID,$goDownID);
				if(!empty($actOpening)){
			
					$rate = NULL;	
					$actOpDate = $actOpening['stock_date'];
					$editID = $actOpening['id'];		
					$args = array();
					$args['godown_id'] = $goDownID;
					$args['item_id'] = $itemID;
					$args['opening_date'] = $fiscalStartDate;
					//$openingQnty = $this->stock->get_opening_stock($args);
					$openingQnty=0;	
					$purchase_rate = $this->stock->get_purchase_rate($itemID);
					if(!empty($purchase_rate)){
						$rate = $purchase_rate;
					}else{
						$rate = $this->stock->get_opening_rate($itemID);}
					$rate = round_this($rate);
					$StockOpenings[] = array('id'=>$editID,'item_id'=>$itemID,'item_code'=>$openingStock['item_code'],'item_name'=>$openingStock['item_name'],'godown_code'=>$openingStock['godown_code'],'godown_name'=>$openingStock['godown_name'],'opening_qnty'=>$openingQnty,'formal_name'=>$openingStock['formal_name'],'symbol'=>$openingStock['symbol'],'rate'=>$rate);
				}
			}
			$head = "Opening Stock Report On ".dateFormat(date('Y-m-d'));
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			
			# for showing opening date
			$line_dt = $line-2;
			$this->my_excel->merge_cell('F'.$line_dt.':'.'G'.$line_dt);
			$this->my_excel->set_bold('F'.$line_dt.':G'.$line_dt);
			$this->my_excel->set_data_align('F'.$line_dt,'R');
			$this->my_excel->set_cell_value('F'.$line_dt,'Opening Date : '.dateFormat($fiscalStartDate));
			#-------------end-------
			
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',20);
			$this->my_excel->set_cell_value('B'.$line,'Item Code');
			$this->my_excel->set_column_width('C',35);
			$this->my_excel->set_cell_value('C'.$line,'Item Name');
			$this->my_excel->set_column_width('D',25);
			$this->my_excel->set_cell_value('D'.$line,'Godown');
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Quantity');
			$this->my_excel->set_column_width('F',15);
			$this->my_excel->set_cell_value('F'.$line,'Rate');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Unit');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
			$this->my_excel->set_bg_color_range(6, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			//$this->my_excel->set_bg_color_range(7, 'A' . $line);
			$line=$line+1;
			$i=0;
			foreach($StockOpenings as $itemID=>$stock_opening){
				$rate = numberFormat($stock_opening['rate']);
				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$this->my_excel->set_cell_value('B'.$line,$stock_opening['item_code']);
				$this->my_excel->set_cell_value('C'.$line, $stock_opening['item_name']);
				$this->my_excel->set_cell_value('D'.$line,$stock_opening['godown_code'].$stock_opening['godown_name']);
				$this->my_excel->set_cell_value('E'.$line,$stock_opening['opening_qnty']);
				$this->my_excel->set_data_align('F'.$line,'R');
				$this->my_excel->set_cell_value('F'.$line,$rate);
				$this->my_excel->set_data_align('G'.$line,NULL);
				$this->my_excel->set_cell_value('G'.$line,$stock_opening['symbol']);
				$line++;	
			}
			$this->my_excel->output_excel();
		}
	}
}