<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Profit_loss_excel extends MY_Controller{

		public function __construct(){

			parent ::__construct();
		}
       #----------------------------------------------------------------------
		public function report(){
			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$from_date = $this->uri->segment(4);
			$to_date = $this->uri->segment(5);
			$expense_array = $income_array = $indirect_expense_array = $indirect_income_array = array();$dc = "";
			$gross_expense = $gross_income = $net_expense = $net_income = 0;
			if(!empty($from_date) && !empty($to_date))
			{
				$next_date = date('Y-m-d',(strtotime($to_date)+86400));
				
				#-----------opening stock
				$opening_stock_bal = $opening_ledger_stock_bal = 0;			
				$opening_voucher_stock_bal = $this->accounts->voucher_bal(16,$from_date,1);//stock in hand voucher			
				$opening_stock_bal = $this->accounts->stock_bal_amt($from_date);//stock in hand stock			
				$opening_stock = ($opening_voucher_stock_bal['dr_amount'] - $opening_voucher_stock_bal['cr_amount']) + $opening_ledger_stock_bal + $opening_stock_bal;
				if($opening_stock != 0)
				{
					$expense_array[16] = array('group_name' => $this->lang->line('openings'),'vamount' => $opening_stock);
				}
				$gross_expense += $opening_stock;
				
				#-----------closed stock
				$closed_voucher_stock_bal = $this->accounts->voucher_bal(16,$to_date,1,$from_date);//stock in hand voucher			
				$closed_stock_bal = $this->accounts->stock_bal_amt($to_date,0,1);//stock in hand stock
				$closed_stock = ($closed_voucher_stock_bal['dr_amount'] - $closed_voucher_stock_bal['cr_amount']) + $closed_stock_bal;	
				if($closed_stock != 0)
				{
					$income_array[16] = array('group_name' => $this->lang->line('closings'),'vamount' => $closed_stock);
				}
				$gross_income += $closed_stock;

				#-----------expense		
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
				foreach($account_groups as $key => $value)
				{			
					$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);											
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);												
					$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
					if($value['id'] != 12)
					{
						if($vamount > 0)
						{					
							$expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
							$gross_expense += $vamount;
						}
						elseif($vamount < 0)				
						{
							$vamount = -$vamount;
							$income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);						
							$gross_income += $vamount;
						}
					}
					else
					{
						if($vamount > 0)
						{					
							$indirect_expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
							$net_expense += $vamount;
						}
						elseif($vamount < 0)				
						{
							$vamount = -$vamount;
							$indirect_income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);						
							$net_income += $vamount;		
						}
					}
				}	
				
				#-----------income
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
				foreach($account_groups as $key => $value)
				{	
					$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);											
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);												
					$vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
					if($value['id'] != 10)
					{
						if($vamount > 0)
						{					
							$income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
							$gross_income += $vamount;
						}
						elseif($vamount < 0)					
						{
							$vamount = -$vamount;
							$expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);						
							$gross_expense += $vamount;	
						}
					}
					else
					{
						if($vamount > 0)
						{					
							$indirect_income_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
							$net_income += $vamount;
						}
						elseif($vamount < 0)					
						{
							$vamount = -$vamount;
							$indirect_expense_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
							$net_expense += $vamount;				
						}
					}
				}
				$gross_amount = $gross_income - $gross_expense;
				$total_expense = $total_income = 0;
				#---------------------------------excel part--------------------
				$head = "Profit & Loss A/c From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);
				#report head
				$a_start_line = $c_start_line = $this->my_excel->report_head_line();
				//$this->my_excel->merge_cell('C'.$line.':D'.$line);
				$headings = array('A'=>'Particulars','B'=>'Amount','C'=>'Particulars','D'=>'Amount');
				$head_width = array('A'=>40,'B'=>30,'C'=>40,'D'=>30);
				$this->my_excel->set_report_head($headings,array(),$a_start_line,NULL);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(4, 'A' . $a_start_line);
				$a_start_line = $a_start_line +1;
				$c_start_line = $c_start_line+1;
				#----pariculars,amount in left side ----------------
				if(!empty($expense_array))
				{
					foreach($expense_array as $ekey => $evalue)
					{
						$this->my_excel->set_cell_value('A'.$a_start_line,stringFormat($evalue['group_name']));
						$this->my_excel->set_cell_value('B'.$a_start_line,$evalue['vamount']);
						$this->my_excel->number_format('B'.$a_start_line);
						$a_start_line++;
					}
					$a_end_line = $a_start_line;
				}
				if($gross_amount > 0)							
				{
					$net_income += $gross_amount;
					$this->my_excel->set_cell_value('A'.$a_start_line,'Gross Profit c/o');
					$this->my_excel->set_cell_value('B'.$a_start_line,$gross_amount);
					$this->my_excel->number_format('B'.$a_start_line);
					$this->my_excel->set_bold('A'.$a_start_line.':B'.$a_start_line);
					$a_start_line = $a_start_line+1;
					$a_end_line =$a_end_line+1;
				}
				elseif($gross_amount < 0)
				{
					$net_expense += (-$gross_amount);
					$this->my_excel->set_cell_value('A'.$a_start_line,'Gross Loss b/f');
					$this->my_excel->set_cell_value('B'.$a_start_line,-$gross_amount);
					$this->my_excel->number_format('B'.$a_start_line);
					$this->my_excel->set_bold('A'.$a_start_line.':B'.$a_start_line);
					$a_start_line = $a_start_line+1;
					$a_end_line =$a_end_line+1;
				}
				if(!empty($indirect_expense_array))
				{
					foreach($indirect_expense_array as $iekey => $ievalue)
					{
						$this->my_excel->set_cell_value('A'.$a_start_line,stringFormat($ievalue['group_name']));
						$this->my_excel->set_cell_value('B'.$a_start_line,$ievalue['vamount']);
						$this->my_excel->number_format('B'.$a_start_line);
						$a_start_line++;
					}
					$a_end_line = $a_start_line;
				}
				$net_profit_loss = $net_income - $net_expense;
				if($net_profit_loss > 0)
				{
					$total_expense = $net_expense + $net_profit_loss;
					$total_income = $total_expense;
					$this->my_excel->set_cell_value('A'.$a_start_line,'Nett Profit');
					$this->my_excel->set_cell_value('B'.$a_start_line,$net_profit_loss);
					$this->my_excel->number_format('B'.$a_start_line);
					$this->my_excel->set_bold('A'.$a_start_line.':B'.$a_start_line);
					$a_start_line = $a_start_line+1;
					$a_end_line =$a_end_line+1;
				}
				#---------------paricular,amount in right side------
				if(!empty($income_array))
				{
					foreach($income_array as $ikey => $ivalue)
					{
						$this->my_excel->set_cell_value('C'.$c_start_line,stringFormat($ivalue['group_name']));
						$this->my_excel->set_cell_value('D'.$c_start_line,$ivalue['vamount']);
						$this->my_excel->number_format('D'.$c_start_line);
						$c_start_line++;
					}
					$c_end_line = $c_start_line;
				}
				if($gross_amount > 0)							
				{
					$this->my_excel->set_cell_value('C'.$c_start_line,'Gross Profit b/f');
					$this->my_excel->set_cell_value('D'.$c_start_line,$gross_amount);
					$this->my_excel->number_format('D'.$c_start_line);
					$this->my_excel->set_bold('C'.$c_start_line.':D'.$c_start_line);
					$c_start_line = $c_start_line+1;
					$c_end_line =$c_end_line+1;
				}
				elseif($gross_amount < 0)
				{
					$this->my_excel->set_cell_value('C'.$c_start_line,'Gross Loss c/o');
					$this->my_excel->set_cell_value('D'.$c_start_line,-$gross_amount);
					$this->my_excel->number_format('D'.$c_start_line);
					$this->my_excel->set_bold('C'.$c_start_line.':D'.$c_start_line);
					$c_start_line = $c_start_line+1;
					$c_end_line =$c_end_line+1;
				}
				if(!empty($indirect_income_array))
				{
					foreach($indirect_income_array as $iikey => $iivalue)
					{	
						$this->my_excel->set_cell_value('C'.$c_start_line,stringFormat($iivalue['group_name']));
						$this->my_excel->set_cell_value('D'.$c_start_line,$iivalue['vamount']);
						$this->my_excel->number_format('D'.$c_start_line);
						$c_start_line++;
					}
					$c_end_line = $c_start_line;
				}
				if($net_profit_loss < 0)
				{
					$total_income = $net_income - $net_profit_loss;
					$total_expense = $total_income;
					$this->my_excel->set_cell_value('C'.$c_start_line,'Nett Loss');
					$this->my_excel->set_cell_value('D'.$c_start_line,-$net_profit_loss);
					$this->my_excel->number_format('D'.$c_start_line);
					$this->my_excel->set_bold('C'.$c_start_line.':D'.$c_start_line);
					$c_start_line = $c_start_line+1;
					$c_end_line =$c_end_line+1;
				}
				//echo $a_end_line.'&&'.$d_end_line;die;
				if($a_end_line >= $c_end_line){
					$next_line = $a_end_line;
				}
				else{
					$next_line = $c_end_line;
				}
				#------total---------
				$this->my_excel->set_cell_value('A'.$next_line,'Total');
				$this->my_excel->set_cell_value('B'.$next_line,$total_expense);
				$this->my_excel->set_cell_value('C'.$next_line,'Total');
				$this->my_excel->set_cell_value('D'.$next_line,$total_income);
				$this->my_excel->number_format('B'.$next_line);
				$this->my_excel->number_format('D'.$next_line);
				$this->my_excel->set_bold('A'.$next_line.':D'.$next_line);
				$this->my_excel->set_border('A4:D'.$next_line);

				$this->my_excel->output_excel();			
			}
			else
			{
				echo "<script>alert('".$this->lang->line('invalid-profit-loss')."');window.close();</script>";
			}
			

		}

	   #----------------------------------------------------------------------
	} 
?>