<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
                
	}

	public function purchase()
	{
		$this->load->model('purchase/Purchase_model','purchase_obj');
		$this->load->library(array('Stock'));

		$vtype_id = 5;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);
		$presumptive_tax = $this->stock->get_tax_type();
		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}
		$item_id = "";
		if(isset($uri_array['item']) && !empty($uri_array['item'])){
			$item_id = $uri_array['item'];
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------purchase report datas
		$purchase_array=$this->purchase_obj->get_bills(array('conditions' => $conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC','item_condition' => $item_id));
		if(!empty($purchase_array))
		{
			#---------------------------------
			$head = "Purchase Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'Sl.No.');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',20);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Invoice No.');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Vendor');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',20);
			$this->my_excel->set_cell_value('G'.$line,'Net. Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
			$this->my_excel->set_bg_color_range(6, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			#----------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($purchase_array as $key => $value){
				#------------------------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);                                
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
                                
                                $item_details = $this->purchase_obj->get_purchase_itemss(array('columns' => array('item_id','qty','rate','amount','discount_amt','cgst_amt','sgst_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
                                
				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
                                        
                                             $tax_amount = $item_value['cgst_amt']+$item_value['sgst_amt'];;
                                         
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				endforeach;
				$total_amount += $total_tax_amount;
				if(!empty($presumptive_tax)){
					$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					$total_amount += $presum_amount;
				}
				$cess_amount = (($total_tax_amount+$presum_amount)*$value['cess'])/100;
				$total_amount += (($cess_amount+$value['bill_freight']+$value['other_expense'])-$value['bill_discount_amt']);
				#------------------------------------------
				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);

				$this->my_excel->set_data_align('D'.$line,'L');
				$this->my_excel->set_cell_value('D'.$line,$bill_prefix.' '.$value['invoice_no']);

				$vendor_name=$this->stock->vendor_name($value['vendor_id']);
				$this->my_excel->set_cell_value('E'.$line,$vendor_name);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value = $total_value + $total_amount;
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$this->my_excel->number_format('G'.$line);
				$line++;

			}
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();
		}
	}
	#----------------------------------------------------------------------------------------------------------

	public function purchase_registry()
	{
		$this->load->model('purchase/Purchase_model','purchase_obj');
		$this->load->library(array('Stock'));
                              
		$vtype_id = 5;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);
		$presumptive_tax = $this->stock->get_tax_type();
		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		//$conditions['vtype_id'] = $vtype_id;
		$conditions['a.status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}
		$item_id = "";
		if(isset($uri_array['item']) && !empty($uri_array['item'])){
			$item_id = $uri_array['item'];
		}

		#----------between condition
		$between = "a.bill_date between '$from_date' and '$to_date'";

		#----------purchase report datas
               
                       $purchase_array=$this->purchase_obj->get_bills_registry(array('conditions' => $conditions,'between' => $between,'order_by'=>'a.bill_no','order'=>'ASC'));

               
		if(!empty($purchase_array))
		{
			#---------------------------------
			$head = "Purchase Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','M');
			$line = $this->my_excel->report_head_line();

                        $this->my_excel->set_font_size('A'.$line.':K'.$line,12);
			$this->my_excel->set_bold('A'.$line.':K'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'Sl.No.');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');

			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Particulars');

			$this->my_excel->set_column_width('D',15);
			$this->my_excel->set_cell_value('D'.$line,'Voucher Type');

			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Voucher No.');

			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Invoice No.');
			
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Value');
			
			$this->my_excel->set_column_width('H',15);
			$this->my_excel->set_cell_value('H'.$line,'CGST Amount');

			$this->my_excel->set_column_width('I',15);
			$this->my_excel->set_cell_value('I'.$line,'SGST Amount');

                        $this->my_excel->set_column_width('J',15);
			$this->my_excel->set_cell_value('J'.$line,'IGST Amount');

                        $this->my_excel->set_column_width('K',15);
			$this->my_excel->set_cell_value('K'.$line,'Gross Total');

			//$this->my_excel->set_bg_color_range('A'.$line,10);
			$this->my_excel->set_bg_color_range(10, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'K'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'K'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'K'.$line,NULL);
			$this->my_excel->set_border('A'.$line.':'.'K'.$line);

			#----------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;

			$TOTAL = 0;$TOTAL_VALUE=0;$TOTAL_CGST_AMT=0;$TOTAL_SGST_AMT = 0;$TOTAL_IGST_AMT = 0;
			
			foreach($purchase_array as $key => $value){
				#------------------------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
                                                                
                                $item_details = $this->purchase_obj->get_purchase_itemss(array('columns' => array('item_id','qty','rate','amount','discount_amt','cgst_amt','sgst_amt','igst_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
                                
				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0; $cgstAmt = 0; $sgstAmt = 0;$igstAmt=0;$total_cgst_amt=0;
                                        $total_sgst_amt=0;$total_igst_amt=0;$total_net_amt=0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
                                        $total_net_amt += $net_value;
                                        $cgstAmt = $item_value['cgst_amt'];
                                        $sgstAmt = $item_value['sgst_amt'];
                                        $igstAmt = $item_value['igst_amt'];

                                        $total_cgst_amt += $cgstAmt;
                                        $total_sgst_amt += $sgstAmt;
                                        $total_igst_amt += $igstAmt;   

                                        $tax_amount = $cgstAmt + $sgstAmt + $igstAmt;;
                                         
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				endforeach;
				$total_amount += $total_tax_amount;
                                
                                $total_amount += (($value['bill_freight']+$value['other_expense'])-$value['bill_discount_amt']);                                 				
                                
                                $TOTAL_VALUE += $total_net_amt;
				$TOTAL_CGST_AMT += $total_cgst_amt;
                                $TOTAL_SGST_AMT += $total_sgst_amt;                                 
				$TOTAL_IGST_AMT += $total_igst_amt;
				$TOTAL = $total_amount;

				#------------------------------------------
                            
                                $this->my_excel->set_border('A'.$line.':'.'K'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);


				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);


				$this->my_excel->set_data_align('c'.$line,'K');
				$vendor_name=$this->stock->vendor_name($value['vendor_id']);
				$this->my_excel->set_cell_value('C'.$line,$vendor_name);

				$this->my_excel->set_cell_value('D'.$line,$value['vtype']);

				$this->my_excel->set_cell_value('E'.$line,$bill_prefix.' '.$value['bill_no']);

				$this->my_excel->set_cell_value('F'.$line,$bill_prefix.' '.$value['invoice_no']);
				
				$this->my_excel->set_cell_value('G'.$line,$total_net_amt);				
				$this->my_excel->number_format('G'.$line);				

				$this->my_excel->set_cell_value('H'.$line,$total_cgst_amt);

				$this->my_excel->set_cell_value('I'.$line,$total_sgst_amt);

                                $this->my_excel->set_cell_value('J'.$line,$total_igst_amt);

                                $this->my_excel->set_cell_value('K'.$line,$total_amount);

				$line++;                            
			}
                   
              /*          $this->my_excel->set_bold('A'.$line.':K'.$line);
			$this->my_excel->set_border('A'.$line.':'.'K'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');

			$this->my_excel->set_cell_value('G'.$line,$TOTAL_QUANT1);
			$this->my_excel->number_format('G'.$line);

			$this->my_excel->set_cell_value('I'.$line,$TOTAL_VALUE);
			$this->my_excel->number_format('I'.$line);

			$this->my_excel->set_cell_value('J'.$line,$total_value);
			$this->my_excel->number_format('J'.$line);

			$this->my_excel->set_cell_value('K'.$line,$TOTAL_VAT1);
			$this->my_excel->number_format('K'.$line);

			$this->my_excel->set_cell_value('L'.$line,$TOTAL_VAT2);
			$this->my_excel->number_format('L'.$line);   */
                    
			$this->my_excel->output_excel();
		}
	}
	/*-----------------------------------------------------------------------------------------------*/
	
	public function purchasebr()
	{
		$this->load->model('purchase/Purchase_model','purchase_obj');
		$this->load->model('branches/Branch_model','branchmod');

		$this->load->library(array('Stock'));

		$vtype_id = 5;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);
		$presumptive_tax = $this->stock->get_tax_type();
		if(isset($uri_array['br']))
		{
			$branch_id = $uri_array['br'];
		}
		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		if($branch_id!=0)
		{
		$conditions['branch_id'] = $branch_id;
		}
		
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}
		$item_id = "";
		if(isset($uri_array['item']) && !empty($uri_array['item'])){
			$item_id = $uri_array['item'];
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------purchase report datas
		$purchase_array=$this->purchase_obj->get_bills_brnch(array('conditions' => $conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC','item_condition' => $item_id));
		if(!empty($purchase_array))
		{
			#---------------------------------
			if($branch_id!=0)
			{
			$brname=$this->branchmod->get_full_name($branch_id);
		
			$head = $brname.":"."Purchase Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			}
			else
			{
			  $head = "Purchase Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
  
			}
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'Sl.No.');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',20);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Invoice No.');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Vendor');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',20);
			$this->my_excel->set_cell_value('G'.$line,'Net. Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
			$this->my_excel->set_bg_color_range(6, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			#----------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($purchase_array as $key => $value){
				#------------------------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);                                
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
                                
                                $item_details = $this->purchase_obj->get_purchase_itemss(array('columns' => array('item_id','qty','rate','amount','discount_amt','cgst_amt','sgst_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
                                
				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
                                        
                                             $tax_amount = $item_value['cgst_amt']+$item_value['sgst_amt'];;
                                         
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				endforeach;
				$total_amount += $total_tax_amount;
				if(!empty($presumptive_tax)){
					$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					$total_amount += $presum_amount;
				}
				$cess_amount = (($total_tax_amount+$presum_amount)*$value['cess'])/100;
				$total_amount += (($cess_amount+$value['bill_freight']+$value['other_expense'])-$value['bill_discount_amt']);
				#------------------------------------------
				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);

				$this->my_excel->set_data_align('D'.$line,'L');
				$this->my_excel->set_cell_value('D'.$line,$bill_prefix.' '.$value['invoice_no']);

				$vendor_name=$this->stock->vendor_name($value['vendor_id']);
				$this->my_excel->set_cell_value('E'.$line,$vendor_name);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value = $total_value + $total_amount;
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$this->my_excel->number_format('G'.$line);
				$line++;

			}
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();
		}
	}
	#----------------------------------------------------------------------------------------------------------

	#---------------------------------------------------------------------------------------
}