<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_order_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function purchase_order()
	{
		$from_date = $this->uri->segment(4);
		$to_date = $this->uri->segment(5);
		$l_date = '2017-07-01';
		$this->load->model('purchase/Purchase_order_model','purchase_order');
		$this->load->library('Stock');
		$args = array();
		$args['select'] = array('dpo.id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','imm.manufacturer_name as vendor_name','imm.phone');
		$args['join'] = array('item_manufacturer_master as imm'=>'dpo.vendor_id=imm.id');
		$args['from_date'] = $from_date;
		$args['to_date'] = $to_date;
		$purchase_orders = $this->purchase_order->get($args);
		$presumtiveTax = $this->stock->get_tax_type();
		$bill_prefix = $this->stock->get_voucher_prefix(-2);

		if(!empty($purchase_orders)){
			$head = "Purchase Order Report  ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','E');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':E'.$line,12);
			$this->my_excel->set_bold('A'.$line.':E'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Bill No.');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Date');
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Vendor');
			$this->my_excel->set_column_width('E',20);
			$this->my_excel->set_cell_value('E'.$line,'Net Amount');
			//$this->my_excel->set_bg_color_range('A'.$line,4);
			$this->my_excel->set_bg_color_range(5, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'E'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'E'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'E'.$line,NULL);
			
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($purchase_orders as $pKey=>$purchase_order){

				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
				$discountAmount = $purchase_order['po_discount_amt'];
				$cess = $purchase_order['cess'];
				$poID = $purchase_order['id'];
				$po_date = $purchase_order['po_date'];
				$args = array();
				/*$args['select'] = array('dpo.id as dpo_id','dpi.id','dpi.group_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.discount_per','dpi.discount_amt','dpi.vat_amt','dpi.cst','dpi.item_status');
				$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id');
				$args['conditions'] = array('dpo.group_id'=>$purchase_order['group_id'],'dpi.item_status <='=>1,'dpi.status'=>1);
				$purchase_order_items[$poID] = $this->purchase_order->get($args);
				if(empty($purchase_order_items[$poID]))
				{*/
					$args['select'] = array('dpo.id as dpo_id','dpi.id','dpi.group_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.discount_per','dpi.discount_amt','dpi.cgst_amt','dpi.sgst_amt','dpi.item_status');
					$args['join'] = array('dms_purchase_items1 as dpi'=>'dpo.group_id=dpi.group_id');
					$args['conditions'] = array('dpo.group_id'=>$purchase_order['group_id'],'dpi.item_status <='=>1,'dpi.status'=>1);
					$purchase_order_items[$poID] = $this->purchase_order->get($args);
				//}
				foreach($purchase_order_items[$poID] as $piKey=>$po_item)
				{
					$tax_amount = 0;
					$net_value = ($po_item['amount']-$po_item['discount_amt']);
					if($po_date <$l_date)
					{
						if(empty($presumtiveTax)){
							if($po_item['cst'] == 0){
								$vat = $this->stock->get_item_vat($po_item['item_id']);
								$tax_amount = $po_item['vat_amt'];
							}else{
								$tax_amount = ($po_item['cst']*$net_value)/100;
							}
						}
					}
					else
					{
						$cgst = $this->stock->get_item_cgst($po_item['item_id']);
						$sgst = $this->stock->get_item_sgst($po_item['item_id']);
						$vat = $cgst + $sgst;	
						$tax_amount = $po_item['cgst_amt']+$po_item['sgst_amt'];
					}
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				}
				$total_amount += $total_tax_amount;
				if($po_date <$l_date)
				{
					if(!empty($presumtiveTax)){
						$presum_amount = ($presumtiveTax[0]*$total_amount)/100;
						$total_amount += $presum_amount;
					}
					$cess_amount = (($total_tax_amount+$presum_amount)*$cess)/100;
					$total_amount += ($cess_amount-$discountAmount);
				}
				else
				{
					$total_amount -= $discountAmount;	
				}
				$this->my_excel->set_border('A'.$line.':'.'E'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,'L');
				$this->my_excel->set_cell_value('B'.$line,$bill_prefix.' '.$purchase_order['po_no']);
				$this->my_excel->set_data_align('C'.$line,NULL);
				$date = dateFormat($purchase_order['po_date']);
				$this->my_excel->set_cell_value('C'.$line,$date);
				$this->my_excel->set_cell_value('D'.$line,$purchase_order['vendor_name']);
				$this->my_excel->number_format('E'.$line);
				$total=get_rounded($total_amount);
				$total_value = $total_value + $total;
				$this->my_excel->set_cell_value('E'.$line,$total);
				$line++;
			}
			$this->my_excel->set_bold('A'.$line.':E'.$line);
			$this->my_excel->set_border('A'.$line.':'.'E'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'D'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('E'.$line,$total_value);
			$this->my_excel->number_format('E'.$line);
			$this->my_excel->output_excel();
		}
	}
}