<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Quotations_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}
	public function quotations()
	{
		$this->load->model('sales/Quotation_model','quotation');
		$this->load->library(array('Stock'));
		$from_date = $this->uri->segment(4);
		$to_date = $this->uri->segment(5);
		$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_status','dq.area_id','dq.remarks','dq.qt_discount_amt','dq.cess','concat(cm.fname," ",cm.lname) as customer_name','cm.address','cm.mobile_no','cm.phone_no');
		$args['from_date'] = $from_date;
		$args['to_date'] = $to_date;
		$presumtiveTax = $this->stock->get_tax_type();
		$args['join'] = array('customer_master as cm'=>'cm.id=dq.customer_id');
		$quotations = $this->quotation->get($args);
		$quotation_types = array(0=>'Individual',1=>'Institutional');
		if(!empty($quotations))
		{
			#---------------------------------
			$head = "Quotation Report On ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','F');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':F'.$line,12);
			$this->my_excel->set_bold('A'.$line.':F'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Bill No.');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill Date');
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Customer');

			$this->my_excel->set_column_width('E',20);
			$this->my_excel->set_cell_value('E'.$line,'Quotation type');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Net Amount');
			//$this->my_excel->set_bg_color_range('A'.$line,5);
			$this->my_excel->set_bg_color_range(5, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'F'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'F'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'F'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($quotations as $qKey=>$quotation){
				$b_date = $quotation['qt_date'];
				$l_date = '2017-07-01';
				$netAmount=0;$totalNetAmount=0;$discountAmount=0;$totalVatAmount=0;
				$discountAmount = $quotation['qt_discount_amt'];
				$cess = $quotation['cess'];
				$quotationID = $quotation['id'];
				$quotation_status = $quotation['qt_status'];
				$quotation_type = $quotation_types[$quotation['qt_type']];
				$totalVatAmt=0;$grandNetAmount=0;$totalCst=0;$cst=0;
				$quotationID = $quotation['id'];
				if($b_date < $l_date)
				{
					$args = array();
					$args['select'] = array('dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_amt','dqi.cst','dqi.godown_id','im.item_code','im.item_name','um.symbol');
					$args['conditions'] = array('dqi.qt_id'=>$quotationID,'dq.status'=>1,'dqi.status'=>1);
					$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
					$quotation_items[$quotationID] = $this->quotation->get($args);
					
					foreach($quotation_items[$quotationID] as $qiKey=>$quotation_item)
					{
						$itemID = $quotation_item['item_id'];
						$qty = $quotation_item['qty'];
						$rate = $quotation_item['rate'];
						$cstPercent = $quotation_item['cst'];
						$discountPer = $quotation_item['discount_per'];
						$discountAmt = $quotation_item['discount_amt'];
						$vatAmount=0;$cstAmount=0;$vat=0;
						if($cstPercent == 0)
						{	
							$vat = $this->stock->get_item_vat($itemID);
						}
						$amount = $quotation_item['amount'];
						$netValue = $amount-$discountAmt;
						$cstAmount = ($cstPercent*$netValue)/100;
						if(empty($presumtiveTax)){
							$vatAmount = $quotation_item['vat_amt'];//($vat*$netValue)/100;
						}
						else{
							$cstAmount=0;
						}	
						$netValue += $cstAmount+$vatAmount;
						$totalVatAmt += $vatAmount;
						$grandNetAmount += $netValue;
						$totalCst += $cstAmount;
					}
				}
				else
				{
					$args = array();
					$args['select'] = array('dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.cgst_amt','dqi.sgst_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol');
					$args['conditions'] = array('dqi.qt_id'=>$quotationID,'dq.status'=>1,'dqi.status'=>1);
					$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
					$quotation_items[$quotationID] = $this->quotation->get($args);
					
					foreach($quotation_items[$quotationID] as $qiKey=>$quotation_item)
					{
						$itemID = $quotation_item['item_id'];
						$qty = $quotation_item['qty'];
						$rate = $quotation_item['rate'];
						$cstPercent = $quotation_item['cst'];
						$discountPer = $quotation_item['discount_per'];
						$discountAmt = $quotation_item['discount_amt'];
						$vatAmount=0;$cstAmount=0;$vat=0;
						
						$cgst = $this->stock->get_item_cgst($itemID);
						$sgst = $this->stock->get_item_sgst($itemID);
						$amount = $quotation_item['amount'];
						$netValue = $amount-$discountAmt;		
						$cgstAmount = $quotation_item['cgst_amt'];//($vat*$netValue)/100;
						$sgstAmount = $quotation_item['sgst_amt'];
						$vatAmount = $cgstAmount+$sgstAmount;
						$netValue +=$vatAmount;
						$totalVatAmt += $vatAmount;
						$grandNetAmount += $netValue;
						
					}
					
					
				}
				
				
				$gnTotalVatAmount=$totalVatAmt;
				if(!empty($presumtiveTax)){
					$pmTaxAmt = ($presumtiveTax[0]*$grandNetAmount)/100;
					$gnTotalVatAmount = $pmTaxAmt;
					$grandNetAmount += $pmTaxAmt;
				}
				$cessAmount=0;
				$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
				$grandNetAmount += $cessAmount;
				$grandNetAmount -= $discountAmount;

				#--------------------------------------
				$this->my_excel->set_border('A'.$line.':'.'F'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$this->my_excel->set_cell_value('B'.$line,$quotation['qt_no']);
				$this->my_excel->set_data_align('C'.$line,NULL);
				$date = dateFormat($quotation['qt_date']);
				$this->my_excel->set_cell_value('C'.$line,$date);
				$this->my_excel->set_cell_value('D'.$line,$quotation['customer_name']);
				$this->my_excel->set_cell_value('E'.$line,$quotation_type);
				$grandNetAmount = get_rounded($grandNetAmount);
				$total_value = $total_value + $grandNetAmount;
				$total=numberFormat($grandNetAmount);
				$this->my_excel->set_data_align('F'.$line,'R');
				$this->my_excel->set_cell_value('F'.$line,$total);

				$line++;
			}
			$total_value1=numberFormat($total_value);
			$this->my_excel->set_bold('A'.$line.':F'.$line);
			$this->my_excel->set_border('A'.$line.':'.'F'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'E'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('F'.$line,$total_value1);
			$this->my_excel->set_data_align('F'.$line,'R');
			$this->my_excel->output_excel();
		}
	}
}