<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_out_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}
	public function rejection_out()
	{
		$this->load->model('purchase/Rejection_out_model','purchase_obj');
		$this->load->library(array('Stock'));

		$vtype_id = 12;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		$presumptive_tax = $this->stock->get_tax_type();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------purchase_return report datas
		$purchase_array=$this->purchase_obj->get_bills(array('conditions' => $conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($purchase_array)){

			$head = "Rejection Out Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','F');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':F'.$line,12);
			$this->my_excel->set_bold('A'.$line.':F'.$line);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Invoice No');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Vendor');
			$this->my_excel->set_column_width('F',15);
			$this->my_excel->set_cell_value('F'.$line,'Net. Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,5);
			$this->my_excel->set_bg_color_range(5, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'F'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'F'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'F'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($purchase_array as $key => $value){

				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
				$item_details = $this->purchase_obj->get_purchase_items(array('columns' => array('item_id','qty','rate','amount','vat_amt','cst'),'conditions' => array('group_id' => $value['group_id'],'status' => 1)));
				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = $item_value['amount'];
					if(empty($presumptive_tax)){
						if($item_value['cst'] == 0){
							$vat = $this->stock->get_item_vat($item_value['item_id']);
							$tax_amount = $item_value['vat_amt'];
						}else{
							$tax_amount = ($item_value['cst']*$net_value)/100;
						}
					}
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				endforeach;
				$total_amount += $total_tax_amount;
				if(!empty($presumptive_tax)){
					$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					$total_amount += $presum_amount;
				}
				$cess_amount = (($total_tax_amount+$presum_amount)*$value['cess'])/100;
				$total_amount += ($cess_amount+$value['bill_freight']+$value['other_expense']);

				$this->my_excel->set_border('A'.$line.':'.'F'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,NULL);
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);
				$this->my_excel->set_data_align('D'.$line,NULL);
				$return_bill_no=$this->purchase_obj->get_bill_no($value['return_bill_no']);
				$this->my_excel->set_cell_value('D'.$line,$return_bill_no);
				$vendor_name=$this->stock->vendor_name($value['vendor_id']);
				$this->my_excel->set_cell_value('E'.$line,$vendor_name);
				$total_amount = get_rounded($total_amount);
				$total_value = $total_value + $total_amount;
				$this->my_excel->number_format('F'.$line);
				$this->my_excel->set_cell_value('F'.$line,$total_amount);
				$line++;
			}
			$this->my_excel->set_bold('A'.$line.':F'.$line);
			$this->my_excel->set_border('A'.$line.':'.'F'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'E'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('F'.$line,$total_value);
			$this->my_excel->number_format('F'.$line);
			$this->my_excel->output_excel();
		}
	}
}