<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_order_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function sales_order()
	{
		$from_date = $this->uri->segment(4);
		$to_date = $this->uri->segment(5);
		$this->branchID = $this->session->userdata('under_id');
		$this->load->model('sales/Sales_order_model','sales_order');
		$this->load->library('Stock');
		$bill_prefix = $this->stock->get_voucher_prefix(-1);
		$args = array();
		$args['select'] = array('dso.id','dso.branch_id','dso.so_no','dso.so_date','dso.group_id','dso.customer_type_id','dso.customer_id','dso.user_id','dso.area_id','dso.remarks','dso.so_status','dso.so_discount_per','dso.so_discount_amt','dso.cess','dso.pricelist_id','dm.designation_name as customer_type','am.area');
		$args['join'] = array('designation_master dm'=>'dso.customer_type_id=dm.id','area_master am'=>'dso.area_id=am.id');
		$args['conditions'] = array('dso.branch_id'=>$this->branchID);
		$args['between'] = array('from_date'=>$from_date,'to_date'=>$to_date);
		$sales_orders = $this->sales_order->get_sales_order($args);
		$presumtiveTax = $this->stock->get_tax_type();
		if(!empty($sales_orders)){

			#---------------------------------
			$head = "Sales Order Report ".dateFormat($from_date).' To '.dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Bill No.');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Date');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Customer Type');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Customer Name');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Area');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Net Amount');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
			$this->my_excel->set_bg_color_range(7, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($sales_orders as $key=>$sales_order){

				$cess = $sales_order['cess'];
				$args = array();
				$args['select'] = array('dsi.id','dsi.item_id','dsi.qty','dsi.unit_id','dsi.rate','dsi.amount','dsi.discount_per','dsi.discount_amt','dsi.godown_id','dsi.status');
				$args['conditions'] = array('dsi.group_id'=>$sales_order['group_id'],'dsi.status'=>1,'dsi.item_status <='=>1);
				$salesOrderItems[$sales_order['id']] = $this->sales_order->get_sales_order_items($args);
				$salesOrderID=$sales_order['id'];
				$totalVatAmt=0;$grandNetAmount=0;$totalCst=0;$cst=0;

				foreach($salesOrderItems[$salesOrderID] as $itmKey=>$item){

					$itemID = $item['item_id'];
					$qty = $item['qty'];
					$rate = $item['rate'];
					$cstPercent = $item['cst'];
					$discountPer = $item['discount_per'];
					$discountAmt = $item['discount_amt'];
					$vatAmount=0;$cstAmount=0;$vat=0;
					if($cstPercent == 0){$vat = $this->stock->get_item_vat($itemID);}else{$cst=1;}
					$amount = $item['amount'];
					$netValue = $amount-$discountAmt;
					$cstAmount = ($cstPercent*$netValue)/100;
					if(empty($presumtiveTax)){
						$vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
					}
					else{
						$cstAmount=0;
					}
					$netValue += $cstAmount+$vatAmount;
					$totalVatAmt += $vatAmount;
					$grandNetAmount += $netValue;
					$totalCst += $cstAmount;
				}
				$gnTotalVatAmount=$totalVatAmt;
				if(!empty($presumtiveTax)){
					$pmTaxAmt = ($presumtiveTax[0]*$grandNetAmount)/100;
					$gnTotalVatAmount = $pmTaxAmt;
					$grandNetAmount += $pmTaxAmt;
				}
				$cessAmount=0;
				$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
				$grandNetAmount += $cessAmount;
				$grandNetAmount -= $sales_order['so_discount_amt'];

				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,'L');
				$this->my_excel->set_cell_value('B'.$line,$bill_prefix.' '.$sales_order['so_no']);
				$this->my_excel->set_data_align('C'.$line,NULL);
				$date = dateFormat($sales_order['so_date']);
				$this->my_excel->set_cell_value('C'.$line,$date);
				$this->my_excel->set_cell_value('D'.$line,$sales_order['customer_type']);
				$custTypeID = $sales_order['customer_type_id'];
				$customerID = $sales_order['customer_id'];
				$customer_name = $this->stock->get_customer($custTypeID,$customerID);
				$this->my_excel->set_cell_value('E'.$line,$customer_name);
				$this->my_excel->set_cell_value('F'.$line,$sales_order['area']);
				$total=get_rounded($grandNetAmount);
				$total_value = $total_value + $total;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('F'.$line,$sales_order['area']);
				$this->my_excel->set_cell_value('G'.$line,$total);
				$line++;
			}
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();

		}
	}
}