<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Stock_item_register_excel extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->load->library(array('Stock','Stock_summary','Accounts','My_excel'));
		}
	  #-----------------------------------------------------------
		public function report(){

			if(!empty($this->uri->segment(4)))
			{
				$data = $this->uri->uri_to_assoc(4);
				//echo '<pre>';print_r($data);die;
				$item_id = $data['item_id'];
				$from_date = $data['from_date'];
				$to_date = $data['to_date'];
				$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
				$stock_array = array();
				if(!empty($item_id) && !empty($from_date) && !empty($to_date))
				{
					$pre_from_date = date('Y-m-d',(strtotime($from_date)-86400));
					$pre_to_date = date('Y-m-d',(strtotime($to_date)-86400));

					#-----------starting fiscal year details
					$fiscal_details = $this->dms->get_default();

					#-------------opening stock calculation
					if($fiscal_start_date == $from_date)
					{
						$opening_item_qty = $this->accounts->item_bal_qty($item_id,$fiscal_details['start_date'],$pre_from_date);

						if($opening_item_qty > 0)
						{
							#-----------last closed year details
							$closed_details = $this->accounts->last_closed_yr($fiscal_start_date);

							#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
							$stock_value_type = $this->dms->stock_value_type($closed_details['id']);

							$opening_item_rate = $this->accounts->item_rate($item_id,$closed_details['start_date'],$closed_details['end_date'],$stock_value_type);
						}
						else
						{
							#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
							$stock_value_type = $this->dms->stock_value_type();

							$opening_item_qty = $this->stock_summary->item_opening_qty($item_id,$fiscal_start_date);
							$opening_item_rate = $this->stock_summary->item_opening_rate($item_id,$fiscal_start_date);
						}
					}
					else
					{
						#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
						$stock_value_type = $this->dms->stock_value_type();

						$opening_item_qty = $this->accounts->item_bal_qty($item_id,$fiscal_details['start_date'],$pre_from_date);
						$opening_item_rate = $this->accounts->item_rate($item_id,$fiscal_start_date,$pre_to_date,$stock_value_type);
					}

					#----------opening value
					$opening_item_value = round_this($opening_item_qty * $opening_item_rate);

					#----------stock distinct dates between selected dates
					//$stock_date_array = $this->stock_summary->stock_dates($item_id,$from_date,$to_date);

					$stock_array = $this->stock_summary->item_register($item_id,$from_date,$to_date,$opening_item_qty);

					if(!empty($stock_array) || !empty($opening_item_qty))
					{
						$unit = $this->stock->get_unit_symbol($item_id);
						#------------------------------------------------------Excel---------------------------------------------------------------
						#sethead
						$item_name = $this->dms->get_item_name($item_id);
						$head = "Item Wise Stock Register From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
						$subhead = "Item : ".$item_name;
						$this->my_excel->set_title($head);
						$this->my_excel->set_headline($head);
						#set subhead
						$line = $this->my_excel->get_line();
						$line = $line+1;
						$this->my_excel->merge_cell('A'.$line.':D'.$line);
						$this->my_excel->set_cell_value('A'.$line,$subhead);
						$this->my_excel->set_font_size('A'.$line);
						$this->my_excel->set_bold('A'.$line);
						#get start line  line
						$line = $this->my_excel->report_head_line();
						$this->my_excel->merge_cell('F'.$line.':H'.$line);
						$this->my_excel->merge_cell('I'.$line.':K'.$line);
						$this->my_excel->merge_cell('L'.$line.':N'.$line);
						#merging and styling for head
						$next_line = $line+1;
						$this->my_excel->merge_cell('F'.$next_line.':G'.$next_line);
						$this->my_excel->merge_cell('I'.$next_line.':J'.$next_line);
						$this->my_excel->merge_cell('L'.$next_line.':M'.$next_line);
						$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
						$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
						$this->my_excel->merge_cell('C'.$line.':C'.$next_line);
						$this->my_excel->merge_cell('D'.$line.':D'.$next_line);
						$this->my_excel->merge_cell('E'.$line.':E'.$next_line);

						$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
						$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");
						$this->my_excel->set_data_align('C'.$line.':C'.$next_line,"M");
						$this->my_excel->set_data_align('D'.$line.':D'.$next_line,"M");
						$this->my_excel->set_data_align('E'.$line.':E'.$next_line,"M");

						#first row head
						$headings = array('A'=>'#','B'=>'Date','C'=>'Particulars','D'=>'Vch Type','E'=>'Vch No','F'=>'Inwards','I'=>'Outwards','L'=>'Closing Balance');
						$head_width = array('A'=>4,'B'=>12,'C'=>25,'D'=>18,'E'=>10,'F'=>18,'G'=>5,'H'=>18,'I'=>18,'J'=>5,'K'=>18,'L'=>18,'M'=>5,'N'=>18);
						$this->my_excel->set_report_head($headings,array(),$line,12);
						$this->my_excel->set_cell_width($head_width);
						$this->my_excel->set_bg_color_range(8, 'A' . $line);
						
						//$this->my_excel->output_excel();
						$line = $line+1;
						#second row width
						$headings = array('A'=>'','B'=>'','C'=>'','D'=>'','E'=>'','F'=>'Quantity','G'=>'','H'=>'value','I'=>'Quantity','J'=>'','K'=>'Value','L'=>'Quantity','M'=>'','N'=>'Value');
						$head_width = array('A'=>4,'B'=>12,'C'=>25,'D'=>18,'E'=>10,'F'=>18,'G'=>5,'H'=>18,'I'=>18,'J'=>5,'K'=>18,'L'=>18,'M'=>5,'N'=>18);
						$this->my_excel->set_report_head($headings,array(),$line,13);
						$this->my_excel->set_cell_width($head_width);
						$this->my_excel->set_bg_color_range(8, 'A' . $line);

						$line = $line+1;
						#--------------------------opening balance row--------------------------------
						$this->my_excel->merge_cell('C'.$line.':E'.$line);
						$this->my_excel->set_cell_value('B'.$line,dateFormat($from_date));
						$this->my_excel->set_cell_value('C'.$line,'Opening Balance');
						if(!empty($opening_item_qty)){
							$this->my_excel->set_cell_value('F'.$line,$opening_item_qty);
							$this->my_excel->set_cell_value('G'.$line,$unit);
						}
						if(!empty($opening_item_value)){
							$this->my_excel->set_cell_value('H'.$line,$opening_item_value);
						}
						if(!empty($opening_item_qty)){
							$this->my_excel->set_cell_value('L'.$line,$opening_item_qty);
							$this->my_excel->set_cell_value('M'.$line,$unit);
						}
						if(!empty($opening_item_value)){
							$this->my_excel->set_cell_value('N'.$line,$opening_item_value);
						}
						$this->my_excel->set_data_align('B'.$line);
						$this->my_excel->set_data_align('C'.$line,"L");
						$this->my_excel->number_format('F'.$line);
						$this->my_excel->number_format('H'.$line);
						$this->my_excel->number_format('L'.$line);
						$this->my_excel->number_format('N'.$line);
						$this->my_excel->set_bold('A'.$line.':N'.$line);
						#------------------------------------------------------------------------------
						$total_inwards_qty = $opening_item_qty;$total_inwards_value = $opening_item_value;
						$total_outwards_qty = $total_outwards_value = $total_closing_qty = $total_closing_value = 0;
						$line =$line+1;
						if(!empty($stock_array))
						{
							$i=1;
							foreach($stock_array as $key => $value)
							{
								$this->my_excel->set_cell_value('A'.$line,$i);
								$this->my_excel->set_cell_value('B'.$line,dateFormat($value['date']));
								$this->my_excel->set_cell_value('C'.$line,stringFormat($value['particulars']));
								$this->my_excel->set_cell_value('D'.$line,stringFormat($value['vname']));
								$this->my_excel->set_cell_value('E'.$line,stringFormat($value['vno']));
								if(!empty($value['inwards_qty'])){
									$this->my_excel->set_cell_value('F'.$line,$value['inwards_qty']);
									$this->my_excel->set_cell_value('G'.$line,$unit);	
								}
								if(!empty($value['inwards_value'])){
									$this->my_excel->set_cell_value('H'.$line,$value['inwards_value']);
								}
								if(!empty($value['outwards_qty'])){
									$this->my_excel->set_cell_value('I'.$line,$value['outwards_qty']);
									$this->my_excel->set_cell_value('J'.$line,$unit);
								}
								if(!empty($value['outwards_value'])){
									$this->my_excel->set_cell_value('K'.$line,$value['outwards_value']);
								}
								if(!empty($value['closing_qty'])){
									$this->my_excel->set_cell_value('L'.$line,$value['closing_qty']);
									$this->my_excel->set_cell_value('M'.$line,$unit);	
								}
								if(!empty($value['closing_value'])){
									$this->my_excel->set_cell_value('N'.$line,$value['closing_value']);	
								}
								#styles
								$this->my_excel->set_data_align('B'.$line);
								$this->my_excel->set_wrap_text('C'.$line);
								$this->my_excel->set_wrap_text('D'.$line);
								$this->my_excel->number_format('F'.$line);
								$this->my_excel->number_format('H'.$line);
								$this->my_excel->number_format('I'.$line);
								$this->my_excel->number_format('K'.$line);
								$this->my_excel->number_format('L'.$line);
								$this->my_excel->number_format('N'.$line);
								
								$total_inwards_qty += $value['inwards_qty'];
								$total_inwards_value += $value['inwards_value'];
								$total_outwards_qty += $value['outwards_qty'];
								$total_outwards_value += $value['outwards_value'];
								$total_closing_qty = $value['closing_qty'];
								$total_closing_value = $value['closing_value'];
								$i++;
								$line++;
							}
						}
						#------------------------------------------------------------------------------
						#total value calcularion
						$this->my_excel->merge_cell('A'.$line.':E'.$line);
						$this->my_excel->set_cell_value('A'.$line,'Grand Total');
						$this->my_excel->set_data_align('A'.$line,"R");
						if(!empty($total_inwards_qty)){
							$this->my_excel->set_cell_value('F'.$line,$total_inwards_qty);
							$this->my_excel->set_cell_value('G'.$line,$unit);	
						}
						if(!empty($total_inwards_value)){
							$this->my_excel->set_cell_value('H'.$line,$total_inwards_value);
						}
						if(!empty($total_outwards_qty)){
							$this->my_excel->set_cell_value('I'.$line,$total_outwards_qty);
							$this->my_excel->set_cell_value('J'.$line,$unit);
						}
						if(!empty($total_outwards_value)){
							$this->my_excel->set_cell_value('K'.$line,$total_outwards_value);
						}
						if(!empty($total_closing_qty)){
							$this->my_excel->set_cell_value('L'.$line,$total_closing_qty);
							$this->my_excel->set_cell_value('M'.$line,$unit);	
						}
						if(!empty($total_closing_value)){
							$this->my_excel->set_cell_value('N'.$line,$total_closing_value);	
						}
						$this->my_excel->number_format('F'.$line);
						$this->my_excel->number_format('H'.$line);
						$this->my_excel->number_format('I'.$line);
						$this->my_excel->number_format('K'.$line);
						$this->my_excel->number_format('L'.$line);
						$this->my_excel->number_format('N'.$line);
						$this->my_excel->set_bold('A'.$line.':N'.$line);
						#------------------------------------------------------------------------------
						$this->my_excel->set_border('A4:N'.$line);
						$this->my_excel->output_excel();
					}
					else
					{
						echo "<script>alert('".$this->lang->line('invalid-stock-item-register')."');window.close();</script>";
					}
				}
				else
				{
					echo "<script>alert('".$this->lang->line('invalid-stock-item-register')."');window.close();</script>";
				}
			}
			else
			{
				echo "<script>alert('".$this->lang->line('invalid-stock-item-register')."');window.close();</script>";
			}
		}
	  #-----------------------------------------------------------
	}
?>