<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Stock_monthly_report_excel extends MY_Controller{

		public function __construct(){

			parent ::__construct();
			$this->load->library(array('Stock','Stock_summary','Accounts','My_excel'));
		}
	  #-------------------------------------------------------------------------------------
		public function report(){
			if(!empty($this->uri->segment(4))){
				$data = $this->uri->uri_to_assoc(4);
				$item_id = $data['item_id'];
				$from_date = $data['from_date'];
				$to_date = $data['to_date'];
				$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
				if(!empty($item_id) && !empty($from_date) && !empty($to_date))
				{
					$from_time = strtotime($from_date);
					$to_time = strtotime($to_date);
					$from_year = date('Y',$from_time);
					$to_year = date('Y',$to_time);
					$from_month = date('n',$from_time);
					$to_month = date('n',$to_time);
					$month_array = $this->dms->get_months($from_date,$to_date,1);
					$pre_from_date = date('Y-m-d',($from_time-86400));
					$pre_to_date = date('Y-m-d',($to_time-86400));

					#-----------starting fiscal year details
					$fiscal_details = $this->dms->get_default();

					#-------------opening stock calculation
					if($fiscal_start_date == $from_date)
					{
						$opening_item_qty = $this->accounts->item_bal_qty($item_id,$fiscal_details['start_date'],$pre_from_date);

						if($opening_item_qty > 0)
						{
							#-----------last closed year details
							$closed_details = $this->accounts->last_closed_yr($fiscal_start_date);

							#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
							$stock_value_type = $this->dms->stock_value_type($closed_details['id']);

							$opening_item_rate = $this->accounts->item_rate($item_id,$closed_details['start_date'],$closed_details['end_date'],$stock_value_type);
						}
						else
						{
							#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
							$stock_value_type = $this->dms->stock_value_type();

							$opening_item_qty = $this->stock_summary->item_opening_qty($item_id,$fiscal_start_date);
							$opening_item_rate = $this->stock_summary->item_opening_rate($item_id,$fiscal_start_date);
						}
					}
					else
					{
						#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
						$stock_value_type = $this->dms->stock_value_type();

						$opening_item_qty = $this->accounts->item_bal_qty($item_id,$fiscal_details['start_date'],$pre_from_date);
						$opening_item_rate = $this->accounts->item_rate($item_id,$fiscal_start_date,$pre_to_date,$stock_value_type);
					}

					#----------opening value
					$opening_item_value = round_this($opening_item_qty * $opening_item_rate);

					$closing_qty = $opening_item_qty;
					foreach($month_array as $key => $value)
					{
						$item_inwards = $this->stock_summary->item_inwards_qty_rate($item_id,$value['from_date'],$value['to_date']);
						$item_outwards = $this->stock_summary->item_outwards_qty_rate($item_id,$value['from_date'],$value['to_date']);				

						#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
						$stock_value_type = $this->dms->stock_value_type();

						#-----------closing qty and value
						$closing_qty += ($item_inwards['qty'] - $item_outwards['qty']);
						$item_rate = $this->accounts->item_rate($item_id,$value['from_date'],$value['to_date'],$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						$stock_array[$key] = array('month' => $value['month'],'item_inwards' => $item_inwards,'item_outwards' => $item_outwards,'closing_qty' => $closing_qty,'closing_value' => $closing_value);
					}
					if(!empty($stock_array) || !empty($opening_item_qty)){
						$unit = $this->stock->get_unit_symbol($item_id);
						#------------------------------------------------------Excel---------------------------------------------------------------
						#sethead
						$item_name = $this->dms->get_item_name($item_id);
						$head = "Stock Item Monthly Report From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
						$subhead = "Item : ".$item_name;
						$this->my_excel->set_title($head);
						$this->my_excel->set_headline($head);
						#set subhead
						$line = $this->my_excel->get_line();
						$line = $line+1;
						$this->my_excel->merge_cell('A'.$line.':D'.$line);
						$this->my_excel->set_cell_value('A'.$line,$subhead);
						$this->my_excel->set_font_size('A'.$line);
						$this->my_excel->set_bold('A'.$line);
						#get start line  line
						$line = $this->my_excel->report_head_line();
						$this->my_excel->merge_cell('C'.$line.':E'.$line);
						$this->my_excel->merge_cell('F'.$line.':H'.$line);
						$this->my_excel->merge_cell('I'.$line.':K'.$line);
						#merging and styling for head
						$next_line = $line+1;
						$this->my_excel->merge_cell('C'.$next_line.':D'.$next_line);
						$this->my_excel->merge_cell('F'.$next_line.':G'.$next_line);
						$this->my_excel->merge_cell('I'.$next_line.':J'.$next_line);
						$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
						$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
						$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
						$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");

						#first row head
						$headings = array('A'=>'#','B'=>'Particulars','C'=>'Inwards','F'=>'Outwards','I'=>'Closing Balance');
						$head_width = array('A'=>4,'B'=>20,'C'=>18,'D'=>5,'E'=>18,'F'=>18,'G'=>5,'H'=>18,'I'=>18,'J'=>5,'K'=>18);
						$this->my_excel->set_report_head($headings,array(),$line,9);
						$this->my_excel->set_cell_width($head_width);
						$this->my_excel->set_bg_color_range(6, 'A' . $line);

						$line = $line+1;
						#second row width
						$headings = array('A'=>'','B'=>'','C'=>'Quantity','D'=>'','E'=>'value','F'=>'Quantity','G'=>'','H'=>'value','I'=>'Quantity','J'=>'','K'=>'Value');
						$head_width = array('A'=>4,'B'=>20,'C'=>18,'D'=>5,'E'=>18,'F'=>18,'G'=>5,'H'=>18,'I'=>18,'J'=>5,'K'=>18);
						$this->my_excel->set_report_head($headings,array(),$line,10);
						$this->my_excel->set_cell_width($head_width);
						$this->my_excel->set_bg_color_range(6, 'A' . $line);

						$line = $line+1;
						#--------------------------opening balance row--------------------------------
						$this->my_excel->merge_cell('A'.$line.':B'.$line);
						$this->my_excel->set_cell_value('A'.$line,'Opening Balance');
						if(!empty($opening_item_qty)){
							$this->my_excel->set_cell_value('I'.$line,$opening_item_qty);
							$this->my_excel->set_cell_value('J'.$line,$unit);
						}
						if(!empty($opening_item_value)){
							$this->my_excel->set_cell_value('K'.$line,$opening_item_value);
						}
						$this->my_excel->set_data_align('A'.$line,"R");
						$this->my_excel->set_data_align('B'.$line,"R");
						$this->my_excel->number_format('I'.$line);
						$this->my_excel->number_format('K'.$line);
						$this->my_excel->set_bold('A'.$line.':K'.$line);
						#------------------------------------------------------------------------------
						$total_inwards_qty = $total_inwards_value = $total_outwards_qty = $total_outwards_value = $total_closing_qty = $total_closing_value = 0;
						if(!empty($stock_array)){
							$i=1;
							$line =$line+1;
							foreach($stock_array as $key => $value){
								$this->my_excel->set_cell_value('A'.$line,$i);
								$this->my_excel->set_cell_value('B'.$line,stringFormat($value['month']));
								if(!empty($value['item_inwards']['qty'])){
									$this->my_excel->set_cell_value('C'.$line,$value['item_inwards']['qty']);
									$this->my_excel->set_cell_value('D'.$line,$unit);	
								}
								if(!empty($value['item_inwards']['rates'])){
									$this->my_excel->set_cell_value('E'.$line,$value['item_inwards']['rates']);
								}
								if(!empty($value['item_outwards']['qty'])){
									$this->my_excel->set_cell_value('F'.$line,$value['item_outwards']['qty']);
									$this->my_excel->set_cell_value('G'.$line,$unit);
								}
								if(!empty($value['item_outwards']['rates'])){
									$this->my_excel->set_cell_value('H'.$line,$value['item_outwards']['rates']);
								}
								if(!empty($value['closing_qty']) && (!empty($value['item_inwards']['qty']) || !empty($value['item_outwards']['qty']))){
									$this->my_excel->set_cell_value('I'.$line,$value['closing_qty']);
									$this->my_excel->set_cell_value('J'.$line,$unit);	
								}
								if(!empty($value['closing_value'])){
									$this->my_excel->set_cell_value('K'.$line,$value['closing_value']);	
								}
								#styles
								$this->my_excel->number_format('C'.$line);
								$this->my_excel->number_format('E'.$line);
								$this->my_excel->number_format('F'.$line);
								$this->my_excel->number_format('H'.$line);
								$this->my_excel->number_format('I'.$line);
								$this->my_excel->number_format('J'.$line);
								$this->my_excel->number_format('K'.$line);
								$total_inwards_qty += $value['item_inwards']['qty'];
								$total_inwards_value += $value['item_inwards']['rates'];
								$total_outwards_qty += $value['item_outwards']['qty'];
								$total_outwards_value += $value['item_outwards']['rates'];
								$total_closing_qty = $value['closing_qty'];
								$total_closing_value = $value['closing_value'];
								$i++;
								$line++;
							}
							#total value calcularion
							$this->my_excel->merge_cell('A'.$line.':B'.$line);
							$this->my_excel->set_cell_value('A'.$line,'Grand Total');
							$this->my_excel->set_data_align('A'.$line,"R");
							if(!empty($total_inwards_qty)){
								$this->my_excel->set_cell_value('C'.$line,$total_inwards_qty);
								$this->my_excel->set_cell_value('D'.$line,$unit);	
							}
							if(!empty($total_inwards_qty)){
								$this->my_excel->set_cell_value('E'.$line,$total_inwards_value);
							}
							if(!empty($total_outwards_qty)){
								$this->my_excel->set_cell_value('F'.$line,$total_outwards_qty);
								$this->my_excel->set_cell_value('G'.$line,$unit);
							}
							if(!empty($total_outwards_qty)){
								$this->my_excel->set_cell_value('H'.$line,$total_outwards_value);
							}
							if(!empty($total_closing_qty)){
								$this->my_excel->set_cell_value('I'.$line,$total_closing_qty);
								$this->my_excel->set_cell_value('J'.$line,$unit);	
							}
							if(!empty($total_closing_value)){
								$this->my_excel->set_cell_value('K'.$line,$total_closing_value);	
							}
							$this->my_excel->number_format('C'.$line);
							$this->my_excel->number_format('E'.$line);
							$this->my_excel->number_format('F'.$line);
							$this->my_excel->number_format('H'.$line);
							$this->my_excel->number_format('I'.$line);
							$this->my_excel->number_format('J'.$line);
							$this->my_excel->number_format('K'.$line);
							$this->my_excel->set_bold('A'.$line.':K'.$line);
						}
						$this->my_excel->set_border('A4:K'.$line);
						$this->my_excel->output_excel();
					}
					else{
						echo "<script>alert('".$this->lang->line('invalid-monthly-report')."');window.close();</script>";
					}
				}
				else{
					echo "<script>alert('".$this->lang->line('invalid-monthly-report')."');window.close();</script>";
				}
			
			}
			else{
				echo "<script>alert('".$this->lang->line('invalid-monthly-report')."');window.close();</script>";
			}
		}
	  #-------------------------------------------------------------------------------------
	}
?>