<?php if(! defined('BASEPATH')) exit('No direct script access allowed');

	class Trial_balance_excel extends MY_Controller{

		public function __construct(){
			parent ::__construct();
		}
	   #---------------------------------------------------
		public function report(){
			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$from_date = $this->uri->segment(4);
			$to_date = $this->uri->segment(5);

			//$total_dr = $total_cr = 0;
			$voucher_array = array();$dc = "";$open_bal_dr = $open_bal_cr = $opening_bal = $total_dr = $total_cr = $profit_loss_dr = $profit_loss_cr = 0;
			if(!empty($from_date) && !empty($to_date))
			{
				$gross_expense = $gross_income = $opening_stock = 0;
				$next_date = date('Y-m-d',(strtotime($to_date)+86400));
				$pre_date = date('Y-m-d',(strtotime($from_date)-86400));
				
				#----------closed details
				$closed = $this->accounts->last_closed_yr($from_date);
				if($closed)
				{
					$open_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
				}
				else
				{
					$open_date  = $this->accounts->stock_open_date();
				}
				
				$data_array = array('columns' => array('id','sub_group','dc'));
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=7 or primary_group_id=8 or primary_group_id=9 or primary_group_id=11 or primary_group_id=12 or primary_group_id=1 or primary_group_id=2)"));
				foreach($account_groups as $key => $value)
				{
					$dr_amount = $cr_amount = $opening_bal = 0;	
					$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);			
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
					if($value['id'] == 16)//stock in hand
					{
						$dr_amount = $this->accounts->stock_bal_amt($from_date);
					}				
					if($value['dc'] == 'dr')
					{
						$dr_amount += ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
						if($dr_amount < 0)
						{
							$cr_amount = -$dr_amount;
							$dr_amount = 0;
						}
					}
					else
					{
						$cr_amount += ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
						if($cr_amount < 0)
						{
							$dr_amount = -$cr_amount;
							$cr_amount = 0;
						}
					}					
					if($dr_amount > 0 || $cr_amount > 0)
					{					
						$voucher_array[$value['id']] = array('group_name' => $value['sub_group'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
					}
					$total_dr += $dr_amount;
					$total_cr += $cr_amount;
				}

				#-----------expense		
				$account_groups_expense = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
				foreach($account_groups_expense as $key => $value)
				{
					$dr_amount = $cr_amount = $opening_bal = 0;
					$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);
					$dr_amount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
					if($dr_amount < 0)
					{
						$cr_amount = -$dr_amount;
						$dr_amount = 0;
					}	
					if($dr_amount > 0 || $cr_amount > 0)
					{					
						$vouchers_array[$value['id']] = array('group_name' => $value['sub_group'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
					}
					$total_dr += $dr_amount;
					$total_cr += $cr_amount;		
				}
				
				#-----------income
				$account_groups_income = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
				foreach($account_groups_income as $key => $value)
				{
					$dr_amount = $cr_amount = $opening_bal = 0;
					$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);
					$cr_amount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;	
					if($cr_amount < 0)
					{
						$dr_amount = -$cr_amount;
						$cr_amount = 0;
					}	
					if($dr_amount > 0 || $cr_amount > 0)
					{					
						$vouchers_array[$value['id']] = array('group_name' => $value['sub_group'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
					}
					$total_dr += $dr_amount;
					$total_cr += $cr_amount;				
				}

				#-------------profit & loss A/c
				$profit_loss = $this->accounts->opening_bal(7,$from_date);//Profit & Loss A/c								

				#-----------expense		
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
				foreach($account_groups as $key => $value)
				{
					$opening_bal = 0;
					$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);	
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$from_date,1);
					$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
					$gross_expense += $vamount;				
				}
				
				#-----------income
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
				foreach($account_groups as $key => $value)
				{
					$opening_bal = 0;	
					$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);	
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$from_date,1);
					$vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
					$gross_income += $vamount;			
				}
				
				if($gross_expense != 0 || $gross_income != 0)
				{
					#-----------opening stock
					$gross_expense += $this->accounts->stock_bal_amt($open_date);
												
					#-----------closed stock
					$closed_voucher_stock_bal = $this->accounts->voucher_bal(16,$pre_date,1,$open_date);//stock in hand voucher
					$closed_stock_bal = $this->accounts->stock_bal_amt($pre_date,0,1);//stock in hand stock		
					$closed_stock = ($closed_voucher_stock_bal['dr_amount'] - $closed_voucher_stock_bal['cr_amount']) + $closed_stock_bal;			
					$gross_income += $closed_stock;
				}
				
				#------------profit & loss calculation
				$profit_loss += ($gross_income - $gross_expense);
				if($profit_loss > 0)
				{
					$profit_loss_cr = $profit_loss;
					$total_cr += $profit_loss_cr;
				}
				elseif($profit_loss < 0)
				{
					$profit_loss_dr = -$profit_loss;
					$total_dr += $profit_loss_dr;
				}
				
				#------------Total calculation
				if($total_dr > $total_cr)
				{
					$open_bal_cr = $total_dr - $total_cr;
					$total_cr += $open_bal_cr;
				}
				elseif($total_cr > $total_dr)
				{
					$open_bal_dr = $total_cr - $total_dr;
					$total_dr += $open_bal_dr;
				}

			    #--------------------------------------------excel-----------------------------
			    $head = "Trial Balance From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);

				#report head
				$line = $this->my_excel->report_head_line();
				$this->my_excel->merge_cell('C'.$line.':D'.$line);

				

				#merging and styling for head
				$next_line = $line+1;
				$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
				$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
				$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
				$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");
				//$this->my_excel->excelObj->getActiveSheet()->getStyle('B'.$line.':B'.$next_line)->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);	
				#first row head
				$headings = array('A'=>'#','B'=>'Particulars','C'=>'Closing Balance');
				$head_width = array('B'=>40,'C'=>50,);
				$this->my_excel->set_report_head($headings,array(),$line,NULL);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(3, 'A' . $line);
				$line = $line+1;
				#second row width
				$headings = array('C'=>'Debit','D'=>'Credit');
				$head_width = array('C'=>25,'D'=>25);
				$this->my_excel->set_report_head($headings,array(),$line,3);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(5, 'A' . $line);
				$i=1;
				$line =$line+1;
				foreach($voucher_array as $key => $value){

					$this->my_excel->set_cell_value('A'.$line,$i);
					$this->my_excel->set_cell_value('B'.$line, stringFormat($value['group_name']));
					$this->my_excel->set_cell_value('C'.$line,$value['dr_amount']);
					$this->my_excel->set_cell_value('D'.$line,$value['cr_amount']);

					$this->my_excel->number_format('C'.$line);
					$this->my_excel->number_format('D'.$line);
					$this->my_excel->set_wrap_text('B'.$line);
					$this->my_excel->set_data_align('A'.$line);
					$line++;
					$i++;

				}
				#profit loss
				if($profit_loss_dr > 0 || $profit_loss_cr > 0)
				{
					$this->my_excel->set_cell_value('B'.$line,'Profit & Loss A/c');
					$this->my_excel->set_cell_value('C'.$line,$profit_loss_dr);
					$this->my_excel->set_cell_value('D'.$line,$profit_loss_cr);

					$this->my_excel->number_format('C'.$line);
					$this->my_excel->number_format('D'.$line);
					$line = $line+1;
				}
				if($open_bal_dr > 0 || $open_bal_cr > 0)
				{
					$this->my_excel->set_cell_value('B'.$line,'Diff. in Opening Balances');
					$this->my_excel->set_cell_value('C'.$line,$open_bal_dr);
					$this->my_excel->set_cell_value('D'.$line,$open_bal_cr);
					$this->my_excel->set_data_align('B'.$line,"R");
					$this->my_excel->number_format('C'.$line);
					$this->my_excel->number_format('D'.$line);
					$line = $line+1;
				}
				$this->my_excel->set_cell_value('B'.$line,'Grand Total');
				$this->my_excel->set_cell_value('C'.$line,$total_dr);
				$this->my_excel->set_cell_value('D'.$line,$total_cr);
				$this->my_excel->set_data_align('B'.$line,"R");
				$this->my_excel->number_format('C'.$line);
				$this->my_excel->number_format('D'.$line);
				$this->my_excel->set_bold('A'.$line.':D'.$line);

				$this->my_excel->set_border('A4:D'.$line);
				$this->my_excel->output_excel(); 
			}
			else{
				echo "<script>alert('".$this->lang->line('invalid-trail-balance')."');window.close();</script>";
			}
		

		}
	   #---------------------------------------------------
	}
?>