<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
	
class Vouchers_excel extends MY_Controller
{

	public function __construct()
	{
		parent ::__construct();
	}

	public function vouchers()
	{		
		$this->load->library('My_excel');
		$this->load->library('Accounts');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$like_array = array();
		$vtype_id = $this->uri->segment(4);
		$from_date = $this->uri->segment(5);
		$to_date = $this->uri->segment(6);
		$between = "vdate between '$from_date' and '$to_date'";
		
		if(!empty($this->uri->segment(7)))
		{
			$like_array['vno'] = $this->uri->segment(7);
		}
		
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		#----------distinct voucher no's
		$voucher_array=$this->vouchers->get_voucher_ids(array('table' => 'dms_vouchers','distinct' => array('vtype_id','vno'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'vno','order'=>'ASC'));
		
		if(!empty($voucher_array))
		{
			if($vtype_id == '1'){$head = "Payment Voucher Report On ".dateFormat(date('Y-m-d'));}
			else if($vtype_id == '2'){$head = "Receipt Voucher Report On ".dateFormat(date('Y-m-d'));}
			else if($vtype_id == '3'){$head = "Contra Voucher Report On ".dateFormat(date('Y-m-d'));}
			else if($vtype_id == '4'){$head = "Journal Voucher Report On ".dateFormat(date('Y-m-d'));}
			//$head = "Payment Voucher Report On ".dateFormat(date('Y-m-d'));
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','E');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':E'.$line,12);
			$this->my_excel->set_bold('A'.$line.':E'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Voucher No.');
			$this->my_excel->set_column_width('D',60);
			$this->my_excel->set_cell_value('D'.$line,'Particulars');
			$this->my_excel->set_column_width('E',20);
			$this->my_excel->set_cell_value('E'.$line,'Amount');
			//$this->my_excel->set_bg_color_range('A'.$line,4);
			$this->my_excel->set_bg_color_range(4, 'A' . $line);

			$this->my_excel->set_font_size('A'.$line.':'.'E'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'E'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'E'.$line,NULL);
			$line = $line+1;
			$i=0;$total_value =0;$vids="";
			foreach($voucher_array as $vchr => $voucher_details)
			{
				$voucher_detail_array = $this->vouchers->get_vouchers(array('table' => 'dms_vouchers','conditions' => array('vtype_id' => $voucher_details['vtype_id'],'vno' => $voucher_details['vno'],'status' => 1),'order_by'=>'vorder_no','order'=>'asc'));
				//echo "<pre>";
				//print_r($voucher_detail_array);
				
				$voucher_no	= $voucher_details['vno'];
				 $mrg = $this->vouchers->max_vorder_no($voucher_details['vtype_id'],$voucher_no);
				//die;
				foreach($voucher_detail_array as $key => $value)
				{
					$line1=$line+$mrg-1;
					
					$this->my_excel->set_border('A'.$line.':'.'E'.$line);
					if($voucher_no != $vids)
					{
						$i++;
						$this->my_excel->set_data_align('A'.$line,NULL);
						$this->my_excel->set_cell_value('A'.$line,$i);
						$this->my_excel->set_data_align('B'.$line,NULL);
						$date = dateFormat($value['vdate']);
						$this->my_excel->set_cell_value('B'.$line,$date);
						$this->my_excel->set_data_align('C'.$line,'L');
						$this->my_excel->set_cell_value('C'.$line,$voucher_no);
					/*	$this->my_excel->merge_cell('A'.$line.':'.'A'.$line1);
						$this->my_excel->merge_cell('B'.$line.':'.'B'.$line1);
						$this->my_excel->merge_cell('C'.$line.':'.'C'.$line1);*/
					} 
					$particulars=$this->accounts->get_ledger_name($value['dr_ledger'])." To ".$this->accounts->get_ledger_name($value['cr_ledger']);
					$this->my_excel->set_cell_value('D'.$line, $particulars);
					$total_value = $total_value + $value['vamount'];
					$total_amount=numberFormat($value['vamount']);
					$this->my_excel->set_data_align('E'.$line,'R');
					$this->my_excel->set_cell_value('E'.$line, $total_amount);
					$vids = $voucher_no;
					$line++;
				}
			}
			$total_value1=numberFormat($total_value);
			$this->my_excel->set_bold('A'.$line.':E'.$line);
			$this->my_excel->set_border('A'.$line.':'.'E'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'D'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('E'.$line,$total_value1);
			$this->my_excel->set_data_align('E'.$line,'R');
			$this->my_excel->output_excel();
		}
	}
}