<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Wholesale_excel extends MY_Controller{

	public function __construct(){
		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function sales(){
	    $this->load->model('wholesale/Wholesale_model','wholesale_obj');
	    $this->load->model('branches/Branch_model','branch_obj');
	    $this->load->library(array('Stock'));
	    $vtype_id = 17;
		$like_array = array();
		
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
        if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date']){
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);
        
		if(isset($uri_array['vt'])){
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate'])){
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
		
		$sales_array = $this->wholesale_obj->get_bills(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array)){
			#---------------------------------
			$head = "Wholesale Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','F');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':F'.$line,12);
			$this->my_excel->set_bold('A'.$line.':F'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');			
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Branch');
			$this->my_excel->set_column_width('E',20);
			$this->my_excel->set_cell_value('E'.$line,'Payment Mode');
			$this->my_excel->set_column_width('F',20);			
			$this->my_excel->set_cell_value('F'.$line,'Net Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,5);
			$this->my_excel->set_bg_color_range(5, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'F'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'F'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'F'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0; $grand_total=0;
			foreach($sales_array as $key => $value):
                $flag=0;
                $bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
                $total_amount = 0;$total_tax_amount = 0;$presum_amount = 0; $total_taxable = 0; $total_cess = 0;
                $item_details = $this->wholesale_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','cgst','sgst','cgst_amt','sgst_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
                foreach($item_details as $item_key => $item_value):
                    $tax_amount = 0;
                    $net_value = ($item_value['amount']-$item_value['discount_amt']);                     
                    $cgst = $item_value['cgst'];
                    $sgst = $item_value['sgst'];
                    $tax_amount = $item_value['cgst_amt']+$item_value['sgst_amt'];  
                    
                    $total_taxable += $item_value['taxable_amt'];
                    $total_cess += $item_value['cess_amt'];
                    $total_tax_amount += $tax_amount;
                    $total_amount += $item_value['taxable_amt'];
                endforeach;
                $total_amount += $total_tax_amount+$total_cess;               
                $total_amount += (($value['bill_freight']+$value['other_expense']-$value['bill_discount_amt']));
                $grand_total += $total_amount;
				
				$this->my_excel->set_border('A'.$line.':'.'F'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'C');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);				
                $this->my_excel->set_cell_value('D'.$line,$this->branch_obj->get_full_name($value['branch_to_id']));
				$payment_mode = $this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_data_align('E'.$line,'C');
				$this->my_excel->set_cell_value('E'.$line,$payment_mode);
				$this->my_excel->set_data_align('F'.$line,'R');
				$this->my_excel->number_format('F'.$line);
				$this->my_excel->set_cell_value('F'.$line,numberFormat(get_rounded($total_amount)));
				$line++;
			endforeach;
			
			$this->my_excel->set_bold('A'.$line.':F'.$line);
			$this->my_excel->set_border('A'.$line.':'.'F'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'E'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Grand Total');
			$this->my_excel->set_data_align('A'.$line,'C');
			$this->my_excel->set_data_align('F'.$line,'R');
			$this->my_excel->set_cell_value('F'.$line,numberFormat(get_rounded($grand_total)));
			$this->my_excel->output_excel();
		}
	}
}