<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

	class Purchase_bills_word extends MY_Controller{

		public function __construct(){

			parent ::__construct();
			$this->companyID = $this->session->userdata('company_id');
			$this->branchID = $this->session->userdata('under_id');
			$this->createdBY = $this->session->userdata('id');
			$fiscals = $this->dms->get_fiscal_year();
			$this->fiscal_start_date = $fiscals['start_date'];
			$this->fiscal_end_date = $fiscals['end_date'];


		}
	#-----------------------------------------------------
	#-----------------------------------------------------
		public function purchase_bills(){
			$payment_mode = NULL;
			$search_date = NULL;
			if($this->uri->segment(3)!=''){
				$data = $this->uri->uri_to_assoc(4);
				if(!empty($data)){
					if(isset($data['payment_mode'])){
						$payment_mode = $data['payment_mode'];
					}
					if(isset($data['date'])){
						$search_date = $data['date'];
					}
				}
			}
			//echo '<pre>';print_r($data);die;
			$this->load->library('My_doc');
			$this->load->model('sales/Sales_model','sales');
			$this->load->library('Stock');
			$args['columns'] = array('id','branch_id','designation_id','department_id');
			$args['conditions'] = array('id'=>$this->createdBY);
			$userDetails = $this->dms->get_users($args)[$this->createdBY];
			$mainBranch = $this->dms->get_main_branch();# get main branch id
			$payment_modes = $this->stock->payment_modes();
			$user_type = NULL;

			if(!empty($userDetails)){
				$departmentID = $userDetails['department_id'];
				$designationID = $userDetails['designation_id'];
				$userBranch = $userDetails['branch_id'];
				if($designationID == 3){
					$user_type = 3;
				}else{
					$user_type = 1;
				}
			}
			$conditions = array('branch_id'=>$mainBranch,'customer_type_id'=>$user_type,'customer_id'=>$userBranch,'status'=>1);
			if(!empty($payment_mode)){
				$conditions['payment_mode'] = $payment_mode;

			}
			if(!empty($search_date)){
				$conditions['bill_date'] = $search_date;
			}
			$args = array();
			$args['columns'] = array('id','vtype_id','bill_no','bill_date','group_id','customer_type_id','customer_id','user_id','area_id','bill_discount_per','bill_discount_amt','bill_freight','other_expense','cess','payment_mode','bill_status');
			$args['conditions'] = $conditions;
			$args['order_by'] = 'bill_date';
			$args['order'] = 'desc';
			$sales = $this->sales->get_bills($args);
			$presumptive_tax = $this->stock->get_tax_type();
			$sales_report = array();
			foreach($sales as $sKey=>$sale){

				if($sale['bill_status'] == 0){
					$this->sales->update_others(array('table'=>'dms_sales','data'=>array('bill_status'=>1),'conditions'=>array('id'=>$sale['id'])));
				}
				$paymentMode = '';$total_amount = $total_tax_amount = $presum_amount = 0;
				$group_id = $sale['group_id'];
				$sales_details = $this->sales->get_sales_items(array('columns' => array('item_id','qty','rate','amount','discount_amt','vat_amt','cst'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));

				foreach($sales_details as $siKey => $sales_item){

					$tax_amount = 0;
					$net_value = ($sales_item['amount']-$sales_item['discount_amt']);
					if(empty($presumptive_tax)){
						if($sales_item['cst'] == 0){
							$vat = $this->stock->get_item_vat($sales_item['item_id']);
							$tax_amount = $sales_item['vat_amt'];//($vat*$net_value)/100;
						}else{
							$tax_amount = ($sales_item['cst']*$net_value)/100;
						}
					}
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				}
				$total_amount += $total_tax_amount;
				if(!empty($presumptive_tax)){
					$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					$total_amount += $presum_amount;
				}
				$cess_amount = (($total_tax_amount+$presum_amount)*$sale['cess'])/100;
				$total_amount += (($cess_amount+$sale['bill_freight']+$sale['other_expense'])-$sale['bill_discount_amt']);
				$paymentMode = $this->stock->ledger_name($sale['payment_mode']);
				$sales_report[$sale['id']] = array('id'=>$sale['id'],'vtype_id'=>$sale['vtype_id'],'bill_no'=>$sale['bill_no'],'bill_date'=>$sale['bill_date'],'payment_mode'=>$paymentMode,'bill_status'=>$sale['bill_status'],'amount'=>$total_amount,'customer_type'=>$sale['customer_type_id']);
			}
			if(!empty($sales_report)){
				#Word data datas
				if(!empty($search_date)){
					$head = "Purchase bills report on ".dateFormat($search_date);
					$title ="Purchase_bills_report_on_".dateFormat($search_date);
				}
				else{
					$head = "Purchase bills report upto ".dateFormat(date('Y-m-d'));
					$title ="Purchase_bills_report_upto_".dateFormat(date('Y-m-d'));
				}

				$this->my_doc->set_width(700);
				$table_style = $this->my_doc->table_style();
				$table_tr_style = $this->my_doc->table_tr_style();
				$this->my_doc->set_company_head();
				$this->my_doc->set_headline($head);
				$this->load->view('my_bills/purchases_word',array('purchase_report'=>$sales_report,'table_style'=>$table_style,'table_tr_style'=>$table_tr_style,'title'=>$title));
				$this->my_doc->output_doc($title);
			}else{
				echo "<script> window.close();</script>";
			}
		}
	}




