<?php
class MY_Form_validation extends CI_Form_validation {
    
    public function __construct($config = array())
    {
		
        parent::__construct($config);
        $this->_error_prefix    = '<label class="error">';
        $this->_error_suffix    = '</label>';
		
    }
	
	#-----------------------------------------------------

    public function is_unique($str, $field)
	{
		list($table, $field)=explode('.', $field);
		$result = $this->CI->db->query("SHOW COLUMNS FROM $table LIKE 'company_id'");
		if(!empty($result->num_rows())){
			$companyID = $this->CI->session->userdata('company_id');
			$query = $this->CI->db->limit(1)->get_where($table, array('company_id'=>$companyID,$field => $str,'status !=' => 0));		
			return $query->num_rows() === 0;			
		}else{
			$query = $this->CI->db->limit(1)->get_where($table, array($field => $str,'status !=' => 0));		
			return $query->num_rows() === 0;
		}
		
    }

	#-----------------------------------------------------	
		
	public function is_edit_unique($str, $field)
	{
		$exp = explode('.', $field);
		if(count($exp) > 2)
		{
			list($table, $field, $primary_key)=$exp;
		}
		else{
			list($table, $field)=$exp;
			$primary_key = $this->CI->uri->segment(3);
		}
		
		$result = $this->CI->db->query("SHOW COLUMNS FROM $table LIKE 'company_id'");
		if(!empty($result->num_rows())){
			$companyID = $this->CI->session->userdata('company_id');
			$query = $this->CI->db->limit(1)->get_where($table, array('company_id'=>$companyID,$field => $str,'id !='=>$primary_key,'status !='=>0));
			return $query->num_rows() === 0;
		}else{
			$query = $this->CI->db->limit(1)->get_where($table, array($field => $str,'id !='=>$primary_key,'status !='=>0));
			return $query->num_rows() === 0;
		}
    }
	   
	#------------------------------------------------------
        
    #date : 16-8-2014
    #purpose : money check
    public function is_money($str){
        $res = preg_match("/^[0-9]+(?:\.[0-9]{2})?$/", $str);      
        if($res){ return TRUE; }
        else{ return FALSE ;}
    }    
    
    #--------------------------------------------------------
	
	public function is_date($str){
		
		$date = date_parse($str);
		if ($date["error_count"] == 0 && checkdate($date["month"], $date["day"], $date["year"])){
		   return true;
		}else{
		    return false;
		 }  
	}

	#-------------------------------------------------------
	
	#--------------------------------------------------------
	public function greater_or_equal($str, $min)
	{
		if ( ! is_numeric($str)){
			return FALSE;
		}
		return $str >= $min;
	}
	#-------------------------------------------------------
	
	#-------------------------------------------------------
	public function less_or_equal($str, $max)
	{
		if ( ! is_numeric($str)){
			return FALSE;
		}
		return $str <= $max;
	}
	#-------------------------------------------------------
	
	#-------------------------------------------------------
	public function valid_date($str)
	{
		$date = date_parse($str);
		if ($date["error_count"] == 0 && checkdate($date["month"], $date["day"], $date["year"]))
		{
			$vdate = date('Y-m-d',strtotime($str));
			$fiscal_start_date = $this->CI->dms->get_fiscal_year()['start_date'];
			$fiscal_end_date = $this->CI->dms->get_fiscal_year()['end_date'];			
			$vdate_time = strtotime($vdate);			
			$fiscal_start_date_time = strtotime($fiscal_start_date);
			$fiscal_end_date_time = strtotime($fiscal_end_date);			
			if($vdate_time >= $fiscal_start_date_time && $vdate_time <= $fiscal_end_date_time)
			{				
				return true;
			}
			return false;
		}
		return false;	
	}
	#-------------------------------------------------------
	
	#-------------------------------------------------------
	public function check_date($current_date,$field)
	{	
		$exp = explode('.', $field);
		$previous_date = $exp[0];
		$condition = $exp[1];
		$current_date = date('Y-m-d',strtotime($current_date));
		$previous_date = date('Y-m-d',strtotime($previous_date));
		$current_date_time = strtotime($current_date);
		$previous_date_time = strtotime($previous_date);
		if($condition == '<'){
			if($current_date_time < $previous_date_time){
				return true;
			}
			return false;
		}
		elseif($condition == '<='){
			if($current_date_time <= $previous_date_time){
				return true;
			}
			return false;
		}
		elseif($condition == '>'){
			if($current_date_time > $previous_date_time){
				return true;
			}
			return false;
		}
		elseif($condition == '>='){
			if($current_date_time >= $previous_date_time){
				return true;
			}
			return false;
		}
		elseif($condition == '='){
			if($current_date_time == $previous_date_time){
				return true;
			}
			return false;
		}
		return false;
	}
	#-------------------------------------------------------
	public function special_char($str){

		return ( ! preg_match("/^([-a-z0-9_!@#$%&])+$/i", $str)) ? FALSE : TRUE;
	}
	#-------------------------------------------------------
}
?>