<?php
class Receipt_ab_lib{

	#=========================
	# Receipt Against Bill Library
	#=========================

	public function __construct(){
		$this->CI =& get_instance();
	}

	#=========================

	public function get_customer_bill($customerTypeID,$customerID){

		$customerBills = array();
		$this->CI->load->model('receipts/receipt_against_bill_model','receipt_against_bill');
		$branchID = $this->CI->session->userdata('under_id');
		$args = array();
		$args['customer_type_id'] = $customerTypeID;
		$args['customer_id'] = $customerID;
		$customerBillArray = $this->CI->receipt_against_bill->get_customer_bill($args);
               
		foreach($customerBillArray as $key=>$bill_details)
		{
			$bill_amount = $this->get_sales_bill($bill_details['id'])['bill_amount'];
			$billPaidAmount = $this->get_bill_payment($bill_details['id']);
			$balanceAmount = $bill_amount-$billPaidAmount;
			$args = array();
			$args['select'] = array('dvab.id');
			$args['conditions'] = array('dvab.branch_id'=>$branchID,'dvab.bill_type'=>0,'dvab.status'=>-1,'dvabi.ps_id'=>$bill_details['id']);
			$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>	'dvab.id=dvabi.vid');
			$exists = $this->CI->receipt_against_bill->get($args);
			if(empty($exists) && $balanceAmount>0)
			{
				$customerBills[$bill_details['id']] = $bill_details['bill_no'];
			}
		}
		if(empty($customerBills))
		{
			$customerBills[''] ='No bill found!';
		}
		return $customerBills;
	}

	#==========================

	public function get_sales_bill($sales_bill_ID){

		$bill_details = array();
		$this->CI->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->CI->load->library('Stock');
		$sales_bill = $this->CI->receipt_against_bill->get_bill_amount($sales_bill_ID);
		if(!empty($sales_bill))
		{
			$presumptive_tax = $this->CI->stock->get_tax_type();
			$i=$totalAmount=$totalDiscountAmt=$totalNetValue=$totalVatAmt=$totalNetAmount=0;
			$grandNetAmount=0;$total_cst_amount = 0;
			$cess = $sales_bill[0]['cess'];
			$bill_freight = $sales_bill[0]['bill_freight'];
			$other_expense = $sales_bill[0]['other_expense'];
			$bill_discount_amt = $sales_bill[0]['bill_discount_amt'];
			$bill_date = $sales_bill[0]['bill_date'];

			foreach($sales_bill as $key=>$sales)
			{
				$qty = $sales['qty'];
				$rate = $sales['rate'];
				$itemID = $sales['item_id'];
				$discount_per = $sales['discount_per'];
				$discount_amt = $sales['discount_amt'];
				$cst_percent = $sales['cst'];
				$vat = 0;$vatAmount = 0;$cst_amount = 0;
				$amount = $sales['amount'];
				$totalAmount += $amount;
				$netValue = $amount-$discount_amt;
				if(empty($presumptive_tax))
				{
					if($cst_percent == 0)
					{
						$vat = $this->CI->stock->get_item_vat($itemID);
						$vatAmount = $sales['vat_amt'];
						$totalVatAmt += $vatAmount;
					}
					else
					{
						$cst_amount = ($netValue*$cst_percent)/100;
					}
				}
				$total_cst_amount += $cst_amount;
				$totalNetValue += $netValue;
				$netAmount = $netValue+$vatAmount+$cst_amount;
				$totalNetAmount += $netAmount;
				$totalDiscountAmt += $discount_amt;
			}
			
    		$grandNetAmount = $totalNetAmount;
    		$presumptive_tax_amt = 0;
    		if(!empty($presumptive_tax)){
       			$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
        		$grandNetAmount += $presumptive_tax_amt;
    		}
    		$cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
        	$grandNetAmount += $cess_amt;
    		$grandNetAmount += (($bill_freight+$other_expense)-$bill_discount_amt);
    
    		$bill_details['bill_date'] = cdateFormat($bill_date);
    		$bill_details['bill_amount'] = round_this($grandNetAmount);
		}
        else
        {
            $sales_bill = $this->CI->receipt_against_bill->get_bill_amounts($sales_bill_ID);  
            if(!empty($sales_bill))
            {
    			$presumptive_tax = $this->CI->stock->get_tax_type();
    			$i=$totalAmount=$totalDiscountAmt=$totalNetValue=$totalVatAmt=$totalNetAmount=0;
    			$grandNetAmount=0;$total_cst_amount = 0;
    			$cess = $sales_bill[0]['cess'];
    			$bill_freight = $sales_bill[0]['bill_freight'];
    			$other_expense = $sales_bill[0]['other_expense'];
    			$bill_discount_amt = $sales_bill[0]['bill_discount_amt'];
    			$bill_date = $sales_bill[0]['bill_date'];

			    foreach($sales_bill as $key=>$sales)
			    {
    				$qty = $sales['qty'];
    				$rate = $sales['rate'];
    				$itemID = $sales['item_id'];
    				$discount_per = $sales['discount_per'];
    				$discount_amt = $sales['discount_amt'];
    				$vat = 0;$vatAmount = 0;$cst_amount = 0;
    				$amount = $sales['amount'];
    				$totalAmount += $amount;
    				$netValue = $amount-$discount_amt;
    				
    				$cgst = $this->CI->stock->get_item_cgst($itemID);
                    $sgst = $this->CI->stock->get_item_sgst($itemID);
    				$cgstAmount = $sales['cgst_amt'];
                    $sgstAmount = $sales['sgst_amt'];
                    $vatAmount = $cgstAmount+$sgstAmount;
    				$totalVatAmt += $vatAmount;
				}
				
				$totalNetValue += $netValue;
				$netAmount = $netValue+$vatAmount;
				$totalNetAmount += $netAmount;
				$totalDiscountAmt += $discount_amt;
			}
    		$grandNetAmount = $totalNetAmount;
    		$presumptive_tax_amt = 0;
    		$grandNetAmount += (($bill_freight+$other_expense)-$bill_discount_amt);
    
    		$bill_details['bill_date'] = cdateFormat($bill_date);
    		$bill_details['bill_amount'] = round_this($grandNetAmount);
		} 
                
		return $bill_details;

	}

	#==========================

	public function get_bill_payment($sales_bill_ID,$conditions=array()){

		$this->CI->db->select_sum('received_amount');
		$this->CI->db->from('dms_voucher_against_bills dvab');
		$this->CI->db->join('dms_voucher_against_bill_items as dvabi','dvab.id=dvabi.vid');
		$this->CI->db->where(array('dvabi.ps_id'=>$sales_bill_ID,'dvabi.status'=>1,'dvab.bill_type'=>0));
		if(!empty($conditions))
		{
			$this->CI->db->where($conditions);
		}
		$row = $this->CI->db->get()->row_array();
		return $row['received_amount'];
	}

	#==========================

}
?>