<?php
class Stock {

	#------------------------------------------------
	public $unit_array = array();

	public function __construct(){

		$this->CI =& get_instance();
	}

	#------------------------------------------------

    public function get_all_items($q)
    {
        $rows = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where (item_code like '%$q%' or item_name like '%$q%' or model_no like '%$q%')")->result_array();
        
		return $rows;
    }
    
    public function get_all_items_purchase($q)
    {
        $branch_id = $this->CI->session->userdata('under_id');
        
        if(in_array($branch_id,array(4,31)))
        {
            $rows = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where (item_code like '%$q%' or item_name like '%$q%' or model_no like '%$q%')")->result_array();
        }
		else
		{
		    $rows = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where item_group_id not in (2,5,6) and (item_code like '%$q%' or item_name like '%$q%' or model_no like '%$q%')")->result_array();
		}
		return $rows;
    }
    
   
    
    public function get_voucher_items_key($vtype,$skey)
    {
        $company_id = $this->CI->session->userdata('company_id');
        $cond = "";
        if($vtype=='40' || $vtype=='41' ){
            $cond = " and item_group_id in (11,12,13,14,15)";
        }
        $rows = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where company_id='$company_id' and stock_type='1' and (item_code like '%$skey%' or item_name like '%$skey%' or model_no like '%$skey%') and status='1' $cond")->result_array();

        return $rows;
    }

    public function get_voucher_items($vtype_id)
    {
        $items = array();
        $company_id = $this->CI->session->userdata('company_id');
        
        if($vtype_id=='40' || $vtype_id=='41' )
        {
            $cond = " and item_group_id in (11,12,13,14,15)";
        }
        $rows = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where company_id='$company_id' and stock_type='1' and status='1' $cond")->result_array();
    
        if(!empty($rows))
		{
			foreach($rows as $key=>$row)
			{
				$items[$row['id']] = $row['item_code'].' / '.$row['item_name'].'/'.$row['model_no'];
			}
		}
		return $items;
    }

	public function get_stock_items($args=array()){

		$items = array();
		$conditions=array();
		if(isset($args['conditions']))
		{
			$conditions = $args['conditions'];
		}

		$company_id = $this->CI->session->userdata('company_id');
		$conditions['company_id'] = $company_id;
		if(!isset($conditions['stock_type']))
		{
			$conditions['stock_type'] = 1;
		}
        $conditions['status'] = 1;
		$rows = $this->CI->db->select(array('id','item_code','item_name','model_no'))->get_where('item_master',$conditions)->result_array();
		
		if(!empty($rows))
		{
			if(!isset($args['return_type']))
			{
				foreach($rows as $key=>$row)
				{
					$items[$row['id']] = $row['item_code'].' / '.$row['item_name'].'/'.$row['model_no'];
				}
			}
			else
			{
				return $rows;
			}
		}
		return $items;
	}
	
	public function fetchProducts($searchTerm, $page) {
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $company_id = $this->CI->session->userdata('company_id');
		$conditions['company_id'] = $company_id;
		$conditions['stock_type'] = 1;
        $conditions['status'] = 1;
		
		$this->CI->db->select(array('id','item_code','item_name','model_no'));
        $this->CI->db->where($conditions);
        $this->CI->db->group_start() // Open parenthesis
          ->like('item_code', $searchTerm)
          ->or_like('item_name', $searchTerm)
          ->or_like('model_no', $searchTerm)
          ->group_end();
        $this->CI->db->limit($limit, $offset);
        $query = $this->CI->db->get('item_master'); 

        $results = $query->result_array();

        // Fetch total count for pagination
        $this->CI->db->group_start() // Open parenthesis
          ->like('item_code', $searchTerm)
          ->or_like('item_name', $searchTerm)
          ->or_like('model_no', $searchTerm)
          ->group_end();
        $total_count = $this->CI->db->count_all_results('item_master');

        return array(
            'results' => $results,
            'total_count' => $total_count
        );
    }
	

    public function get_branch_stock_items()
    {
		$items = array();
		$branch_id = $this->CI->session->userdata('under_id');
		$rows = $this->CI->db->query("select a.id,a.item_code,a.item_name,a.model_no from item_master as a inner join dms_stocks as s on a.id=s.item_id where s.branch_id='$branch_id' and a.stock_type='1' group by s.item_id")->result_array();
		
		if(!empty($rows))
		{
			foreach($rows as $key=>$row)
			{
				$items[$row['id']] = $row['item_code'].' / '.$row['item_name'].'/'.$row['model_no'];
			}
		}
		return $items;
	}
	
	public function get_search_items($skey)
	{
	    $branch_id = $this->CI->session->userdata('under_id');
		$godown_id = $this->get_branch_godown($branch_id);   
		
        $cdate = date('Y-m-d');
		
	    $row = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where item_code LIKE '%$skey%' or item_name LIKE '%$skey%' or model_no LIKE '%$skey%' order by item_name asc")->result_array();
	    //$row = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where item_name LIKE '%$skey%' order by item_name asc")->result_array();
	    $items = array();
	   
	    foreach($row as $key => $item_det)
	    {
	        $itid = $item_det['id'];
	        
	        //$qty = $this->get_stock_count($godown_id,$itid,$cdate);
	        //$rate = $this->get_item_rate($itid);
	        $qty=$rate=0;
	        $items[$itid] = array('item_code'=>$item_det['item_code'],'item_name'=>$item_det['item_name'],'model_no'=>$item_det['model_no'],'qty'=>$qty,'rate'=>$rate);
	    }
	    
	    return $items;
	}
	
	
	public function get_search_items_per($skey,$offset,$limit)
	{
	    $branch_id = $this->CI->session->userdata('under_id');
		$godown_id = $this->get_branch_godown($branch_id);   
		
        $cdate = date('Y-m-d');
		
	    //$row = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where item_code LIKE '%$skey%' or item_name LIKE '%$skey%' or model_no LIKE '%$skey%' order by item_name asc limit $offset,$limit")->result_array();
	    $this->CI->db->select('id, item_code, item_name, model_no');
        $this->CI->db->from('item_master');
        $this->CI->db->like('item_code', $skey);
        $this->CI->db->or_like('item_name', $skey);
        $this->CI->db->or_like('model_no', $skey);
        $this->CI->db->order_by('item_name', 'asc');
        $this->CI->db->limit($limit, $offset);
        $row = $this->CI->db->get()->result_array();
	    
	    
	    //$row = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where item_name LIKE '%$skey%' order by item_name asc")->result_array();
	    $items = array();
	   
	    foreach($row as $key => $item_det)
	    {
	        $itid = $item_det['id'];
	        
	        $qty = $this->get_stock_count($godown_id,$itid,$cdate);
	        $rate = $this->get_item_rate($itid);
	        if($qty > 0){
	        $items[$itid] = array('item_code'=>$item_det['item_code'],'item_name'=>$item_det['item_name'],'model_no'=>$item_det['model_no'],'qty'=>$qty,'rate'=>$rate);
	        }
	    }
	    
	    return $items;
	}

    public function get_search_items_wr($skey)
	{
	    $branch_id = $this->CI->session->userdata('under_id');
		$godown_id = $this->get_branch_godown($branch_id);   
		
        $cdate = date('Y-m-d');
		
	    //$row = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where item_code LIKE '%$skey%' or item_name LIKE '%$skey%' or model_no LIKE '%$skey%' order by item_name asc limit $offset,$limit")->result_array();
	    $this->CI->db->select('id, item_code, item_name, model_no');
        $this->CI->db->from('item_master');
        $this->CI->db->like('item_code', $skey);
        $this->CI->db->or_like('item_name', $skey);
        $this->CI->db->or_like('model_no', $skey);
        $this->CI->db->order_by('item_name', 'asc');
        
        $row = $this->CI->db->get()->result_array();
	    
	    
	    //$row = $this->CI->db->query("select id,item_code,item_name,model_no from item_master where item_name LIKE '%$skey%' order by item_name asc")->result_array();
	    $items = array();
	   
	    foreach($row as $key => $item_det)
	    {
	        $itid = $item_det['id'];
	        
	        $qty = $this->get_stock_count($godown_id,$itid,$cdate);
	        $rate = $this->get_item_rate($itid);
	        
	        $items[$itid] = array('item_code'=>$item_det['item_code'],'item_name'=>$item_det['item_name'],'model_no'=>$item_det['model_no'],'qty'=>$qty,'rate'=>$rate);
	    }
	    
	    return $items;
	}



	public function get_godowns($args = array()){

		$goDowns = array();
		$conditions=array();

		if(isset($args['conditions'])){
			$conditions = $args['conditions'];
		}

		$this->CI->load->model('godown/godown_model','godown');
		if(isset($args['listing'])){
			$godownArray = $this->CI->godown->listing($args);
		}else{
			$godownArray = $this->CI->godown->get_all($args);
		}

		return $godownArray;
	}
	
	public function get_godowns1($args = array()){

		$goDowns = array();
		$conditions=array();

		if(isset($args['conditions'])){
			$conditions = $args['conditions'];
		}

		$this->CI->load->model('godown/godown_model','godown');
		if(isset($args['listing'])){
			$godownArray = $this->CI->godown->listing1($args);
		}else{
			$godownArray = $this->CI->godown->get_all($args);
		}

		return $godownArray;
	}
	
	public function get_branch_godown($branch_id)
	{
		$CI =& get_instance();
		$row = $CI->db->select('id')->get_where('godown_master',array('branch_id' => $branch_id,'status'=>1))->row_array();
		if(!empty($row))
		{
			return $row['id'];;
		}
		return false;
	}
	
	public function get_godown_branch($godown_id)
	{
		$CI =& get_instance();
		$row = $CI->db->select('branch_id')->get_where('godown_master',array('id' => $godown_id))->row_array();
		if(!empty($row))
		{
			return $row['branch_id'];;
		}
		return false;
	}

	#-----------------------------------------------------
	
	public function get_type($group_id)
	{
		$CI =& get_instance();
		$row = $CI->db->select('item_type')->get_where('item_type_master',array('id' => $group_id))->row_array();
		if(!empty($row))
		{
			return $row['item_type'];;
		}
		return false;
	}
	
	#------------------------------------------------
	
	
	public function unitlist(){
	    $CI =& get_instance();
	    $units = array();
	    
	    $CI->db->select('*');
		$CI->db->from('unit_master');
		$rows = $CI->db->get()->result_array();
		
		foreach($rows as $row){
		    $units[$row['id']] = $row['symbol'];
		}
		
		return $units;
	}

	public function get_units($id,$type = 0)
	{
		#----------type = 0 => id = item_id , type = 1 => id = unit_id
		$CI =& get_instance();
		if($type == 0){
			$CI->db->select('unit_id');
			$CI->db->from('item_master');
			$CI->db->where('id',$id);
			$row = $CI->db->get()->row_array();
		}
		else{
			$row['unit_id'] = $id;
		}
		if(!empty($row))
		{
			$item_unit = $row['unit_id'];
			$this->unit_array[$item_unit] = $this->get_unit_symbol($item_unit);

			#---------- second unit
			$second_unit = $CI->db->select('second_unit')->get_where('unit_master',array('first_unit' => $item_unit,'unit_type' => 1,'status'=>1))->row_array();
			if(!empty($second_unit))
			{
				$this->unit_array[$second_unit['second_unit']] = $this->get_unit_symbol($second_unit['second_unit']);
				$second_unit_array = $this->get_second_units($second_unit['second_unit']);
				$this->unit_array = $this->unit_array+$second_unit_array;
			}

			#---------- first unit
			$first_unit = $CI->db->select('first_unit')->get_where('unit_master',array('second_unit' => $item_unit,'unit_type' => 1,'status'=>1))->result_array();
			if(!empty($first_unit))
			{
				foreach($first_unit as $key => $value)
				{
					$this->unit_array[$value['first_unit']] = $this->get_unit_symbol($value['first_unit']);
					$first_unit_array = $this->get_first_units($value['first_unit']);
					$this->unit_array = $this->unit_array+$first_unit_array;
				}
			}
		}
		return $this->unit_array;
	}

	#--------------------------------------------------------------------------------

	public function get_second_units($first_unit,$type = NULL)
	{
		if($type != NULL){
			$this->unit_array = array();
		}
		$CI =& get_instance();
		$second_unit = $CI->db->select('second_unit')->get_where('unit_master',array('first_unit' => $first_unit,'unit_type' => 1,'status'=>1))->row_array();
		if(!empty($second_unit))
		{
			$this->unit_array[$second_unit['second_unit']] = $this->get_unit_symbol($second_unit['second_unit']);
			$this->get_second_units($second_unit['second_unit']);
		}
		return $this->unit_array;
	}

	#--------------------------------------------------------------------------------

	public function get_first_units($second_unit,$type = NULL)
	{
		if($type != NULL){
			$this->unit_array = array();
		}
		$CI =& get_instance();
		$first_unit = $CI->db->select('first_unit')->get_where('unit_master',array('second_unit' => $second_unit,'unit_type' => 1,'status'=>1))->row_array();
		if(!empty($first_unit))
		{
			$this->unit_array[$first_unit['first_unit']] = $this->get_unit_symbol($first_unit['first_unit']);
			$this->get_first_units($first_unit['first_unit']);
		}
		return $this->unit_array;
	}

	#--------------------------------------------------------------------------------

	public function get_unit_symbol($unit_id)
	{
		$CI =& get_instance();
		$row = $CI->db->select('symbol')->get_where('unit_master',array('id' => $unit_id,'status'=>1))->row_array();
		if(!empty($row)){
			return $row['symbol'];
		}
		return false;
	}

    public function get_symbol($unit_id)
	{
		$CI =& get_instance();$res = array();
		$row = $CI->db->select('symbol')->get_where('unit_master',array('id' => $unit_id,'status'=>1))->row_array();
		if(!empty($row)){
                        $res[$unit_id] = $row['symbol'];
			return $res;
		}
		return false;
	}


	#------------------------------------------------------------------------------

	public function get_voucher_prefix($vid){

		$row = $this->CI->db->select(array('vprefix'))->get_where('dms_voucher_prefixes',array('company_id'=>$this->CI->session->userdata('company_id'),'vid'=>$vid))->row_array();
		if(!empty($row)){
			return $row['vprefix'];
		}
		return NULL;
	}

	#------------------------------------------------------------------------------

	public function get_primary_unit($item_id){

		$itemArray = array();
		if(!empty($item_id)){

			$this->CI->db->select(array('u.id','u.unit_type','u.formal_name','u.symbol'));
			$this->CI->db->from('item_master as i');
			$this->CI->db->join('unit_master as u','i.unit_id=u.id');
			$this->CI->db->where(array('i.id'=>$item_id,'i.status'=>1));
			$row = $this->CI->db->get()->row_array();
		}
		if(!empty($row)){
			$itemArray = $row;
		}
		return $itemArray;
	}

	#------------------------------------------------------------------------------

	public function get_opening_stock($args=array()){

		$goDowns = array();
		if(isset($args['godown_id'])){
			if(is_array($args['godown_id'])){
				foreach($args['godown_id'] as $key=>$gid){
					$goDowns[$gid] = $gid;
				}
			}else{
				$goDowns[$args['godown_id']] = $args['godown_id'];
			}
		}else{
			$branch_id = $this->CI->session->userdata('under_id');
			$goDownsList = $this->get_godowns(array('conditions'=>array('branch_id'=>$branch_id)));
			foreach($goDownsList as $gkey=>$godwn){
				$goDowns[$godwn['id']] = $godwn['id'];
			}
		}

		$itemID = $args['item_id'];
		$openingDate = $args['opening_date'];
		$totalOpeningQnty = NULL;

		$company_id = $this->CI->session->userdata('company_id');
		if(!empty($goDowns)){
			foreach($goDowns as $goDownID=>$goDown){

				$this->CI->db->query("CALL opening_stock($goDownID,$itemID,'$openingDate',@ss); ");
			//	$ops = $this->CI->db->query("SELECT @ss as openQty");
				/*$this->CI->db->query("CALL opening_stock($goDownID,$itemID,'$openingDate',@ss); ");*/
				$ops = $this->CI->db->query("SELECT * from dms_stocks where godown_id='$goDownID' and stock_date='$openingDate' and item_id='$itemID'");
				$row = $ops->row_array();
				if(!empty($row)){
					$totalOpeningQnty += $row['qty'];
				}
			}
		}
		return $totalOpeningQnty;
	}

	#------------------------------------------------------------------------------

	public function get_actual_opening($itemID,$goDownID){

		$company_id = $this->CI->session->userdata('company_id');

		$this->CI->db->select(array('id','company_id','qty','unit_id','rate','stock_date',));
		$this->CI->db->from('dms_stocks');
		$this->CI->db->where(array('company_id'=>$company_id,'godown_id'=>$goDownID,'item_id'=>$itemID,'stock_status'=>0,'status'=>1));
		$this->CI->db->order_by('stock_date','desc');
		$this->CI->db->limit(1);
		#echo "<pre>";
		$row = $this->CI->db->get()->row_array();
		#echo $this->CI->db->last_query();
		return $row;

	}

	#-------------------------------------------------------------------------------

	public function get_item_godowns($args){

		$itemGodowns=array();
		$itemID = $args['item_id'];
		$branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('ds.godown_id','gm.godown_code','gm.godown_name','bm.branch_name'));
		$this->CI->db->from('dms_stocks as ds');
		$this->CI->db->join('godown_master as gm','ds.godown_id=gm.id');
		$this->CI->db->join('branch_master as bm','gm.branch_id=bm.id');	
		$this->CI->db->where(array('ds.item_id'=>$itemID,'gm.branch_id'=>$branchID,'ds.status'=>1));

		$rows = $this->CI->db->get()->result_array();

		if(!empty($rows)){
			foreach($rows as $key=>$row){
				if(isset($args['listing'])){
					$itemGodowns[$row['godown_id']] = $row['godown_code'].' / '.$row['godown_name'].' - '.$row['branch_name'];
				}else{
					$itemGodowns[$row['godown_id']] = $row;
				}
			}
		}
		else
		{
		    $rows1 = $this->CI->db->select(array('gm.id','gm.godown_code','gm.godown_name','bm.branch_name'))->from('godown_master as gm')->join('branch_master as bm','gm.branch_id=bm.id')->where(array('gm.branch_id'=>$branchID,'gm.status'=>1))->get()->result_array();
		    foreach($rows1 as $k=>$r){
		        $itemGodowns[$r['id']] = $r['godown_code'].' / '.$r['godown_name'].' - '.$r['branch_name'];
		    }
		}

		return $itemGodowns;
	}
	/*	public function get_first_godown($args){

		$itemGodowns=array();
		$itemID = $args['item_id'];
		$branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('ds.godown_id','gm.godown_code','gm.godown_name','bm.branch_name'));
		$this->CI->db->from('dms_stocks as ds');
		$this->CI->db->join('godown_master as gm','ds.godown_id=gm.id');
		$this->CI->db->join('branch_master as bm','gm.branch_id=bm.id');	
		$this->CI->db->where(array('ds.item_id'=>$itemID,'gm.branch_id'=>$branchID,'ds.status'=>1));

		$rows = $this->CI->db->get()->result_array();

		if(!empty($rows)){
			foreach($rows as $key=>$row){
				if(isset($args['listing'])){
					$itemGodowns[$row['godown_id']] = $row['godown_code'].' / '.$row['godown_name'].' - '.$row['branch_name'];
				}else{
					$itemGodowns[$row['godown_id']] = $row;
				}
			}
		}
		else
		{
		    $rows1 = $this->CI->db->select(array('gm.id','gm.godown_code','gm.godown_name','bm.branch_name'))->from('godown_master as gm')->join('branch_master as bm','gm.branch_id=bm.id')->where(array('gm.branch_id'=>$branchID,'gm.status'=>1))->get()->result_array();
		    foreach($rows1 as $k=>$r){
		        $itemGodowns[$r['id']] = $r['godown_code'].' / '.$r['godown_name'].' - '.$r['branch_name'];
		    }
		}

		return $itemGodowns;
	}*/

    public function get_first_godown($args){
        $itemGodown = 0;
		$itemID = $args['item_id'];
		$branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('ds.godown_id','gm.godown_name'));
		$this->CI->db->from('dms_stocks as ds');
		$this->CI->db->join('godown_master as gm','ds.godown_id=gm.id');
		$this->CI->db->where(array('ds.item_id'=>$itemID,'gm.branch_id'=>$branchID,'ds.status'=>1));
        
		$rows = $this->CI->db->get()->row_array();

		if(!empty($rows))
		{
			foreach($rows as $key=>$row)
			{
				$itemGodown= $row;
				//$itemGodown[$row['godown_id']] = $row['godown_name'];
			}
		}

		return $itemGodown;
	}

	public function get_users($args){

		if(!isset($args['select'])){
			$args['selects'] = array('id','fname','lname');
		}else{
			$args['selects'] = $args['select'];
			$args['selects'][] = 'id';
		}
		$args['conditions']['status'] = 1;
		$rows = $this->CI->db->select($args['selects'])->get_where('users',$args['conditions'])->result_array();

		$users = array();
		if(!empty($rows)){
			foreach($rows as $row){
				if(!isset($args['select'])){
						$users[$row['id']] = $row['fname'].' '.$row['lname'];
				}else{
					$users[$row['id']] = $row;
				}
			}
		}
		return $users;
	}

	public function get_item_vat($itemID)
	{
		$this->CI->load->model('accounts/vat_model','vat');
		$row = $this->CI->db->select('item_group_id')->get_where('item_master',array('id' => $itemID))->row_array();
		return $vatPercent = $this->CI->vat->get_item_vat($row['item_group_id']);
	}


    public function get_item_cgst($itemID)
    {
        $this->CI->load->model('accounts/vat_model','vat');
        $row = $this->CI->db->select('item_group_id')->get_where('item_master',array('id' => $itemID))->row_array();
		return $cgst = $this->CI->vat->get_item_cgst($row['item_group_id']);
    }

    public function get_item_sgst($itemID)
    {
        $this->CI->load->model('accounts/vat_model','vat');
        $row = $this->CI->db->select('item_group_id')->get_where('item_master',array('id' => $itemID))->row_array();
		return $sgst = $this->CI->vat->get_item_sgst($row['item_group_id']);
    }

    public function get_item_igst($itemID)
    {
        $this->CI->load->model('accounts/vat_model','vat');
        $row = $this->CI->db->select('item_group_id')->get_where('item_master',array('id' => $itemID))->row_array();
		return $igst = $this->CI->vat->get_item_igst($row['item_group_id']);
    }

	public function get_group_id($table)
	{
		$maxRow = $this->CI->db->select_max('group_id')->get_where($table)->row_array();
		if($maxRow['group_id'] != NULL){
			$maxRow['group_id'] = (int)$maxRow['group_id']+1;
		}else{
			$maxRow['group_id'] = 1;
		}
		return $maxRow['group_id'];
	}
	
	public function get_book_group_id($branch)
	{
	    $group_id = 0;
		$maxRow = $this->CI->db->select_max('group_id')->from('dms_booking')->where('branch_id',$branch)->get()->row_array();
		if($maxRow['group_id'] != NULL)
		{
			$group_id = $maxRow['group_id'];
		}
		
		$maxRow1 = $this->CI->db->select_max('group_id')->from('dms_sales')->where('branch_id',$branch)->get()->row_array();
		if($maxRow1['group_id'] != NULL)
		{
		    if($maxRow1['group_id'] > $group_id)
		    {
			    $group_id = $maxRow1['group_id'];
		    }
		}
		
		$group_id++;
		
		return $group_id;
	}

	#----------------------------------------------------------------------------------

	public function get_customer($customerType,$customerID,$return=NULL){

		if($customerType ==1){

			#-branch details
			$rows = $this->CI->db->select(array('branch_name as name','branch_landline phone_no','branch_mobile as mobile_no','branch_address as address','branch_email as email_id','ledger_id'))->get_where('branch_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else if($customerType ==2){

			#-customer details
			$rows = $this->CI->db->select(array('concat(fname," ",lname) as name','address','mobile_no','phone_no','email_id','ledger_id'))->get_where('customer_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else if($customerType ==3){

			#-ar details
			$rows = $this->CI->db->select(array('concat(retailer_short_name," ",retailer_name) as name','retailer_address as address','retailer_landline as phone_no','retailer_mobile as mobile_no','retailer_email as email_id','tin_no as tin','gstn','ledger_id'))->get_where('retailer_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else{
			return NULL;
		}
	}

	#-------------------------------------------------------------------------------

	public function get_item($item_id,$columns = array()){

		if(empty($columns)){
			$columns = "item_name";
		}
		$row = $this->CI->db->select($columns)->get_where('item_master',array('id' => $item_id))->row_array();
		if(!is_array($columns)){
			return $row['item_name'];
		}
		return $row;
	}
	#------------------------------------------------------------------------------demo
   	public function get_single_item($args=array()){

		$items = array();
		$conditions=array();
		if(isset($args['conditions'])){
			$conditions = $args['conditions'];
		}

		$company_id = $this->CI->session->userdata('company_id');
		$conditions['company_id'] = $company_id;
		if(!isset($conditions['stock_type'])){
			$conditions['stock_type'] = 1;
		}

		$rows = $this->CI->db->select(array('id','item_code','item_name'))->get_where('item_master',$conditions)->result_array();
		if(!empty($rows)){
			if(!isset($args['return_type']))
			{
				foreach($rows as $key=>$row){
					$items[$row['id']] = $row['item_code'].' / '.$row['item_name'];
				}
			}
			else
			{
				return $rows;
			}
		}
		return $items;
	}
	
	#-------------------------------------------------------------------------------demo

	public function get_tax_type()
	{
		#return array(10);
		$row = $this->CI->db->select(array('tax_type','presum_tax'))->get_where('company_master',array('id' => $this->CI->session->userdata('company_id')))->row_array();
		if($row['tax_type'] == 0){
			return array($row['presum_tax']);
		}
		return array();
	}

	#-------------------------------------------------------------------------------

	public function get_cess()
	{
		$this->CI->load->model('accounts/cess_model','cess');
		$row = $this->CI->cess->get(array('columns' => 'cess_percent'));
		if(!empty($row)){
			return $row['cess_percent'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------
	public function get_item_rate($itemID){
	    
	  /*  $row1 = $this->CI->db->select('rate')->from('dms_item_sales_rate')->where(array('branch_id' =>$this->CI->session->userdata('under_id'),'item_id' => $itemID,'status'=>1))->order_by('valid_from','desc')->limit(1)->get()->row_array();
        if(!empty($row1))
        {
            $rate = $row1['rate'];
        }
        else
        {
    		$this->CI->db->select('rate');
    		$this->CI->db->from('dms_item_rates');
    		$this->CI->db->where(array('company_id' => $this->CI->session->userdata('company_id'),'item_id' => $itemID,'status'=>1));
    		$this->CI->db->order_by('id','desc');
    		$this->CI->db->limit(1);

		    $row = $this->CI->db->get()->row_array();
		    $rate = $row['rate']; */
		    
		    $branch_id = $this->CI->session->userdata('under_id');
		    
		    $res = $this->CI->db->query("select rate from dms_item_rates where item_id ='$itemID' and valid_from >= '2021-08-01' and created_by='-2' order by id desc")->row_array();
		    if(!empty($res['rate']))
		    {
		        $rate = $res['rate'];
		    }
		    else
		    {
    		    $row = $this->CI->db->query("select max(si.rate) as rt from dms_sales as s inner join dms_sales_items1 as si on s.group_id=si.group_id where si.status='1' and s.branch_id='$branch_id' and si.item_id='$itemID'")->row_array();
                    
    		    if(!empty($row['rt']))
    		    {
    		        $rate = $row['rt'];
    		    }
    		    else
    		    {
    		        $this->CI->db->select('rate');
            		$this->CI->db->from('dms_item_rates');
            		$this->CI->db->where(array('company_id' => $this->CI->session->userdata('company_id'),'item_id' => $itemID,'status'=>1));
            		$this->CI->db->order_by('id','desc');
            		$this->CI->db->limit(1);
        
        		    $row1 = $this->CI->db->get()->row_array();
        		    $rate = $row1['rate'];
    		    }
		    }
       // }   

		if($rate!=''){
			return $rate;
		}
		return false;

	}
	
	public function last_purchase_rate($branch,$item){
	    $prate=0;
	    $row = $this->CI->db->query("select pi.rate from dms_purchase_items1 as pi inner join dms_purchases as p on pi.group_id=p.group_id where p.branch_id='$branch' and pi.item_id='$item' and p.status=1 and pi.status=1 order by pi.id desc")->row_array();
	    if(!empty($row)){ $prate = $row['rate']; }
	    
	    return $prate;
	}
	
#-----------------------------------------item id--------------------------------------
	public function get_item_id($itemcode){
	    
	    $row1 = $this->CI->db->select('id')->from('item_master')->where(array('item_code' => $itemcode,'status'=>1))->get()->row_array();
        if(!empty($row1))
        {
            $item_id = $row1['id'];
        }
        else
        {
    		$this->CI->db->select('id');
    		$this->CI->db->from('item_master');
    		$this->CI->db->where(array('item_id' => $itemcode,'status'=>1));
    		

		    $row = $this->CI->db->get()->row_array();
		    $item_id = $row['id'];
        }   

		if($item_id!=''){
			return $item_id;
		}
		return false;

	}
		
	
#------------------------------------------------------------------------------------------------------------	
	
public function get_item_landcost($itemID){
	    
	    $row1 = $this->CI->db->select('landing_cost')->from('dms_item_rates')->where(array('company_id' =>$this->CI->session->userdata('company_id'),'item_id' => $itemID,'status'=>1))->order_by('valid_from','desc')->limit(1)->get()->row_array();
        if(!empty($row1))
        {
            $landingcost = $row1['landing_cost'];
        }
        /*else
        {
    		$this->CI->db->select('rate');
    		$this->CI->db->from('dms_item_rates');
    		$this->CI->db->where(array('company_id' =>$this->CI->session->userdata('company_id'),'item_id' => $itemID,'status'=>1));
    		$this->CI->db->order_by('valid_from','desc');
    		$this->CI->db->limit(1);

		    $row = $this->CI->db->get()->row_array();
		    $rate = $row['rate'];
        } */  

		if($landingcost!=''){
			return $landingcost;
		}
		return false;

	}
		
	
	
	
	
	
#-----------------------------------------------------------------------------------------------------------	
	
	
	public function get_item_price($itemID){
	    
    		$this->CI->db->select(array('rate','rate2','landing_cost'));
    		$this->CI->db->from('dms_item_rates');
    		$this->CI->db->where(array('company_id' =>$this->CI->session->userdata('company_id'),'item_id' => $itemID,'status'=>1));
    		$this->CI->db->order_by('valid_from','desc');
    		$this->CI->db->order_by('id','desc');
    		$this->CI->db->limit(1);

		    $row = $this->CI->db->get()->row_array();
		    
		if(!empty($row)){
			return $row;
		}
		return false;

	}
	

	#-------------------------------------------------------------------------------

        public function get_item_hsn($itemID){

		$this->CI->db->select('hsn');
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('id' => $itemID,'status'=>1));		
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();

		if(!empty($row)){
			return $row['hsn'];
		}
		return false;

	}

    #-------------------------------------------------------------------------------
        
    public function get_group_hsn($groupID){

		$this->CI->db->select('hsn');
		$this->CI->db->from('item_type_master');
		$this->CI->db->where(array('id' => $groupID,'status'=>1));		
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();

		if(!empty($row)){
			return $row['hsn'];
		}
		return false;

	}

    #-------------------------------------------------------------------------------

	public function get_constant($constant=array()){
		if(empty($constant)){
			$constant = array('date_format','decimal_place','currency_symbol','time_for_targets','vat_in_ex','sales_cst','purchase_cst');
		}
		$rows = $this->CI->db->select($constant)->get_where('constant_master',array('company_id'=>$this->CI->session->userdata('company_id')))->row_array();

			if(count($constant) == 1){
				if(!empty($rows)){
					return $rows[$constant[0]];
				}else{
					return NULL;
				}
			}else{
				if(!empty($rows)){
					return $rows;
				}else{
					return array();
				}
			}
	}

	#-------------------------------------------------------------------------------

	public function payment_modes($conditions=array())
	{
		$modes = array();
		$this->CI->db->select(array('id','ledger_name'))->from('dms_ledgers')->where("(company_id = ".$this->CI->session->userdata('company_id')." or company_id = 0 or company_id = -1)")->where('id !=',7);
		if(empty($conditions['sub_groups'])){
			$sGroups = array(13,14,0);
		}else{
			$sGroups = $conditions['sub_groups'];
		}
		$this->CI->db->where_in('sgroup_id',$sGroups);
		$row = $this->CI->db->get()->result_array();
		if(!empty($row)){
			foreach($row as $key => $value){
				$modes[$value['id']] = $value['ledger_name'];
			}
		}
		return $modes;
	}

	#-------------------------------------------------------------------------------

	public function get_stock_count($godown_id,$item_id,$date = NULL)
	{
		if(empty($date)){
			$date = $this->CI->dms->get_fiscal_year()['end_date'];
		    $s_date = $this->CI->dms->get_fiscal_year()['start_date'];
		}
		$s_date = $this->CI->dms->get_fiscal_year()['start_date'];
		$date = date('Y-m-d',strtotime($date)); $in=0; $out=0;
	//	$this->CI->db->query("CALL opening_stock($godown_id,$item_id,'$date',@stock_count); ");
	//	$ops = $this->CI->db->query("SELECT @stock_count as open_qty");
	//	$row = $ops->row_array();
	//	return $row['open_qty'];
        $ops = $this->CI->db->query("SELECT sum(qty) as open_qty from dms_stocks where godown_id='$godown_id' and item_id='$item_id' and stock_date >='$s_date' and stock_date <='$date' and stock_status in (0,1,2,7,8,9,10) and status=1");
		$row = $ops->row_array();
		if(!empty($row))
		{
            $in = $row['open_qty'];
		}
        $opss = $this->CI->db->query("SELECT sum(qty) as open_qty from dms_stocks where godown_id='$godown_id' and item_id='$item_id' and stock_date >='$s_date' and stock_date <='$date' and stock_status in (3,4,5,6) and status=1");
		$rows = $opss->row_array();
        if(!empty($rows))
		{
            $out = $rows['open_qty'];
		}        
        $bal = $in-$out;

        return $bal;
	}
	
	public function get_sale_qty($godown_id,$item_id,$sdate,$edate)
	{
		$sdate = date('Y-m-d',strtotime($sdate));
		$edate = date('Y-m-d',strtotime($edate));
		$qty=0;
	
        $ops = $this->CI->db->query("SELECT sum(qty) as open_qty from dms_stocks where godown_id='$godown_id' and item_id='$item_id' and stock_date >='$sdate' and stock_date <='$edate' and stock_status='6' and status=1");
		$row = $ops->row_array();
		if(!empty($row))
		{
            $qty = $row['open_qty'];
		}
        
        return $qty;
	}
	
	public function get_purchase_qty($godown_id,$item_id,$sdate,$edate)
	{
		$sdate = date('Y-m-d',strtotime($sdate));
		$edate = date('Y-m-d',strtotime($edate));
		$qty=0;
	
        $ops = $this->CI->db->query("SELECT sum(qty) as open_qty from dms_stocks where godown_id='$godown_id' and item_id='$item_id' and stock_date >='$sdate' and stock_date <='$edate' and stock_status='2' and status=1");
		$row = $ops->row_array();
		if(!empty($row))
		{
            $qty = $row['open_qty'];
		}
        
        return $qty;
	}
	

	#-------------------------------------------------------------------------------

	public function unit_conversion($item_id,$unit,$qty,$rate = NULL,$amount = NULL)
	{
		$convert_qty = $qty;$convert_rate = $rate;$convert_amt = $amount;$new_qty=0;$stock_array = array();
		$row = $this->get_item($item_id,array('unit_id','alt_unit_id','unit_conversion','alt_unit_conversion'));
		if(!empty($row))
		{
			$stock_array['primary_unit'] = $row['unit_id'];
			if($row['unit_id'] == $unit){
				$stock_array['qty'] = $convert_qty;
				$stock_array['rate'] = $convert_rate;
				$stock_array['amount'] = $convert_amt;
				return $stock_array;
			}
			elseif($row['alt_unit_id'] > 0 && $unit == $row['alt_unit_id'])
			{
				$stock_array = $stock_array + $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$qty,$rate,1,$amount);
				return $stock_array;
			}
			else
			{
				$second_unit_array = $this->get_second_units($row['unit_id'],1);
				if(array_key_exists($unit,$second_unit_array))
				{
					$position = array_search($unit,array_keys($second_unit_array));
					$array_keys = array_keys($second_unit_array);
					for($i=$position;$i>=0;$i--)
					{
						if($i == 0){
							$previous_key = $row['unit_id'];
							if($array_keys[$i] == $row['alt_unit_id']){
								$result = $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$convert_qty,$convert_rate,1,$convert_amt);
							}
							else
							{
								$current_key = $array_keys[$i];
								$result = $this->get_converted_qty($previous_key,$current_key,$convert_qty,1,$convert_rate,$convert_amt);
							}
						}
						else{
							$previous_key = $array_keys[$i-1];
							$current_key = $array_keys[$i];
							$result = $this->get_converted_qty($previous_key,$current_key,$convert_qty,1,$convert_rate,$convert_amt);
						}
						$convert_qty = $result['qty'];
						$convert_rate = $result['rate'];
						$convert_amt = $result['amount'];
					}
				}
				else
				{
					$first_unit_array = $this->get_first_units($row['unit_id'],1);
					$position = array_search($unit,array_keys($first_unit_array));
					$array_keys = array_keys($first_unit_array);
					for($i=$position;$i>=0;$i--)
					{
						if($i == 0){
							$previous_key = $row['unit_id'];
							if($array_keys[$i] == $row['alt_unit_id']){
								$result = $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$convert_qty,$convert_rate,1,$convert_amt);
							}
							else{
								$current_key = $array_keys[$i];
								$result = $this->get_converted_qty($current_key,$previous_key,$convert_qty,2,$convert_rate,$convert_amt);
							}
						}
						else{
							$previous_key = $array_keys[$i-1];
							$current_key = $array_keys[$i];
							$result = $this->get_converted_qty($current_key,$previous_key,$convert_qty,2,$convert_rate,$convert_amt);
						}
						$convert_qty = $result['qty'];
						$convert_rate = $result['rate'];
						$convert_amt = $result['amount'];
					}
				}
				$stock_array['qty'] = $convert_qty;
				$stock_array['rate'] = $convert_rate;
				$stock_array['amount'] = $convert_amt;
				return $stock_array;
			}
		}
		return false;
	}

	#-------------------------------------------------------------------------------

	public function alternate_unit_convert($alt_conversion,$unit_conversion,$qty,$rate = NULL,$type = 1,$amount = NULL)
	{
		//$type = 1 => get_second_units function , $type = 2 => get_first_units function
		$new_alt_conversion = $alt_conversion/$unit_conversion;
		if($type == 1){
			$convert_qty = $qty/$new_alt_conversion;
			$convert_rate = $rate*$new_alt_conversion;
			$convert_amt = $amount*$new_alt_conversion;
		}
		else{
			$convert_qty = $qty*$new_alt_conversion;
			$convert_rate = $rate/$new_alt_conversion;
			$convert_amt = $amount/$new_alt_conversion;
		}
		return array('qty' => $convert_qty,'rate' => $convert_rate,'amount' => $convert_amt);
	}

	#-------------------------------------------------------------------------------

	public function get_converted_qty($first_unit,$second_unit,$qty,$type = 1,$rate = NULL,$amount = NULL)
	{
		//$type = 1 => get_second_units function , $type = 2 => get_first_units function
		$convert_qty = $convert_rate = $convert_amt = 0;
		$conversion = $this->CI->db->select(array('conversion'))->get_where('unit_master',array('first_unit' => $first_unit,'second_unit' => $second_unit))->row_array();
		if(!empty($conversion) && $conversion['conversion'] > 0 && $qty > 0){
			if($type == 1){
				$convert_qty = $qty/$conversion['conversion'];
				$convert_rate = $rate*$conversion['conversion'];
				$convert_amt = $amount*$conversion['conversion'];
			}
			else{
				$convert_qty = $conversion['conversion']*$qty;
				$convert_rate = $rate/$conversion['conversion'];
				$convert_amt = $amount/$conversion['conversion'];
			}
		}
		return array('qty' => $convert_qty,'rate' => $convert_rate,'amount' => $convert_amt);
	}

	#-------------------------------------------------------------------------------

	public function ledger_name($ledger_id)
	{
		$this->CI->db->select('ledger_name')->from('dms_ledgers')->where('id',$ledger_id);
		$row = $this->CI->db->get()->row_array();
		if(!empty($row)){
			return $row['ledger_name'];
		}
		return false;
	}

	#--------------------------------------------------------------------------------

	public function get_vendors($args=array()){

		# if isset of $args['return'] function returns vendor details as array
		$returnArray = array();
		$branchID = $this->CI->session->userdata('under_id');
	//	if($this->CI->dms->get_main_branch($branchID) === true){

			if(!isset($args['fields'])){
				$args['fields'] = array('id','manufacturer_name as name','phone as phone','manufacturer_email as email','address as address','tin_no','gstn','pincode','pan_no');
			}
			$args['fields'][] = 'id';
			$this->CI->db->select($args['fields'])->from('item_manufacturer_master');
			$args['conditions']['status'] = 1;
			$args['conditions']['company_id'] = $this->CI->session->userdata('company_id');
			$this->CI->db->where($args['conditions']);
			$this->CI->db->order_by('manufacturer_name','asc');
			$rows = $this->CI->db->get()->result_array();

	/*	}else{

			if(!isset($args['fields'])){
				$args['fields'] = array('id','concat(branch_short_name," / ",branch_name) as name','branch_address as address','branch_mobile as phone','branch_email as email');
			}


			$args['fields'][] = 'id';
			$this->CI->db->select($args['fields'])->from('branch_master');
			$args['conditions']['status'] = 1;
			$args['conditions']['branch_type'] = 1;
			$args['conditions']['company_id'] = $this->CI->session->userdata('company_id');
			$this->CI->db->where($args['conditions']);
			$this->CI->db->order_by('branch_name','asc');
			$rows = $this->CI->db->get()->result_array();

		} */
		if(!empty($rows)){

			foreach($rows as $key=>$row){
				$vendorID = $row['id'];
				unset($row['id']);
				if(isset($args['return'])){
					if(count($rows) == 1){
						return $row;
					}else{
						$returnArray[$vendorID] = $row;
					}
				}else{
					$returnArray[$vendorID] = $row['name'].' / '.$row['phone'];
				}
			}
		}
		return $returnArray;
	}

	#--------------------------------------------------------------------------------

	public function convert_unit_rate($item_id,$from_unit,$to_unit,$from_rate){

		$returnArray = array();$return_rate=0;
		$row = $this->get_item($item_id,array('unit_id','alt_unit_id','unit_conversion','alt_unit_conversion'));
		$primaryUnit = $row['unit_id'];
		$primaryUnitCon = $row['unit_conversion'];
		$alterUnit = $row['alt_unit_id'];
		$altterUnitCon = $row['alt_unit_conversion'];

		if($from_unit == $to_unit){
			$returnArray['rate'] = $from_rate;
		}else{

			$upper_units = $this->get_first_units($from_unit,1);
			$lower_units = $this->get_second_units($from_unit,1);
			if(array_key_exists($to_unit,$upper_units)){

				$unit_pos = array_search($to_unit,array_keys($upper_units));
				$upper_unit_keys = array_keys($upper_units);$cnvrt_from = $from_unit;
				for($Key_pos =0 ;$Key_pos<=$unit_pos;$Key_pos++){


					$cnvrt_to = ($Key_pos ==$unit_pos)?$to_unit:$upper_unit_keys[$Key_pos];
					if($alterUnit == $cnvrt_from){
						$conversion = ($altterUnitCon/$primaryUnitCon);
					}else{
						$conversion = $this->CI->db->select('conversion')->get_where('unit_master',array('first_unit'=>$cnvrt_to,'second_unit'=>$cnvrt_from))->row_array()['conversion'];
					}
					$return_rate = ($from_rate*$conversion);
					$from_rate = $return_rate;
					$cnvrt_from = $cnvrt_to;
				}
			}
			if(array_key_exists($to_unit,$lower_units)){
					$unit_pos = array_search($to_unit,array_keys($lower_units));
					$lower_unit_keys = array_keys($lower_units);$cnvrt_from = $from_unit;
					for($Key_pos =0 ;$Key_pos<=$unit_pos;$Key_pos++){
						$cnvrt_to = ($Key_pos ==$unit_pos)?$to_unit:$lower_unit_keys[$Key_pos];
						if($alterUnit == $cnvrt_to){
							$conversion = ($altterUnitCon);
						}else{
							$conversion = $this->CI->db->select('conversion')->get_where('unit_master',array('first_unit'=>$cnvrt_from,'second_unit'=>$cnvrt_to))->row_array()['conversion'];
						}
						$return_rate = ($from_rate/$conversion);
						$from_rate = $return_rate;
						$cnvrt_from = $cnvrt_to;
					}
			}
			$returnArray['rate'] = $return_rate;
		}

		return $returnArray;
	}

	#-------------------------------------------------------------------------------

	public function check_stock($conditions = array())
	{
		$row = $this->CI->db->select('id')->get_where('dms_stocks',$conditions)->row_array();
		if(!empty($row)){
			return $row['id'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------

	public function get_purchase_rate($itemID,$branch_id=NULL){

		#---purchase rate calculation cri. 0 ->Average Purchase Cost 1-> Last Purchase Cost
		$purchaseRateClcn = $this->CI->dms->stock_value_type($this->CI->session->userdata('fiscal_yr_id'));
		$fiscal_start_date = $this->CI->dms->get_fiscal_year()['start_date'];
		$fiscal_end_date = $this->CI->dms->get_fiscal_year()['end_date'];
		if(empty($branch_id)){
			$branch_id = $this->CI->session->userdata('under_id');
		}

		if($purchaseRateClcn == 0){
			# Average Purchase Cost
			$this->CI->db->select_avg('dpi.rate','avg_rate');
			$this->CI->db->from('dms_purchases as dp');
			$this->CI->db->join('dms_purchase_items1 as dpi','dp.group_id=dpi.group_id');
			$this->CI->db->where(array('branch_id'=>$branch_id,'dpi.item_id'=>$itemID,'dp.status'=>1,'dpi.status'=>1,'dpi.item_status >='=>1));
			$this->CI->db->where("dp.bill_date between '".$fiscal_start_date."' and '".$fiscal_end_date."'",NULL,true);
			$rows = $this->CI->db->get()->row_array();
			if(!empty($rows)){
				return $rows['avg_rate'];
			}
			return 0;
		}else{
			# last purchase cost
			$this->CI->db->select_max('dpi.rate');
			$this->CI->db->from('dms_purchases as dp');
			$this->CI->db->join('dms_purchase_items1 as dpi','dp.group_id=dpi.group_id');
			$this->CI->db->where(array('branch_id'=>$branch_id,'dpi.item_id'=>$itemID,'dpi.item_status >='=>1,'dp.status'=>1,'dpi.status'=>1));
			$this->CI->db->order_by('dp.bill_date','desc');
			$this->CI->db->order_by('dp.bill_no','desc');
			$this->CI->db->limit(1);
			$rows = $this->CI->db->get()->row_array();
			if(!empty($rows)){
				return $rows['rate'];
			}
			return 0;
		}
	}

	#==============================================

	public function get_customers($custType,$return=0){

		$customers = array();
		$customers[0] = array();
		$customers[1] = array();

		if($custType ==1){

			$this->CI->load->model('branches/branch_model','branches');
			$customers[0] = $this->CI->branches->listing(array('id !='=>$this->CI->session->userdata('under_id')));

		}else if($custType ==2){

			$this->CI->load->model('customers/customer_master_model','customer_master');
			$customers[0] = $this->CI->customer_master->listing();
			#array('conditions'=>array('branch_id'=>$this->CI->session->userdata('under_id')))
			$this->CI->load->model('designations/designation_master_model','designations');
			$customers[1] = $this->CI->designations->listing(array('utype_status'=>1));

		}else if($custType ==3){

			$this->CI->load->model('retailers/counter_model','retailer_master');
			$customers[0] = $this->CI->retailer_master->listing(array('company_id'=>$this->CI->session->userdata('company_id')));
		}else{

			$customers[0] = array();
		}
		return $customers[$return];
	}

	#==============================================

	public function get_designation($desigID){

		$this->CI->db->select(array('designation_name'));
		$this->CI->db->from('designation_master');
		$this->CI->db->where(array('id'=>$desigID));
		$row = $this->CI->db->get()->row_array();
		if(!empty($row)){
			return $row['designation_name'];
		}
		return NULL;
	}

	#-------------------------------------------------------------------------------

	public function vendor_name($vendor_id)
	{
		/*if($this->CI->dms->branch_type())
		{*/
			$row = $this->CI->db->select('manufacturer_name')->get_where('item_manufacturer_master',array('id' => $vendor_id))->row_array();
		/*}
		else
		{
			$row = $this->CI->db->select('concat(branch_short_name," / ",branch_name) as manufacturer_name')->get_where('branch_master',array('id' => $vendor_id))->row_array();
		}*/
		if(!empty($row)){
			return $row['manufacturer_name'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------
	public function bank_list(){

		$bank = array();
		$this->CI->db->select(array('id','ledger_name'))->from('dms_ledgers')->where('sgroup_id',14);
		$rows = $this->CI->db->get()->result_array();

		if(!empty($rows)){

			foreach($rows as $row){
				$bank[$row['id']] = $row['ledger_name'];
			}
		}
		return $bank;

	}
	#-------------------------------------------------------------------------------

	public function get_godown()//main godown of particular branch
	{
		$row = $this->CI->db->select('id')->from('godown_master')->where('branch_id',$this->CI->session->userdata('under_id'))->order_by('id','asc')->limit(1)->get()->row_array();
		if(!empty($row)){
			return $row['id'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------

	public function get_opening_rate($item_id,$goDowns=array()){

		if(empty($goDowns)){
			$goDowns = array_keys($this->get_item_godowns(array('item_id'=>$item_id,'listing'=>1)));
		}
		if(!empty($goDowns)){
			$this->CI->db->select(array('sum(rate) as rate','count(id) as count'))->from('dms_stocks')->where(array('item_id'=>$item_id,'rate !='=>0,'stock_status'=>0,'status'=>1))->where_in('godown_id',$goDowns);
			$row= $this->CI->db->get()->row_array();

			if(!empty($row)){
				if(!empty($row['count'])){
					return $row['rate']/$row['count'];
				}else{
					return $row['rate'];
				}
			}
		}
		return 0;
	}

	#------------------------------------------------------------------------------
	
	public function get_item_group_units($ite_group_id){
		
		$CI =& get_instance();
		$company_id = $this->CI->session->userdata('company_id');
		$CI->db->select('unit_id');
		$CI->db->from('item_master');
		$CI->db->where(array('item_group_id'=>$ite_group_id,'company_id'=>$company_id));
		$items = $CI->db->get()->result_array();

		if(!empty($items))
		{
			foreach($items as $row){
			$item_unit = $row['unit_id'];
			$this->unit_array[$item_unit] = $this->get_unit_symbol($item_unit);

			#---------- second unit
			$second_unit = $CI->db->select('second_unit')->get_where('unit_master',array('first_unit' => $item_unit,'unit_type' => 1,'status'=>1))->row_array();
			if(!empty($second_unit))
			{
				$this->unit_array[$second_unit['second_unit']] = $this->get_unit_symbol($second_unit['second_unit']);
				$second_unit_array = $this->get_second_units($second_unit['second_unit']);
				$this->unit_array = $this->unit_array+$second_unit_array;
			}

			#---------- first unit
			$first_unit = $CI->db->select('first_unit')->get_where('unit_master',array('second_unit' => $item_unit,'unit_type' => 1,'status'=>1))->result_array();
			if(!empty($first_unit))
			{
				foreach($first_unit as $key => $value)
				{
					$this->unit_array[$value['first_unit']] = $this->get_unit_symbol($value['first_unit']);
					$first_unit_array = $this->get_first_units($value['first_unit']);
					$this->unit_array = $this->unit_array+$first_unit_array;
				}
			}
		}
		}
		return $this->unit_array;
			
	}
	
	#------------------------------------------------------------------------------

        public function get_stock_count_items($args=array()){

		$items = array();
		$conditions=array();
                $ar=array();
		if(isset($args['conditions'])){
			$conditions = $args['conditions'];
		}

		$company_id = $this->CI->session->userdata('company_id');
		$conditions['company_id'] = $company_id;

                $ar['godown_id']=2;
                $ar['bill_date'] = date("Y-m-d");
		if(!isset($conditions['stock_type'])){
			$conditions['stock_type'] = 1;
		}
		$conditions['status'] = 1;
                $lrate = $args['lrate'];
                $hrate = $args['hrate'];
                if($lrate == '')
                {
                   $lrate=0; 
                }
                if($hrate == '')
                {
                   $hrate=1000000; 
                }

		$rows = $this->CI->db->select(array('id','item_code','item_name'))->get_where('item_master',$conditions)->result_array();
		if(!empty($rows)){
			if(!isset($args['return_type']))
			{
				foreach($rows as $key=>$row){
                                        $godown_id=2;
                                        $bill_date = date("Y-m-d");
                                        $item_id = $row['id'];
                                        				                                        
                                        $it_bal = $this->get_stock_count($godown_id,$item_id,$bill_date);
                                        $it_unit = $this->get_primary_unit($item_id);
                                        $qty_unit =$it_bal." ".$it_unit['symbol'];
                                        $rate = $this->get_item_rate($item_id);
                                        if($rate >= $lrate && $rate  <= $hrate)
                                        {
                                                 $item = $row['item_code'].' / '.$row['item_name'];
                                                 $items[$row['id']] = array('item'=>$item,'qnty'=>$qty_unit,'rate'=>$rate);  
                                        }
				}
			}
			else
			{
				return $rows;
			}
		}
		return $items;
	}

        public function get_vendor_items($args){

		$items=array();
		$vendorID = $args['vendor_id'];
		$companyID = $this->CI->session->userdata('company_id');

		$this->CI->db->select(array('id','item_code','item_name'));
		$this->CI->db->from('item_master');		
		$this->CI->db->where(array('item_manufacturer_id'=>$vendorID,'company_id'=>$companyID,'status'=>1));

		$rows = $this->CI->db->get()->result_array();

		if(!empty($rows)){
			foreach($rows as $key=>$row){
				if(isset($args['listing'])){
					$items[$row['id']] = $row['item_code'].' / '.$row['item_name'];
				}else{
					$items[$row['id']] = $row;
				}
			}
		}

		return $items;
	}
	
	public function get_item_dats($item_code){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name','model_no'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $data['name'] = $row['item_name'].'/'.$row['model_no'];
		    $rate = $this->get_item_rate($item_id);
		    if(empty($rate)){ $rate=0;}
		    $data['rate'] = $rate;
		    
		    $cgst = $this->get_item_cgst($item_id);
		    if(empty($cgst)){ $cgst=0;}
		    
		    $sgst = $this->get_item_sgst($item_id);
		    if(empty($sgst)){ $sgst = 0;}
		    
		    $qry_godown = $this->CI->db->select('id')->from('godown_master')->where(array('branch_id' => $branchID,'status'=>1))->get()->row_array();
		    $godown = $qry_godown['id'];
		    
		    $cess = $this->get_cess();
		    if(empty($cess)){ $cess = 0;}
		    
		    $cqty = $this->get_stock_count($godown,$item_id,date('Y-m-d'));
		    $data['cqty'] = $cqty;
		    
		    $taxable = ($rate*100)/(100+$cgst+$sgst+$cess);
		    $data['taxable'] = number_format($taxable,2);
		    
		    $cgst_amt = ($taxable*$cgst)/100;
		    $sgst_amt = ($taxable*$sgst)/100;
		    $cess_amt = ($taxable*$cess)/100;
		    
		    if(empty($cgst_amt)){$cgst_amt=0;}
		    $data['cgst_amt'] = number_format($cgst_amt,2);
		    
		    if(empty($sgst_amt)){$sgst_amt=0;}
		    $data['sgst_amt'] = number_format($sgst_amt,2);
		    
		    if(empty($cess_amt)){$cess_amt=0;}
		    $data['cess_amt'] = number_format($cess_amt,2);
		    
			return $data;
		}
		return false;

	}
#--------------------------------------------------------------------------------------------------------------------
public function get_item_datsnew($item_code){
    $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name','unit_id'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		if(!empty($row))
		{
		    $data['name'] = $row['item_name'];
		$item_id = $row['id'];
		$unit_id = $row['unit_id'];
		$unit = $this->get_item_unit($unit_id);
		$data['unit'] = $unit;
    	return $data;
        }
        return false;
}

#--------------------------------------------------------------------------------------------------------------------
public function get_item_stockcount($item_code){
    $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name','unit_id','model_no'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		if(!empty($row))
		{
		    $data['name'] = $row['item_name'].'/'.$row['model_no'];
		$item_id = $row['id'];
		$rate = $this->get_item_rate($item_id);
		    if(empty($rate)){ $rate=0;}
		    $data['rate'] = $rate;
		    
		    $landingcost = $this->get_item_landcost($item_id);
		    if(empty($landingcost)){ $landingcost=0;}
		    $data['landingcost'] = $landingcost;
		    
		$unit_id = $row['unit_id'];
		$unit = $this->get_item_unit($unit_id);
		$data['unit'] = $unit;
    	return $data;
        }
        return false;
}
#------------------------------------------------------------------------------------------------------------------------

public function get_item_unit($unit_id)
{
  
        $this->CI->db->select(array('symbol'));
		$this->CI->db->from('unit_master');
		$this->CI->db->where(array('id' => $unit_id,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['symbol'];

		if(!empty($row)){
			return $row['symbol'];
		}
		return false;

}

#------------------------------------------------------------------------------------------------------------------------
	public function get_item_purchase($item_code){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name','model_no'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $data['name'] = $row['item_name'].'/'.$row['model_no'];
		    $rate = $this->get_item_rate($item_id);
		    if(empty($rate)){ $rate=0;}
		    $data['rate'] = $rate;
		    
		    $cgst = $this->get_item_cgst($item_id);
		    if(empty($cgst)){ $cgst=0;}
		    
		    $sgst = $this->get_item_sgst($item_id);
		    if(empty($sgst)){ $sgst = 0;}
		    
		    $qry_godown = $this->CI->db->select('id')->from('godown_master')->where(array('branch_id' => $branchID,'status'=>1))->get()->row_array();
		    $godown = $qry_godown['id'];
		    
		    $cess = $this->get_cess();
		    if(empty($cess)){ $cess = 0;}
		    
		    $cqty = $this->get_stock_count($godown,$item_id,date('Y-m-d'));
		    $data['cqty'] = $cqty;
		    
		    $amount = $rate;
		    $data['amount'] = number_format($amount,2);
		    
		    $cgst_amt = ($amount*$cgst)/100;
		    $sgst_amt = ($amount*$sgst)/100;
		    
		    if(empty($cgst_amt)){$cgst_amt=0;}
		    $data['cgst_amt'] = number_format($cgst_amt,2);
		    
		    if(empty($sgst_amt)){$sgst_amt=0;}
		    $data['sgst_amt'] = number_format($sgst_amt,2);
		    
		    $grand = $amount+$cgst_amt+$sgst_amt;
		    $data['grand'] = number_format($grand,2);
		    
			return $data;
		}
		return false;

	}
	
	public function get_item_dats1($item_name){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_code'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_name' => $item_name,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $data['code'] = $row['item_code'];
		    $rate = $this->get_item_rate($item_id);
		    if(empty($rate)){ $rate=0;}
		    $data['rate'] = $rate;
		    
		    $cgst = $this->get_item_cgst($item_id);
		    if(empty($cgst)){ $cgst=0;}
		    
		    $sgst = $this->get_item_sgst($item_id);
		    if(empty($sgst)){ $sgst = 0;}
		    
		    $qry_godown = $this->CI->db->select('id')->from('godown_master')->where(array('branch_id' => $branchID,'status'=>1))->get()->row_array();
		    $godown = $qry_godown['id'];
		    
		    $cess = $this->get_cess();
		    if(empty($cess)){ $cess = 0;}
		    
		    $cqty = $this->get_stock_count($godown,$item_id,date('Y-m-d'));
		    $data['cqty'] = $cqty;
		    
		    $taxable = ($rate*100)/(100+$cgst+$sgst+$cess);
		    $data['taxable'] = number_format($taxable,2);
		    
		    $cgst_amt = ($taxable*$cgst)/100;
		    $sgst_amt = ($taxable*$sgst)/100;
		    $cess_amt = ($taxable*$cess)/100;
		    
		    if(empty($cgst_amt)){$cgst_amt=0;}
		    $data['cgst_amt'] = number_format($cgst_amt,2);
		    
		    if(empty($sgst_amt)){$sgst_amt=0;}
		    $data['sgst_amt'] = number_format($sgst_amt,2);
		    
		    if(empty($cess_amt)){$cess_amt=0;}
		    $data['cess_amt'] = number_format($cess_amt,2);
		    
			return $data;
		}
		return false;

	}
	
	public function get_item_gscs($item_code,$qty,$rate){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $cgst= $this->get_item_cgst($item_id);
		    $sgst= $this->get_item_sgst($item_id);
		    $cess = $this->get_cess();
		    if(empty($cess)){ $cess = 0;}
		  
		    $amount = $qty*$rate;
		    $taxable = ($amount*100)/(100+$cgst+$sgst+$cess);
		    
		    $data['taxable'] = number_format($taxable,2);
		    
		    $cgst_amt = ($taxable*$cgst)/100;
		    $sgst_amt = ($taxable*$sgst)/100;
		    $cess_amt = ($taxable*$cess)/100;
		    
		    if(empty($cgst_amt)){$cgst_amt=0;}
		    $data['cgst_amt'] = number_format($cgst_amt,2);
		    
		    if(empty($sgst_amt)){$sgst_amt=0;}
		    $data['sgst_amt'] = number_format($sgst_amt,2);
		    
		    if(empty($cess_amt)){$cess_amt=0;}
		    $data['cess_amt'] = number_format($cess_amt,2);
		    
		    $data['amount'] = $amount;
		    
		    return $data;
		}
		return false;
	}
	
	
	#---------------------------------------------------------------------------------------------------------------
	
		public function get_item_amount($item_code,$qty,$rate){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		   /* $cgst= $this->get_item_cgst($item_id);
		    $sgst= $this->get_item_sgst($item_id);
		    $cess = $this->get_cess();
		    if(empty($cess)){ $cess = 0;}*/
		  
		    $amount = $qty*$rate;
		   /* $taxable = ($amount*100)/(100+$cgst+$sgst+$cess);
		    
		    $data['taxable'] = number_format($taxable,2);
		    
		    $cgst_amt = ($taxable*$cgst)/100;
		    $sgst_amt = ($taxable*$sgst)/100;
		    $cess_amt = ($taxable*$cess)/100;
		    
		    if(empty($cgst_amt)){$cgst_amt=0;}
		    $data['cgst_amt'] = number_format($cgst_amt,2);
		    
		    if(empty($sgst_amt)){$sgst_amt=0;}
		    $data['sgst_amt'] = number_format($sgst_amt,2);
		    
		    if(empty($cess_amt)){$cess_amt=0;}
		    $data['cess_amt'] = number_format($cess_amt,2);*/
		    
		    $data['amount'] = $amount;
		    
		    return $data;
		}
		return false;
	}
	
	#---------------------------------------------------------------------------------------------------------------
	
		public function get_item_stockamount($item_code,$qty,$rate){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		   
		  
		    $amount = $qty*$rate;
		   
		    $data['amount'] = $amount;
		    
		    return $data;
		}
		return false;
	}
	
	
	#-----------------------------------------------------------------------------------------------------------------
	
	public function get_item_wholesale($item_code,$qty,$rate){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $cgst= $this->get_item_cgst($item_id);
		    $sgst= $this->get_item_sgst($item_id);
		    $cess = $this->get_cess();
		    if(empty($cess)){ $cess = 0;}
 
		    $taxable = $qty*$rate;
		    
		    $data['taxable'] = $taxable;
		    
		    $cgst_amt = ($taxable*$cgst)/100;
		    $sgst_amt = ($taxable*$sgst)/100;
		    //$cess_amt = ($taxable*$cess)/100;
		    
		    if(empty($cgst_amt)){$cgst_amt=0;}
		    $data['cgst_amt'] = $cgst_amt;
		    
		    if(empty($sgst_amt)){$sgst_amt=0;}
		    $data['sgst_amt'] = $sgst_amt;
		    
		    if(empty($cess_amt)){$cess_amt=0;}
		    $data['cess_amt'] = $cess_amt;
		    
		    $amount = $data['taxable']+$data['cgst_amt']+$data['sgst_amt'];
		    
		    $data['amount'] = $amount;
		    
		    return $data;
		}
		return false;
	}
	
	public function get_item_purch($item_code,$qty,$rate){

        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $cgst= $this->get_item_cgst($item_id);
		    $sgst= $this->get_item_sgst($item_id);
		    $cess = $this->get_cess();
		    if(empty($cess)){ $cess = 0;}
		  
		    $amount = $qty*$rate;
		    $data['amount'] = number_format($amount,2);
		    
		    $cgst_amt = ($amount*$cgst)/100;
		    $sgst_amt = ($amount*$sgst)/100;
		    
		    if(empty($cgst_amt)){$cgst_amt=0;}
		    $data['cgst_amt'] = number_format($cgst_amt,2);
		    
		    if(empty($sgst_amt)){$sgst_amt=0;}
		    $data['sgst_amt'] = number_format($sgst_amt,2);

		    $grand = $amount+$cgst_amt+$sgst_amt;
		    $data['grand'] = number_format($grand,2);

		    return $data;
		}
		return false;
	}
	
	public function get_item_datas($item_code){

        $data = array();

		$this->CI->db->select(array('id'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code' => $item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
			return $row['id'];
		}
		return false;
	}
	
	public function get_unit_id($item_id){

        $data = array();

		$this->CI->db->select(array('unit_id'));
		$this->CI->db->from('dms_stocks');
		$this->CI->db->where(array('item_id' => $item_id,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['unit_id'];

		if(!empty($row))
		{
			return $row['unit_id'];
		}
		return false;

	}
	public function minus_stock_sales(){

        $data = array();
        $branch_id = $this->CI->session->userdata('under_id');
		$this->CI->db->select(array('minus_stock_sales'));
		$this->CI->db->from('branch_master');
		$this->CI->db->where(array('id' => $branch_id));
		
		$row = $this->CI->db->get()->row_array();
		
		if(!empty($row))
		{
			return $row['minus_stock_sales'];
		}
		return false;

	}
	
	public function offer_updation($group_id)
	{
	    $user_id = $this->CI->session->userdata('id');
	    
	    $frame_tot=0; $lens_tot=0; $offer_discount=0; $upd_array = array();
		$rs2 = $this->CI->db->query("select sum(amount) as amt from dms_sales_items1 as s inner join item_master as i on s.item_id=i.id where s.group_id='$group_id' and s.status!='0' and s.created_by='$user_id' and i.item_group_id in(11,14)")->result_array();
		$frame_tot = $rs2[0]['amt'];
					        
		$rs3 = $this->CI->db->query("select sum(amount) as amt from dms_sales_items1 as s inner join item_master as i on s.item_id=i.id where s.group_id='$group_id' and s.status!='0' and s.created_by='$user_id' and i.item_group_id in(12,13,15)")->result_array();
		$lens_tot = $rs3[0]['amt'];
		//echo $frame_tot ."/".$lens_tot; die;
		if($frame_tot >= $lens_tot)
		{
			$offer_discount = $lens_tot;
			$this->CI->db->query("update dms_sales_items1 as s inner join item_master as i on s.item_id=i.id set s.discount_per='100',s.discount_amt=s.amount,s.taxable_amt='0',s.cgst_amt='0',s.sgst_amt='0',s.cess_amt='0' where s.group_id='$group_id' and s.status!='0' and s.created_by='$user_id' and i.item_group_id in(12,13,15)");
        
            $rs4 = $this->CI->db->query("select s.* from dms_sales_items1 as s inner join item_master as i on s.item_id=i.id where s.group_id='$group_id' and s.status!='0' and s.created_by='$user_id' and i.item_group_id in(11,14)")->result_array();
		    foreach($rs4 as $k1 => $v1)
        	{
        	    $upd_array['discount_per'] = 0;
        	    $upd_array['discount_amt'] = 0;
        	    $upd_array['taxable_amt'] = (($v1['amount'])*100)/(100+$v1['cgst']+$v1['sgst']);
        	    $upd_array['cgst_amt'] = ($upd_array['taxable_amt'] * $v1['cgst']) / 100;
        	    $upd_array['sgst_amt'] = ($upd_array['taxable_amt'] * $v1['sgst']) / 100;
        	    
        	    $this->CI->db->update('dms_sales_items1',$upd_array,array('id' => $v1['id']));
        	 }
        }
        else
        {
        	$offer_discount = $frame_tot;
			$this->CI->db->query("update dms_sales_items1 as s inner join item_master as i on s.item_id=i.id set s.discount_per='100',s.discount_amt=s.amount,s.taxable_amt='0',s.cgst_amt='0',s.sgst_amt='0',s.cess_amt='0' where s.group_id='$group_id' and s.status!='0' and s.created_by='$user_id' and i.item_group_id in(11,14)");
        
            $rs4 = $this->CI->db->query("select s.* from dms_sales_items1 as s inner join item_master as i on s.item_id=i.id where s.group_id='$group_id' and s.status!='0' and s.created_by='$user_id' and i.item_group_id in(12,13,15)")->result_array();
		    foreach($rs4 as $k1 => $v1)
        	{
        	    $upd_array['discount_per'] = 0;
        	    $upd_array['discount_amt'] = 0;
        	    $upd_array['taxable_amt'] = (($v1['amount'])*100)/(100+$v1['cgst']+$v1['sgst']);
        	    $upd_array['cgst_amt'] = ($upd_array['taxable_amt'] * $v1['cgst']) / 100;
        	    $upd_array['sgst_amt'] = ($upd_array['taxable_amt'] * $v1['sgst']) / 100;
        	    
        	    $this->CI->db->update('dms_sales_items1',$upd_array,array('id' => $v1['id']));
        	 }
        }
        return $offer_discount;
	}
	
}