<?php
class Stock {

	#------------------------------------------------
	public $unit_array = array();

	public function __construct(){

		$this->CI =& get_instance();
	}

	#------------------------------------------------

	public function get_stock_items($args=array()){

		$items = array();
		$conditions=array();
		if(isset($args['conditions'])){
			$conditions = $args['conditions'];
		}

		$company_id = $this->CI->session->userdata('company_id');
		$conditions['company_id'] = $company_id;
		if(!isset($conditions['stock_type'])){
			$conditions['stock_type'] = 1;
		}
		$conditions['status'] = 1;

		$rows = $this->CI->db->select(array('id','item_code','item_name'))->get_where('item_master',$conditions)->result_array();
		if(!empty($rows)){
			if(!isset($args['return_type']))
			{
				foreach($rows as $key=>$row){
					$items[$row['id']] = $row['item_code'].' / '.$row['item_name'];
				}
			}
			else
			{
				return $rows;
			}
		}
		return $items;
	}

	#------------------------------------------------------

	public function get_godowns($args = array()){

		$goDowns = array();
		$conditions=array();

		if(isset($args['conditions'])){
			$conditions = $args['conditions'];
		}

		$this->CI->load->model('godown/godown_model','godown');
		if(isset($args['listing'])){
			$godownArray = $this->CI->godown->listing($args);
		}else{
			$godownArray = $this->CI->godown->get_all($args);
		}

		return $godownArray;
	}

	#-----------------------------------------------------
	#------------------------------------------------

	public function get_units($id,$type = 0)
	{
		#----------type = 0 => id = item_id , type = 1 => id = unit_id
		$CI =& get_instance();
		if($type == 0){
			$CI->db->select('unit_id');
			$CI->db->from('item_master');
			$CI->db->where('id',$id);
			$row = $CI->db->get()->row_array();
		}
		else{
			$row['unit_id'] = $id;
		}
		if(!empty($row))
		{
			$item_unit = $row['unit_id'];
			$this->unit_array[$item_unit] = $this->get_unit_symbol($item_unit);

			#---------- second unit
			$second_unit = $CI->db->select('second_unit')->get_where('unit_master',array('first_unit' => $item_unit,'unit_type' => 1,'status'=>1))->row_array();
			if(!empty($second_unit))
			{
				$this->unit_array[$second_unit['second_unit']] = $this->get_unit_symbol($second_unit['second_unit']);
				$second_unit_array = $this->get_second_units($second_unit['second_unit']);
				$this->unit_array = $this->unit_array+$second_unit_array;
			}

			#---------- first unit
			$first_unit = $CI->db->select('first_unit')->get_where('unit_master',array('second_unit' => $item_unit,'unit_type' => 1,'status'=>1))->result_array();
			if(!empty($first_unit))
			{
				foreach($first_unit as $key => $value)
				{
					$this->unit_array[$value['first_unit']] = $this->get_unit_symbol($value['first_unit']);
					$first_unit_array = $this->get_first_units($value['first_unit']);
					$this->unit_array = $this->unit_array+$first_unit_array;
				}
			}
		}
		return $this->unit_array;
	}

	#--------------------------------------------------------------------------------

	public function get_second_units($first_unit,$type = NULL)
	{
		if($type != NULL){
			$this->unit_array = array();
		}
		$CI =& get_instance();
		$second_unit = $CI->db->select('second_unit')->get_where('unit_master',array('first_unit' => $first_unit,'unit_type' => 1,'status'=>1))->row_array();
		if(!empty($second_unit))
		{
			$this->unit_array[$second_unit['second_unit']] = $this->get_unit_symbol($second_unit['second_unit']);
			$this->get_second_units($second_unit['second_unit']);
		}
		return $this->unit_array;
	}

	#--------------------------------------------------------------------------------

	public function get_first_units($second_unit,$type = NULL)
	{
		if($type != NULL){
			$this->unit_array = array();
		}
		$CI =& get_instance();
		$first_unit = $CI->db->select('first_unit')->get_where('unit_master',array('second_unit' => $second_unit,'unit_type' => 1,'status'=>1))->row_array();
		if(!empty($first_unit))
		{
			$this->unit_array[$first_unit['first_unit']] = $this->get_unit_symbol($first_unit['first_unit']);
			$this->get_first_units($first_unit['first_unit']);
		}
		return $this->unit_array;
	}

	#--------------------------------------------------------------------------------

	public function get_unit_symbol($unit_id)
	{
		$CI =& get_instance();
		$row = $CI->db->select('symbol')->get_where('unit_master',array('id' => $unit_id,'status'=>1))->row_array();
		if(!empty($row)){
			return $row['symbol'];
		}
		return false;
	}

	#------------------------------------------------------------------------------

	public function get_voucher_prefix($vid){

		$row = $this->CI->db->select(array('vprefix'))->get_where('dms_voucher_prefixes',array('company_id'=>$this->CI->session->userdata('company_id'),'vid'=>$vid))->row_array();
		if(!empty($row)){
			return $row['vprefix'];
		}
		return NULL;
	}

	#------------------------------------------------------------------------------

	public function get_primary_unit($item_id){

		$itemArray = array();
		if(!empty($item_id)){

			$this->CI->db->select(array('u.id','u.unit_type','u.formal_name','u.symbol'));
			$this->CI->db->from('item_master as i');
			$this->CI->db->join('unit_master as u','i.unit_id=u.id');
			$this->CI->db->where(array('i.id'=>$item_id,'i.status'=>1));
			$row = $this->CI->db->get()->row_array();
		}
		if(!empty($row)){
			$itemArray = $row;
		}
		return $itemArray;
	}

	#------------------------------------------------------------------------------

	public function get_opening_stock($args=array()){

		$goDowns = array();
		if(isset($args['godown_id'])){
			if(is_array($args['godown_id'])){
				foreach($args['godown_id'] as $key=>$gid){
					$goDowns[$gid] = $gid;
				}
			}else{
				$goDowns[$args['godown_id']] = $args['godown_id'];
			}
		}else{
			$branch_id = $this->CI->session->userdata('under_id');
			$goDownsList = $this->get_godowns(array('conditions'=>array('branch_id'=>$branch_id)));
			foreach($goDownsList as $gkey=>$godwn){
				$goDowns[$godwn['id']] = $godwn['id'];
			}
		}

		$itemID = $args['item_id'];
		$openingDate = $args['opening_date'];
		$totalOpeningQnty = NULL;

		$company_id = $this->CI->session->userdata('company_id');
		if(!empty($goDowns)){
			foreach($goDowns as $goDownID=>$goDown){

				$this->CI->db->query("CALL opening_stock($goDownID,$itemID,'$openingDate',@ss); ");
				$ops = $this->CI->db->query("SELECT @ss as openQty");
				$row = $ops->row_array();
				if(!empty($row)){
					$totalOpeningQnty += $row['openQty'];
				}
			}
		}
		return $totalOpeningQnty;
	}

	#------------------------------------------------------------------------------

	public function get_actual_opening($itemID,$goDownID){

		$company_id = $this->CI->session->userdata('company_id');

		$this->CI->db->select(array('id','company_id','qty','unit_id','rate','stock_date',));
		$this->CI->db->from('dms_stocks');
		$this->CI->db->where(array('company_id'=>$company_id,'godown_id'=>$goDownID,'item_id'=>$itemID,'stock_status'=>0,'status'=>1));
		$this->CI->db->order_by('stock_date','desc');
		$this->CI->db->limit(1);
		#echo "<pre>";
		$row = $this->CI->db->get()->row_array();
		#echo $this->CI->db->last_query();
		return $row;

	}

	#-------------------------------------------------------------------------------

	public function get_item_godowns($args){

		$itemGodowns=array();
		$itemID = $args['item_id'];
		$branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('ds.godown_id','gm.godown_code','gm.godown_name'));
		$this->CI->db->from('dms_stocks as ds');
		$this->CI->db->join('godown_master as gm','ds.godown_id=gm.id');
		$this->CI->db->where(array('ds.item_id'=>$itemID,'gm.branch_id'=>$branchID,'ds.status'=>1));

		$rows = $this->CI->db->get()->result_array();

		if(!empty($rows)){
			foreach($rows as $key=>$row){
				if(isset($args['listing'])){
					$itemGodowns[$row['godown_id']] = $row['godown_code'].' / '.$row['godown_name'];
				}else{
					$itemGodowns[$row['godown_id']] = $row;
				}
			}
		}

		return $itemGodowns;
	}

	#-------------------------------------------------------------------------------

	public function get_users($args){

		if(!isset($args['select'])){
			$args['selects'] = array('id','fname','lname');
		}else{
			$args['selects'] = $args['select'];
			$args['selects'][] = 'id';
		}
		$args['conditions']['status'] = 1;
		$rows = $this->CI->db->select($args['selects'])->get_where('users',$args['conditions'])->result_array();

		$users = array();
		if(!empty($rows)){
			foreach($rows as $row){
				if(!isset($args['select'])){
						$users[$row['id']] = $row['fname'].' '.$row['lname'];
				}else{
					$users[$row['id']] = $row;
				}
			}
		}
		return $users;
	}

	#-------------------------------------------------------------------------------

	public function get_item_vat($itemID)
	{
		$this->CI->load->model('accounts/vat_model','vat');
		$row = $this->CI->db->select('item_group_id')->get_where('item_master',array('id' => $itemID))->row_array();
		return $vatPercent = $this->CI->vat->get_item_vat($row['item_group_id']);
	}

	#-------------------------------------------------------------------------------

	public function get_group_id($table){

		$maxRow = $this->CI->db->select_max('group_id')->get_where($table)->row_array();
		if($maxRow['group_id'] != NULL){
			$maxRow['group_id'] = $maxRow['group_id']+1;
		}else{
			$maxRow['group_id'] = 1;
		}
		return $maxRow['group_id'];
	}

	#----------------------------------------------------------------------------------

	public function get_customer($customerType,$customerID,$return=NULL){

		if($customerType ==1){

			#-branch details
			$rows = $this->CI->db->select(array('concat(branch_short_name," ",branch_name) as name','branch_landline phone_no','branch_mobile as mobile_no','branch_address as address','branch_email as email_id','ledger_id'))->get_where('branch_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else if($customerType ==2){

			#-customer details
			$rows = $this->CI->db->select(array('concat(fname," ",lname) as name','address','mobile_no','phone_no','email_id','ledger_id'))->get_where('customer_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else if($customerType ==3){

			#-ar details
			$rows = $this->CI->db->select(array('concat(retailer_short_name," ",retailer_name) as name','retailer_address as address','retailer_landline as phone_no','retailer_mobile as mobile_no','retailer_email as email_id','tin_no as tin','ledger_id'))->get_where('retailer_master',array('id'=>$customerID))->row_array();
			if(!empty($rows)){
				if(empty($return)){
					return $rows['name'];
				}else{
					return $rows;
				}
			}
			return NULL;

		}else{
			return NULL;
		}
	}

	#-------------------------------------------------------------------------------

	public function get_item($item_id,$columns = array()){

		if(empty($columns)){
			$columns = "item_name";
		}
		$row = $this->CI->db->select($columns)->get_where('item_master',array('id' => $item_id))->row_array();
		if(!is_array($columns)){
			return $row['item_name'];
		}
		return $row;
	}

	#-------------------------------------------------------------------------------

	public function get_tax_type()
	{
		#return array(10);
		$row = $this->CI->db->select(array('tax_type','presum_tax'))->get_where('company_master',array('id' => $this->CI->session->userdata('company_id')))->row_array();
		if($row['tax_type'] == 0){
			return array($row['presum_tax']);
		}
		return array();
	}

	#-------------------------------------------------------------------------------

	public function get_cess()
	{
		$this->CI->load->model('accounts/cess_model','cess');
		$row = $this->CI->cess->get(array('columns' => 'cess_percent'));
		if(!empty($row)){
			return $row['cess_percent'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------
	public function get_item_rate($itemID){

		$this->CI->db->select('rate');
		$this->CI->db->from('dms_item_rates');
		$this->CI->db->where(array('company_id' =>$this->CI->session->userdata('company_id'),'item_id' => $itemID,'status'=>1));
		$this->CI->db->order_by('valid_from','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();

		if(!empty($row)){
			return $row['rate'];
		}
		return false;

	}

	#-------------------------------------------------------------------------------

	public function get_constant($constant=array()){
		if(empty($constant)){
			$constant = array('date_format','decimal_place','currency_symbol','time_for_targets','vat_in_ex','sales_cst','purchase_cst');
		}
		$rows = $this->CI->db->select($constant)->get_where('constant_master',array('company_id'=>$this->CI->session->userdata('company_id')))->row_array();

			if(count($constant) == 1){
				if(!empty($rows)){
					return $rows[$constant[0]];
				}else{
					return NULL;
				}
			}else{
				if(!empty($rows)){
					return $rows;
				}else{
					return array();
				}
			}
	}

	#-------------------------------------------------------------------------------

	public function payment_modes($conditions=array())
	{
		$modes = array();
		$this->CI->db->select(array('id','ledger_name'))->from('dms_ledgers')->where("(company_id = ".$this->CI->session->userdata('company_id')." or company_id = 0 or company_id = -1)")->where('id !=',7);
		if(empty($conditions['sub_groups'])){
			$sGroups = array(13,14,0);
		}else{
			$sGroups = $conditions['sub_groups'];
		}
		$this->CI->db->where_in('sgroup_id',$sGroups);
		$row = $this->CI->db->get()->result_array();
		if(!empty($row)){
			foreach($row as $key => $value){
				$modes[$value['id']] = $value['ledger_name'];
			}
		}
		return $modes;
	}

	#-------------------------------------------------------------------------------

	public function get_stock_count($godown_id,$item_id,$date = NULL)
	{
		if(empty($date)){
			$date = $this->CI->dms->get_fiscal_year()['end_date'];}
		$date = date('Y-m-d',strtotime($date));
		$this->CI->db->query("CALL opening_stock($godown_id,$item_id,'$date',@stock_count); ");
		$ops = $this->CI->db->query("SELECT @stock_count as open_qty");
		$row = $ops->row_array();
		return $row['open_qty'];
	}

	#-------------------------------------------------------------------------------

	public function unit_conversion($item_id,$unit,$qty,$rate = NULL,$amount = NULL)
	{
		$convert_qty = $qty;$convert_rate = $rate;$convert_amt = $amount;$new_qty=0;$stock_array = array();
		$row = $this->get_item($item_id,array('unit_id','alt_unit_id','unit_conversion','alt_unit_conversion'));
		if(!empty($row))
		{
			$stock_array['primary_unit'] = $row['unit_id'];
			if($row['unit_id'] == $unit){
				$stock_array['qty'] = $convert_qty;
				$stock_array['rate'] = $convert_rate;
				$stock_array['amount'] = $convert_amt;
				return $stock_array;
			}
			elseif($row['alt_unit_id'] > 0 && $unit == $row['alt_unit_id'])
			{
				$stock_array = $stock_array + $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$qty,$rate,1,$amount);
				return $stock_array;
			}
			else
			{
				$second_unit_array = $this->get_second_units($row['unit_id'],1);
				if(array_key_exists($unit,$second_unit_array))
				{
					$position = array_search($unit,array_keys($second_unit_array));
					$array_keys = array_keys($second_unit_array);
					for($i=$position;$i>=0;$i--)
					{
						if($i == 0){
							$previous_key = $row['unit_id'];
							if($array_keys[$i] == $row['alt_unit_id']){
								$result = $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$convert_qty,$convert_rate,1,$convert_amt);
							}
							else
							{
								$current_key = $array_keys[$i];
								$result = $this->get_converted_qty($previous_key,$current_key,$convert_qty,1,$convert_rate,$convert_amt);
							}
						}
						else{
							$previous_key = $array_keys[$i-1];
							$current_key = $array_keys[$i];
							$result = $this->get_converted_qty($previous_key,$current_key,$convert_qty,1,$convert_rate,$convert_amt);
						}
						$convert_qty = $result['qty'];
						$convert_rate = $result['rate'];
						$convert_amt = $result['amount'];
					}
				}
				else
				{
					$first_unit_array = $this->get_first_units($row['unit_id'],1);
					$position = array_search($unit,array_keys($first_unit_array));
					$array_keys = array_keys($first_unit_array);
					for($i=$position;$i>=0;$i--)
					{
						if($i == 0){
							$previous_key = $row['unit_id'];
							if($array_keys[$i] == $row['alt_unit_id']){
								$result = $this->alternate_unit_convert($row['alt_unit_conversion'],$row['unit_conversion'],$convert_qty,$convert_rate,1,$convert_amt);
							}
							else{
								$current_key = $array_keys[$i];
								$result = $this->get_converted_qty($current_key,$previous_key,$convert_qty,2,$convert_rate,$convert_amt);
							}
						}
						else{
							$previous_key = $array_keys[$i-1];
							$current_key = $array_keys[$i];
							$result = $this->get_converted_qty($current_key,$previous_key,$convert_qty,2,$convert_rate,$convert_amt);
						}
						$convert_qty = $result['qty'];
						$convert_rate = $result['rate'];
						$convert_amt = $result['amount'];
					}
				}
				$stock_array['qty'] = $convert_qty;
				$stock_array['rate'] = $convert_rate;
				$stock_array['amount'] = $convert_amt;
				return $stock_array;
			}
		}
		return false;
	}

	#-------------------------------------------------------------------------------

	public function alternate_unit_convert($alt_conversion,$unit_conversion,$qty,$rate = NULL,$type = 1,$amount = NULL)
	{
		//$type = 1 => get_second_units function , $type = 2 => get_first_units function
		$new_alt_conversion = $alt_conversion/$unit_conversion;
		if($type == 1){
			$convert_qty = $qty/$new_alt_conversion;
			$convert_rate = $rate*$new_alt_conversion;
			$convert_amt = $amount*$new_alt_conversion;
		}
		else{
			$convert_qty = $qty*$new_alt_conversion;
			$convert_rate = $rate/$new_alt_conversion;
			$convert_amt = $amount/$new_alt_conversion;
		}
		return array('qty' => $convert_qty,'rate' => $convert_rate,'amount' => $convert_amt);
	}

	#-------------------------------------------------------------------------------

	public function get_converted_qty($first_unit,$second_unit,$qty,$type = 1,$rate = NULL,$amount = NULL)
	{
		//$type = 1 => get_second_units function , $type = 2 => get_first_units function
		$convert_qty = $convert_rate = $convert_amt = 0;
		$conversion = $this->CI->db->select(array('conversion'))->get_where('unit_master',array('first_unit' => $first_unit,'second_unit' => $second_unit))->row_array();
		if(!empty($conversion) && $conversion['conversion'] > 0 && $qty > 0){
			if($type == 1){
				$convert_qty = $qty/$conversion['conversion'];
				$convert_rate = $rate*$conversion['conversion'];
				$convert_amt = $amount*$conversion['conversion'];
			}
			else{
				$convert_qty = $conversion['conversion']*$qty;
				$convert_rate = $rate/$conversion['conversion'];
				$convert_amt = $amount/$conversion['conversion'];
			}
		}
		return array('qty' => $convert_qty,'rate' => $convert_rate,'amount' => $convert_amt);
	}

	#-------------------------------------------------------------------------------

	public function ledger_name($ledger_id)
	{
		$this->CI->db->select('ledger_name')->from('dms_ledgers')->where('id',$ledger_id);
		$row = $this->CI->db->get()->row_array();
		if(!empty($row)){
			return $row['ledger_name'];
		}
		return false;
	}

	#--------------------------------------------------------------------------------

	public function get_vendors($args=array()){

		# if isset of $args['return'] function returns vendor details as array
		$returnArray = array();
		$branchID = $this->CI->session->userdata('under_id');
		if($this->CI->dms->get_main_branch($branchID) === true){

			if(!isset($args['fields'])){
				$args['fields'] = array('id','manufacturer_name as name','phone as phone','manufacturer_email as email','address as address','tin_no','pincode','pan_no');
			}
			$args['fields'][] = 'id';
			$this->CI->db->select($args['fields'])->from('item_manufacturer_master');
			$args['conditions']['status'] = 1;
			$args['conditions']['company_id'] = $this->CI->session->userdata('company_id');
			$this->CI->db->where($args['conditions']);
			$this->CI->db->order_by('manufacturer_name','asc');
			$rows = $this->CI->db->get()->result_array();

		}else{

			if(!isset($args['fields'])){
				$args['fields'] = array('id','concat(branch_short_name," / ",branch_name) as name','branch_address as address','branch_mobile as phone','branch_email as email');
			}


			$args['fields'][] = 'id';
			$this->CI->db->select($args['fields'])->from('branch_master');
			$args['conditions']['status'] = 1;
			$args['conditions']['branch_type'] = 1;
			$args['conditions']['company_id'] = $this->CI->session->userdata('company_id');
			$this->CI->db->where($args['conditions']);
			$this->CI->db->order_by('branch_name','asc');
			$rows = $this->CI->db->get()->result_array();

		}
		if(!empty($rows)){

			foreach($rows as $key=>$row){
				$vendorID = $row['id'];
				unset($row['id']);
				if(isset($args['return'])){
					if(count($rows) == 1){
						return $row;
					}else{
						$returnArray[$vendorID] = $row;
					}
				}else{
					$returnArray[$vendorID] = $row['name'].' / '.$row['phone'];
				}
			}
		}
		return $returnArray;
	}

	#--------------------------------------------------------------------------------

	public function convert_unit_rate($item_id,$from_unit,$to_unit,$from_rate){

		$returnArray = array();$return_rate=0;
		$row = $this->get_item($item_id,array('unit_id','alt_unit_id','unit_conversion','alt_unit_conversion'));
		$primaryUnit = $row['unit_id'];
		$primaryUnitCon = $row['unit_conversion'];
		$alterUnit = $row['alt_unit_id'];
		$altterUnitCon = $row['alt_unit_conversion'];

		if($from_unit == $to_unit){
			$returnArray['rate'] = $from_rate;
		}else{

			$upper_units = $this->get_first_units($from_unit,1);
			$lower_units = $this->get_second_units($from_unit,1);
			if(array_key_exists($to_unit,$upper_units)){

				$unit_pos = array_search($to_unit,array_keys($upper_units));
				$upper_unit_keys = array_keys($upper_units);$cnvrt_from = $from_unit;
				for($Key_pos =0 ;$Key_pos<=$unit_pos;$Key_pos++){


					$cnvrt_to = ($Key_pos ==$unit_pos)?$to_unit:$upper_unit_keys[$Key_pos];
					if($alterUnit == $cnvrt_from){
						$conversion = ($altterUnitCon/$primaryUnitCon);
					}else{
						$conversion = $this->CI->db->select('conversion')->get_where('unit_master',array('first_unit'=>$cnvrt_to,'second_unit'=>$cnvrt_from))->row_array()['conversion'];
					}
					$return_rate = ($from_rate*$conversion);
					$from_rate = $return_rate;
					$cnvrt_from = $cnvrt_to;
				}
			}
			if(array_key_exists($to_unit,$lower_units)){
					$unit_pos = array_search($to_unit,array_keys($lower_units));
					$lower_unit_keys = array_keys($lower_units);$cnvrt_from = $from_unit;
					for($Key_pos =0 ;$Key_pos<=$unit_pos;$Key_pos++){
						$cnvrt_to = ($Key_pos ==$unit_pos)?$to_unit:$lower_unit_keys[$Key_pos];
						if($alterUnit == $cnvrt_to){
							$conversion = ($altterUnitCon);
						}else{
							$conversion = $this->CI->db->select('conversion')->get_where('unit_master',array('first_unit'=>$cnvrt_from,'second_unit'=>$cnvrt_to))->row_array()['conversion'];
						}
						$return_rate = ($from_rate/$conversion);
						$from_rate = $return_rate;
						$cnvrt_from = $cnvrt_to;
					}
			}
			$returnArray['rate'] = $return_rate;
		}

		return $returnArray;
	}

	#-------------------------------------------------------------------------------

	public function check_stock($conditions = array())
	{
		$row = $this->CI->db->select('id')->get_where('dms_stocks',$conditions)->row_array();
		if(!empty($row)){
			return $row['id'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------

	public function get_purchase_rate($itemID,$branch_id=NULL){

		#---purchase rate calculation cri. 0 ->Average Purchase Cost 1-> Last Purchase Cost
		$purchaseRateClcn = $this->CI->dms->stock_value_type($this->CI->session->userdata('fiscal_yr_id'));
		$fiscal_start_date = $this->CI->dms->get_fiscal_year()['start_date'];
		$fiscal_end_date = $this->CI->dms->get_fiscal_year()['end_date'];
		if(empty($branch_id)){
			$branch_id = $this->CI->session->userdata('under_id');
		}

		if($purchaseRateClcn == 0){
			# Average Purchase Cost
			$this->CI->db->select_avg('dpi.rate','avg_rate');
			$this->CI->db->from('dms_purchases as dp');
			$this->CI->db->join('dms_purchase_items as dpi','dp.group_id=dpi.group_id');
			$this->CI->db->where(array('branch_id'=>$branch_id,'dpi.item_id'=>$itemID,'dp.status'=>1,'dpi.status'=>1,'dpi.item_status >='=>1));
			$this->CI->db->where("dp.bill_date between '".$fiscal_start_date."' and '".$fiscal_end_date."'",NULL,true);
			$rows = $this->CI->db->get()->row_array();
			if(!empty($rows)){
				return $rows['avg_rate'];
			}
			return 0;
		}else{
			# last purchase cost
			$this->CI->db->select_max('dpi.rate');
			$this->CI->db->from('dms_purchases as dp');
			$this->CI->db->join('dms_purchase_items as dpi','dp.group_id=dpi.group_id');
			$this->CI->db->where(array('branch_id'=>$branch_id,'dpi.item_id'=>$itemID,'dpi.item_status >='=>1,'dp.status'=>1,'dp.status'=>1,'dpi.status'=>1));
			$this->CI->db->order_by('dp.bill_date','desc');
			$this->CI->db->order_by('dp.bill_no','desc');
			$this->CI->db->limit(1);
			$rows = $this->CI->db->get()->row_array();
			if(!empty($rows)){
				return $rows['rate'];
			}
			return 0;
		}
	}

	#==============================================

	public function get_customers($custType,$return=0){

		$customers = array();
		$customers[0] = array();
		$customers[1] = array();

		if($custType ==1){

			$this->CI->load->model('branches/branch_model','branches');
			$customers[0] = $this->CI->branches->listing(array('id !='=>$this->CI->session->userdata('under_id')));

		}else if($custType ==2){

			$this->CI->load->model('customers/customer_master_model','customer_master');
			$customers[0] = $this->CI->customer_master->listing();
			#array('conditions'=>array('branch_id'=>$this->CI->session->userdata('under_id')))
			$this->CI->load->model('designations/designation_master_model','designations');
			$customers[1] = $this->CI->designations->listing(array('utype_status'=>1));

		}else if($custType ==3){

			$this->CI->load->model('retailers/counter_model','retailer_master');
			$customers[0] = $this->CI->retailer_master->listing(array('company_id'=>$this->CI->session->userdata('company_id')));
		}else{

			$customers[0] = array();
		}
		return $customers[$return];
	}

	#==============================================

	public function get_designation($desigID){

		$this->CI->db->select(array('designation_name'));
		$this->CI->db->from('designation_master');
		$this->CI->db->where(array('id'=>$desigID));
		$row = $this->CI->db->get()->row_array();
		if(!empty($row)){
			return $row['designation_name'];
		}
		return NULL;
	}

	#-------------------------------------------------------------------------------

	public function vendor_name($vendor_id)
	{
		if($this->CI->dms->branch_type())
		{
			$row = $this->CI->db->select('manufacturer_name')->get_where('item_manufacturer_master',array('id' => $vendor_id))->row_array();
		}
		else
		{
			$row = $this->CI->db->select('concat(branch_short_name," / ",branch_name) as manufacturer_name')->get_where('branch_master',array('id' => $vendor_id))->row_array();
		}
		if(!empty($row)){
			return $row['manufacturer_name'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------
	public function bank_list(){

		$bank = array();
		$this->CI->db->select(array('id','ledger_name'))->from('dms_ledgers')->where('sgroup_id',14);
		$rows = $this->CI->db->get()->result_array();

		if(!empty($rows)){

			foreach($rows as $row){
				$bank[$row['id']] = $row['ledger_name'];
			}
		}
		return $bank;

	}
	#-------------------------------------------------------------------------------

	public function get_godown()//main godown of particular branch
	{
		$row = $this->CI->db->select('id')->from('godown_master')->where('branch_id',$this->CI->session->userdata('under_id'))->order_by('id','asc')->limit(1)->get()->row_array();
		if(!empty($row)){
			return $row['id'];
		}
		return false;
	}

	#-------------------------------------------------------------------------------

	public function get_opening_rate($item_id,$goDowns=array()){

		if(empty($goDowns)){
			$goDowns = array_keys($this->get_item_godowns(array('item_id'=>$item_id,'listing'=>1)));
		}
		if(!empty($goDowns)){
			$this->CI->db->select(array('sum(rate) as rate','count(id) as count'))->from('dms_stocks')->where(array('item_id'=>$item_id,'rate !='=>0,'stock_status'=>0,'status'=>1))->where_in('godown_id',$goDowns);
			$row= $this->CI->db->get()->row_array();

			if(!empty($row)){
				if(!empty($row['count'])){
					return $row['rate']/$row['count'];
				}else{
					return $row['rate'];
				}
			}
		}
		return 0;
	}

	#------------------------------------------------------------------------------
	
	public function get_item_group_units($ite_group_id){
		
		$CI =& get_instance();
		$company_id = $this->CI->session->userdata('company_id');
		$CI->db->select('unit_id');
		$CI->db->from('item_master');
		$CI->db->where(array('item_group_id'=>$ite_group_id,'company_id'=>$company_id));
		$items = $CI->db->get()->result_array();

		if(!empty($items))
		{
			foreach($items as $row){
			$item_unit = $row['unit_id'];
			$this->unit_array[$item_unit] = $this->get_unit_symbol($item_unit);

			#---------- second unit
			$second_unit = $CI->db->select('second_unit')->get_where('unit_master',array('first_unit' => $item_unit,'unit_type' => 1,'status'=>1))->row_array();
			if(!empty($second_unit))
			{
				$this->unit_array[$second_unit['second_unit']] = $this->get_unit_symbol($second_unit['second_unit']);
				$second_unit_array = $this->get_second_units($second_unit['second_unit']);
				$this->unit_array = $this->unit_array+$second_unit_array;
			}

			#---------- first unit
			$first_unit = $CI->db->select('first_unit')->get_where('unit_master',array('second_unit' => $item_unit,'unit_type' => 1,'status'=>1))->result_array();
			if(!empty($first_unit))
			{
				foreach($first_unit as $key => $value)
				{
					$this->unit_array[$value['first_unit']] = $this->get_unit_symbol($value['first_unit']);
					$first_unit_array = $this->get_first_units($value['first_unit']);
					$this->unit_array = $this->unit_array+$first_unit_array;
				}
			}
		}
		}
		return $this->unit_array;
			
	}
	
	#------------------------------------------------------------------------------
}