<?php
class Stock_summary
{
	public $CI;
	public $company_id;
	public $branch_id;
	public $created_by;

	public function __construct(){

		$this->CI =& get_instance();
		$this->company_id = $this->CI->session->userdata('company_id');
		$this->branch_id = $this->CI->session->userdata('under_id');
		$this->created_by = $this->CI->session->userdata('id');
	}

	#----------all stock items
	public function get_items()
	{
		$row = $this->CI->db->select(array('id','item_code','item_name','unit_id','model_no'))->from('item_master')->where(array('company_id' => $this->CI->session->userdata('company_id'),'stock_type' => 1,'status' => 1))->order_by('item_code','asc')->get()->result_array();
		if(!empty($row))
		{
			return $row;
		}
		return false;
	}

    public function get_items_stock()
	{
        $row = $this->CI->db->query("SELECT i.id,item_code,item_name,model_no,unit_id,rate,landing_cost from item_master as i left join (select * from dms_item_rates where id in(select max(id) from dms_item_rates group by item_id)) as r on i.id = r.item_id order by item_code asc")->result_array();
		if(!empty($row))
		{
			return $row;
		}
		return false;
	}

    /*public function get_items_new()
	{
		$row = $this->CI->db->select(array('item_id','qty','unit_id'))->from('item_stock')->where(array('company_id' => $this->CI->session->userdata('company_id'),'branch_id' => $this->CI->session->userdata('under_id'),'qty'!=0))->get()->result_array();
		if(!empty($row))
		{
			return $row;
		}
		return false;
	}

    */




#----------------------------------------------------------------------------------------------------#

/*public function getItemUnit($item_id)
	{
		return $this->CI->db->select(array('unit_id','symbol'))->from('item_master as a')->join('unit_master as b','a.unit_id = b.id')->where('a.id',$item_id)->get()->row_array();

	}*/
public function get_qty($itemid)
	{
		$row = $this->CI->db->select(array('qty'))->from('item_stock')->where(array('company_id' => $this->CI->session->userdata('company_id'),'branch_id' =>$this->CI->session->userdata('under_id'),'item_id' =>$itemid))->get()->result_array();
		if(!empty($row))
		{
			return $row;
		}
		return false;
	}

	#---------item opening rate
	public function item_opening_rate($item_id,$date)
	{
		$row = $this->CI->db->select('rate')->from('dms_stocks')->where(array('branch_id' => $this->CI->session->userdata('under_id'),'item_id' => $item_id,'stock_status' => 0,'status' => 1))->limit(1)->get()->row_array();
		if(!empty($row)){
			return $row['rate'];
		}
		return 0;
	}

	#---------item opening qty
	public function item_opening_qty($item_id,$date)
	{
		$row = $this->CI->db->select_sum('qty')->get_where('dms_stocks',array('branch_id' => $this->CI->session->userdata('under_id'),'item_id' => $item_id,'stock_status' => 0,'status' => 1))->row_array();
		if($row['qty'] != NULL){
			return $row['qty'];
		}
		return 0;
	}

	#---------item inwards qty (receipt_note,purchase,rejection_in,credit_note,phy_stock,stock_transfer)
	public function item_inwards_qty_rate($item_id,$from_date,$to_date)
	{
		$this->CI->db->select(array('sum(qty) as qty','sum(amount) as rates'))->from('dms_stocks')->where(array('branch_id' => $this->CI->session->userdata('under_id'),'item_id' => $item_id));
		$this->CI->db->where("stock_date between '$from_date' and '$to_date'",NULL,false);
		$row = $this->CI->db->where("(stock_status=1 or stock_status=2 or stock_status=7 or stock_status=8 or stock_status=9 or stock_status=10) and status = 1")->get()->row_array();
		return $row;
	}

	#---------item outwards qty (rejection_out,delivery_note,sales,debit_note)
	public function item_outwards_qty_rate($item_id,$from_date,$to_date)
	{
		$this->CI->db->select(array('sum(qty) as qty','sum(amount) as rates'))->from('dms_stocks')->where(array('branch_id' => $this->CI->session->userdata('under_id'),'item_id' => $item_id));
		$this->CI->db->where("stock_date between '$from_date' and '$to_date'",NULL,false);
		$row = $this->CI->db->where("(stock_status=3 or stock_status=4 or stock_status=5 or stock_status=6) and status = 1")->get()->row_array();
		return $row;
	}

	#----------stock distinct dates between selected dates
	public function stock_dates($item_id,$from_date,$to_date)
	{
		$this->CI->db->distinct()->select('stock_date')->from('dms_stocks')->where(array('branch_id' => $this->CI->session->userdata('under_id'),'item_id' => $item_id));
		$this->CI->db->where("stock_date between '$from_date' and '$to_date'",NULL,false);
		$row = $this->CI->db->where(array('stock_status >' => 0,'status' => 1))->order_by('stock_date','asc')->get()->result_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function item_register($item_id,$from_date,$to_date,$opening_qty)
	{
		$stock_array = array();$closing_qty = $opening_qty;

		$this->CI->db->select(array('sum(qty) as qty','sum(amount) as rates','stock_date','stock_status','table_group_id'))->from('dms_stocks')->where(array('branch_id' => $this->CI->session->userdata('under_id'),'item_id' => $item_id));
		$this->CI->db->where("stock_date between '$from_date' and '$to_date'",NULL,false);
		$row = $this->CI->db->where(array('stock_status >' => 0,'status' => 1))->group_by(array("stock_status","table_group_id"))->order_by('stock_date','asc')->get()->result_array();
		if(!empty($row))
		{
			#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
			$stock_value_type = $this->CI->dms->stock_value_type();

			foreach($row as $skey => $svalue)
			{
				$stock_status = $svalue['stock_status'];
				$group_id = $svalue['table_group_id'];

				if($stock_status == 1)//receipt note
				{
					$row1 = $this->CI->db->select(array('vtype_id','bill_no','r_status'))->get_where('dms_receipt_notes',array('group_id' => $group_id,'status' => 1))->row_array();
					if($row1['r_status'] == 0)
					{
						$vtype_name = $this->CI->accounts->voucher_name($row1['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty += $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => 'Pending Purchase Bill','vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => $svalue['qty'],'inwards_value' => round_this($svalue['rates']),'outwards_qty' => 0,'outwards_value' => 0,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_receipt_notes','group_id' => $group_id);
					}
					else
					{
						$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_purchases',array('group_id' => $group_id,'status' => 1))->row_array();

						#-----------particluars
						$ledger_id = $row2['payment_mode'];
						if($ledger_id == 2)
						{
							$voucher = $this->CI->db->select('cr_ledger')->get_where('dms_vouchers',array('dr_ledger' => 3,'table_name' => 'dms_purchases','table_group_id' => $group_id,'status >' => 0))->row_array();
							$ledger_id = $voucher['cr_ledger'];
						}
						$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

						$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty += $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => $svalue['qty'],'inwards_value' => round_this($svalue['rates']),'outwards_qty' => 0,'outwards_value' => 0,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_purchases','group_id' => $group_id);
					}
				}
				elseif($stock_status == 2)//purchase
				{
					$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_purchases',array('group_id' => $group_id,'status' => 1))->row_array();

					#-----------particluars
					$ledger_id = $row2['payment_mode'];
					if($ledger_id == 2)
					{
						$voucher = $this->CI->db->select('cr_ledger')->get_where('dms_vouchers',array('dr_ledger' => 3,'table_name' => 'dms_purchases','table_group_id' => $group_id,'status >' => 0))->row_array();
						$ledger_id = $voucher['cr_ledger'];
					}
					$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

					$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

					#-----------closing qty and value
					$closing_qty += $svalue['qty'];
					$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
					$closing_value = round_this($closing_qty * $item_rate);

					#-----------stock array
					$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row2['bill_no'],'inwards_qty' => $svalue['qty'],'inwards_value' => round_this($svalue['rates']),'outwards_qty' => 0,'outwards_value' => 0,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_purchases','group_id' => $group_id);
				}
				elseif($stock_status == 3)//rejection_out
				{
					$row1 = $this->CI->db->select(array('vtype_id','bill_no','p_status'))->get_where('dms_rejection_outs',array('group_id' => $group_id,'status' => 1))->row_array();
					if($row1['p_status'] == 0)
					{
						$vtype_name = $this->CI->accounts->voucher_name($row1['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty -= $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => 'Pending Purchase Return Bill','vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => 0,'inwards_value' => 0,'outwards_qty' => $svalue['qty'],'outwards_value' => round_this($svalue['rates']),'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_rejection_outs','group_id' => $group_id);
					}
					else
					{
						$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_purchase_returns',array('group_id' => $group_id,'status' => 1))->row_array();

						#-----------particluars
						$ledger_id = $row2['payment_mode'];
						if($ledger_id == 2)
						{
							$voucher = $this->CI->db->select('dr_ledger')->get_where('dms_vouchers',array('cr_ledger' => 5,'table_name' => 'dms_purchase_returns','table_group_id' => $group_id,'status >' => 0))->row_array();
							$ledger_id = $voucher['dr_ledger'];
						}
						$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

						$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty -= $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => 0,'inwards_value' => 0,'outwards_qty' => $svalue['qty'],'outwards_value' => round_this($svalue['rates']),'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_purchase_returns','group_id' => $group_id);
					}
				}
				elseif($stock_status == 4)//debit_note
				{
					$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_purchase_returns',array('group_id' => $group_id,'status' => 1))->row_array();

					#-----------particluars
					$ledger_id = $row2['payment_mode'];
					if($ledger_id == 2)
					{
						$voucher = $this->CI->db->select('dr_ledger')->get_where('dms_vouchers',array('cr_ledger' => 5,'table_name' => 'dms_purchase_returns','table_group_id' => $group_id,'status >' => 0))->row_array();
						$ledger_id = $voucher['dr_ledger'];
					}
					$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

					$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

					#-----------closing qty and value
					$closing_qty -= $svalue['qty'];
					$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
					$closing_value = round_this($closing_qty * $item_rate);

					#-----------stock array
					$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => 0,'inwards_value' => 0,'outwards_qty' => $svalue['qty'],'outwards_value' => round_this($svalue['rates']),'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_purchase_returns','group_id' => $group_id);
				}
				elseif($stock_status == 5)//delivery_note
				{
					$row1 = $this->CI->db->select(array('vtype_id','bill_no','d_status'))->get_where('dms_delivery_notes',array('group_id' => $group_id,'status' => 1))->row_array();
					if($row1['d_status'] == 0)
					{
						$vtype_name = $this->CI->accounts->voucher_name($row1['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty -= $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => 'Pending Sales Bill','vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => 0,'inwards_value' => 0,'outwards_qty' => $svalue['qty'],'outwards_value' => round_this($svalue['rates']),'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_delivery_notes','group_id' => $group_id);
					}
					else
					{
						$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_sales',array('group_id' => $group_id,'status' => 1))->row_array();

						#-----------particluars
						$ledger_id = $row2['payment_mode'];
						if($ledger_id == 2)
						{
							$voucher = $this->CI->db->select('dr_ledger')->get_where('dms_vouchers',array('cr_ledger' => 4,'table_name' => 'dms_sales','table_group_id' => $group_id,'status >' => 0))->row_array();
							$ledger_id = $voucher['dr_ledger'];
						}
						$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

						$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty -= $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => 0,'inwards_value' => 0,'outwards_qty' => $svalue['qty'],'outwards_value' => round_this($svalue['rates']),'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_sales','group_id' => $group_id);
					}
				}
				elseif($stock_status == 6)//sales
				{
					$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_sales',array('group_id' => $group_id,'status' => 1))->row_array();

					#-----------particluars
					$ledger_id = $row2['payment_mode'];
					if($ledger_id == 2)
					{
						$voucher = $this->CI->db->select('dr_ledger')->get_where('dms_vouchers',array('cr_ledger' => 4,'table_name' => 'dms_sales','table_group_id' => $group_id,'status >' => 0))->row_array();
						$ledger_id = $voucher['dr_ledger'];
					}
					$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

					$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

					#-----------closing qty and value
					$closing_qty -= $svalue['qty'];
					$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
					$closing_value = round_this($closing_qty * $item_rate);

					#-----------stock array
					$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row2['bill_no'],'inwards_qty' => 0,'inwards_value' => 0,'outwards_qty' => $svalue['qty'],'outwards_value' => round_this($svalue['rates']),'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_sales','group_id' => $group_id);
				}
				elseif($stock_status == 7)//rejection_in
				{
					$row1 = $this->CI->db->select(array('vtype_id','bill_no','r_status'))->get_where('dms_rejection_ins',array('group_id' => $group_id,'status' => 1))->row_array();
					if($row1['r_status'] == 0)
					{
						$vtype_name = $this->CI->accounts->voucher_name($row1['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty += $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => 'Pending Sales Return Bill','vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => $svalue['qty'],'inwards_value' => round_this($svalue['rates']),'outwards_qty' => 0,'outwards_value' => 0,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_rejection_ins','group_id' => $group_id);
					}
					else
					{
						$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_sales_returns',array('group_id' => $group_id,'status' => 1))->row_array();

						#-----------particluars
						$ledger_id = $row2['payment_mode'];
						if($ledger_id == 2)
						{
							$voucher = $this->CI->db->select('cr_ledger')->get_where('dms_vouchers',array('dr_ledger' => 6,'table_name' => 'dms_sales_returns','table_group_id' => $group_id,'status >' => 0))->row_array();
							$ledger_id = $voucher['cr_ledger'];
						}
						$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

						$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

						#-----------closing qty and value
						$closing_qty += $svalue['qty'];
						$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
						$closing_value = round_this($closing_qty * $item_rate);

						#-----------stock array
						$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => $svalue['qty'],'inwards_value' => round_this($svalue['rates']),'outwards_qty' => 0,'outwards_value' => 0,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_sales_returns','group_id' => $group_id);
					}
				}
				elseif($stock_status == 8)//credit_note
				{
					$row2 = $this->CI->db->select(array('vtype_id','bill_no','payment_mode'))->get_where('dms_sales_returns',array('group_id' => $group_id,'status' => 1))->row_array();

					#-----------particluars
					$ledger_id = $row2['payment_mode'];
					if($ledger_id == 2)
					{
						$voucher = $this->CI->db->select('cr_ledger')->get_where('dms_vouchers',array('dr_ledger' => 6,'table_name' => 'dms_sales_returns','table_group_id' => $group_id,'status >' => 0))->row_array();
						$ledger_id = $voucher['cr_ledger'];
					}
					$particulars = $this->CI->accounts->get_ledger_name($ledger_id);

					$vtype_name = $this->CI->accounts->voucher_name($row2['vtype_id']);//voucher type name

					#-----------closing qty and value
					$closing_qty += $svalue['qty'];
					$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
					$closing_value = round_this($closing_qty * $item_rate);

					#-----------stock array
					$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row1['bill_no'],'inwards_qty' => $svalue['qty'],'inwards_value' => round_this($svalue['rates']),'outwards_qty' => 0,'outwards_value' => 0,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_sales_returns','group_id' => $group_id);
				}
				elseif($stock_status == 9)//physical_stock
				{
					$row2 = $this->CI->db->select('bill_no')->get_where('dms_stock_adjustments',array('id' => $group_id,'status' => 1))->row_array();

					$vtype_name = $this->CI->accounts->voucher_name(13);//voucher type name

					#-----------particluars
					$particulars = $vtype_name;

					#-----------closing qty and value
					$closing_qty += $svalue['qty'];
					$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);
					$closing_value = round_this($closing_qty * $item_rate);

					$inwards_qty = $outwards_qty = $inwards_value = $outwards_value = 0;
					if($svalue['qty'] > 0)
					{
						$inwards_qty = $svalue['qty'];
					}
					elseif($svalue['qty'] < 0)
					{
						$outwards_qty = -$svalue['qty'];
					}

					#-----------stock array
					$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row2['bill_no'],'inwards_qty' => $inwards_qty,'inwards_value' => 0,'outwards_qty' => $outwards_qty,'outwards_value' => 0,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_stock_adjustments','group_id' => $group_id);
				}
				elseif($stock_status == 10)//stock_transfer
				{
					$row2 = $this->CI->db->select('transfer_no')->get_where('dms_stock_transfers',array('group_id' => $group_id,'status' => 1))->row_array();

					$vtype_name = "Stock Journal";

					#-----------particluars
					$particulars = $vtype_name;

					#-----------item rate
					$item_rate = $this->CI->accounts->item_rate($item_id,$from_date,$svalue['stock_date'],0,$stock_value_type);

					$inwards_qty = $outwards_qty = $inwards_value = $outwards_value = 0;
					if($svalue['qty'] == 0)
					{
						$row3 = $this->CI->db->select(array('sum(qty) as qty'))->get_where('dms_stocks',array('branch_id' => $this->CI->session->userdata('under_id'),'item_id' => $item_id,'qty >' => 0,'stock_date' => $svalue['stock_date'],'stock_status' => 10,'table_group_id' => $group_id,'status' => 1))->row_array();
						$inwards_qty = $row3['qty'];
						$inwards_value = round_this($inwards_qty * $item_rate);
						$outwards_qty = $row3['qty'];
						$outwards_value = round_this($outwards_qty * $item_rate);
					}
					elseif($svalue['qty'] > 0)
					{
						$inwards_qty = $svalue['qty'];
						$inwards_value = round_this($inwards_qty * $item_rate);
					}
					elseif($svalue['qty'] < 0)
					{
						$outwards_qty = -$svalue['qty'];
						$outwards_value = round_this($outwards_qty * $item_rate);
					}

					#-----------closing qty and value
					$closing_qty += ($inwards_qty - $outwards_qty);
					$closing_value = round_this($closing_qty * $item_rate);

					#-----------stock array
					$stock_array[$skey] = array('date' => $svalue['stock_date'],'particulars' => $particulars,'vname' => $vtype_name,'vno' => $row2['transfer_no'],'inwards_qty' => $inwards_qty,'inwards_value' => $inwards_value,'outwards_qty' => $outwards_qty,'outwards_value' => $outwards_value,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'table_name' => 'dms_stock_transfers','group_id' => $group_id);
				}
			}
		}
		return $stock_array;
	}

	public function getItemUnit($item_id)
	{
		return $this->CI->db->select(array('unit_id','symbol'))->from('item_master as a')->join('unit_master as b','a.unit_id = b.id')->where('a.id',$item_id)->get()->row_array();

	}
}