<?php
class Transport_lib {
	
	var $CI,$companyID,$branchID,$createdBY;
	#-----------------------------------------------
	
	public function __construct(){
		
		$this->CI =& get_instance();
		$this->companyID = $this->CI->session->userdata('company_id');
		$this->branchID = $this->CI->session->userdata('under_id');
		$this->createdBY = $this->CI->session->userdata('id');		
	}
	
	#-----------------------------------------------
	
	public function vehicles(){
		
		$vehicles = array();
		$this->CI->db->select(array('vm.id','vm.vehicle_no','vtm.vehicle_type'));
		$this->CI->db->from('vehicle_master as vm');
		$this->CI->db->join('vehicle_type_master as vtm','vm.vehicle_type_id=vtm.id');
		$this->CI->db->where(array('vm.company_id'=>$this->companyID,'vm.under_id'=>$this->branchID,'vm.status'=>1));
		$vehiclesList = $this->CI->db->get()->result_array();
		
		foreach($vehiclesList as $key=>$list){
			$vehicles[$list['id']] = '<div>'.$list['vehicle_no'].' <label class="pull-right" >[ '.$list['vehicle_type'].' ] </label></div>';
		}
		return $vehicles;
	}
	
	#----------------------------------------------
	
	public function drivers(){
		
		$drivers = array();
		$this->CI->db->select(array('u.id','concat(u.fname," ",u.lname) as name','u.mobile'));
		$this->CI->db->from('users as u');
		$this->CI->db->where(array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'u.status'=>1,'u.designation_id'=>7,'u.department_id'=>1));
		
		$driverList = $this->CI->db->get()->result_array();
		
		foreach($driverList as $key=>$list){
			$drivers[$list['id']] = $list['name'].' '.$list['mobile'];
		}
		
		return $drivers;
	}
	
	#----------------------------------------------
	
	public function routes(){
		
		$routes = array();
		$this->CI->db->select(array('id','route_name'));
		$this->CI->db->from('route_master as rm');
		$this->CI->db->where(array('rm.company_id'=>$this->companyID,'rm.status'=>1));
		
		$routeLists = $this->CI->db->get()->result_array();
		
		foreach($routeLists as $key=>$list){
			$routes[$list['id']] = $list['route_name'];
		}
		
		return $routes;
	}
	
	#----------------------------------------------
	
}

?>